/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.business.singleorg;

import com.google.common.collect.Maps;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.tctsa.common.enums.TctsaSysTaxTypeEnum;
import kd.taxc.tctsa.common.helper.LevytypeHelper;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.OrgUtils;

public class SingleOrgTrendOrTBHelper {
    private static final String POSITION_VALUE = "40px";
    private static final String TREND = "tctsa_single_trend";
    private static final String TONGBI = "tctsa_single_tongbi";
    private static final String POINTLINECHARTAP = "pointlinechartap";
    private static final String HISTOGRAMCHARTAP = "histogramchartap";
    private static final Map<String, String> RMB_UNIT = new HashMap<String, String>();

    public static void initTrendOrTBControl(Date startDate, Date endDate, List<Long> finalTypeList, Boolean jumpFlag, List<Long> orgids, String mainjump, IFormView view, IPageCache pageCacheInput) {
        Boolean isLess6 = SingleOrgTrendOrTBHelper.isLessSixMonth(startDate, endDate);
        Date tongbiStart = SingleOrgTrendOrTBHelper.getTongbiStart(startDate, endDate, jumpFlag);
        QFilter currentqFilter = SingleOrgTrendOrTBHelper.getQFilter(startDate, endDate);
        QFilter previousqFilter = SingleOrgTrendOrTBHelper.getQFilter(DateUtils.addYear((Date)startDate, (int)-1), DateUtils.addYear((Date)endDate, (int)-1));
        Map<String, BigDecimal> currentAmountMap = SingleOrgTrendOrTBHelper.initAmountMap(isLess6 != false ? startDate : DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)endDate, (int)-5)), endDate);
        Map<String, BigDecimal> tongbiCurrentAmountMap = SingleOrgTrendOrTBHelper.initAmountMap(tongbiStart, endDate);
        Map<String, BigDecimal> trendAllcurrentAmountMap = SingleOrgTrendOrTBHelper.initAmountMap(startDate, endDate);
        Map<String, BigDecimal> previousAmountMap = SingleOrgTrendOrTBHelper.initAmountMap(DateUtils.addYear((Date)tongbiStart, (int)-1), DateUtils.addYear((Date)endDate, (int)-1));
        QFilter typeFilter = new QFilter("taxtype", "in", finalTypeList);
        QFilter orgsFilter = new QFilter("org", "in", orgids);
        currentqFilter = currentqFilter.and(typeFilter);
        previousqFilter = previousqFilter.and(typeFilter);
        if ("tctsa_single_analysis".equals(mainjump) || "tctsa_board_home".equals(mainjump)) {
            currentqFilter = currentqFilter.and(orgsFilter);
            previousqFilter = previousqFilter.and(orgsFilter);
        }
        DynamicObjectCollection currenttjsjbInfos = QueryServiceHelper.query((String)"tctb_tjsjb", (String)"id,org,skssqq,skssqz,taxtype,bqybtse", (QFilter[])new QFilter[]{currentqFilter.and(LevytypeHelper.getLevytype())});
        DynamicObjectCollection previoustjsjbInfos = QueryServiceHelper.query((String)"tctb_tjsjb", (String)"id,org,skssqq,skssqz,taxtype,bqybtse", (QFilter[])new QFilter[]{previousqFilter.and(LevytypeHelper.getLevytype())});
        HashMap<String, List<Long>> currentpkids = new HashMap<String, List<Long>>(32);
        HashMap<String, List<Long>> tongbiCurrentpkids = new HashMap<String, List<Long>>(32);
        HashMap<String, List<Long>> previouspkids = new HashMap<String, List<Long>>(32);
        HashMap<String, List<Long>> trendAllpkids = new HashMap<String, List<Long>>(32);
        SingleOrgTrendOrTBHelper.setAmount(currentAmountMap, currenttjsjbInfos, currentpkids, "skssqz", "bqybtse", "id");
        SingleOrgTrendOrTBHelper.setAmount(tongbiCurrentAmountMap, currenttjsjbInfos, tongbiCurrentpkids, "skssqz", "bqybtse", "id");
        SingleOrgTrendOrTBHelper.setAmount(previousAmountMap, previoustjsjbInfos, previouspkids, "skssqz", "bqybtse", "id");
        SingleOrgTrendOrTBHelper.setAmount(trendAllcurrentAmountMap, currenttjsjbInfos, trendAllpkids, "skssqz", "bqybtse", "id");
        String entityId = view.getEntityId();
        SingleOrgTrendOrTBHelper.drawChart(currentAmountMap, tongbiCurrentAmountMap, previousAmountMap, entityId, jumpFlag, endDate, currentpkids, tongbiCurrentpkids, previouspkids, trendAllpkids, trendAllcurrentAmountMap, view, pageCacheInput);
    }

    private static Date getTongbiStart(Date startDate, Date endDate, Boolean jumpFlag) {
        if (DateUtils.getYearOfDate((Date)startDate) == DateUtils.getYearOfDate((Date)endDate)) {
            if (jumpFlag.booleanValue()) {
                return startDate;
            }
            Boolean isLess6 = SingleOrgTrendOrTBHelper.isLessSixMonth(startDate, endDate);
            if (isLess6.booleanValue()) {
                return startDate;
            }
            return DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)endDate, (int)-5));
        }
        if (jumpFlag.booleanValue()) {
            return DateUtils.getFirstDateOfYear((Date)endDate);
        }
        Boolean isLess6 = SingleOrgTrendOrTBHelper.isLessSixMonth(DateUtils.getFirstDateOfYear((Date)endDate), endDate);
        if (isLess6.booleanValue()) {
            return DateUtils.getFirstDateOfYear((Date)endDate);
        }
        return DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)endDate, (int)-5));
    }

    public static Boolean isLessSixMonth(Date startDate, Date endDate) {
        int month = DateUtils.getMonthDiff((Date)startDate, (Date)endDate);
        Boolean isLess6 = false;
        isLess6 = month <= 5 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return isLess6;
    }

    private static void drawChart(Map<String, BigDecimal> currentAmountMap, Map<String, BigDecimal> tongbiCurrentAmountMap, Map<String, BigDecimal> previousAmountMap, String entityId, Boolean jumpFlag, Date endDate, Map<String, List<Long>> currentpkids, Map<String, List<Long>> tongbiCurrentpkids, Map<String, List<Long>> previouspkids, Map<String, List<Long>> trendAllpkids, Map<String, BigDecimal> trendAllcurrentAmountMap, IFormView view, IPageCache pageCacheInput) {
        pageCacheInput.put("currentpagecache", EmptyCheckUtils.isEmpty(currentpkids) ? null : SerializationUtils.toJsonString(currentpkids));
        pageCacheInput.put("previouspagecache", EmptyCheckUtils.isEmpty(previouspkids) ? null : SerializationUtils.toJsonString(previouspkids));
        pageCacheInput.put("trendAllpagecache", EmptyCheckUtils.isEmpty(trendAllpkids) ? null : SerializationUtils.toJsonString(trendAllpkids));
        pageCacheInput.put("tongbiCurrentpagecache", EmptyCheckUtils.isEmpty(tongbiCurrentpkids) ? null : SerializationUtils.toJsonString(tongbiCurrentpkids));
        if (jumpFlag.booleanValue()) {
            view.setVisible(Boolean.valueOf(false), new String[]{"detailsflex"});
            view.setVisible(Boolean.valueOf(true), new String[]{"closeflex"});
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"detailsflex"});
            view.setVisible(Boolean.valueOf(false), new String[]{"closeflex"});
        }
        List<Object> categorys = new ArrayList(256);
        ArrayList<BigDecimal> currentValues = new ArrayList(256);
        List<Object> previousValues = new ArrayList(256);
        if (jumpFlag.booleanValue()) {
            if (TREND.equalsIgnoreCase(entityId)) {
                categorys = trendAllcurrentAmountMap.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
                currentValues = trendAllcurrentAmountMap.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)).collect(Collectors.toList());
            } else if (TONGBI.equalsIgnoreCase(entityId)) {
                categorys = tongbiCurrentAmountMap.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
                currentValues = tongbiCurrentAmountMap.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)).collect(Collectors.toList());
                previousValues = previousAmountMap.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)).collect(Collectors.toList());
            }
        } else if (TREND.equalsIgnoreCase(entityId)) {
            categorys = currentAmountMap.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
            currentValues = currentAmountMap.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)).collect(Collectors.toList());
        } else if (TONGBI.equalsIgnoreCase(entityId)) {
            categorys = tongbiCurrentAmountMap.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
            currentValues = tongbiCurrentAmountMap.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)).collect(Collectors.toList());
            previousValues = previousAmountMap.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)).collect(Collectors.toList());
        }
        if (TREND.equalsIgnoreCase(entityId)) {
            PointLineChart chart = (PointLineChart)view.getControl(POINTLINECHARTAP);
            chart.clearData();
            Axis xAxis = SingleOrgTrendOrTBHelper.createCategoryAxis(chart, ResManager.loadKDString((String)"\u6708\u4efd", (String)"SingleOrgTrendOrTBHelper_1", (String)"taxc-tctsa-business", (Object[])new Object[0]));
            xAxis.setCategorys(categorys);
            SingleOrgTrendOrTBHelper.createLine(chart, currentValues);
            chart.setLegendAlign(XAlign.right, YAlign.top);
            chart.setLegendVertical(false);
            chart.setShowLegend(false);
            chart.setMargin(Position.right, POSITION_VALUE);
            chart.setMargin(Position.top, POSITION_VALUE);
            chart.setMargin(Position.left, POSITION_VALUE);
            chart.setName(new LocaleString(ResManager.loadKDString((String)"", (String)"SingleOrgTrendOrTBHelper_2", (String)"taxc-tctsa-business", (Object[])new Object[0])));
            chart.setTitleAlign(XAlign.left, YAlign.top);
            chart.refresh();
        } else if (TONGBI.equalsIgnoreCase(entityId)) {
            HistogramChart customchart = (HistogramChart)view.getControl(HISTOGRAMCHARTAP);
            Axis xAxis = SingleOrgTrendOrTBHelper.createValueAxis(customchart, ResManager.loadKDString((String)"(\u4e07\u5143)", (String)"SingleOrgTrendOrTBHelper_0", (String)"taxc-tctsa-business", (Object[])new Object[0]), false);
            HashMap splitLine = new HashMap();
            HashMap<String, String> lineStyle = new HashMap<String, String>();
            lineStyle.put("type", "dotted");
            lineStyle.put("color", "#E2E2E2");
            splitLine.put("lineStyle", lineStyle);
            xAxis.setPropValue("splitLine", splitLine);
            List<String> newCategorys = categorys.stream().map(s -> String.format(ResManager.loadKDString((String)"%s\u6708\u4efd", (String)"SingleOrgTrendOrTBHelper_3", (String)"taxc-tctsa-business", (Object[])new Object[0]), Integer.valueOf(s.substring(5, 7)))).collect(Collectors.toList());
            SingleOrgTrendOrTBHelper.createCategoryAxis(customchart, "", newCategorys, true);
            int year = DateUtils.getYearOfDate((Date)endDate);
            String yearName = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"SingleOrgTrendOrTBHelper_4", (String)"taxc-tctsa-business", (Object[])new Object[0]), year);
            String previousYearName = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"SingleOrgTrendOrTBHelper_4", (String)"taxc-tctsa-business", (Object[])new Object[0]), year - 1);
            SingleOrgTrendOrTBHelper.createHistogramSeries(customchart, previousYearName, previousValues.toArray(new Number[0]), "1");
            SingleOrgTrendOrTBHelper.createHistogramSeries(customchart, yearName, currentValues.toArray(new Number[0]), "2");
            ArrayList<BigDecimal> tbchangList = new ArrayList<BigDecimal>(256);
            int i = 0;
            for (BigDecimal current : currentValues) {
                BigDecimal growthBigDecimal = BigDecimalUtil.divideObject((Object)BigDecimalUtil.subtractObject((Object)current, (Object)previousValues.get(i)), (Object)previousValues.get(i), (int)4, (int)4);
                if (growthBigDecimal == null) {
                    growthBigDecimal = BigDecimal.ZERO;
                }
                tbchangList.add(growthBigDecimal.multiply(new BigDecimal(100)));
                ++i;
            }
            SingleOrgTrendOrTBHelper.createLineSeries(customchart, ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f(%)", (String)"SingleOrgTrendOrTBHelper_6", (String)"taxc-tctsa-business", (Object[])new Object[0]), tbchangList, "#F57582");
            customchart.setName(new LocaleString(""));
            customchart.setLegendAlign(XAlign.right, YAlign.top);
            customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 35});
            customchart.setMargin(Position.right, POSITION_VALUE);
            customchart.setMargin(Position.top, POSITION_VALUE);
            customchart.setMargin(Position.left, POSITION_VALUE);
            customchart.setShowLegend(true);
            customchart.setShowTooltip(true);
            customchart.setLegendVertical(false);
            customchart.refresh();
        }
    }

    private static List<Long> getFinalTypeList(IFormView view) {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)view.getParentView().getModel().getValue("taxtype");
        List finalTypeList = dynamicObjects.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).distinct().collect(Collectors.toList());
        if (finalTypeList.size() == 0) {
            finalTypeList = TctsaSysTaxTypeEnum.getTypeIdList();
        }
        return finalTypeList;
    }

    private static void createLineSeries(HistogramChart customchart, String name, List<BigDecimal> values, String color) {
        LineSeries expireSeries = customchart.createLineSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setData(values.toArray(new Number[0]));
    }

    public static Date getStartDate(IFormView view) {
        return DateUtils.getFirstDateOfMonth((Date)((Date)view.getParentView().getModel().getValue("startdate")));
    }

    public static Date getEndDate(IFormView view) {
        return DateUtils.getLastDateOfMonth2((Date)((Date)view.getParentView().getModel().getValue("enddate")));
    }

    public static List<Long> getOrgIds(IFormView view) {
        Long orgid = ((DynamicObject)view.getParentView().getModel().getValue("org")).getLong("id");
        ArrayList<Long> orgs = new ArrayList<Long>(16);
        Boolean isentity = false;
        Map entity = SingleOrgTrendOrTBHelper.getEntity(orgid, view);
        if (EmptyCheckUtils.isNotEmpty((Object)entity)) {
            Object notice = entity.get("notice");
            if (notice != null) {
                return null;
            }
            Object notice1 = entity.get("isentity");
            isentity = (Boolean)notice1;
        }
        List<Object> SubOrgIds = new ArrayList(16);
        if (!isentity.booleanValue()) {
            SubOrgIds = SingleOrgTrendOrTBHelper.getSubOrgIds(orgid);
        }
        if (isentity.booleanValue()) {
            orgs.add(orgid);
        } else {
            orgs.addAll(SubOrgIds);
            if (orgs.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u865a\u4f53\u7ec4\u7ec7\u4e0b\u65e0\u6709\u6548\u7684\u7eb3\u7a0e\u4e3b\u4f53", (String)"SingleOrgTrendOrTBHelper_7", (String)"taxc-tctsa-business", (Object[])new Object[0]));
            }
        }
        return orgs;
    }

    private static Axis createValueAxis(HistogramChart histogramChart, String name, boolean isX) {
        Axis xaxis = null;
        xaxis = isX ? histogramChart.createXAxis(name, AxisType.value) : histogramChart.createYAxis(name, AxisType.value);
        xaxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, 2, -20};
        map.put("padding", aa);
        xaxis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        xaxis.setPropValue("axisTick", axisTick);
        SingleOrgTrendOrTBHelper.setLineColor(xaxis, "#999999");
        return xaxis;
    }

    private static Axis createCategoryAxis(HistogramChart histogramChart, String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.category) : histogramChart.createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, -25, -35};
        map.put("padding", aa);
        axis.setPropValue("nameTextStyle", map);
        histogramChart.setShowTooltip(true);
        SingleOrgTrendOrTBHelper.setLineColor(axis, "#999999");
        return axis;
    }

    private static Map getEntity(Long orgid, IFormView view) {
        HashMap<String, Boolean> noticeMap = new HashMap<String, Boolean>();
        DynamicObject taxmain = TaxcMainServiceHelper.getTaxcMainByMore((Long)orgid);
        if (taxmain == null) {
            String orgname = OrgUtils.getOrgNameById((String)String.valueOf(orgid));
            noticeMap.put("notice", false);
            view.setVisible(Boolean.FALSE, new String[]{POINTLINECHARTAP, HISTOGRAMCHARTAP, "querydetails", "flexpanelap1", "close1", "close"});
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7a0e\u52a1\u4fe1\u606f\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011\u4fe1\u606f", (String)"SingleOrgTrendOrTBHelper_8", (String)"taxc-tctsa-business", (Object[])new Object[0]), orgname));
            return noticeMap;
        }
        Boolean isentity = taxmain.getBoolean("taxorg.istaxpayer");
        isentity = EmptyCheckUtils.isEmpty((Object)isentity) ? Boolean.TRUE : isentity;
        noticeMap.put("isentity", isentity);
        return noticeMap;
    }

    private static List<Long> getSubOrgIds(Long orgid) {
        List<Long> orgList = Collections.singletonList(orgid);
        return OrgUnitServiceHelper.getAllSubordinateOrgs((String)OrgFuncEnum.TAX.getNumber(), orgList, (boolean)true);
    }

    private static void createHistogramSeries(HistogramChart histogramChart, String name, Number[] values, String isyear) {
        BarSeries expireSeries = histogramChart.createSeries(name);
        expireSeries.setBarWidth("25px");
        Label label = new Label();
        label.setPosition(Position.insideBottom);
        label.setShow(false);
        expireSeries.setLabel(label);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> normap = new HashMap<String, HashMap<String, String>>();
        map.put("color", "1".equals(isyear) ? "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#6DDBDC'}, {\"offset\": 1, \"color\": '#5CC0DA'}])" : "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#7DBFFF'}, {\"offset\": 1, \"color\": '#568DFF'}])");
        normap.put("normal", map);
        expireSeries.setPropValue("itemStyle", normap);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        expireSeries.addFuncPath(list);
        expireSeries.setLabel((Label)null);
        HashMap dataLabels = Maps.newHashMap();
        dataLabels.put("format", "{point.y:.1f}");
        expireSeries.setPropValue("dataLabels", (Object)dataLabels);
        expireSeries.setData(values);
        expireSeries.setAnimationDuration(2000);
    }

    private static Axis createCategoryAxis(PointLineChart pointLineChart, String name) {
        Axis axis = pointLineChart.createXAxis(name, AxisType.category);
        axis.setPropValue("nameLocation", (Object)"end");
        axis.setPropValue("position", (Object)"bottom");
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        axis.setPropValue("axisTick", axisTick);
        axis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, 0, 0};
        map.put("padding", aa);
        axis.setPropValue("nameTextStyle", map);
        SingleOrgTrendOrTBHelper.setLineColor(axis, "#999999");
        return axis;
    }

    private static void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private static void createLine(PointLineChart chart, List<BigDecimal> outputValues) {
        ArrayList<BigDecimal> lineData1 = new ArrayList<BigDecimal>();
        SingleOrgTrendOrTBHelper.createValueAxis(chart, RMB_UNIT.get("3"));
        outputValues.forEach(output -> lineData1.add((BigDecimal)output));
        SingleOrgTrendOrTBHelper.createLineSeries(chart, ResManager.loadKDString((String)"\u7eb3\u7a0e\u603b\u989d", (String)"SingleOrgTrendOrTBHelper_9", (String)"taxc-tctsa-business", (Object[])new Object[0]), lineData1, "#9EB8FF");
    }

    public static void createLineSeries(PointLineChart pointLineChart, String name, List<BigDecimal> values, String color) {
        LineSeries expireSeries = pointLineChart.createLineSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setData(values.toArray(new Number[0]));
    }

    private static Axis createValueAxis(PointLineChart pointLineChart, String name) {
        Axis axis = pointLineChart.createYAxis(name, AxisType.value);
        HashMap splitLine = Maps.newHashMap();
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, 2, -20};
        map.put("padding", aa);
        axis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        axis.setPropValue("axisTick", axisTick);
        SingleOrgTrendOrTBHelper.setLineColor(axis, "#999999");
        pointLineChart.setShowTooltip(true);
        return axis;
    }

    private static void setAmount(Map<String, BigDecimal> amountMap, DynamicObjectCollection resultCol, Map<String, List<Long>> pkids, String periodField, String amountField, String idField) {
        for (DynamicObject object : resultCol) {
            BigDecimal amount = object.getBigDecimal(amountField);
            Date invoiceDate = object.getDate(periodField);
            String dateStr = DateUtils.format((Date)invoiceDate, (String)"yyyy-MM");
            Long id = object.getLong(idField);
            if (!amountMap.containsKey(dateStr)) continue;
            List ids = pkids.getOrDefault(dateStr, new ArrayList());
            BigDecimal newAmount = amountMap.get(dateStr).add(amount);
            amountMap.put(dateStr, newAmount.setScale(2, 4));
            ids.add(id);
            pkids.put(dateStr, ids);
        }
    }

    private static Map<String, BigDecimal> initAmountMap(Date startDate, Date endDate) {
        List monthList = DateUtils.getMonthBetween((Date)startDate, (Date)endDate);
        LinkedHashMap<String, BigDecimal> amountMap = new LinkedHashMap<String, BigDecimal>(monthList.size());
        for (String month : monthList) {
            amountMap.put(month, BigDecimal.ZERO);
        }
        return amountMap;
    }

    private static QFilter getQFilter(Date startdate, Date enddate) {
        QFilter qFilter = new QFilter("skssqq", ">=", (Object)startdate);
        if (EmptyCheckUtils.isEmpty((Object)startdate) || EmptyCheckUtils.isEmpty((Object)enddate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u4e0d\u6b63\u786e\u3002", (String)"SingleOrgTrendOrTBHelper_10", (String)"taxc-tctsa-business", (Object[])new Object[0]));
        }
        QFilter endFilter = new QFilter("skssqz", "<=", (Object)enddate);
        qFilter.and(endFilter);
        return qFilter;
    }

    public static void showForm(String entityId, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(entityId);
        StyleCss sc = new StyleCss();
        sc.setHeight("500px");
        sc.setWidth("960px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("jump", "1");
        customParams.put("startdate", SingleOrgTrendOrTBHelper.getStartDate(view));
        String parentid = view.getParentView().getEntityId();
        customParams.put("mainjump", parentid);
        customParams.put("enddate", SingleOrgTrendOrTBHelper.getEndDate(view));
        customParams.put("typeList", SingleOrgTrendOrTBHelper.getFinalTypeList(view));
        customParams.put("orgList", SingleOrgTrendOrTBHelper.getOrgIds(view));
        parameter.setCustomParams(customParams);
        parameter.setCaption(TONGBI.equals(entityId) ? ResManager.loadKDString((String)"\u7a0e\u91d1\u540c\u6bd4\u5206\u6790", (String)"SingleOrgTrendOrTBHelper_11", (String)"taxc-tctsa-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7a0e\u91d1\u8d8b\u52bf\u5206\u6790", (String)"SingleOrgTrendOrTBHelper_12", (String)"taxc-tctsa-business", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(parameter);
    }

    public static void openTjsjReport(List<Long> pkids, IFormView view) {
        if (EmptyCheckUtils.isEmpty(pkids)) {
            return;
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setPageId(view.getPageId() + "abcd");
        reportShowParameter.setFormId("tctsa_statistics_detail");
        reportShowParameter.setCustomParam("ids", pkids);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)reportShowParameter);
    }

    static {
        RMB_UNIT.put("3", ResManager.loadKDString((String)"(\u4e07\u5143)", (String)"SingleOrgTrendOrTBHelper_0", (String)"taxc-tctsa-business", (Object[])new Object[0]));
    }
}

