/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.business.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.BindingContext;
import kd.bos.form.field.FieldEdit;
import kd.bos.report.IReportView;
import kd.taxc.tctsa.common.util.DateUtils;
import org.apache.commons.lang.StringUtils;

public class TaxStatisticsRptHelper {
    public static String formatShowFilterString(List<String> fields, IDataModel model, IReportView view) {
        StringBuilder msg = new StringBuilder();
        BindingContext bindingContext = new BindingContext((Object)model.getDataEntity());
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)view.getControl(field);
            if (fieldEdit == null) {
                return null;
            }
            Object value = fieldEdit.getBindingValue(bindingContext);
            Object valDesc = TaxStatisticsRptHelper.getValueDesc(value, fieldEdit.getProperty());
            if (valDesc == null || !StringUtils.isNotEmpty((String)valDesc.toString())) continue;
            if ("enddate".equals(field)) {
                msg.append(" - ").append(valDesc);
                continue;
            }
            if (msg.length() > 0) {
                msg.append(";  ");
            }
            msg.append(fieldEdit.getProperty().getDisplayName()).append(':').append(' ').append(valDesc);
        }
        return msg.toString();
    }

    private static Object getValueDesc(Object value, IDataEntityProperty prop) {
        Object valDesc = "";
        if (value == null) {
            return valDesc;
        }
        if (!(prop instanceof BasedataProp) && !(prop instanceof MulBasedataProp)) {
            valDesc = prop instanceof ComboProp ? ((ComboProp)prop).getItemByName(value.toString()) : (prop instanceof DateProp || prop instanceof DateTimeProp ? DateUtils.format((Date)DateUtils.stringToDate((String)((String)value)), (String)"yyyy-MM") : (prop instanceof BooleanProp ? (Boolean.parseBoolean(value.toString()) ? ResManager.loadKDString((String)"\u662f", (String)"TaxStatisticsRptHelper_0", (String)"taxc-tctsa-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"TaxStatisticsRptHelper_1", (String)"taxc-tctsa-business", (Object[])new Object[0])) : value));
        } else if (value instanceof ArrayList) {
            ArrayList<String> valueDescList = new ArrayList<String>();
            for (Object valueArray : (List)value) {
                Object[] valArray = (Object[])valueArray;
                String newValueDesc = null;
                if (valArray.length >= 2) {
                    String string = newValueDesc = valArray[1] == null ? "" : valArray[1].toString();
                }
                if (!kd.bos.util.StringUtils.isNotEmpty(newValueDesc)) continue;
                valueDescList.add(newValueDesc);
            }
            valDesc = String.join((CharSequence)";", valueDescList);
        } else {
            Object[] valArray = (Object[])value;
            if (valArray.length >= 2) {
                valDesc = valArray[1] == null ? "" : valArray[1].toString();
            }
        }
        return valDesc;
    }

    public static Set<String> getUnVisibleFields() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList("type3", "managareas2", "industryname2", "bizsegmentname2", "orgid", "area2", "issumline", "type"));
        return result;
    }
}

