/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.business.statistics;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.entity.RowMetaMsgInfo;
import kd.taxc.tctsa.common.enums.TaxStatisticColEnum;
import kd.taxc.tctsa.common.enums.TaxStatisticDimensionEnum;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.BizCommomUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.TctsaUtils;

public class TaxStatisticsRptQueryHelper {
    private static DynamicObjectCollection queryTaxMainInfo(List<QFilter> filterList) {
        List orgattrFilter = filterList.stream().filter(f -> f.toString().contains("orgattr.fbasedataid.id")).collect(Collectors.toList());
        if (orgattrFilter.size() == 1) {
            DynamicObjectCollection coll = TaxcMainServiceHelper.queryDiy((QFilter[])filterList.toArray(new QFilter[0]), (String)TaxcMainServiceHelper.selectFields3);
            List idList = coll.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            return TaxcMainServiceHelper.queryDiy((QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, (String)TaxcMainServiceHelper.selectFields4);
        }
        if (orgattrFilter.size() == 2) {
            filterList.removeIf(item -> item.toString().contains("orgattr.fbasedataid.id"));
            filterList.add((QFilter)orgattrFilter.get(0));
            DynamicObjectCollection coll1 = TaxcMainServiceHelper.queryDiy((QFilter[])filterList.toArray(new QFilter[0]), (String)TaxcMainServiceHelper.selectFields4);
            filterList.removeIf(item -> item.toString().contains("orgattr.fbasedataid.id"));
            filterList.add((QFilter)orgattrFilter.get(1));
            DynamicObjectCollection coll2 = TaxcMainServiceHelper.queryDiy((QFilter[])filterList.toArray(new QFilter[0]), (String)TaxcMainServiceHelper.selectFields4);
            List orglist1 = coll1.stream().map(r -> r.getString("orgid")).collect(Collectors.toList());
            List orglist2 = coll2.stream().map(r -> r.getString("orgid")).collect(Collectors.toList());
            DynamicObjectCollection result = coll1.stream().filter(r -> orglist2.contains(r.getString("orgid"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            DynamicObjectCollection result2 = coll2.stream().filter(r -> orglist1.contains(r.getString("orgid"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            result.addAll((Collection)result2);
            return result;
        }
        return TaxcMainServiceHelper.queryDiy((QFilter[])filterList.toArray(new QFilter[0]), (String)TaxcMainServiceHelper.selectFields4);
    }

    private static Map<Long, Map<String, String>> getOrgattrMap(Map<Long, List<DynamicObject>> taxmainGroup) {
        HashMap<Long, Map<String, String>> orgattrMap = new HashMap<Long, Map<String, String>>();
        if (taxmainGroup.size() > 0) {
            for (Map.Entry<Long, List<DynamicObject>> entry : taxmainGroup.entrySet()) {
                List<DynamicObject> dyo = entry.getValue();
                HashMap<String, String> attr = new HashMap<String, String>();
                String managarea = "";
                String segment = "";
                for (DynamicObject obj : dyo) {
                    if ("regulated_areas".equalsIgnoreCase(obj.getString("number"))) {
                        managarea = obj.getString("name");
                        continue;
                    }
                    if (!"biz-segment001".equalsIgnoreCase(obj.getString("number"))) continue;
                    segment = obj.getString("name");
                }
                attr.put("managarea", managarea);
                attr.put("segment", segment);
                orgattrMap.put(entry.getKey(), attr);
            }
        }
        return orgattrMap;
    }

    private static DataSet emptyResultDataSet(List<RowMetaMsgInfo> cols, String className) {
        RowMeta rowMeta = BizCommomUtil.createRowMeta(cols);
        CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
        return Algo.create((String)className).createDataSet(new Input[]{inputs});
    }

    public static List<QFilter> getFilter(FilterInfo filterInfo) {
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        for (FilterItemInfo filter : list) {
            QFilter qFilter;
            if (null == filter || null == filter.getValue() || "dimension".equals(filter.getPropName()) || null == (qFilter = TaxStatisticsRptQueryHelper.getFilterByName(filter))) continue;
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    private static QFilter getFilterByName(FilterItemInfo filterItemInfo) {
        QFilter qFilter = null;
        String name = filterItemInfo.getPropName();
        Object value = filterItemInfo.getValue();
        switch (name) {
            case "org": {
                if (value instanceof DynamicObjectCollection) {
                    Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                    qFilter = new QFilter(name, "in", groups.keySet());
                    break;
                }
                if (!(value instanceof List) || ((List)value).size() == 0) break;
                qFilter = new QFilter(name, "in", (Object)((List)value).toArray());
                break;
            }
            case "taxtype": {
                if (!(value instanceof DynamicObjectCollection)) break;
                Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                qFilter = new QFilter(name, "in", groups.keySet());
                break;
            }
            case "manageareas": 
            case "bizsegment": {
                if (!(value instanceof DynamicObjectCollection)) break;
                Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                qFilter = new QFilter("orgattr.fbasedataid.id", "in", groups.keySet());
                break;
            }
            case "industrycode": {
                if (!(value instanceof DynamicObjectCollection)) break;
                Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                qFilter = new QFilter("codeandname.id", "in", groups.keySet());
                break;
            }
            case "ids": {
                if (value == null) break;
                List ids = (List)value;
                qFilter = new QFilter("id", "in", (Object)ids);
                break;
            }
            case "zcdz": {
                DynamicObjectCollection areas = (DynamicObjectCollection)filterItemInfo.getValue();
                qFilter = TaxStatisticsRptQueryHelper.getLocationFilter(qFilter, areas);
                break;
            }
            case "startdate": {
                qFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)filterItemInfo.getValue())));
                break;
            }
            case "enddate": {
                qFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth2((Date)((Date)filterItemInfo.getValue())));
                break;
            }
            case "tabletypefilter": {
                if (filterItemInfo.getValue() == null) break;
                List tableTypeFilter = Arrays.stream(filterItemInfo.getValue().toString().split(",")).filter(v -> StringUtils.isNotEmpty((CharSequence)v)).collect(Collectors.toList());
                qFilter = new QFilter("type", "in", tableTypeFilter);
                break;
            }
            default: {
                return null;
            }
        }
        return qFilter;
    }

    private static QFilter getLocationFilter(QFilter qFilter, DynamicObjectCollection areas) {
        HashSet<String> citys = new HashSet<String>();
        HashSet<String> provinces = new HashSet<String>();
        for (DynamicObject dyo : areas) {
            String fullName = dyo.getString("fullname");
            if ("1".equals(dyo.getString("iscity"))) {
                citys.add(fullName);
            } else {
                provinces.add(fullName);
            }
            if (null == qFilter) {
                qFilter = new QFilter("zcdz", "like", (Object)(fullName + "%"));
                continue;
            }
            qFilter.or(new QFilter("zcdz", "like", (Object)(fullName + "%")));
        }
        TaxStatisticsRptQueryHelper.filterCitys(citys, provinces);
        return qFilter;
    }

    private static void filterCitys(Set<String> citys, Set<String> provinces) {
        for (String province : provinces) {
            citys.removeIf(city -> city.startsWith(province));
        }
        citys.addAll(provinces);
    }

    public static DataSet handler(FilterInfo filterInfo, String className) {
        List industrycodeFilter;
        DynamicObjectCollection taxmainCollection = null;
        List filterItemInfos = filterInfo.getFilterItems();
        if (CollectionUtils.isEmpty((Collection)filterItemInfos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxStatisticsRptQueryHelper_0", (String)"taxc-tctsa-business", (Object[])new Object[0]));
        }
        FilterItemInfo groupItemInfo = null;
        for (FilterItemInfo itemInfo : filterItemInfos) {
            if (!"dimension".equalsIgnoreCase(itemInfo.getPropName())) continue;
            groupItemInfo = itemInfo;
        }
        ArrayList<RowMetaMsgInfo> cols = new ArrayList(16);
        if (groupItemInfo != null) {
            cols = TaxStatisticColEnum.createDynamicCol((String)TaxStatisticDimensionEnum.getEnumByCode((String)String.valueOf(groupItemInfo.getValue())).getFirstColEnum().getRowMetaMsgInfo().getFieldId());
        }
        List<QFilter> qFilterList = TaxStatisticsRptQueryHelper.getFilter(filterInfo);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter orgFilter = QFilter.parse((String)qFilterList.stream().findFirst().filter(s -> s.toString().contains("org in")).get().toString().replace("org", "orgid"), (Object[])new Object[0]);
        filterList.add(orgFilter);
        List orgattrFilter = qFilterList.stream().filter(s -> s.toString().contains("orgattr.fbasedataid.id")).collect(Collectors.toList());
        if (orgattrFilter.size() > 0) {
            filterList.addAll(orgattrFilter);
        }
        if ((industrycodeFilter = qFilterList.stream().filter(s -> s.toString().contains("codeandname.id")).collect(Collectors.toList())).size() > 0) {
            filterList.add((QFilter)industrycodeFilter.get(0));
        }
        taxmainCollection = TaxStatisticsRptQueryHelper.queryTaxMainInfo(filterList);
        Map<Long, List<DynamicObject>> taxmainGroup = taxmainCollection.stream().collect(Collectors.groupingBy(s -> s.getLong("orgid")));
        Map<Long, Map<String, String>> orgattrMap = TaxStatisticsRptQueryHelper.getOrgattrMap(taxmainGroup);
        ArrayList<Long> orgList = new ArrayList<Long>();
        if (taxmainCollection != null && taxmainCollection.size() > 0) {
            for (DynamicObject dynamicObject : taxmainCollection) {
                orgList.add(dynamicObject.getLong("orgid"));
            }
        }
        List<QFilter> tjsjbqFilter = qFilterList.stream().filter(s -> !s.toString().contains("manageareas") && !s.toString().contains("orgattr.fbasedataid.id") && !s.toString().contains("codeandname.id")).collect(Collectors.toList());
        tjsjbqFilter.removeIf(item -> item.toString().contains("org in"));
        tjsjbqFilter.add(new QFilter("org", "in", orgList));
        DynamicObject[] collection = TjsjbBusiness.loadTjsjbData(tjsjbqFilter, "id,type,org,skssqq,skssqz,declarestatus,taxtype,apanage,yssr,bqybtse,jmse,fsl,datatype,ynse,jmse,sbbid,formno");
        if (null == collection || collection.length == 0) {
            return TaxStatisticsRptQueryHelper.emptyResultDataSet(cols, className);
        }
        return TaxStatisticsRptQueryHelper.matchResultAndFilter(collection, taxmainGroup, orgattrMap, cols, className);
    }

    private static DataSet matchResultAndFilter(DynamicObject[] collection, Map<Long, List<DynamicObject>> taxmainGroup, Map<Long, Map<String, String>> orgattrMap, List<RowMetaMsgInfo> cols, String className) {
        ArrayList<Map<String, Object>> colls = new ArrayList<Map<String, Object>>(16);
        RowMetaMsgInfo groupCol = cols.get(0);
        HashMap<String, Object> resRow = null;
        for (DynamicObject r : collection) {
            resRow = new HashMap<String, Object>(16);
            String string = (String)TctsaUtils.getInfoByOrgIdFromErp((String)String.valueOf(r.getDynamicObject("org").get("masterid")), (String[])new String[]{"number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank"}).get("name");
            resRow.put("orgid", string);
            resRow.put("taxtype", r.getDynamicObject("taxtype") == null ? "" : r.getDynamicObject("taxtype").getString("name"));
            resRow.put("skssqz", DateUtils.format((Date)r.getDate("skssqq"), (String)TctsaConstant.FORMAT) + "~" + DateUtils.format((Date)r.getDate("skssqz"), (String)TctsaConstant.FORMAT));
            resRow.put("tabletype", r.getString("type"));
            resRow.put("apanage", r.getString("apanage"));
            resRow.put("yssr", r.getBigDecimal("yssr").setScale(2, 4));
            resRow.put("bqybtse", r.getBigDecimal("bqybtse").setScale(2, 4));
            resRow.put("ynse", r.getBigDecimal("ynse").setScale(2, 4));
            resRow.put("jmse", r.getBigDecimal("jmse").setScale(2, 4));
            resRow.put("fsl", r.getBigDecimal("fsl").multiply(BigDecimal.valueOf(100L)).setScale(2, 4) + "%");
            if (EmptyCheckUtils.isEmpty((Object)r.getDynamicObject("org").get("masterid"))) continue;
            resRow.put("managareas", EmptyCheckUtils.isNotEmpty(orgattrMap.get(r.getDynamicObject("org").get("masterid"))) ? orgattrMap.get(r.getDynamicObject("org").get("masterid")).get("managarea") : null);
            resRow.put("industryname", EmptyCheckUtils.isNotEmpty(taxmainGroup.get(r.getDynamicObject("org").get("masterid"))) ? taxmainGroup.get(r.getDynamicObject("org").get("masterid")).get(0).get("codename") : null);
            resRow.put("bizsegmentname", EmptyCheckUtils.isNotEmpty(orgattrMap.get(r.getDynamicObject("org").get("masterid"))) ? orgattrMap.get(r.getDynamicObject("org").get("masterid")).get("segment") : null);
            resRow.put("area", EmptyCheckUtils.isNotEmpty(taxmainGroup.get(r.getDynamicObject("org").get("masterid"))) ? taxmainGroup.get(r.getDynamicObject("org").get("masterid")).get(0).get("registeraddress") : null);
            resRow.put("datasouce", r.getString("datatype"));
            resRow.put("sbbid", r.getString("sbbid"));
            resRow.put("sbbno", r.getString("formno"));
            colls.add(resRow);
        }
        Map<String, List<Map>> key2GroupListMap = colls.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.get(groupCol.getQueryFiled()))));
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        for (Map.Entry entry : key2GroupListMap.entrySet()) {
            for (Map map : (List)entry.getValue()) {
                Object[] resRowData = TaxStatisticsRptQueryHelper.createRow(map, cols);
                coll.add(resRowData);
            }
            Object[] resRowData = TaxStatisticsRptQueryHelper.createTotalRow((List)entry.getValue(), (String)entry.getKey(), cols, "subtotal");
            coll.add(resRowData);
        }
        coll.add(TaxStatisticsRptQueryHelper.createTotalRow(colls, null, cols, "alltotal"));
        RowMeta rowMeta = BizCommomUtil.createRowMeta(cols);
        CollectionInput collectionInput = new CollectionInput(rowMeta, coll);
        return Algo.create((String)className).createDataSet(new Input[]{collectionInput});
    }

    private static Object[] createTotalRow(List<Map<String, Object>> colls, String key, List<RowMetaMsgInfo> cols, String type) {
        Object[] row = new Object[cols.size()];
        String currentpaytotal = "0.0";
        String ynsetotal = "0.0";
        String taxableincometotal = "0.0";
        String jmsetotal = "0.0";
        row[0] = "subtotal".equals(type) ? (kd.bos.orm.util.StringUtils.isEmpty((Object)key) ? ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"TaxStatisticsRptQueryHelper_1", (String)"taxc-tctsa-business", (Object[])new Object[0]) : key) : ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TaxStatisticsRptQueryHelper_2", (String)"taxc-tctsa-business", (Object[])new Object[0]);
        for (Map<String, Object> temp : colls) {
            currentpaytotal = BigDecimalUtil.addObject((Object)currentpaytotal, (Object)temp.get("bqybtse")) + "";
            ynsetotal = BigDecimalUtil.addObject((Object)ynsetotal, (Object)temp.get("ynse")) + "";
            taxableincometotal = BigDecimalUtil.addObject((Object)taxableincometotal, (Object)temp.get("yssr")) + "";
            jmsetotal = BigDecimalUtil.addObject((Object)jmsetotal, (Object)temp.get("jmse")) + "";
        }
        for (int i = 1; i < cols.size(); ++i) {
            row[i] = cols.get(i).getFieldId().equalsIgnoreCase(TaxStatisticColEnum.CURRENTPAY.getRowMetaMsgInfo().getFieldId()) ? currentpaytotal : (cols.get(i).getFieldId().equalsIgnoreCase(TaxStatisticColEnum.TAXABLEINCOME.getRowMetaMsgInfo().getFieldId()) ? taxableincometotal : (cols.get(i).getFieldId().equalsIgnoreCase(TaxStatisticColEnum.JMSE.getRowMetaMsgInfo().getFieldId()) ? jmsetotal : (cols.get(i).getFieldId().equalsIgnoreCase(TaxStatisticColEnum.YNSE.getRowMetaMsgInfo().getFieldId()) ? ynsetotal : (cols.get(i).getFieldId().equalsIgnoreCase(TaxStatisticColEnum.SBBID.getRowMetaMsgInfo().getFieldId()) ? Integer.valueOf(0) : ""))));
        }
        return row;
    }

    private static Object[] createRow(Map<String, Object> tempMap, List<RowMetaMsgInfo> cols) {
        Object[] row = new Object[cols.size()];
        int index = 0;
        for (RowMetaMsgInfo info : cols) {
            row[index++] = tempMap.get(info.getQueryFiled());
        }
        return row;
    }
}

