/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.business.taxmain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.tctsa.business.taxmain.TctsaTaxOrgDao;
import org.apache.commons.collections4.CollectionUtils;

public class TctsaTaxOrgBusiness {
    public static Map<String, String> getTaxOrgTaxpayerChina(List<Long> orgIds) {
        return TctsaTaxOrgBusiness.getTaxOrgTaxpayer(orgIds, 1L);
    }

    public static Map<String, String> getTaxOrgTaxpayer(List<Long> orgIds, Long taxationsysId) {
        List<DynamicObject> taxResult = TctsaTaxOrgDao.queryTaxcOrgByIds(orgIds, taxationsysId);
        HashMap<String, String> retyrnMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(taxResult)) {
            for (DynamicObject datum : taxResult) {
                DynamicObjectCollection entryentity = datum.getDynamicObjectCollection("entryentity");
                if (!CollectionUtils.isNotEmpty((Collection)entryentity)) continue;
                retyrnMap.put(datum.getString("id") + "_" + taxationsysId, ((DynamicObject)entryentity.get(0)).getString("entry_taxpayer"));
            }
        }
        return retyrnMap;
    }

    public static String getKey(DynamicObject obj) {
        return obj.getString("org") + "_" + obj.getString("taxationsys");
    }

    public static Map<String, String> getTaxpayerMap(DataSet dataSet, String orgtitle, String taxationsystitle) {
        HashMap map = new HashMap();
        for (Row row : dataSet) {
            List<Long> list;
            long org = row.getLong(orgtitle);
            Long taxsystem = row.getLong(taxationsystitle);
            if (map.containsKey(taxsystem)) {
                list = (List)map.get(taxsystem);
                list.add(org);
                map.put(taxsystem, list);
                continue;
            }
            list = new ArrayList();
            list.add(org);
            map.put(taxsystem, list);
        }
        HashMap<String, String> taxpayerMap = new HashMap<String, String>();
        for (Map.Entry mapentry : map.entrySet()) {
            taxpayerMap.putAll(TctsaTaxOrgBusiness.getTaxOrgTaxpayer((List)mapentry.getValue(), (Long)mapentry.getKey()));
        }
        return taxpayerMap;
    }
}

