/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.business.tjsjb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.taxc.tctsa.business.tjsjb.TjsjbDao;
import kd.taxc.tctsa.common.helper.LevytypeHelper;
import org.apache.commons.collections.CollectionUtils;

public class TjsjbBusiness {
    private static final String TAXES_AND_FEES_DETAILS_SELECT_FIELDS = "id,type,org,org.name orgname,org.masterid orgmasterid,skssqq,skssqz,declarestatus,taxtype,taxtype.name taxtypename,apanage,yssr,bqybtse,fsl,datatype,ynse,jmse,sbbid,formno,levytype,taxationsys";
    private static final String TAXES_AND_FEES_STATISTICS_SELECT_FIELDS = "id,org,org.name orgname,taxtype,bqybtse,sjsj,taxoffice.name as taxofficename,entryentity.djtsjsj,entryentity.djtjkdate";
    private static final String TAXES_INCOME_DISTRIBUTION_TOP_FIVE = "id,type,declarestatus,bqybtse,org,jmse";
    private static final String TAX_ANALYSIS_SELECT_FIELDS = "id,org,skssqq,skssqz,taxtype,bqybtse";

    public static DynamicObjectCollection getTaxesAndFeesDetails(List<QFilter> filters) {
        return TjsjbBusiness.queryTjsjbData(filters, TAXES_AND_FEES_DETAILS_SELECT_FIELDS);
    }

    public static List<DynamicObject> getTaxesAndFeesStatistics(List<QFilter> filters) {
        DynamicObjectCollection tjsjDyos = TjsjbBusiness.queryTjsjbData(filters, TAXES_AND_FEES_STATISTICS_SELECT_FIELDS);
        if (CollectionUtils.isEmpty((Collection)tjsjDyos)) {
            return new ArrayList<DynamicObject>(8);
        }
        Map<String, List<DynamicObject>> listMap = tjsjDyos.stream().collect(Collectors.groupingBy(s -> s.getString("id")));
        return listMap.values().stream().filter(CollectionUtils::isNotEmpty).map(tjsjbList -> {
            DynamicObject tjsjb = (DynamicObject)tjsjbList.get(0);
            BigDecimal sum = tjsjbList.stream().filter(m -> m.get("entryentity.djtsjsj") != null).map(m -> m.getBigDecimal("entryentity.djtsjsj")).reduce(BigDecimal.ZERO, BigDecimal::add);
            tjsjb.set("sjsj", (Object)sum);
            return tjsjb;
        }).collect(Collectors.toList());
    }

    public static DynamicObjectCollection getTaxesIncomeDistributionTop5(List<Long> orgIds, Date startDate, Date endDate, List<Long> taxTypeIdList) {
        QFilter filter = new QFilter("org", "in", orgIds).and(new QFilter("skssqq", ">=", (Object)startDate)).and(new QFilter("skssqz", "<=", (Object)endDate)).and(new QFilter("taxtype", "in", taxTypeIdList)).and(LevytypeHelper.getLevytype());
        return TjsjbBusiness.queryTjsjbData(Stream.of(filter).collect(Collectors.toList()), TAXES_INCOME_DISTRIBUTION_TOP_FIVE);
    }

    public static DynamicObjectCollection getTaxAnalysisData(QFilter filter) {
        return TjsjbBusiness.queryTjsjbData(Stream.of(filter).collect(Collectors.toList()), TAX_ANALYSIS_SELECT_FIELDS);
    }

    public static List<Long> getAllOrgIdsByTjsjbInChina(Date startDate, Date endDate, List<Long> finalTypeList) {
        QFilter filter = new QFilter("skssqq", ">=", (Object)startDate).and(new QFilter("skssqz", "<=", (Object)endDate)).and(new QFilter("taxtype", "in", finalTypeList)).and(new QFilter("taxationsys", "=", (Object)1L).and(LevytypeHelper.getLevytype()));
        DynamicObjectCollection tjsjbList = TjsjbBusiness.queryTjsjbData(Stream.of(filter).collect(Collectors.toList()), "org");
        if (CollectionUtils.isEmpty((Collection)tjsjbList)) {
            return new ArrayList<Long>();
        }
        return tjsjbList.stream().map(m -> m.getLong("org")).distinct().collect(Collectors.toList());
    }

    public static DynamicObject[] loadTjsjbData(List<QFilter> filters, String selectFields) {
        return TjsjbDao.loadTjsjbData(filters, selectFields);
    }

    public static DynamicObject loadSingleTjsjbData(List<QFilter> filters, String selectFields) {
        return TjsjbDao.loadSingleTjsjbData(filters, selectFields);
    }

    public static DynamicObjectCollection queryTjsjbData(List<QFilter> filters, String selectFields) {
        return TjsjbDao.queryTjsjbData(filters, selectFields);
    }

    public static DynamicObjectCollection queryTjsjbDataWithOrder(List<QFilter> filters, String selectFields, String orderStr) {
        return TjsjbDao.queryTjsjbDataWithOrder(filters, selectFields, orderStr);
    }
}

