/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.PermissionUtils;
import kd.taxc.tctsa.common.util.TreeUtils;
import kd.taxc.tctsa.formplugin.TaxProvincePlugin;

public class TaxDeclareProgressCardPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TaxProvincePlugin.class);
    private Map<String, String> statusMap = new HashMap<String, String>(){
        {
            this.put("declared", ResManager.loadKDString((String)"\u7533\u62a5\u6210\u529f", (String)"TaxDeclareProgressCardPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            this.put("declaring", ResManager.loadKDString((String)"\u7533\u62a5\u4e2d", (String)"TaxDeclareProgressCardPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            this.put("editing", ResManager.loadKDString((String)"\u672a\u7533\u62a5", (String)"TaxDeclareProgressCardPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            this.put("undeclare", ResManager.loadKDString((String)"\u672a\u7f16\u5236", (String)"TaxDeclareProgressCardPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            this.put("declarefailed", ResManager.loadKDString((String)"\u7533\u62a5\u5931\u8d25", (String)"TaxDeclareProgressCardPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
    };

    public void afterCreateNewData(EventObject e) {
        this.refreshBar();
    }

    public void registerListener(EventObject e) {
        BarChart barChart = (BarChart)this.getView().getControl("barchartap");
        barChart.addClickListener((ClickListener)this);
    }

    private void refreshBar() {
        Date startdate = (Date)this.getView().getParentView().getModel().getValue("startdate");
        Date enddate = (Date)this.getView().getParentView().getModel().getValue("enddate");
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((String)"tctsa", (String)"tctsa_statistics_detail", (String)"47150e89000000ac");
        List orgIds = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs);
        logger.info("diyiciguolvzuzhi:" + orgIds.toString());
        logger.info("dierciguolvzuzhisize:" + orgIds.size());
        QFilter startFilter = new QFilter("skssqq", ">=", (Object)DateUtils.trunc((Date)DateUtils.getFirstDateOfMonth((Date)startdate), (String)"yyyy-MM-dd"));
        QFilter endFilter = new QFilter("skssqz", "<=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth2((Date)enddate), (String)"yyyy-MM-dd"));
        List<Object> orgList = new ArrayList();
        Object taxmainCollection = null;
        List list = TaxcMainServiceHelper.getTaxcMain((List)orgIds, null);
        orgList = list.stream().map(v -> v.getLong("orgid.id")).distinct().collect(Collectors.toList());
        QFilter org1Filter = new QFilter("org", "in", orgList);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"type,declarestatus,bqybtse,yssr", (QFilter[])new QFilter[]{startFilter, endFilter, org1Filter});
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Integer count;
            String type = dynamicObject.getString("type");
            String declarestatus = dynamicObject.getString("declarestatus");
            String key = this.statusMap.get(declarestatus);
            if (type.startsWith("zzs")) {
                count = countMap.getOrDefault(String.format(ResManager.loadKDString((String)"\u589e\u503c\u7a0e%s", (String)"TaxDeclareProgressCardPlugin_24", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), key), 0) + 1;
                countMap.put(String.format(ResManager.loadKDString((String)"\u589e\u503c\u7a0e%s", (String)"TaxDeclareProgressCardPlugin_24", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), key), count);
                continue;
            }
            if (type.startsWith("qysds")) {
                count = countMap.getOrDefault(String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e%s", (String)"TaxDeclareProgressCardPlugin_25", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), key), 0) + 1;
                countMap.put(String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e%s", (String)"TaxDeclareProgressCardPlugin_25", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), key), count);
                continue;
            }
            if (!type.startsWith("yhs")) continue;
            count = countMap.getOrDefault(String.format(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e%s", (String)"TaxDeclareProgressCardPlugin_26", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), key), 0) + 1;
            countMap.put(String.format(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e%s", (String)"TaxDeclareProgressCardPlugin_26", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), key), count);
        }
        BarChart customchart = this.getMainChart();
        customchart.clearData();
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"TaxDeclareProgressCardPlugin_12", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        keys.add(ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TaxDeclareProgressCardPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        keys.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"TaxDeclareProgressCardPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        this.createCategoryAxis("", keys, false);
        this.createValueAxis("", true);
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(countMap.getOrDefault(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u672a\u7533\u62a5", (String)"TaxDeclareProgressCardPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), 0));
        values.add(countMap.getOrDefault(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u672a\u7533\u62a5", (String)"TaxDeclareProgressCardPlugin_14", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), 0));
        values.add(countMap.getOrDefault(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u672a\u7533\u62a5", (String)"TaxDeclareProgressCardPlugin_19", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), 0));
        this.createBarSeries(ResManager.loadKDString((String)"\u672a\u7533\u62a5", (String)"TaxDeclareProgressCardPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), values.toArray(new Integer[0]), "#FEC035");
        this.setBarSeries(keys, countMap, ResManager.loadKDString((String)"\u7533\u62a5\u4e2d", (String)"TaxDeclareProgressCardPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "#1E90FF");
        this.setBarSeries(keys, countMap, ResManager.loadKDString((String)"\u7533\u62a5\u6210\u529f", (String)"TaxDeclareProgressCardPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "#4FCE9A");
        this.setBarSeries(keys, countMap, ResManager.loadKDString((String)"\u672a\u7f16\u5236", (String)"TaxDeclareProgressCardPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "#26C9C3");
        this.setBarSeries(keys, countMap, ResManager.loadKDString((String)"\u7533\u62a5\u5931\u8d25", (String)"TaxDeclareProgressCardPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "#73D13D");
        customchart.setMargin(Position.right, "30px");
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setLegendVertical(false);
        customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 23});
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    private void setBarSeries(List<String> keys, Map<String, Integer> countMap, String statusName, String color) {
        ArrayList<Integer> values = new ArrayList<Integer>(keys.size());
        for (String key : keys) {
            values.add(countMap.getOrDefault(key + statusName, 0));
        }
        this.createBarSeries(statusName, values.toArray(new Integer[0]), color);
    }

    private Axis createCategoryAxis(String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private BarChart getMainChart() {
        return (BarChart)this.getView().getControl("barchartap");
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private void createBarSeries(String name, Number[] values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(name);
        barSeries.setStack("stack");
        barSeries.setBarWidth("25px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        Label label = new Label();
        label.setPosition(Position.insideRight);
        label.setShow(false);
        barSeries.setLabel(label);
        for (int i = 0; i < values.length; ++i) {
            Number n = values[i];
            if (n.intValue() != 0) continue;
            values[i] = null;
        }
        barSeries.setData(values);
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }
}

