/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportShowParameter;
import kd.taxc.tctsa.business.admindivision.AdminDivisionBusiness;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.entity.MultiLangEnumBridge;
import kd.taxc.tctsa.common.enums.ProvinceEnum;
import kd.taxc.tctsa.common.enums.TctsaSysTaxTypeEnum;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxProvincePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TaxProvincePlugin.class);
    private static String CUSTOM_CONTROL = "customcontrolap";
    private static int TOP = 5;
    private static final Map<String, Map<String, BigDecimal>> levels = new HashMap<String, Map<String, BigDecimal>>(){
        {
            this.put("#003A8C", new HashMap<String, BigDecimal>(){
                {
                    this.put("min", new BigDecimal("100"));
                }
            });
            this.put("#096DD9", new HashMap<String, BigDecimal>(){
                {
                    this.put("max", new BigDecimal("100"));
                    this.put("min", new BigDecimal("50"));
                }
            });
            this.put("#40A9FF", new HashMap<String, BigDecimal>(){
                {
                    this.put("max", new BigDecimal("50"));
                    this.put("min", new BigDecimal("10"));
                }
            });
            this.put("#91D5FF", new HashMap<String, BigDecimal>(){
                {
                    this.put("max", new BigDecimal("10"));
                }
            });
        }
    };

    private void bind(Map<String, BigDecimal> valMap) {
        HashMap<String, Object> map;
        ArrayList valList = new ArrayList(10);
        for (ProvinceEnum enums : ProvinceEnum.values()) {
            String provinceName = ProvinceEnum.loadKDStringMyChiness((MultiLangEnumBridge)enums.getCode());
            BigDecimal bigDecimal = valMap.getOrDefault(provinceName, BigDecimal.ZERO);
            map = new HashMap<String, Object>();
            map.put("name", provinceName);
            map.put("value", String.valueOf(bigDecimal));
            valList.add(map);
        }
        Collections.sort(valList, (o1, o2) -> {
            BigDecimal b1 = new BigDecimal((String)o1.get("value"));
            BigDecimal b2 = new BigDecimal((String)o2.get("value"));
            return b2.compareTo(b1);
        });
        StringBuilder sbData = new StringBuilder();
        StringBuilder topData = new StringBuilder();
        topData.append('[');
        sbData.append('[');
        int index = 0;
        ArrayList<Map> topList = new ArrayList<Map>();
        for (Map map2 : valList) {
            if (sbData.length() > 10) {
                sbData.append(',');
            }
            BigDecimal value = BigDecimalUtil.toBigDecimal(map2.get("value"));
            Iterator<Map.Entry<String, Map<String, BigDecimal>>> iterator = levels.entrySet().iterator();
            String color = "";
            while (iterator.hasNext()) {
                Map.Entry<String, Map<String, BigDecimal>> entry = iterator.next();
                color = entry.getKey();
                Map<String, BigDecimal> val = entry.getValue();
                BigDecimal min = val.get("min");
                BigDecimal max = val.get("max");
                if (!(max == null && value.compareTo(min) >= 0 || max != null && min != null && value.compareTo(min) >= 0 && value.compareTo(max) < 0) && (min != null || value.compareTo(max) >= 0)) continue;
                break;
            }
            sbData.append("{\"name\":\"").append((String)map2.get("name")).append("\",");
            sbData.append("\"value\":").append((String)map2.get("value")).append(',');
            sbData.append("\"itemStyle\":{\"normal\":{\"areaColor\":\"").append(color).append("\"}}");
            sbData.append('}');
            if (TOP > index) {
                topList.add(0, map2);
            }
            ++index;
        }
        sbData.append(']');
        topData.append(']');
        List dstObject = (List)SerializationUtils.fromJsonString((String)sbData.toString(), List.class);
        CustomControl customControl = (CustomControl)this.getControl(CUSTOM_CONTROL);
        map = new HashMap(16);
        HashMap<String, String> pageData = new HashMap<String, String>();
        pageData.put("cockpitmapBoxStyle", "width:calc(100% - 240px);height: 500px;background-color: #ffffff;margin: 0px auto 0 auto;");
        pageData.put("mapBoxStyle", "width: calc(100% - 240px);height: 500px;background-color: #ffffff;margin: 0px auto 0 auto;");
        map.put("pagedata", pageData);
        map.put("data", dstObject);
        map.put("topData", topList);
        customControl.setData(map);
    }

    public void afterCreateNewData(EventObject e) {
        Date startdate = DateUtils.getFirstDateOfMonth((Date)((Date)this.getView().getParentView().getModel().getValue("startdate")));
        Date enddate = DateUtils.getLastDateOfMonth2((Date)((Date)this.getView().getParentView().getModel().getValue("enddate")));
        DynamicObjectCollection typeidCollection = (DynamicObjectCollection)this.getView().getParentView().getModel().getValue("taxtype");
        List finalTypeList = typeidCollection.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).distinct().collect(Collectors.toList());
        if (finalTypeList.size() == 0) {
            finalTypeList = TctsaSysTaxTypeEnum.getTypeIdList();
        }
        Map<String, BigDecimal> valMap = this.loadData(startdate, enddate, finalTypeList);
        this.bind(valMap);
    }

    private Map<String, BigDecimal> calculateProvinceData(Date startdate, Date enddate, List<Long> finalTypeList) {
        List<Long> orgList = TjsjbBusiness.getAllOrgIdsByTjsjbInChina((Date)startdate, (Date)enddate, finalTypeList);
        List taxmainCollection = TaxcMainServiceHelper.getTaxcMain((List)orgList, null);
        orgList = orgList.stream().distinct().collect(Collectors.toList());
        Map<String, BigDecimal> totalMap = this.getProvinceNameAmountMap(orgList, startdate, enddate, taxmainCollection, finalTypeList);
        BigDecimal taxTotal = totalMap.getOrDefault("taxTotal", BigDecimal.ZERO);
        Label taxTotal1 = (Label)this.getControl("labelap2");
        taxTotal1.setText(String.valueOf(taxTotal));
        return totalMap;
    }

    private Map<String, BigDecimal> getProvinceNameAmountMap(List<Long> orgIds, Date startDate, Date endDate, List<DynamicObject> taxMainList, List<Long> taxTypeIdList) {
        if (kd.bos.orm.util.CollectionUtils.isEmpty(taxMainList)) {
            return new HashMap<String, BigDecimal>(0);
        }
        DynamicObjectCollection dataObjects = TjsjbBusiness.getTaxesIncomeDistributionTop5(orgIds, (Date)startDate, (Date)endDate, taxTypeIdList);
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)dataObjects)) {
            return new HashMap<String, BigDecimal>(0);
        }
        Map<Long, List<DynamicObject>> orgIdAndTaxStatisticDataMap = dataObjects.stream().collect(Collectors.groupingBy(s -> s.getLong("org")));
        Map<Long, List<DynamicObject>> orgIdTaxMainMap = taxMainList.stream().collect(Collectors.groupingBy(p -> p.getLong("orgid.id")));
        List adminDivisionIds = orgIdTaxMainMap.values().stream().map(p -> ((DynamicObject)p.get(0)).getLong("registeraddress")).collect(Collectors.toList());
        Map adminDivisionIdAndProvinceNameMap = AdminDivisionBusiness.getIdAndProvinceNameMap(adminDivisionIds);
        BigDecimal totalAmount = BigDecimal.ZERO;
        HashMap<String, BigDecimal> provinceAndAmountMap = new HashMap<String, BigDecimal>(34);
        HashMap<String, List> provinceAndDataIdMap = new HashMap<String, List>(34);
        ArrayList<Long> errorOrgIds = new ArrayList<Long>(8);
        for (Map.Entry<Long, List<DynamicObject>> entry : orgIdAndTaxStatisticDataMap.entrySet()) {
            List<DynamicObject> list = orgIdTaxMainMap.get(entry.getKey());
            if (kd.bos.orm.util.CollectionUtils.isEmpty(list)) {
                errorOrgIds.add(entry.getKey());
                continue;
            }
            long adminDivisionId = list.get(0).getLong("registeraddress");
            String provinceName = (String)adminDivisionIdAndProvinceNameMap.get(adminDivisionId);
            if (provinceName == null) {
                errorOrgIds.add(entry.getKey());
                continue;
            }
            BigDecimal provinceAmount = entry.getValue().stream().map(p -> p.getBigDecimal("bqybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List taxStatisticDataIds = entry.getValue().stream().map(t -> t.getLong("id")).collect(Collectors.toList());
            for (ProvinceEnum enums : ProvinceEnum.values()) {
                String province = ProvinceEnum.loadKDStringMyChiness((MultiLangEnumBridge)enums.getCode());
                if (!provinceName.contains(province)) continue;
                BigDecimal val = provinceAndAmountMap.getOrDefault(province, BigDecimal.ZERO);
                val = BigDecimalUtil.addObject((Object)val, (Object)provinceAmount);
                provinceAndAmountMap.put(province, val);
                List dataIds = provinceAndDataIdMap.getOrDefault(province, new ArrayList());
                dataIds.addAll(taxStatisticDataIds);
                provinceAndDataIdMap.put(province, dataIds);
            }
            totalAmount = totalAmount.add(provinceAmount);
        }
        Map<String, BigDecimal> result = provinceAndAmountMap.entrySet().stream().collect(Collectors.toMap(k -> (String)k.getKey(), v -> ((BigDecimal)v.getValue()).divide(new BigDecimal(10000), 2, 4)));
        result.put("taxTotal", totalAmount.divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP));
        this.getPageCache().put("provincepkidscache", EmptyCheckUtils.isEmpty(provinceAndDataIdMap) ? null : SerializationUtils.toJsonString(provinceAndDataIdMap));
        if (CollectionUtils.isNotEmpty(errorOrgIds)) {
            logger.info("\u5b58\u5728\u627e\u4e0d\u5230\u5bf9\u5e94\u5b57\u6bb5\u7684\u7ec4\u7ec7:{}", errorOrgIds);
        }
        return result;
    }

    private Map<String, BigDecimal> loadData(Date startdate, Date enddate, List<Long> finalTypeList) {
        HashMap<String, BigDecimal> returnMap = new HashMap(34);
        returnMap = this.calculateProvinceData(startdate, enddate, finalTypeList);
        logger.info("ditushuju: " + returnMap);
        return returnMap;
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        String eventName = e.getEventName();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if ("detail".equals(eventName)) {
            Map pkidsMap;
            String name = (String)argsMap.get("name");
            String provincepkidscache = this.getPageCache().get("provincepkidscache");
            if (EmptyCheckUtils.isNotEmpty((Object)provincepkidscache) && EmptyCheckUtils.isNotEmpty((Object)(pkidsMap = (Map)SerializationUtils.fromJsonString((String)provincepkidscache, Map.class)))) {
                this.openTjsjReport((List)pkidsMap.get(name));
            }
        }
    }

    private void openTjsjReport(List<Long> pkids) {
        if (EmptyCheckUtils.isEmpty(pkids)) {
            return;
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setPageId(this.getView().getPageId() + UUID.randomUUID());
        reportShowParameter.setFormId("tctsa_statistics_detail");
        reportShowParameter.setCustomParam("ids", pkids);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }
}

