/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportShowParameter;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.enums.TctsaTypeEnum;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.PermissionUtils;
import kd.taxc.tctsa.common.util.StringUtil;
import kd.taxc.tctsa.common.util.TreeUtils;

public class TaxStatisticsCardPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TaxStatisticsCardPlugin.class);
    private static final Map<String, String> shuizhongMap = new HashMap<String, String>();
    private BigDecimal TEN_THOUSAND = new BigDecimal(10000);

    public void afterCreateNewData(EventObject e) {
        this.refreshData();
    }

    public void registerListener(EventObject e) {
        PieChart chart = (PieChart)this.getControl("piechartap");
        chart.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        if (evt instanceof ChartClickEvent) {
            ChartClickEvent chartClickEvent = (ChartClickEvent)evt;
            String name = chartClickEvent.getName();
            if (StringUtil.isEmpty((CharSequence)name)) {
                return;
            }
            this.showForm(name);
        }
    }

    private void showForm(String name) {
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tctsa_statistics_detail");
        showParameter.setCustomParam("type", (Object)shuizhongMap.get(name));
        String startdate = this.getParentPageCache().get("startdate");
        showParameter.setCustomParam("skssqq", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)startdate)));
        if (this.getParentPageCache().get("enddate") == null || "".equals(this.getParentPageCache().get("enddate"))) {
            LocalDate now = LocalDate.now();
            int days = now.lengthOfMonth();
            showParameter.setCustomParam("skssqz", (Object)now.withDayOfMonth(days).toString());
        } else {
            String enddate = this.getParentPageCache().get("enddate");
            showParameter.setCustomParam("skssqz", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)enddate)));
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("flexcontent");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private IPageCache getParentPageCache() {
        return (IPageCache)this.getView().getParentView().getService(IPageCache.class);
    }

    private void refreshData() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        BigDecimal zzsTaxTotal = BigDecimal.ZERO;
        BigDecimal sdsTaxTotal = BigDecimal.ZERO;
        BigDecimal yhsTaxTotal = BigDecimal.ZERO;
        BigDecimal fjsTaxTotal = BigDecimal.ZERO;
        BigDecimal fcsTaxTotal = BigDecimal.ZERO;
        BigDecimal ztdsysTaxTotal = BigDecimal.ZERO;
        String startdate = this.getParentPageCache().get("startdate");
        filters.add(new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)startdate))));
        if (this.getParentPageCache().get("enddate") == null || "".equals(this.getParentPageCache().get("enddate"))) {
            LocalDate now = LocalDate.now();
            int days = now.lengthOfMonth();
            filters.add(new QFilter("skssqz", "<=", (Object)now.withDayOfMonth(days)));
        } else {
            String enddate = this.getParentPageCache().get("enddate");
            filters.add(new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)enddate))));
        }
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((String)"tctsa", (String)"tctsa_statistics_detail", (String)"47150e89000000ac");
        List orgIds = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs);
        List<Object> orgList = new ArrayList();
        DynamicObjectCollection taxmainCollection = null;
        taxmainCollection = TaxcMainServiceHelper.queryDiyByid((List)orgIds, (String)TaxcMainServiceHelper.selectFields5);
        if (taxmainCollection != null && taxmainCollection.size() > 0) {
            for (DynamicObject dynamicObject : taxmainCollection) {
                orgList.add(dynamicObject.getLong("orgid"));
            }
        }
        orgList = orgList.stream().distinct().collect(Collectors.toList());
        filters.add(new QFilter("org", "in", orgList));
        DynamicObjectCollection dynamicObjects = TjsjbBusiness.queryTjsjbData(filters, (String)"id,type,declarestatus,bqybtse,org,jmse");
        Map<String, List<DynamicObject>> typeGroups = dynamicObjects.stream().collect(Collectors.groupingBy(s -> s.getString("type")));
        BigDecimal tempTaxTypeNsTotal = BigDecimal.ZERO;
        for (String type : typeGroups.keySet()) {
            tempTaxTypeNsTotal = ((List)typeGroups.getOrDefault(type, new ArrayList())).stream().map(s -> s.getBigDecimal("bqybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (StringUtil.isEmpty((CharSequence)type)) continue;
            if (type.startsWith("zzs")) {
                zzsTaxTotal = BigDecimalUtil.addObject((Object)zzsTaxTotal, (Object)tempTaxTypeNsTotal);
            } else if (type.startsWith("qysds")) {
                sdsTaxTotal = BigDecimalUtil.addObject((Object)sdsTaxTotal, (Object)tempTaxTypeNsTotal);
            } else if (type.startsWith("yhs")) {
                yhsTaxTotal = BigDecimalUtil.addObject((Object)yhsTaxTotal, (Object)tempTaxTypeNsTotal);
            } else if (Arrays.asList(TctsaTypeEnum.TAX_FJS.getDeclarationType()).contains(type)) {
                fjsTaxTotal = BigDecimalUtil.addObject((Object)fjsTaxTotal, (Object)tempTaxTypeNsTotal);
            } else if (Arrays.asList(TctsaTypeEnum.TAX_FCS.getDeclarationType()).contains(type)) {
                fcsTaxTotal = BigDecimalUtil.addObject((Object)fcsTaxTotal, (Object)tempTaxTypeNsTotal);
            } else if (Arrays.asList(TctsaTypeEnum.TAX_CZTDS.getDeclarationType()).contains(type)) {
                ztdsysTaxTotal = BigDecimalUtil.addObject((Object)ztdsysTaxTotal, (Object)tempTaxTypeNsTotal);
            }
            tempTaxTypeNsTotal = BigDecimal.ZERO;
        }
        PieChart chart = (PieChart)this.getControl("piechartap");
        chart.clearData();
        PieSeries series = chart.createSeries(ResManager.loadKDString((String)"", (String)"TaxStatisticsCardPlugin_11", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        AmountObject amountObject = new AmountObject(zzsTaxTotal, sdsTaxTotal, yhsTaxTotal, fjsTaxTotal, fcsTaxTotal, ztdsysTaxTotal);
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TaxStatisticsCardPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)amountObject.getTotalVat().divide(this.TEN_THOUSAND, 2, RoundingMode.HALF_UP), "#3F83F2"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u6240\u5f97\u7a0e", (String)"TaxStatisticsCardPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)amountObject.getTotalIncome().divide(this.TEN_THOUSAND, 2, RoundingMode.HALF_UP), "#4FCE9A"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"TaxStatisticsCardPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)amountObject.getTotalOther().divide(this.TEN_THOUSAND, 2, RoundingMode.HALF_UP), "#FEC035"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u9644\u52a0\u7a0e", (String)"TaxStatisticsCardPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)amountObject.getTotalFjs().divide(this.TEN_THOUSAND, 2, RoundingMode.HALF_UP), "#40A9FF"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"TaxStatisticsCardPlugin_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)amountObject.getTotalFcs().divide(this.TEN_THOUSAND, 2, RoundingMode.HALF_UP), "#26C9C3"));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"TaxStatisticsCardPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)amountObject.getTotalZctds().divide(this.TEN_THOUSAND, 2, RoundingMode.HALF_UP), "#73D13D"));
        Map itemNormalStyle = series.getItemNormalStyle();
        HashMap<String, Object> lableMap = new HashMap<String, Object>();
        lableMap.put("show", Boolean.FALSE);
        lableMap.put("position", "center");
        itemNormalStyle.put("label", lableMap);
        HashMap<String, Boolean> lableLineMap = new HashMap<String, Boolean>();
        lableLineMap.put("show", Boolean.FALSE);
        itemNormalStyle.put("labelLine", lableLineMap);
        series.setRadius("50%", "70%");
        Map<String, Object> values = this.getValues(series);
        this.setEmphasisLabel(values);
        chart.setShowTooltip(true);
        chart.addTooltip("trigger", (Object)"item");
        chart.addTooltip("formatter", (Object)ResManager.loadKDString((String)"{a} <br/>{b} : {c}\u4e07\u5143 ({d}%)", (String)"TaxStatisticsCardPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setLegendVertical(false);
        chart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 23});
        chart.refresh();
    }

    private void setEmphasisLabel(Map<String, Object> values) {
        if (null != values && values.size() > 0) {
            Map itemStyle = (Map)values.get("itemStyle");
            HashMap emphasisMap = new HashMap();
            HashMap<String, Serializable> labelMap = new HashMap<String, Serializable>();
            HashMap<String, String> textStyleMap = new HashMap<String, String>();
            textStyleMap.put("fontSize", "24");
            textStyleMap.put("fontWeight", "bold");
            labelMap.put("show", Boolean.TRUE);
            labelMap.put("textStyle", textStyleMap);
            emphasisMap.put("label", labelMap);
            HashMap<String, Boolean> labelLineMap = new HashMap<String, Boolean>();
            labelLineMap.put("show", Boolean.FALSE);
            emphasisMap.put("labelLine", labelLineMap);
            itemStyle.put("emphasis", emphasisMap);
        }
    }

    private Map<String, Object> getValues(PieSeries series) {
        try {
            Class<?> clazz = Class.forName("kd.bos.form.chart.Series");
            Method getValues = clazz.getDeclaredMethod("getValues", new Class[0]);
            AccessibleObject.setAccessible(new AccessibleObject[]{getValues}, true);
            Object invoke = getValues.invoke((Object)series, (Object[])null);
            return null == invoke ? new HashMap(16) : (Map)invoke;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    static {
        shuizhongMap.put(ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TaxStatisticsCardPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "zzs");
        shuizhongMap.put(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"TaxStatisticsCardPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "qysds");
        shuizhongMap.put(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"TaxStatisticsCardPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "yhs");
        shuizhongMap.put(ResManager.loadKDString((String)"\u9644\u52a0\u7a0e", (String)"TaxStatisticsCardPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "fjs");
        shuizhongMap.put(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"TaxStatisticsCardPlugin_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "fcscztdsys");
        shuizhongMap.put(ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"TaxStatisticsCardPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "cztdsys");
    }

    static class AmountObject {
        private BigDecimal totalZzs;
        private BigDecimal totalSds;
        private BigDecimal totalYhs;
        private BigDecimal totalFjs;
        private BigDecimal totalFcs;
        private BigDecimal totalZctds;

        AmountObject(BigDecimal totalZzs, BigDecimal totalSds, BigDecimal totalYhs, BigDecimal totalFjs, BigDecimal totalFcs, BigDecimal totalZctds) {
            this.totalZzs = totalZzs;
            this.totalSds = totalSds;
            this.totalYhs = totalYhs;
            this.totalFjs = totalFjs;
            this.totalFcs = totalFcs;
            this.totalZctds = totalZctds;
        }

        BigDecimal getTotalVat() {
            return this.totalZzs;
        }

        BigDecimal getTotalIncome() {
            return this.totalSds;
        }

        BigDecimal getTotalOther() {
            return this.totalYhs;
        }

        BigDecimal getTotalFjs() {
            return this.totalFjs;
        }

        BigDecimal getTotalFcs() {
            return this.totalFcs;
        }

        BigDecimal getTotalZctds() {
            return this.totalZctds;
        }
    }
}

