/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang.StringUtils;

public class TaxStatisticsList
extends AbstractListPlugin {
    private static final String FIELD_TAX_TYPE = "type";

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc source = (AbstractColumnDesc)e.getSource();
        String key = source.getKey();
        DynamicObject rowData = e.getRowData();
        if ("taxbearingrate".equals(key)) {
            String type = rowData.getString(FIELD_TAX_TYPE);
            if (type.equals("zzsybnsr") || type.equals("zzsxgmnsr") || type.equals("qysdsjb") || type.equals("qysdsnb")) {
                BigDecimal bqybtse = rowData.getBigDecimal("bqybtse");
                BigDecimal yssr = rowData.getBigDecimal("yssr");
                if (yssr.compareTo(BigDecimal.ZERO) == 0) {
                    e.setFormatValue((Object)"0%");
                } else {
                    e.setFormatValue((Object)(bqybtse.multiply(new BigDecimal(100)).divide(yssr, 2, RoundingMode.HALF_UP) + "%"));
                }
            } else {
                e.setFormatValue((Object)"\u2014\u2014");
            }
        } else if ("year".equals(key)) {
            Date skssqq = rowData.getDate("skssqq");
            e.setFormatValue((Object)(skssqq.getYear() + 1900));
        } else if ("month".equals(key)) {
            Date skssqq = rowData.getDate("skssqq");
            e.setFormatValue((Object)String.format(ResManager.loadKDString((String)"%s\u6708", (String)"TaxStatisticsList_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), skssqq.getMonth() + 1));
        } else if ("province".equals(key)) {
            String zcdz = rowData.getString("zcdz");
            if (StringUtils.isNotBlank((String)zcdz)) {
                e.setFormatValue((Object)zcdz.split("_")[0]);
            }
        } else if ("taxtype".equals(key)) {
            String type = e.getRowData().getString(FIELD_TAX_TYPE);
            if (type.equals("zzsybnsr") || type.equals("zzsxgmnsr")) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TaxStatisticsList_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            } else {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"TaxStatisticsList_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        QFilter selectedFlagFilter = null;
        for (QFilter qFilter : qFilters) {
            if (!FIELD_TAX_TYPE.equals(qFilter.getProperty())) continue;
            selectedFlagFilter = qFilter;
        }
        if (selectedFlagFilter != null) {
            qFilters.remove(selectedFlagFilter);
            Object value = selectedFlagFilter.getValue();
            QFilter filter = null;
            if (value instanceof List) {
                for (String filterValue : (List)value) {
                    QFilter qFilter = this.generateQFilter(filterValue);
                    filter = this.getResultFilter(filter, qFilter);
                }
            } else if (value instanceof String) {
                filter = this.generateQFilter((String)value);
            }
            qFilters.add(filter);
        }
    }

    private QFilter generateQFilter(String filterValue) {
        String[] filters = filterValue.split(",");
        QFilter result = null;
        for (String filterType : filters) {
            QFilter filter;
            QFilter filter2;
            QFilter filter1;
            if (filterType.equals("zzs")) {
                filter1 = new QFilter(FIELD_TAX_TYPE, "=", (Object)"zzsybnsr");
                filter2 = new QFilter(FIELD_TAX_TYPE, "=", (Object)"zzsxgmnsr");
                result = this.getResultFilter(result, filter1.or(filter2));
                continue;
            }
            if (filterType.equals("xfs")) {
                filter = new QFilter(FIELD_TAX_TYPE, "=", (Object)"3");
                result = this.getResultFilter(result, filter);
                continue;
            }
            if (filterType.equals("qysdsjb")) {
                filter1 = new QFilter(FIELD_TAX_TYPE, "=", (Object)"qysdsjb");
                filter2 = new QFilter(FIELD_TAX_TYPE, "=", (Object)"qysdsnb");
                result = this.getResultFilter(result, filter1.or(filter2));
                continue;
            }
            if (!filterType.equals("yhs")) continue;
            filter = new QFilter(FIELD_TAX_TYPE, "=", (Object)"5");
            result = this.getResultFilter(result, filter);
        }
        return result;
    }

    private QFilter getResultFilter(QFilter result, QFilter filter1) {
        result = result == null ? filter1 : result.or(filter1);
        return result;
    }
}

