/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tctsa.common.util.DateUtils;

public class TctsaAppHomePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Date startDate = DateUtils.getFirstDateOfYear((Date)new Date());
        this.getModel().setValue("startdate", (Object)startDate);
        this.getModel().setValue("enddate", (Object)new Date());
        this.putYearToCache();
    }

    private boolean validateDate(Date start, Date end) {
        Date startdate;
        Date enddate = DateUtils.getLastDateOfMonth((Date)end);
        return null == enddate || null == start || !(startdate = DateUtils.getFirstDateOfMonth((Date)start)).after(enddate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        Date date = (Date)this.getModel().getValue("startdate");
        Date dateend = (Date)this.getModel().getValue("enddate");
        if (date == null || dateend == null) {
            return;
        }
        boolean result = this.putYearToCache();
        if (result) {
            this.refreshView();
        } else {
            ChangeData[] valueSet = e.getChangeSet();
            Object propValue = valueSet[0].getOldValue();
            String propName = e.getProperty().getName();
            this.getModel().setValue(propName, propValue);
        }
    }

    private boolean putYearToCache() {
        Date dateend;
        Date date = (Date)this.getModel().getValue("startdate");
        boolean result = this.validateDate(date, dateend = (Date)this.getModel().getValue("enddate"));
        if (!result) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u4efd\u9009\u62e9\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f00\u59cb\u6708\u4efd\u8981\u65e9\u4e8e\u7ed3\u675f\u6708\u4efd\u3002", (String)"TctsaAppHomePlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (date != null) {
            this.getPageCache().put("startdate", DateUtils.format((Date)date));
        } else {
            this.getPageCache().put("startdate", DateUtils.format((Date)new Date()));
        }
        if (dateend != null) {
            this.getPageCache().put("enddate", DateUtils.format((Date)dateend));
        }
        return true;
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.refreshView();
        }
    }
}

