/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.baserpt.data.dateset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.ReportShowParameter;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.tctsa.common.rpt.RptDataSetFacility;
import kd.taxc.tctsa.common.rpt.RptDatasetProcess;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class RptDataSetFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TabSelectListener,
RowClickEventListener {
    public static final String CURRENT_TAB = "CURRENT_TAB";
    private static final String TYPE = "type";
    private static final String SBB_THREE_TYPE = "sbbthreetype";
    private static final String SBB_TWO_TYPE = "sbbtwotype";
    private static final String TABLE = "table";
    private static final String ARG_ENTRYENTITY = "arg_entryentity";
    private static final String CELL_ENTRYENTITY = "cell_entryentity";
    private static final String VALUE_ENTRYENTITY = "value_entryentity";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ARG_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(CELL_ENTRYENTITY);
        entryGrid1.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getControl(VALUE_ENTRYENTITY);
        entryGrid2.addRowClickListener((RowClickEventListener)this);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    private void setVisible() {
        String type = this.getModel().getDataEntity().getString(TYPE);
        if ("3.0".equalsIgnoreCase(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SBB_THREE_TYPE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SBB_TWO_TYPE, TABLE, "cell_field"});
        } else if ("2.0".equalsIgnoreCase(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SBB_TWO_TYPE, "cell_field"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SBB_THREE_TYPE, TABLE});
        } else if ("tz".equalsIgnoreCase(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TABLE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SBB_THREE_TYPE, SBB_TWO_TYPE, "cell_field"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SBB_THREE_TYPE, SBB_TWO_TYPE, TABLE, "cell_field"});
        }
    }

    private void setComboItem() {
        this.setCmboItem("arg_name");
        this.setCmboItem("cell_bref");
        this.setPluginCombo();
    }

    private void setCmboItem(String name) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(name);
        String type = this.getModel().getDataEntity().getString(TYPE);
        List<Object> comboItems = new ArrayList(8);
        if ("3.0".equalsIgnoreCase(type)) {
            List fieldList = RptDataSetFacility.getEntityFields((DynamicObject)this.getModel().getDataEntity());
            if (fieldList == null) {
                return;
            }
            comboItems = fieldList.stream().map(entityField -> {
                String fieldName = entityField.getFieldName();
                if (StringUtils.isEmpty((CharSequence)fieldName)) {
                    return null;
                }
                return new ComboItem(new LocaleString(entityField.getFieldName()), entityField.getFieldId());
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        comboEdit.setComboItems(comboItems);
    }

    private EntityField getEntityField(String fieldStr) {
        List entityFields = RptDataSetFacility.getEntityFields((DynamicObject)this.getModel().getDataEntity());
        if (CollectionUtils.isEmpty((Collection)entityFields)) {
            return null;
        }
        Optional<EntityField> first = entityFields.stream().filter(m -> fieldStr.equalsIgnoreCase(m.getFieldId())).findFirst();
        return first.orElse(null);
    }

    public void afterBindData(EventObject e) {
        this.setVisible();
        this.setComboItem();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("arg_type".equalsIgnoreCase(name) || "arg_default".equalsIgnoreCase(name) || "arg_debug".equalsIgnoreCase(name) || "arg_mustinput".equalsIgnoreCase(name)) {
            return;
        }
        if ("cell_arg_name".equalsIgnoreCase(name) || "cell_arg_json".equalsIgnoreCase(name)) {
            return;
        }
        this.setVisible();
        if (this.getModel().getValue(SBB_THREE_TYPE) != null) {
            this.setComboItem();
        }
        if ("arg_name".equalsIgnoreCase(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ARG_ENTRYENTITY);
            if (newValue == null) {
                this.getModel().setValue("arg_type", null, rowIndex);
            } else {
                EntityField entityField = this.getEntityField(String.valueOf(newValue));
                String s = entityField == null ? null : entityField.getFieldType();
                this.getModel().setValue("arg_type", (Object)s, rowIndex);
            }
            this.getModel().setValue("arg_default", null, rowIndex);
            this.getModel().setValue("arg_debug", null, rowIndex);
            this.getModel().setValue("arg_mustinput", (Object)false, rowIndex);
        } else if ("plugintype".equalsIgnoreCase(name)) {
            this.setPluginCombo();
        }
    }

    private void setPluginCombo() {
        ComboEdit valueDefaultFormulaCombo = (ComboEdit)this.getView().getControl("value_default_formula");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(8);
        map.put(ResManager.loadKDString((String)"\u6839\u636eid\u83b7\u53d6\u7a0e\u52a1\u7ec4\u7ec7\u540d\u79f0", (String)"RptDataSetFormPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "swzzmc");
        map.put(ResManager.loadKDString((String)"\u6839\u636eid\u83b7\u53d6\u7a0e\u6536\u5236\u5ea6\u540d\u79f0", (String)"RptDataSetFormPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "sszd");
        map.put(ResManager.loadKDString((String)"\u6839\u636eid\u83b7\u53d6\u7a0e\u79cd\u540d\u79f0", (String)"RptDataSetFormPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "sz");
        map.put(ResManager.loadKDString((String)"\u6839\u636eid\u83b7\u53d6\u7a0e\u6536\u8f96\u533a\u540d\u79f0", (String)"RptDataSetFormPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "ssxq");
        map.put(ResManager.loadKDString((String)"\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u7ba1\u7406\u533a\u57df", (String)"RptDataSetFormPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "glqy");
        map.put(ResManager.loadKDString((String)"\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u6240\u5c5e\u884c\u4e1a", (String)"RptDataSetFormPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "sshy");
        List comboItems = map.entrySet().stream().map(entityField -> new ComboItem(new LocaleString((String)entityField.getKey()), (String)entityField.getValue())).collect(Collectors.toList());
        valueDefaultFormulaCombo.setComboItems(comboItems);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            String plugintype = this.getModel().getDataEntity().getString("plugintype");
            if ("config_arg".equalsIgnoreCase(key)) {
                if (StringUtils.isEmpty((CharSequence)plugintype)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u63d2\u4ef6", (String)"RptDataSetFormPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                }
                try {
                    Class<?> aClass = Class.forName(RptDataSetFacility.getPluginClassName((String)plugintype));
                    RptDatasetProcess rptDatasetProcess = (RptDatasetProcess)aClass.newInstance();
                    rptDatasetProcess.showArgView((IFormPlugin)this, this.getView());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u4ef6\u914d\u7f6e\u9519\u8bef", (String)"RptDataSetFormPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if ("debug".equalsIgnoreCase(operateKey)) {
            ReportShowParameter param = new ReportShowParameter();
            param.setFormId("tctsa_rpt_debug");
            param.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> customParam = new HashMap<String, String>(8);
            String tab = this.getPageCache().get(CURRENT_TAB);
            if (StringUtils.isEmpty((CharSequence)tab)) {
                tab = "arg";
                this.getPageCache().put(CURRENT_TAB, tab);
            }
            customParam.put(CURRENT_TAB, tab);
            param.setCustomParams(customParam);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getRow() < 0) {
            return;
        }
        if (!this.hasTable()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u6570\u636e\u96c6\u7c7b\u578b\u548c\u5bf9\u5e94\u7684\u7533\u62a5\u8868\u6a21\u677f/\u53f0\u8d26\u5143\u6570\u636e\u6807\u8bc6\u3002", (String)"RptDataSetFormPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("showArgView".equals(evt.getActionId()) && evt.getReturnData() != null) {
            Map map = (Map)evt.getReturnData();
            try {
                String plugin = this.getModel().getDataEntity().getString("plugintype");
                Class<?> aClass = Class.forName(RptDataSetFacility.getPluginClassName((String)plugin));
                RptDatasetProcess rptDatasetProcess = (RptDatasetProcess)aClass.newInstance();
                ImmutablePair result = rptDatasetProcess.showArgViewCallback(map);
                EntryGrid entryGrid2 = (EntryGrid)this.getControl(CELL_ENTRYENTITY);
                int[] selectRows = entryGrid2.getSelectRows();
                this.getModel().setValue("cell_arg_name", result.left, selectRows[0]);
                this.getModel().setValue("cell_arg_json", result.right, selectRows[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u4ef6\u914d\u7f6e\u9519\u8bef", (String)"RptDataSetFormPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean hasTable() {
        String type = this.getModel().getDataEntity().getString(TYPE);
        if ("3.0".equalsIgnoreCase(type)) {
            return this.getModel().getDataEntity().get(SBB_THREE_TYPE) != null;
        }
        if ("2.0".equalsIgnoreCase(type)) {
            return this.getModel().getDataEntity().get(SBB_TWO_TYPE) != null;
        }
        if ("tz".equalsIgnoreCase(type)) {
            return this.getModel().getDataEntity().get(TABLE) != null;
        }
        return false;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.getPageCache().put(CURRENT_TAB, tabKey);
    }
}

