/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.baserpt.data.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctsa.common.rpt.RptDataSetFacility;
import org.apache.commons.lang3.StringUtils;

public class RptDebugPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final List<String> ID_FEILD_LIST = Arrays.asList("Org", "Long", "Basedata");
    private static final List<String> STR_FEILD_LIST = Arrays.asList("Text", "BillStatus", "Combo", "Varchar");
    private static final List<String> BOL_FEILD_LIST = Collections.singletonList("Boolean");
    private static final List<String> DATE_FEILD_LIST = Arrays.asList("Date", "DateTime");
    public static final String CURRENT_TAB = "CURRENT_TAB";
    private static final String REPORTLISTAP = "reportlistap";

    public void registerListener(EventObject e) {
        ReportList reportList = (ReportList)this.getControl(REPORTLISTAP);
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IPageCache parentCache = parentView.getPageCache();
        String tabName = parentCache.get(CURRENT_TAB);
        DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)parentModel.getDataEntity().getLong("id"), (String)"tctsa_rpt_data");
        String plugintype = rptConfig.getString("plugintype");
        String plugin = RptDataSetFacility.getPluginClassName((String)plugintype);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        Long typeId = rptConfig.getLong("sbbthreetype.id");
        qFilters.add(new QFilter("templateid", "=", (Object)typeId));
        DynamicObjectCollection argEntryentity = rptConfig.getDynamicObjectCollection("arg_entryentity");
        for (DynamicObject argEntry : argEntryentity) {
            String json;
            String argName = argEntry.getString("arg_name");
            String argType = argEntry.getString("arg_type");
            String argDefault = argEntry.getString("arg_default");
            String argDebug = argEntry.getString("arg_debug");
            boolean argMustinput = argEntry.getBoolean("arg_mustinput");
            boolean argUnique = argEntry.getBoolean("arg_unique");
            String string = json = StringUtils.isEmpty((CharSequence)argDebug) ? argDefault : argDebug;
            if (argMustinput && StringUtils.isEmpty((CharSequence)json)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5165\u53c2\u6570", (String)"RptDebugPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
            Object filterValue = null;
            if (ID_FEILD_LIST.contains(argType)) {
                filterValue = this.fromJsonString(json, argUnique, Long.class);
            } else if (STR_FEILD_LIST.contains(argType)) {
                filterValue = this.fromJsonString(json, argUnique, String.class);
            } else if (BOL_FEILD_LIST.contains(argType)) {
                filterValue = this.fromJsonString(json, argUnique, Boolean.class);
            } else if (DATE_FEILD_LIST.contains(argType)) {
                filterValue = this.fromJsonString(json, argUnique, Date.class);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7c7b\u578b\u7684\u53c2\u6570", (String)"RptDebugPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
            if (filterValue == null) continue;
            qFilters.add(new QFilter(argName, "=", filterValue));
        }
        queryParam.getCustomParam().put("Type", tabName);
        queryParam.getCustomParam().put("Table", RptDataSetFacility.getTable((Long)rptConfig.getLong("id")));
        queryParam.getCustomParam().put("id", rptConfig.getString("id"));
        queryParam.getCustomParam().put("Filter", qFilters);
        queryParam.getCustomParam().put("plugin", plugin);
    }

    private Object fromJsonString(String json, boolean argUnique, Class<?> valueType) {
        try {
            if (argUnique) {
                return SerializationUtils.fromJsonString((String)json, valueType);
            }
            return SerializationUtils.fromJsonStringToList((String)json, valueType);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u5931\u8d25", (String)"RptDebugPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        DynamicObject rowData = ((ReportList)evt.getSource()).getReportModel().getRowData(evt.getRowIndex());
        if ("0".equals(rowData.getString(fieldName = evt.getFieldName()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728", (String)"RptDebugPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)parentModel.getDataEntity().getLong("id"), (String)"tctsa_rpt_data");
        DynamicObjectCollection cellEntryentity = rptConfig.getDynamicObjectCollection("cell_entryentity");
        Optional<DynamicObject> cellNoOpt = cellEntryentity.stream().filter(m -> m.getString("cell_no").equals(fieldName)).findFirst();
        if (!cellNoOpt.isPresent()) {
            return;
        }
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("tctsa_rpt_detail_debug");
        param.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customParam = new HashMap<String, Object>(8);
        customParam.put(CURRENT_TAB, "cell");
        customParam.put("cell_no", fieldName);
        customParam.put("id", parentModel.getDataEntity().getLong("id"));
        customParam.put("row_id", rowData.getLong("id"));
        customParam.put("fieldName", fieldName);
        param.setCustomParams(customParam);
        this.getView().showForm((FormShowParameter)param);
    }
}

