/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.baserpt.data.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.tctsa.common.rpt.RptDataSetFacility;
import org.apache.commons.collections4.CollectionUtils;

public class RptDebugQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String ID = "id";
    private static final Log logger = LogFactory.getLog(RptDebugQueryPlugin.class);

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        block19: {
            DynamicObject rptConfig;
            String type;
            block20: {
                block18: {
                    columns.clear();
                    type = (String)this.getQueryParam().getCustomParam().get("Type");
                    Long id = Long.parseLong(String.valueOf(this.getQueryParam().getCustomParam().get(ID)));
                    String plugin = (String)this.getQueryParam().getCustomParam().get("plugin");
                    rptConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctsa_rpt_data");
                    if (!"arg".equalsIgnoreCase(type)) break block18;
                    List entityFields = RptDataSetFacility.getEntityFields((DynamicObject)rptConfig);
                    for (EntityField field : entityFields) {
                        ReportColumn endRpt = new ReportColumn();
                        endRpt.setCaption(new LocaleString(field.getFieldName()));
                        endRpt.setFieldKey(field.getFieldId());
                        endRpt.setFieldType("text");
                        columns.add((AbstractReportColumn)endRpt);
                    }
                    break block19;
                }
                if (!"cell".equalsIgnoreCase(type)) break block20;
                DynamicObjectCollection cellEntryentity = rptConfig.getDynamicObjectCollection("cell_entryentity");
                if (CollectionUtils.isEmpty((Collection)cellEntryentity)) {
                    return columns;
                }
                ReportColumn endRpt = new ReportColumn();
                endRpt.setCaption(new LocaleString("ID"));
                endRpt.setFieldKey(ID);
                endRpt.setFieldType("bigint");
                columns.add((AbstractReportColumn)endRpt);
                for (DynamicObject cellEntry : cellEntryentity) {
                    ReportColumn reportColumn = new ReportColumn();
                    String cellType = cellEntry.getString("cell_type");
                    String cellBy = cellEntry.getString("cell_by");
                    reportColumn.setCaption(new LocaleString(cellEntry.getString("cell_name")));
                    reportColumn.setFieldKey(cellEntry.getString("cell_no"));
                    if ("dth".equalsIgnoreCase(cellBy)) {
                        reportColumn.setFieldType("text");
                    } else if ("str".equalsIgnoreCase(cellType)) {
                        reportColumn.setFieldType("text");
                    } else if ("je".equalsIgnoreCase(cellType)) {
                        reportColumn.setFieldType("decimal");
                    } else if ("sl".equalsIgnoreCase(cellType)) {
                        reportColumn.setFieldType("integer");
                    } else if (ID.equalsIgnoreCase(cellType)) {
                        reportColumn.setFieldType("bigint");
                    } else if ("date".equalsIgnoreCase(cellType)) {
                        reportColumn.setFieldType("date");
                    } else if ("xs".equalsIgnoreCase(cellType)) {
                        reportColumn.setFieldType("decimal");
                    }
                    reportColumn.setHyperlink("dth".equalsIgnoreCase(cellBy));
                    reportColumn.setZeroShow(true);
                    columns.add((AbstractReportColumn)reportColumn);
                }
                break block19;
            }
            if (!"value".equalsIgnoreCase(type)) break block19;
            DynamicObjectCollection valueEntryentity = rptConfig.getDynamicObjectCollection("value_entryentity");
            if (CollectionUtils.isEmpty((Collection)valueEntryentity)) {
                return columns;
            }
            ReportColumn endRpt = new ReportColumn();
            endRpt.setCaption(new LocaleString("ID"));
            endRpt.setFieldKey(ID);
            endRpt.setFieldType("text");
            columns.add((AbstractReportColumn)endRpt);
            for (DynamicObject valueEntry : valueEntryentity) {
                ReportColumn reportColumn = new ReportColumn();
                reportColumn.setCaption(new LocaleString(valueEntry.getString("value_name")));
                reportColumn.setFieldKey(valueEntry.getString("value_no"));
                reportColumn.setFieldType("text");
                reportColumn.setZeroShow(true);
                columns.add((AbstractReportColumn)reportColumn);
            }
        }
        return columns;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        try {
            String type = (String)reportQueryParam.getCustomParam().get("Type");
            String plugin = (String)reportQueryParam.getCustomParam().get("plugin");
            long id = Long.parseLong(String.valueOf(reportQueryParam.getCustomParam().get(ID)));
            DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctsa_rpt_data");
            String table = (String)reportQueryParam.getCustomParam().get("Table");
            List filters = (List)reportQueryParam.getCustomParam().get("Filter");
            if ("arg".equalsIgnoreCase(type)) {
                return RptDataSetFacility.getArgRows((Long)id, (List)filters);
            }
            if ("cell".equalsIgnoreCase(type)) {
                return (DataSet)RptDataSetFacility.getCellRow((Long)Long.valueOf((long)id), (List)filters).left;
            }
            if ("value".equalsIgnoreCase(type)) {
                return RptDataSetFacility.getValueRows((Long)id, (List)filters);
            }
            return this.getEmptyRows();
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u63d2\u4ef6\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38:" + exceptionStackTraceMessage);
            throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u4ef6\u914d\u7f6e\u9519\u8bef", (String)"RptDebugQueryPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
    }

    private DataSet getEmptyRows() {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"field"}, (DataType[])new DataType[]{DataType.StringType});
        CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }
}

