/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.baserpt.data.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.common.rpt.RptDataSetFacility;
import org.apache.commons.collections4.CollectionUtils;

public class RptDetailDebugQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String ID = "id";

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        columns.clear();
        Long id = (Long)this.getQueryParam().getCustomParam().get(ID);
        DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctsa_rpt_data");
        DynamicObjectCollection cellEntryentity = rptConfig.getDynamicObjectCollection("cell_entryentity");
        if (CollectionUtils.isEmpty((Collection)cellEntryentity)) {
            return columns;
        }
        ReportColumn endRpt = new ReportColumn();
        endRpt.setCaption(new LocaleString(ID));
        endRpt.setFieldKey(ID);
        endRpt.setFieldType("text");
        columns.add((AbstractReportColumn)endRpt);
        ReportColumn endRpt2 = new ReportColumn();
        endRpt2.setCaption(new LocaleString("number"));
        endRpt2.setFieldKey("number");
        endRpt2.setFieldType("text");
        columns.add((AbstractReportColumn)endRpt2);
        ReportColumn endRpt1 = new ReportColumn();
        endRpt1.setCaption(new LocaleString("amount"));
        endRpt1.setFieldKey("amount");
        endRpt1.setFieldType("text");
        columns.add((AbstractReportColumn)endRpt1);
        return columns;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        Long id = Long.parseLong(String.valueOf(reportQueryParam.getCustomParam().get(ID)));
        String cellNo = String.valueOf(reportQueryParam.getCustomParam().get("cell_no"));
        long rowId = Long.parseLong(String.valueOf(reportQueryParam.getCustomParam().get("row_id")));
        String table = RptDataSetFacility.getTable((Long)id);
        DynamicObject rptConfig = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tctsa_rpt_data");
        DynamicObjectCollection cellEntryentity = rptConfig.getDynamicObjectCollection("cell_entryentity");
        if (CollectionUtils.isEmpty((Collection)cellEntryentity)) {
            return this.getEmptyRows();
        }
        List<String> btFields = cellEntryentity.stream().filter(m -> "bt".equalsIgnoreCase(m.getString("cell_by"))).map(m -> m.getString("cell_bref")).collect(Collectors.toList());
        if (!btFields.contains(ID)) {
            btFields.add(ID);
        }
        String mainField = String.join((CharSequence)",", btFields);
        QFilter filter = new QFilter(ID, "=", (Object)rowId);
        DataSet mainTsdDataSet = QueryServiceHelper.queryDataSet((String)(System.currentTimeMillis() + ""), (String)table, (String)mainField, (QFilter[])filter.toArray(), null);
        if (mainTsdDataSet.isEmpty()) {
            return this.getEmptyRows();
        }
        DataSet idsDataSet = mainTsdDataSet.copy();
        ArrayList<Long> entryids = new ArrayList<Long>(8);
        for (Row mian : idsDataSet) {
            entryids.add(mian.getLong(ID));
        }
        idsDataSet.close();
        List cellNoList = cellEntryentity.stream().filter(m -> cellNo.equals(m.getString("cell_no"))).collect(Collectors.toList());
        Set cellHw = cellNoList.stream().filter(m -> m.get("cell_hw") != null).map(m -> m.getLong("cell_hw.id")).collect(Collectors.toSet());
        Set cellLw = cellNoList.stream().filter(m -> m.get("cell_lw") != null).map(m -> m.getLong("cell_lw.id")).collect(Collectors.toSet());
        Set cellJczllw = cellNoList.stream().filter(m -> m.get("cell_jczllw") != null).map(m -> m.getLong("cell_jczllw.id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(cellJczllw)) {
            cellLw.addAll(cellJczllw);
        }
        QFilter detailFilter = new QFilter("entryid", "in", entryids).and("row", "in", new ArrayList(cellHw)).and("column", "in", new ArrayList(cellLw));
        DataSet mainTsdDetailSet = QueryServiceHelper.queryDataSet((String)String.valueOf(System.currentTimeMillis()), (String)"tpo_declare_detail_tsd", (String)"entryid,cellnumber,dynrowno,index,valuetype,value", (QFilter[])detailFilter.toArray(), (String)"cellnumber asc");
        DataSet dataSet = mainTsdDataSet.copy().leftJoin(mainTsdDetailSet).on(ID, "entryid").select(btFields.toArray(new String[0]), new String[]{"cellnumber", "dynrowno", "index", "value"}).finish();
        DataSet mapDataset = dataSet.copy();
        HashMap<String, String> cellMap = new HashMap<String, String>(1024);
        for (Row row : mapDataset) {
            String key = row.getString(ID) + "#" + row.getString("cellnumber");
            String value = row.getString("value");
            cellMap.put(key, value);
        }
        mapDataset.close();
        DynamicObject cellEntry = (DynamicObject)cellNoList.get(0);
        String cellHwName = cellEntry.getString("cell_hw.number");
        String cellLwName = cellEntry.getString("cell_lw.number");
        String celljczllwName = cellEntry.getString("cell_jczllw.number");
        String cellType = cellEntry.getString("cell_type");
        Integer maxRow = this.getMaxRow(String.valueOf(rowId), cellHwName, cellLwName, cellMap);
        QFilter filter1 = new QFilter(ID, "!=", (Object)0L);
        DynamicObjectCollection gtcpFetchitem = QueryServiceHelper.query((String)"gtcp_fetchitem", (String)"id,name,number", (QFilter[])filter1.toArray());
        Map<String, List<DynamicObject>> map = gtcpFetchitem.stream().collect(Collectors.groupingBy(m -> m.getString(ID)));
        for (int i = 1; i < maxRow + 1; ++i) {
            ArrayList<String> rowData = new ArrayList<String>(8);
            String itemKey = rowId + "#" + cellHwName + "#" + i + "#" + celljczllwName;
            String amontKey = rowId + "#" + cellHwName + "#" + i + "#" + cellLwName;
            String s = (String)cellMap.get(itemKey);
            List<DynamicObject> list = map.get(s);
            if (CollectionUtils.isEmpty(list)) continue;
            String number = list.get(0).getString("number");
            rowData.add(s);
            rowData.add(number);
            rowData.add((String)cellMap.get(amontKey));
            result.add(rowData.toArray(new Object[0]));
        }
        List<String> fields = Arrays.asList(ID, "number", "amount");
        List<DataType> types = Arrays.asList(DataType.StringType, DataType.StringType, DataType.StringType);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[0]), (DataType[])types.toArray(new DataType[0]));
        CollectionInput inputs = new CollectionInput(rowMeta, result);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private Integer getMaxRow(String id, String hw, String lw, Map<String, String> cellMap) {
        for (int i = 1; i < 1000; ++i) {
            String key = id.concat("#").concat(hw).concat("#").concat(String.valueOf(i)).concat("#").concat(lw);
            if (cellMap.containsKey(key)) continue;
            return i - 1;
        }
        return 0;
    }

    private DataSet getEmptyRows() {
        this.getQueryParam().getCustomParam().put(ID, new HashMap());
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"field"}, (DataType[])new DataType[]{DataType.StringType});
        CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }
}

