/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.baserpt.data.plugin.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.refactor.formula.fel.FelEngineImpl;
import kd.taxc.tctsa.common.rpt.RptDataSetFacility;
import kd.taxc.tctsa.common.rpt.RptDatasetProcess;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class VatDatesetProcess
implements RptDatasetProcess {
    public void showArgView(IFormPlugin plugin, IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tctsa_vat_dialog");
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "showArgView");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    public ImmutablePair<String, String> showArgViewCallback(Map<String, Object> map) {
        if (MapUtils.isNotEmpty(map)) {
            String type = String.valueOf(map.get("type"));
            String s = "ynsr".equalsIgnoreCase(type) ? ResManager.loadKDString((String)"\u5e94\u7a0e\u6536\u5165", (String)"VatDatesetProcess_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u7eb3\u7a0e\u989d", (String)"VatDatesetProcess_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]);
            return ImmutablePair.of((Object)s, (Object)SerializationUtils.toJsonString(map));
        }
        return ImmutablePair.of(null, null);
    }

    public DataSet getValueDataset(DataSet cellDateset, Map<String, String> cellMap, DataSet valueRowWithNoArg, DynamicObject rptConfig) {
        DataSet idDateset = valueRowWithNoArg.copy().select("id").distinct();
        ArrayList<Long> ids = new ArrayList<Long>(8);
        for (Row row : idDateset) {
            ids.add(Long.parseLong(row.getString("id")));
        }
        idDateset.close();
        DynamicObjectCollection valueEntryentity = rptConfig.getDynamicObjectCollection("value_entryentity");
        DynamicObjectCollection cellEntryentity = rptConfig.getDynamicObjectCollection("cell_entryentity");
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id,taxsystem,taxareagroup", (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> mainMap = dynamicObjects.stream().collect(Collectors.groupingBy(m -> m.getLong("id")));
        QFilter filter = new QFilter("id", "!=", (Object)0L);
        DynamicObject[] bastaxTaxareagroups = BusinessDataServiceHelper.load((String)"bastax_taxareagroup", (String)"id,name,number", (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> taxareagroupMap = Arrays.stream(bastaxTaxareagroups).collect(Collectors.groupingBy(m -> m.getLong("id")));
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        QFilter filter1 = new QFilter("id", "!=", (Object)0L);
        DynamicObjectCollection gtcpFetchitem = QueryServiceHelper.query((String)"tctsa_item_area", (String)"fetchitem,taxareagroup", (QFilter[])filter1.toArray());
        HashMap<Long, Long> itemTaxareagroupMap = new HashMap<Long, Long>(8);
        for (Object dynamicObject : gtcpFetchitem) {
            long fetchitem = dynamicObject.getLong("fetchitem");
            long taxareagroup = dynamicObject.getLong("taxareagroup");
            itemTaxareagroupMap.put(fetchitem, taxareagroup);
        }
        FelEngineImpl engine = new FelEngineImpl();
        for (Row row : valueRowWithNoArg) {
            DataSet rows1;
            Long rowId = Long.parseLong(row.getString("id"));
            List<DynamicObject> list = mainMap.get(rowId);
            if (CollectionUtils.isEmpty(list) || (rows1 = cellDateset.copy().filter(new QFilter("id", "=", (Object)rowId).toString())).isEmpty()) continue;
            Row cellRow = (Row)rows1.iterator().next();
            long taxsystem = list.get(0).getLong("taxsystem");
            long taxareagroupId = list.get(0).getLong("taxareagroup");
            if (1636078644810086400L == taxsystem) {
                LinkedHashMap<Long, String> ynsrMap = this.getAreaList(cellMap, cellEntryentity, itemTaxareagroupMap, cellRow, "ynsr");
                LinkedHashMap<Long, String> ynseMap = this.getAreaList(cellMap, cellEntryentity, itemTaxareagroupMap, cellRow, "ynse");
                for (Map.Entry<Long, String> ynsrEntry : ynsrMap.entrySet()) {
                    taxareagroupId = ynsrEntry.getKey();
                    if (!ynseMap.containsKey(taxareagroupId)) continue;
                    String ynsr = ynsrEntry.getValue();
                    String ynse = ynseMap.get(taxareagroupId);
                    ArrayList<String> rowData = new ArrayList<String>(8);
                    rowData.add(String.valueOf(rowId));
                    for (DynamicObject valueEntry : valueEntryentity) {
                        String value;
                        String valueNo = valueEntry.getString("value_no");
                        String valueFormula = valueEntry.getString("value_formula");
                        String valueDefaultFormula = valueEntry.getString("value_default_formula");
                        if (StringUtils.isNotEmpty((String)valueDefaultFormula)) {
                            value = row.getString(valueNo);
                            rowData.add(value);
                            continue;
                        }
                        if (StringUtils.isNotEmpty((String)valueFormula)) {
                            value = String.valueOf(RptDataSetFacility.getValue((String)valueFormula, (Row)cellRow));
                            rowData.add(value);
                            continue;
                        }
                        if ("taxareagroup".equalsIgnoreCase(valueNo)) {
                            String name;
                            String string = name = taxareagroupMap.get(taxareagroupId) == null ? "" : taxareagroupMap.get(taxareagroupId).get(0).getString("name");
                            if (StringUtils.isEmpty((String)name)) continue;
                            rowData.add(String.valueOf(taxareagroupId));
                            continue;
                        }
                        if ("ynse".equalsIgnoreCase(valueNo)) {
                            rowData.add(ynse);
                            continue;
                        }
                        if (!"ynsr".equalsIgnoreCase(valueNo)) continue;
                        rowData.add(ynsr);
                    }
                    result.add(rowData.toArray(new Object[0]));
                }
                continue;
            }
            ArrayList<String> rowData = new ArrayList<String>(8);
            rowData.add(String.valueOf(rowId));
            for (DynamicObject valueEntry : valueEntryentity) {
                String value;
                String valueNo = valueEntry.getString("value_no");
                String valueFormula = valueEntry.getString("value_formula");
                String valueDefaultFormula = valueEntry.getString("value_default_formula");
                if (StringUtils.isNotEmpty((String)valueDefaultFormula)) {
                    value = row.getString(valueNo);
                    rowData.add(value);
                    continue;
                }
                if (StringUtils.isNotEmpty((String)valueFormula)) {
                    value = String.valueOf(RptDataSetFacility.getValue((String)valueFormula, (Row)cellRow));
                    rowData.add(value);
                    continue;
                }
                if ("taxareagroup".equalsIgnoreCase(valueNo)) {
                    String name;
                    String string = name = taxareagroupMap.get(taxareagroupId) == null ? "" : taxareagroupMap.get(taxareagroupId).get(0).getString("name");
                    if (StringUtils.isEmpty((String)name)) continue;
                    rowData.add(String.valueOf(taxareagroupId));
                    continue;
                }
                if ("ynse".equalsIgnoreCase(valueNo)) {
                    rowData.add(this.getUnUsaValue(cellEntryentity, cellRow, valueNo));
                    continue;
                }
                if (!"ynsr".equalsIgnoreCase(valueNo)) continue;
                rowData.add(this.getUnUsaValue(cellEntryentity, cellRow, valueNo));
            }
            result.add(rowData.toArray(new Object[0]));
        }
        ArrayList<String> fields = new ArrayList<String>(8);
        fields.add(0, "id");
        for (Object entry : valueEntryentity) {
            String valueNo = entry.getString("value_no");
            fields.add(valueNo);
        }
        ArrayList<StringType> dataTypes = new ArrayList<StringType>(8);
        for (String ignored : fields) {
            dataTypes.add(DataType.StringType);
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[0]), (DataType[])dataTypes.toArray(new DataType[0]));
        CollectionInput inputs = new CollectionInput(rowMeta, result);
        return Algo.create((String)this.getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private LinkedHashMap<Long, String> getAreaList(Map<String, String> cellMap, DynamicObjectCollection cellEntryentity, Map<Long, Long> itemAreaMap, Row cellRow, String type) {
        LinkedHashMap<Long, String> hashMap = new LinkedHashMap<Long, String>(8);
        for (DynamicObject entry : cellEntryentity) {
            String cellArgJson = entry.getString("cell_arg_json");
            String cellNo = entry.getString("cell_no");
            String cellBy = entry.getString("cell_by");
            if (!"dth".equalsIgnoreCase(cellBy)) continue;
            String cellHwName = entry.getString("cell_hw.number");
            String cellLwName = entry.getString("cell_lw.number");
            String celljczllwName = entry.getString("cell_jczllw.number");
            if (StringUtils.isEmpty((String)cellArgJson) || !cellArgJson.contains(type)) continue;
            String rowId = cellRow.getString("id");
            int parseInt = Integer.parseInt(cellRow.getString(cellNo));
            for (int i = 1; i < parseInt + 1; ++i) {
                String prefix = rowId.concat("#").concat(cellHwName).concat("#").concat(String.valueOf(i)).concat("#");
                String itemKey = prefix.concat(celljczllwName);
                String amontKey = prefix.concat(cellLwName);
                String item = cellMap.get(itemKey);
                String amont = cellMap.get(amontKey);
                Long areaId = itemAreaMap.get(Long.parseLong(item));
                if (areaId == null) continue;
                hashMap.put(areaId, amont);
            }
        }
        return hashMap;
    }

    private String getUnUsaValue(DynamicObjectCollection cellEntryentity, Row cellRow, String type) {
        BigDecimal r = BigDecimal.ZERO;
        for (DynamicObject cellEntry : cellEntryentity) {
            String cellNo;
            BigDecimal bigDecimal;
            String cellArgJson;
            String cellBy = cellEntry.getString("cell_by");
            if (!"gd".equalsIgnoreCase(cellBy) || StringUtils.isEmpty((String)(cellArgJson = cellEntry.getString("cell_arg_json"))) || !cellArgJson.contains(type) || (bigDecimal = cellRow.getBigDecimal(cellNo = cellEntry.getString("cell_no"))) == null) continue;
            r = r.add(bigDecimal);
        }
        return r.toString();
    }
}

