/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctsa.common.entity.TotalBean;
import kd.taxc.tctsa.common.enums.BooleanEnum;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.formplugin.board.helper.RankService;
import kd.taxc.tctsa.formplugin.board.helper.ServiceFactory;

public class AreaTaxcRankCardPlugin
extends AbstractFormPlugin
implements ListboxClickListener {
    public void afterCreateNewData(EventObject e) {
        RankService serviceFactory = this.getRankService();
        List<ListboxItem> listboxItems = serviceFactory.initListBox(this.getView());
        serviceFactory.initChat(this.getView(), listboxItems.get(0).getId());
        this.getPageCache().put("itemid", listboxItems.get(0).getId());
    }

    private RankService getRankService() {
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String type = pageCache.get("type");
        return ServiceFactory.getServiceFactory(ServiceFactory.bigCard2SmallCard(type));
    }

    public void listboxClick(ListboxEvent evt) {
        String itemId = evt.getItemId();
        RankService serviceFactory = this.getRankService();
        serviceFactory.initChat(this.getView(), itemId);
        this.getPageCache().put("itemid", itemId);
    }

    public void registerListener(EventObject e) {
        Listbox listbox = (Listbox)this.getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
        try {
            this.addClickListeners(new String[]{"querymore"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistogramChart histogramChart = (HistogramChart)this.getControl("histogramchartap");
        histogramChart.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String type = pageCache.get("type");
        String key = ((Control)evt.getSource()).getKey();
        if ("histogramchartap".equals(key)) {
            String name = ((ChartClickEvent)evt).getName();
            if (EmptyCheckUtils.isEmpty((Object)name)) {
                return;
            }
            if (EmptyCheckUtils.isEmpty((Object)type)) {
                String itemId = this.getPageCache().get("itemid");
                this.jumpToBoard(name, itemId);
            } else {
                TotalBean totalBean;
                List totalBeanList;
                String clickpagecache = this.getPageCache().get("clickpagecache");
                if (EmptyCheckUtils.isNotEmpty((Object)clickpagecache) && EmptyCheckUtils.isNotEmpty((Object)(totalBeanList = SerializationUtils.fromJsonStringToList((String)clickpagecache, TotalBean.class))) && EmptyCheckUtils.isNotEmpty((Object)(totalBean = totalBeanList.stream().filter(v -> name.equalsIgnoreCase(v.getName())).findFirst().get()))) {
                    this.openTjsjList(totalBean.getPkids());
                }
            }
        } else if ("querymore".equalsIgnoreCase(key)) {
            RankService serviceFactory = this.getRankService();
            serviceFactory.jumpToFullBoard(this.getView());
        }
    }

    private void jumpToBoard(String name, String itemid) {
        List taxtypes;
        Map<String, String> itemMap = this.itemIdMapByType(itemid);
        String type = itemMap.get("type");
        Long id = this.getBaseDataIdByName(type, name);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(itemMap.get("title"));
        parameter.setFormId("tctsa_board_home");
        parameter.setPageId(this.getView().getPageId() + id + "board");
        parameter.setHasRight(true);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("baseid", id);
        DynamicObjectCollection taxtypeList = (DynamicObjectCollection)this.getView().getParentView().getModel().getValue("taxtype");
        List list = taxtypes = EmptyCheckUtils.isEmpty((Object)taxtypeList) ? null : taxtypeList.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).distinct().collect(Collectors.toList());
        if (EmptyCheckUtils.isNotEmpty(taxtypes)) {
            paramsMap.put("taxtype", taxtypes);
        }
        paramsMap.put("type", type);
        paramsMap.put("startdate", this.getView().getParentView().getModel().getValue("startdate"));
        paramsMap.put("enddate", this.getView().getParentView().getModel().getValue("enddate"));
        parameter.setCustomParams(paramsMap);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    private Map<String, String> itemIdMapByType(String itemid) {
        HashMap<String, String> itemMap = new HashMap<String, String>(10);
        if ("5".equalsIgnoreCase(itemid)) {
            itemMap.put("type", "1");
            itemMap.put("title", ResManager.loadKDString((String)"\u533a\u57df\u5206\u6790", (String)"AreaTaxcRankCardPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return itemMap;
        }
        if ("4".equalsIgnoreCase(itemid)) {
            itemMap.put("type", "2");
            itemMap.put("title", ResManager.loadKDString((String)"\u884c\u4e1a\u5206\u6790", (String)"AreaTaxcRankCardPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return itemMap;
        }
        if ("6".equalsIgnoreCase(itemid)) {
            itemMap.put("type", "3");
            itemMap.put("title", ResManager.loadKDString((String)"\u677f\u5757\u5206\u6790", (String)"AreaTaxcRankCardPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return itemMap;
        }
        return itemMap;
    }

    private Long getBaseDataIdByName(String type, String name) {
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        qFilter.and(new QFilter("enable", "=", (Object)BooleanEnum.YES.getCode()));
        DynamicObject[] dynamicObjects = null;
        if ("1".equalsIgnoreCase(type) || "3".equalsIgnoreCase(type)) {
            dynamicObjects = BusinessDataServiceHelper.load((String)"tctb_label_group", (String)"id", (QFilter[])new QFilter[]{qFilter});
        } else if ("2".equalsIgnoreCase(type)) {
            dynamicObjects = BusinessDataServiceHelper.load((String)"tpo_tcvat_industrycode", (String)"id", (QFilter[])new QFilter[]{qFilter});
        }
        if (null != dynamicObjects && dynamicObjects.length > 0) {
            return dynamicObjects[0].getLong("id");
        }
        return 0L;
    }

    private void openTjsjList(List<Long> pkids) {
        if (EmptyCheckUtils.isEmpty(pkids)) {
            return;
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setPageId(this.getView().getPageId() + UUID.randomUUID());
        reportShowParameter.setFormId("tctsa_statistics_detail");
        reportShowParameter.setCustomParam("ids", pkids);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }
}

