/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tctsa.common.util.BaseDataUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.formplugin.board.helper.RankService;
import kd.taxc.tctsa.formplugin.board.helper.ServiceFactory;

public class BoardHomePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Object type;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (EmptyCheckUtils.isNotEmpty((Object)customParams) && EmptyCheckUtils.isNotEmpty(type = customParams.get("type"))) {
            this.getPageCache().put("type", String.valueOf(type));
        }
        this.initQueryCondition();
        this.setShowOrHide();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("refresh1".equals(key)) {
            this.refreshView();
        }
    }

    private void initQueryCondition() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isEmpty((Object)customParams)) {
            this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
            this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth((Date)new Date()));
            return;
        }
        Object typeo = customParams.get("type");
        if (EmptyCheckUtils.isEmpty(typeo)) {
            this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
            this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth((Date)new Date()));
            return;
        }
        String type = String.valueOf(typeo);
        if (EmptyCheckUtils.isNotEmpty(customParams.get("startdate"))) {
            this.getView().getModel().setValue("startdate", customParams.get("startdate"));
        } else {
            this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        }
        if (EmptyCheckUtils.isNotEmpty(customParams.get("enddate"))) {
            this.getView().getModel().setValue("enddate", customParams.get("enddate"));
        } else {
            this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth((Date)new Date()));
        }
        if (EmptyCheckUtils.isNotEmpty(customParams.get("baseid"))) {
            if ("1".equalsIgnoreCase(type)) {
                this.getView().getModel().setValue("taxcarea", (Object)Collections.singleton(customParams.get("baseid")).toArray());
            } else if ("2".equalsIgnoreCase(type)) {
                List list = Collections.singletonList(customParams.get("baseid"));
                this.setHangYeLeafDatas(list);
            } else if ("3".equalsIgnoreCase(type)) {
                this.getView().getModel().setValue("taxcbiz", (Object)Collections.singleton(customParams.get("baseid")).toArray());
            }
        }
        if (EmptyCheckUtils.isNotEmpty(customParams.get("taxtype"))) {
            this.getView().getModel().setValue("taxtype", (Object)((List)customParams.get("taxtype")).toArray());
        }
    }

    private void setHangYeLeafDatas(List ids) {
        List<Object> leafIds = new ArrayList<Long>(8);
        for (Object id : ids) {
            long longId = Long.parseLong(String.valueOf(id));
            BaseDataUtil.getChildId((Long)longId, leafIds, (String)"tpo_tcvat_industrycode");
        }
        for (Object id : ids) {
            leafIds.add(Long.parseLong(String.valueOf(id)));
        }
        leafIds = leafIds.stream().distinct().sorted().collect(Collectors.toList());
        this.getView().getModel().setValue("hangye", (Object)leafIds.toArray());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ((name.equalsIgnoreCase("startdate") || name.equalsIgnoreCase("enddate")) && e.getChangeSet()[0].getNewValue() == null) {
            ChangeData[] valueSet = e.getChangeSet();
            Object propValue = valueSet[0].getOldValue();
            String propName = e.getProperty().getName();
            this.getModel().setValue(propName, propValue);
            return;
        }
        boolean result = this.putYearToCache();
        if (result) {
            this.refreshView();
        } else {
            ChangeData[] valueSet = e.getChangeSet();
            Object propValue = valueSet[0].getOldValue();
            String propName = e.getProperty().getName();
            this.getModel().setValue(propName, propValue);
        }
    }

    private boolean validateDate(Date start, Date end) {
        Date enddate = DateUtils.getLastDateOfMonth((Date)end);
        if (null != enddate) {
            Date startdate = DateUtils.getFirstDateOfMonth((Date)start);
            return !startdate.after(enddate);
        }
        return true;
    }

    private boolean putYearToCache() {
        Date dateend;
        Date date = (Date)this.getModel().getValue("startdate");
        boolean result = this.validateDate(date, dateend = (Date)this.getModel().getValue("enddate"));
        if (!result) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u4efd\u9009\u62e9\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f00\u59cb\u6708\u4efd\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6708\u4efd\u3002", (String)"BoardHomePlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (date != null) {
            this.getPageCache().put("startdate", DateUtils.format((Date)date));
        } else {
            this.getPageCache().put("startdate", DateUtils.format((Date)new Date()));
        }
        if (dateend != null) {
            this.getPageCache().put("enddate", DateUtils.format((Date)dateend));
        }
        return true;
    }

    private void refreshView() {
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (EmptyCheckUtils.isEmpty((Object)startdate) || EmptyCheckUtils.isEmpty((Object)enddate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u65f6\u95f4\u4e0d\u6b63\u786e", (String)"BoardHomePlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refresh1"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("refresh1".equals(key)) {
            this.refreshView();
        }
    }

    private void setShowOrHide() {
        RankService rankservice = ServiceFactory.getServiceFactory(this.getPageCache().get("type"));
        rankservice.setBaseEditShowOrHide(this.getView());
    }
}

