/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board;

import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.PieChart;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.report.ReportShowParameter;
import kd.taxc.tctsa.common.entity.TotalBean;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.formplugin.board.helper.RankService;
import kd.taxc.tctsa.formplugin.board.helper.ServiceFactory;

public class CityAreaCardPlugin
extends AbstractFormPlugin
implements ListboxClickListener {
    private static final String LISTBOXAP = "listboxap";

    public void afterCreateNewData(EventObject e) {
        RankService serviceFactory = this.getRankService();
        serviceFactory.initListBox(this.getView());
        serviceFactory.initChat(this.getView(), "1");
    }

    private RankService getRankService() {
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String type = pageCache.get("type");
        return ServiceFactory.getServiceFactory(type);
    }

    public void listboxClick(ListboxEvent evt) {
        String itemId = evt.getItemId();
        this.getPageCache().put("selectedlistboxid", itemId);
        RankService serviceFactory = this.getRankService();
        serviceFactory.initChat(this.getView(), itemId);
    }

    public void registerListener(EventObject e) {
        Listbox listbox = (Listbox)this.getControl(LISTBOXAP);
        listbox.addListboxClickListener((ListboxClickListener)this);
        HistogramChart histogramChart = (HistogramChart)this.getControl("histogramchartap");
        histogramChart.addClickListener((ClickListener)this);
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.addClickListener((ClickListener)this);
        try {
            this.addClickListeners(new String[]{"querymore"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("querymore".equals(key)) {
            RankService serviceFactory = this.getRankService();
            serviceFactory.jumpToFullBoard(this.getView());
        } else if ("histogramchartap".equals(key) || "piechartap".equalsIgnoreCase(key)) {
            TotalBean totalBean;
            List totalBeanList;
            String name1 = ((ChartClickEvent)evt).getName();
            if (EmptyCheckUtils.isEmpty((Object)name1)) {
                return;
            }
            String name = "histogramchartap".equals(key) ? name1 : name1.split(" ")[0];
            String clickpagecache = this.getPageCache().get("histogramchartap".equals(key) ? "clickpagecache" : "clickpagecache2");
            if (EmptyCheckUtils.isNotEmpty((Object)clickpagecache) && EmptyCheckUtils.isNotEmpty((Object)(totalBeanList = SerializationUtils.fromJsonStringToList((String)clickpagecache, TotalBean.class))) && EmptyCheckUtils.isNotEmpty((Object)(totalBean = totalBeanList.stream().filter(v -> name.equalsIgnoreCase(v.getName())).findFirst().get()))) {
                this.openTjsjList(totalBean.getPkids(), key);
            }
        }
    }

    private void openTjsjList(List<Long> pkids, String key) {
        if (EmptyCheckUtils.isEmpty(pkids)) {
            return;
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setPageId(this.getView().getPageId() + UUID.randomUUID());
        reportShowParameter.setFormId("tctsa_statistics_detail");
        reportShowParameter.setCustomParam("ids", pkids);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }
}

