/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;

public class IndustryCodeFormPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("industryids")) {
            List industryids = (List)customParams.get("industryids");
            this.getModel().setValue("industrycode", (Object)industryids.toArray());
            this.setQfilter(industryids);
        } else {
            this.setQfilter(null);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        MulBasedataEdit industrycode = (MulBasedataEdit)this.getView().getControl("industrycode");
        industrycode.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        ListSelectedRowCollection listSelectedRows = evt.getListSelectedRowCollection();
        if (!CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            List<Long> ids = listSelectedRows.stream().map(row -> Long.parseLong(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            this.setQfilter(ids);
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button && "btnok".equals(((Button)source).getKey())) {
            List<Object> ids = new ArrayList(8);
            DynamicObjectCollection industrycode = (DynamicObjectCollection)this.getModel().getValue("industrycode");
            if (industrycode != null && industrycode.size() > 0) {
                ids = industrycode.stream().map(row -> row.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            }
            this.getView().returnDataToParent(ids);
            this.getView().close();
        }
    }

    private void setQfilter(List<Long> ids) {
        BillList billlist = (BillList)this.getControl("billlistap");
        List orgIds = OrgServiceHelper.getOrgListHasPermission((IFormView)this.getView());
        QFilter filters = new QFilter("taxorg", "in", (Object)orgIds);
        if (ids != null) {
            filters.and(new QFilter("codeandname.id", "in", ids));
        }
        billlist.setFilter(filters);
        billlist.refreshData();
    }
}

