/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;

public class TaxLabelFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.setFieldTitle(customParams);
        String groupnumber = "";
        if (customParams.containsKey("labelfilter")) {
            List labelfilter = (List)customParams.get("labelfilter");
            groupnumber = (String)labelfilter.get(0);
            this.getPageCache().put("groupnumber", groupnumber);
        }
        if (customParams.containsKey("labelids")) {
            List labelids = (List)customParams.get("labelids");
            this.getModel().setValue("taxlabel", (Object)labelids.toArray());
            this.setQfilter(labelids);
        } else {
            this.setQfilter(null);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        MulBasedataEdit label = (MulBasedataEdit)this.getView().getControl("taxlabel");
        label.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        label.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String groupnumber = this.getPageCache().get("groupnumber");
        if (StringUtils.isNotBlank((CharSequence)groupnumber)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
            treeFilterParameter.getQFilters().add(new QFilter("number", "=", (Object)groupnumber));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("group.number", "=", (Object)groupnumber));
            formShowParameter.setTreeFilterParameter(treeFilterParameter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        ListSelectedRowCollection listSelectedRows = evt.getListSelectedRowCollection();
        if (!CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            List<Long> ids = listSelectedRows.stream().map(row -> Long.parseLong(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            this.setQfilter(ids);
        } else {
            this.setQfilter(null);
        }
    }

    public void click(EventObject evt) {
        DynamicObjectCollection labels;
        Object source = evt.getSource();
        if (source instanceof Button && "btnok".equals(((Button)source).getKey()) && (labels = (DynamicObjectCollection)this.getModel().getValue("taxlabel")) != null && labels.size() > 0) {
            List ids = labels.stream().map(row -> row.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            this.getView().returnDataToParent(ids);
            this.getView().close();
        }
    }

    private void setFieldTitle(Map<String, Object> customParams) {
        if (customParams.containsKey("fieldkey")) {
            String fieldkey = (String)customParams.get("fieldkey");
            HashMap<String, LocaleString> props = new HashMap<String, LocaleString>();
            if ("taxcarea".equalsIgnoreCase(fieldkey)) {
                props.put("caption", new LocaleString(ResManager.loadKDString((String)"\u7ba1\u7406\u533a\u57df", (String)"TaxLabelFormPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
            } else if ("taxcbiz".equalsIgnoreCase(fieldkey)) {
                props.put("caption", new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u677f\u5757", (String)"TaxLabelFormPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
            }
            this.getView().updateControlMetadata("taxlabel", props);
        }
    }

    private void setQfilter(List<Long> labelList) {
        BillList billlist = (BillList)this.getControl("billlistap");
        List orgIds = OrgServiceHelper.getOrgListHasPermission((IFormView)this.getView());
        QFilter filters = new QFilter("taxorg", "in", (Object)orgIds);
        if (labelList != null) {
            filters.and(new QFilter("orgattr.fbasedataid.id", "in", labelList));
        }
        billlist.setFilter(filters);
        billlist.refreshData();
    }
}

