/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class TaxLabelShowPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        MulBasedataEdit taxcarea = (MulBasedataEdit)this.getView().getControl("taxcarea");
        taxcarea.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit taxcbiz = (MulBasedataEdit)this.getView().getControl("taxcbiz");
        taxcbiz.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit hangye = (MulBasedataEdit)this.getView().getControl("hangye");
        hangye.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (!"click".equals(beforeF7SelectEvent.getSourceMethod())) {
            return;
        }
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List filters = formShowParameter.getListFilterParameter().getQFilters();
        if ("hangye".equalsIgnoreCase(fieldKey)) {
            this.showIndustryCodeForm(fieldKey);
        } else {
            this.showTaxLabelForm(filters, fieldKey);
        }
        beforeF7SelectEvent.setCancel(true);
    }

    private void showIndustryCodeForm(String fieldKey) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tctsa_industry_code");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        DynamicObjectCollection coll = (DynamicObjectCollection)this.getModel().getValue(fieldKey);
        if (coll != null && coll.size() > 0) {
            List ids = coll.stream().map(row -> row.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            parameter.setCustomParam("industryids", ids);
        }
        this.getView().showForm(parameter);
    }

    private void showTaxLabelForm(List<QFilter> filters, String fieldKey) {
        DynamicObjectCollection labels;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tctsa_tax_label");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String captionName = "taxcarea".equalsIgnoreCase(fieldKey) ? ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ba1\u7406\u533a\u57df", (String)"TaxLabelShowPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u677f\u5757", (String)"TaxLabelShowPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]);
        parameter.setCaption(captionName);
        if (filters != null && filters.size() > 0) {
            List labelfilter = filters.stream().filter(filter -> "group.number".equalsIgnoreCase(filter.getProperty())).map(label -> label.getValue().toString()).collect(Collectors.toList());
            parameter.setCustomParam("labelfilter", labelfilter);
        }
        if ((labels = (DynamicObjectCollection)this.getModel().getValue(fieldKey)) != null && labels.size() > 0) {
            List ids = labels.stream().map(row -> row.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            parameter.setCustomParam("labelids", ids);
        }
        parameter.setCustomParam("fieldkey", (Object)fieldKey);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            List ids = (List)closedCallBackEvent.getReturnData();
            String key = closedCallBackEvent.getActionId();
            if (key != null) {
                if ("hangye".equalsIgnoreCase(key)) {
                    this.getView().getModel().setValue("hangye", (Object)ids.toArray());
                } else {
                    this.getModel().setValue(key, (Object)ids.toArray());
                }
            }
        }
    }
}

