/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board.helper;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.chart.PieSeries;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.entity.TotalBean;
import kd.taxc.tctsa.common.enums.BooleanEnum;
import kd.taxc.tctsa.common.helper.LevytypeHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.formplugin.board.helper.RankService;

public abstract class AbstractRankService
implements RankService {
    protected static final String FLEX_PANEL_AP11 = "flexpanelap11";
    protected static final String FLEX_PANEL_AP111 = "flexpanelap111";
    public static final String PIE_CHART_AP = "piechartap";

    protected String setColor(int idx, boolean isEnd) {
        List colors = TctsaConstant.getColors();
        if (idx % colors.size() == 0 && isEnd) {
            return (String)colors.get(1);
        }
        return (String)colors.get(idx % colors.size());
    }

    @Override
    public void jumpToFullBoard(IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        String title = this.getTitle(view);
        parameter.setCaption(title);
        parameter.setFormId("tctsa_board_more");
        parameter.setHasRight(true);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        String clickpagecache = view.getPageCache().get("clickpagecache");
        if (EmptyCheckUtils.isEmpty((Object)clickpagecache)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u3002", (String)"AbstractRankService_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return;
        }
        paramsMap.put("clickpagecache", clickpagecache);
        parameter.setCustomParams(paramsMap);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(parameter);
    }

    private String getTitle(IFormView view) {
        String selectedlistboxid = view.getPageCache().get("selectedlistboxid");
        List listboxs = SerializationUtils.fromJsonStringToList((String)view.getPageCache().get("listboxs"), ListboxItem.class);
        return listboxs.stream().filter(v -> selectedlistboxid.equalsIgnoreCase(v.getId())).findFirst().get().getContent();
    }

    protected void createXYVals(DynamicObjectCollection tjsjbInfos, Map<String, List<Long>> key2OrgIDsMap, Map<String, String> key2NameMap, List<String> keys, List<BigDecimal> vals, IFormView view) {
        List<TotalBean> totalBeanList = this.getTotalBeans(tjsjbInfos, key2OrgIDsMap, key2NameMap);
        this.setClickPageCache(totalBeanList, view);
        int top = this.getTop();
        int maxIndex = totalBeanList.size() > top ? top : totalBeanList.size();
        BigDecimal totalAmount = totalBeanList.stream().map(TotalBean::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (int i = maxIndex - 1; i >= 0; --i) {
            keys.add(totalBeanList.get(i).getName());
            BigDecimal sub = BigDecimalUtil.divideObject((Object)totalBeanList.get(i).getTotal(), (Object)new BigDecimal(10000), (int)2);
            vals.add(sub);
        }
        this.setTotalAmount(totalAmount, view);
    }

    protected int getTop() {
        return 10;
    }

    private void setTotalAmount(BigDecimal totalAmount, IFormView view) {
        try {
            view.getModel().setValue("total", (Object)BigDecimalUtil.divideObject((Object)totalAmount, (Object)new BigDecimal(10000), (int)2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setClickPageCache(List<TotalBean> totalBeanList, IFormView view) {
        view.getPageCache().put("clickpagecache", EmptyCheckUtils.isEmpty(totalBeanList) ? null : SerializationUtils.toJsonString(totalBeanList));
    }

    protected void setCharShowOrHide(IFormView view, List<String> keys) {
        if (EmptyCheckUtils.isEmpty(keys)) {
            view.setVisible(Boolean.FALSE, new String[]{"histogramchartap", FLEX_PANEL_AP11, FLEX_PANEL_AP111, "querymore"});
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7edf\u8ba1\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"AbstractRankService_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"histogramchartap", FLEX_PANEL_AP11, FLEX_PANEL_AP111, "querymore"});
        }
    }

    protected DynamicObject findBanKuai(DynamicObject taxmain, Map<String, DynamicObject> key2InfoMap) {
        String orgattrid = taxmain.getString("orgattr.fbasedataid");
        if (EmptyCheckUtils.isEmpty((Object)orgattrid)) {
            return null;
        }
        DynamicObject attr = key2InfoMap.get(orgattrid);
        if (null == attr) {
            return null;
        }
        String longNumber = attr.getString("group.longnumber");
        if (EmptyCheckUtils.isEmpty((Object)longNumber)) {
            return null;
        }
        if (longNumber.contains("biz-segment")) {
            return attr;
        }
        return null;
    }

    protected DynamicObject findTopIndustry(DynamicObject taxmain, Map<String, DynamicObject> key2InfoMap) {
        String codeandnameid = taxmain.getString("codeandname");
        if (EmptyCheckUtils.isEmpty((Object)codeandnameid)) {
            return null;
        }
        DynamicObject codeandname = key2InfoMap.get(codeandnameid);
        if (null == codeandname) {
            return null;
        }
        String longNumber = codeandname.getString("longnumber");
        if (EmptyCheckUtils.isEmpty((Object)longNumber)) {
            return null;
        }
        if (!longNumber.contains(".")) {
            return codeandname;
        }
        String[] longnumberarr = longNumber.split("\\.");
        return key2InfoMap.get(longnumberarr[0]);
    }

    protected DynamicObjectCollection getTjsjbRecords(QFilter qFilter) {
        if (qFilter != null) {
            qFilter.and("taxationsys", "=", (Object)1L);
            qFilter.and(LevytypeHelper.getLevytype());
        }
        return QueryServiceHelper.query((String)"tctb_tjsjb", (String)"id,org,skssqq,skssqz,taxtype,bqybtse", (QFilter[])new QFilter[]{qFilter});
    }

    protected List<TotalBean> getTotalBeans(DynamicObjectCollection tjsjbInfos, Map<String, List<Long>> key2OrgIDsMap, Map<String, String> key2NameMap) {
        return key2OrgIDsMap.entrySet().stream().map(entry -> {
            BigDecimal total = BigDecimal.ZERO;
            ArrayList<Long> pkids = new ArrayList<Long>(100);
            for (DynamicObject tjsjb : tjsjbInfos) {
                if (!((List)entry.getValue()).contains(tjsjb.getLong("org")) || null == tjsjb.getBigDecimal("bqybtse")) continue;
                total = BigDecimalUtil.addObject((Object)total, (Object)tjsjb.getBigDecimal("bqybtse"));
                pkids.add(tjsjb.getLong("id"));
            }
            return new TotalBean((String)entry.getKey(), (String)key2NameMap.get(entry.getKey()), total, pkids);
        }).sorted(Comparator.comparing(TotalBean::getTotal).reversed()).collect(Collectors.toList());
    }

    protected void addOrgIdsFilter(QFilter qFilter, DynamicObjectCollection orgs) {
        qFilter.and(new QFilter("org", "in", orgs.stream().map(v -> v.getLong("orgid")).distinct().collect(Collectors.toList())));
    }

    @Override
    public QFilter getBaseDataQFilter(IFormView view) {
        return null;
    }

    protected QFilter doGetBaseDataQFilter(IFormView view, String modelFlag, String queryField) {
        DynamicObjectCollection areas = (DynamicObjectCollection)view.getParentView().getModel().getValue(modelFlag);
        return EmptyCheckUtils.isEmpty((Object)areas) ? null : new QFilter(queryField, "in", areas.stream().map(v -> v.getDynamicObject("fbasedataid").get("id")).distinct().collect(Collectors.toList()));
    }

    protected void setEmphasisLabel(Map<String, Object> values) {
        Map itemStyle = (Map)values.get("itemStyle");
        HashMap emphasisMap = new HashMap();
        HashMap<String, Serializable> labelMap = new HashMap<String, Serializable>();
        HashMap<String, String> textStyleMap = new HashMap<String, String>();
        textStyleMap.put("fontSize", "24");
        textStyleMap.put("fontWeight", "bold");
        labelMap.put("show", Boolean.TRUE);
        labelMap.put("textStyle", textStyleMap);
        emphasisMap.put("label", labelMap);
        HashMap<String, Boolean> labelLineMap = new HashMap<String, Boolean>();
        labelLineMap.put("show", Boolean.FALSE);
        emphasisMap.put("labelLine", labelLineMap);
        itemStyle.put("emphasis", emphasisMap);
    }

    protected Map<String, Object> getValues(PieSeries series) {
        try {
            Class<?> clazz = Class.forName("kd.bos.form.chart.Series");
            Method getValues = clazz.getDeclaredMethod("getValues", new Class[0]);
            AccessibleObject.setAccessible(new AccessibleObject[]{getValues}, true);
            return (Map)getValues.invoke((Object)series, (Object[])null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected DynamicObject findArea(DynamicObject taxmain, Map<String, DynamicObject> key2InfoMap) {
        String orgattrid = taxmain.getString("orgattr.fbasedataid");
        if (EmptyCheckUtils.isEmpty((Object)orgattrid)) {
            return null;
        }
        DynamicObject attr = key2InfoMap.get(orgattrid);
        if (null == attr) {
            return null;
        }
        String longNumber = attr.getString("group.longnumber");
        if (EmptyCheckUtils.isEmpty((Object)longNumber)) {
            return null;
        }
        if (longNumber.contains("regulated_areas")) {
            return attr;
        }
        return null;
    }

    protected void cacheListBox(ArrayList<ListboxItem> items, IFormView view) {
        view.getPageCache().put("listboxs", SerializationUtils.toJsonString(items));
    }

    protected QFilter getQFilter(IFormView view) {
        IFormView parentView = view.getParentView();
        if (null == parentView) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7236\u9875\u9762", (String)"AbstractRankService_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
        Object startdate = parentView.getModel().getValue("startdate");
        Object enddate = parentView.getModel().getValue("enddate");
        if (EmptyCheckUtils.isEmpty((Object)startdate) || EmptyCheckUtils.isEmpty((Object)enddate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u4e0d\u6b63\u786e\u3002", (String)"AbstractRankService_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)startdate)));
        QFilter endFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth2((Date)((Date)enddate)));
        qFilter.and(endFilter);
        try {
            QFilter taxtypeQF = this.doGetBaseDataQFilter(view, "taxtype", "taxtype");
            if (null != taxtypeQF) {
                qFilter.and(taxtypeQF);
            } else {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_taxcategory", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)BooleanEnum.YES.getCode())});
                qFilter.and(new QFilter("taxtype", "in", Arrays.stream(dynamicObjects).map(v -> v.getLong("id")).collect(Collectors.toList())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return qFilter;
    }
}

