/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.chart.HistogramChart;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.OrgUtils;
import kd.taxc.tctsa.formplugin.board.helper.AbstractRankService;
import kd.taxc.tctsa.formplugin.board.helper.HistogramChartHelper;

public abstract class AbstractSmallCardService
extends AbstractRankService {
    @Override
    protected int getTop() {
        return 5;
    }

    @Override
    public void initChat(IFormView view, String type) {
        DynamicObjectCollection orgs;
        view.getPageCache().put("selectedlistboxid", type);
        QFilter qFilter = this.getQFilter(view);
        QFilter taxMainFilter = this.getBaseDataQFilter(view);
        List<Long> filterIds = this.dealBanKuaiAreaFilter(taxMainFilter);
        boolean isNeedRight = this.isNeedRight();
        DynamicObjectCollection dynamicObjectCollection = orgs = isNeedRight ? OrgUtils.getTaxOrgListHasPermission((QFilter)taxMainFilter) : OrgUtils.getTaxOrgList();
        if (EmptyCheckUtils.isEmpty((Object)orgs)) {
            view.setVisible(Boolean.FALSE, new String[]{"histogramchartap"});
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6709\u6548\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractSmallCardService_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.addOrgIdsFilter(qFilter, orgs);
        DynamicObjectCollection tjsjbInfos = this.getTjsjbRecords(qFilter);
        if (EmptyCheckUtils.isEmpty((Object)tjsjbInfos)) {
            view.setVisible(Boolean.FALSE, new String[]{"histogramchartap"});
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7edf\u8ba1\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"AbstractSmallCardService_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, DynamicObject> key2InfoMap = this.getBaseDataMapper(type);
        HashMap<String, List<Long>> key2OrgIDsMap = new HashMap<String, List<Long>>(256);
        HashMap<String, String> key2NameMap = new HashMap<String, String>(256);
        Map<Long, List<DynamicObject>> orgid2ListMap = orgs.stream().collect(Collectors.groupingBy(v -> v.getLong("orgid")));
        String pageType = view.getParentView().getPageCache().get("type");
        for (Map.Entry<Long, List<DynamicObject>> entry : orgid2ListMap.entrySet()) {
            if ((!EmptyCheckUtils.isNotEmpty(filterIds) || !this.isIn(entry.getValue(), filterIds, pageType)) && !EmptyCheckUtils.isEmpty(filterIds)) continue;
            for (DynamicObject taxmain : entry.getValue()) {
                DynamicObject banKuai = this.findDyByType(taxmain, key2InfoMap, type);
                if (null == banKuai) continue;
                Long banKuaiid = banKuai.getLong("id");
                List orgids = (List)key2OrgIDsMap.get(String.valueOf(banKuaiid));
                orgids = EmptyCheckUtils.isEmpty((Object)orgids) ? new ArrayList(52) : orgids;
                orgids.add(taxmain.getLong("orgid"));
                key2NameMap.put(String.valueOf(banKuaiid), banKuai.getString("name"));
                key2OrgIDsMap.put(String.valueOf(banKuaiid), orgids);
            }
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>();
        this.createXYVals(tjsjbInfos, key2OrgIDsMap, key2NameMap, keys, vals, view);
        this.setCharShowOrHide(view, keys);
        HistogramChart barChart = (HistogramChart)view.getControl("histogramchartap");
        barChart.clearData();
        HistogramChartHelper.showCustomChart(barChart, keys, vals, "#40A9FF", false);
    }

    private boolean isIn(List<DynamicObject> values, List<Long> filterIds, String type) {
        if (EmptyCheckUtils.isEmpty((Object)type)) {
            return true;
        }
        String key = "2".equalsIgnoreCase(type) ? "codeandname" : "orgattr.fbasedataid";
        List ids = values.stream().map(v -> v.getString(key)).distinct().collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(ids)) {
            return false;
        }
        return Stream.concat(ids.stream(), filterIds.stream().map(v -> String.valueOf(v))).distinct().count() < (long)(ids.size() + filterIds.size());
    }

    protected boolean isNeedRight() {
        return false;
    }

    protected DynamicObject findDyByType(DynamicObject taxmain, Map<String, DynamicObject> key2InfoMap, String type) {
        if ("4".equalsIgnoreCase(type)) {
            return this.findTopIndustry(taxmain, key2InfoMap);
        }
        if ("6".equalsIgnoreCase(type)) {
            return this.findBanKuai(taxmain, key2InfoMap);
        }
        if ("5".equalsIgnoreCase(type)) {
            return this.findArea(taxmain, key2InfoMap);
        }
        return null;
    }

    protected List<Long> dealBanKuaiAreaFilter(QFilter taxMainFilter) {
        if (null != taxMainFilter && "orgattr.fbasedataid".equalsIgnoreCase(taxMainFilter.getProperty())) {
            String longnumber = this.isArea() ? "biz-segment001" : "regulated_areas";
            QFilter qFilter2 = new QFilter("group.longnumber", "like", (Object)('%' + longnumber + "%"));
            DynamicObject[] infos = BusinessDataServiceHelper.load((String)"tctb_label_group", (String)"id,number,name,group", (QFilter[])new QFilter[]{qFilter2});
            if (null != infos && null != taxMainFilter.getValue()) {
                List ids = (List)taxMainFilter.getValue();
                ArrayList fullids = new ArrayList(256);
                fullids.addAll(ids);
                fullids.addAll(Arrays.stream(infos).map(v -> v.getLong("id")).collect(Collectors.toList()));
                taxMainFilter.__setValue(fullids);
                return ids;
            }
        }
        return new ArrayList<Long>();
    }

    protected boolean isArea() {
        return false;
    }

    protected Map<String, DynamicObject> getBaseDataMapper(String type) {
        DynamicObject[] infos = null;
        if ("4".equalsIgnoreCase(type)) {
            infos = BusinessDataServiceHelper.load((String)"tpo_tcvat_industrycode", (String)"id,number,name,longnumber,level,isleaf", null);
        } else if ("6".equalsIgnoreCase(type)) {
            infos = BusinessDataServiceHelper.load((String)"tctb_label_group", (String)"id,number,name,group", null);
        } else if ("5".equalsIgnoreCase(type)) {
            infos = BusinessDataServiceHelper.load((String)"tctb_label_group", (String)"id,number,name,group", null);
        }
        if (EmptyCheckUtils.isNotEmpty((Object)infos)) {
            return Arrays.stream(infos).collect(Collectors.toMap(k -> k.getString("id"), v -> v));
        }
        return new HashMap<String, DynamicObject>(256);
    }
}

