/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.IFormView;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctsa.common.address.AddressUtils;
import kd.taxc.tctsa.common.entity.TotalBean;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.OrgUtils;
import kd.taxc.tctsa.common.util.RegisterAddressUtil;
import kd.taxc.tctsa.formplugin.board.helper.AbstractRankService;
import kd.taxc.tctsa.formplugin.board.helper.HistogramChartHelper;

public class AreaServiceHelper
extends AbstractRankService {
    @Override
    public List<ListboxItem> initListBox(IFormView view) {
        Listbox listboxap = (Listbox)view.getControl("listboxap");
        ArrayList<ListboxItem> items = new ArrayList<ListboxItem>();
        items.add(new ListboxItem("1", ResManager.loadKDString((String)"\u57ce\u5e02\u6392\u540d", (String)"AreaServiceHelper_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        items.add(new ListboxItem("2", ResManager.loadKDString((String)"\u533a\u57df\u6bd4\u5bf9", (String)"AreaServiceHelper_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        listboxap.addItems(items);
        this.cacheListBox(items, view);
        return items;
    }

    @Override
    public void initChat(IFormView view, String type) {
        view.getPageCache().put("selectedlistboxid", type);
        QFilter qFilter = this.getQFilter(view);
        QFilter areaFilter = this.doGetBaseDataQFilter(view, "taxcarea", "orgattr.fbasedataid");
        DynamicObjectCollection orgs = OrgUtils.getTaxOrgListHasPermission((QFilter)areaFilter);
        if (EmptyCheckUtils.isEmpty((Object)orgs)) {
            view.setVisible(Boolean.FALSE, new String[]{"piechartap", "histogramchartap", "flexpanelap11", "flexpanelap111", "querymore"});
            return;
        }
        qFilter.and(new QFilter("org", "in", orgs.stream().map(v -> v.getLong("orgid")).distinct().collect(Collectors.toList())));
        DynamicObjectCollection tjsjbInfos = this.getTjsjbRecords(qFilter);
        if (EmptyCheckUtils.isEmpty((Object)tjsjbInfos)) {
            view.setVisible(Boolean.FALSE, new String[]{"piechartap", "histogramchartap", "flexpanelap11", "flexpanelap111"});
            return;
        }
        HashMap<String, List<Long>> key2OrgIDsMap = new HashMap<String, List<Long>>(256);
        HashMap<String, String> key2NameMap = new HashMap<String, String>(256);
        if ("1".equalsIgnoreCase(type)) {
            view.setVisible(Boolean.TRUE, new String[]{"histogramchartap", "flexpanelap11", "flexpanelap111"});
            view.setVisible(Boolean.FALSE, new String[]{"piechartap"});
            for (DynamicObject taxmain : orgs) {
                DynamicObject city;
                long streetid;
                DynamicObject area;
                DynamicObject registerAddress = RegisterAddressUtil.getAdmindivision((Long)taxmain.getLong("registeraddress"));
                if (registerAddress == null) continue;
                long level = registerAddress.getLong("level");
                Long cityid = null;
                String cityName = "";
                if (level == 1L) {
                    cityid = registerAddress.getLong("id");
                    DynamicObject admindivisionFullName = RegisterAddressUtil.getAdmindivisionFullName((Long)cityid);
                    cityName = admindivisionFullName.getString("fullname");
                    if (cityName.indexOf(ResManager.loadKDString((String)"\u9999\u6e2f", (String)"AreaServiceHelper_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])) < 0 && cityName.indexOf(ResManager.loadKDString((String)"\u6fb3\u95e8", (String)"AreaServiceHelper_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])) < 0 && cityName.indexOf(ResManager.loadKDString((String)"\u53f0\u6e7e", (String)"AreaServiceHelper_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])) < 0) {
                        cityName = null;
                    }
                } else if (level == 2L) {
                    cityid = registerAddress.getLong("id");
                    DynamicObject admindivisionFullName = RegisterAddressUtil.getAdmindivisionFullName((Long)cityid);
                    if (EmptyCheckUtils.isNotEmpty((Object)admindivisionFullName)) {
                        cityName = admindivisionFullName.getString("fullname");
                    }
                } else if (level == 3L) {
                    cityid = registerAddress.getLong("parent");
                    DynamicObject admindivisionFullName = RegisterAddressUtil.getAdmindivisionFullName((Long)cityid);
                    if (EmptyCheckUtils.isNotEmpty((Object)admindivisionFullName)) {
                        cityName = admindivisionFullName.getString("fullname");
                    }
                } else if (level > 3L && (area = AddressUtils.getAdmindivision((Long)(streetid = registerAddress.getLong("parent")))) != null && (city = RegisterAddressUtil.getAdmindivisionFullName((Long)(cityid = Long.valueOf(area.getLong("parent"))))) != null) {
                    cityName = city.getString("fullname");
                }
                if (EmptyCheckUtils.isEmpty((Object)cityid) || EmptyCheckUtils.isEmpty((Object)cityName)) continue;
                List orgids = (List)key2OrgIDsMap.get(String.valueOf(cityid));
                orgids = EmptyCheckUtils.isEmpty((Object)orgids) ? new ArrayList(52) : orgids;
                orgids.add(taxmain.getLong("orgid"));
                key2NameMap.put(String.valueOf(cityid), cityName);
                key2OrgIDsMap.put(String.valueOf(cityid), orgids);
            }
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>();
            this.createXYVals(tjsjbInfos, key2OrgIDsMap, key2NameMap, keys, vals, view);
            this.setCharShowOrHide(view, keys);
            HistogramChart barChart = (HistogramChart)view.getControl("histogramchartap");
            HistogramChartHelper.showCustomChart(barChart, keys, vals, "#40A9FF", false);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"histogramchartap", "flexpanelap11", "flexpanelap111", "querymore"});
            view.setVisible(Boolean.TRUE, new String[]{"piechartap"});
            DynamicObject[] areaInfos = BusinessDataServiceHelper.load((String)"tctb_label_group", (String)"id,number,name,group", null);
            Map<String, DynamicObject> key2InfoMap = Arrays.stream(areaInfos).collect(Collectors.toMap(k -> k.getString("id"), v -> v));
            for (DynamicObject taxmain : orgs) {
                DynamicObject orgattr = this.findArea(taxmain, key2InfoMap);
                if (null == orgattr) continue;
                Long areaid = orgattr.getLong("id");
                List orgids = (List)key2OrgIDsMap.get(String.valueOf(areaid));
                orgids = EmptyCheckUtils.isEmpty((Object)orgids) ? new ArrayList(52) : orgids;
                orgids.add(taxmain.getLong("orgid"));
                key2NameMap.put(String.valueOf(areaid), orgattr.getString("name"));
                key2OrgIDsMap.put(String.valueOf(areaid), orgids);
            }
            List<TotalBean> totalBeanList = this.getTotalBeans(tjsjbInfos, key2OrgIDsMap, key2NameMap);
            if (EmptyCheckUtils.isEmpty(totalBeanList)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7edf\u8ba1\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"AreaServiceHelper_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
            view.getPageCache().put("clickpagecache2", EmptyCheckUtils.isEmpty(totalBeanList) ? null : SerializationUtils.toJsonString(totalBeanList));
            this.setClickPageCache(totalBeanList, view);
            PieChart pieChart = (PieChart)view.getControl("piechartap");
            pieChart.clearData();
            PieSeries series = pieChart.createSeries(ResManager.loadKDString((String)"", (String)"AreaServiceHelper_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            BigDecimal totalVal = totalBeanList.stream().map(TotalBean::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            Double totalB = 0.0;
            for (int i = 0; i < totalBeanList.size(); ++i) {
                Double singleB;
                if (i == totalBeanList.size() - 1) {
                    singleB = BigDecimalUtil.subtractObject((Object)1, (Object)totalB, (int)8).doubleValue();
                } else {
                    singleB = BigDecimalUtil.divideObject((Object)totalBeanList.get(i).getTotal(), (Object)totalVal, (int)8) != null ? BigDecimalUtil.divideObject((Object)totalBeanList.get(i).getTotal(), (Object)totalVal, (int)8).doubleValue() : 0.0;
                    totalB = totalB + singleB;
                }
                series.addData(new ItemValue(totalBeanList.get(i).getName() + "  " + BigDecimalUtil.multiplyObject((Object)100, (Object)singleB, (int)2) + "%", (Number)BigDecimalUtil.divideObject((Object)totalBeanList.get(i).getTotal(), (Object)new BigDecimal(10000), (int)2), this.setColor(i, i == totalBeanList.size() - 1)));
            }
            Map itemNormalStyle = series.getItemNormalStyle();
            HashMap<String, Object> lableMap = new HashMap<String, Object>();
            lableMap.put("show", Boolean.TRUE);
            lableMap.put("position", "left");
            itemNormalStyle.put("label", lableMap);
            HashMap<String, Boolean> lableLineMap = new HashMap<String, Boolean>();
            lableLineMap.put("show", Boolean.TRUE);
            itemNormalStyle.put("labelLine", lableLineMap);
            series.setRadius("70%");
            Map<String, Object> values = this.getValues(series);
            this.setEmphasisLabel(values);
            pieChart.setShowTooltip(true);
            pieChart.setShowLegend(true);
            pieChart.setName(new LocaleString(""));
            pieChart.addTooltip("trigger", (Object)"item");
            pieChart.addTooltip("formatter", (Object)ResManager.loadKDString((String)"{b} <br/>\u7eb3\u7a0e\u603b\u989d\uff08\u4e07\u5143\uff09: {c}", (String)"AreaServiceHelper_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            pieChart.setLegendAlign(XAlign.right, YAlign.top);
            pieChart.setLegendVertical(true);
            pieChart.setLegendPropValue("padding", (Object)new Integer[]{0, 20, 0, 0});
            pieChart.refresh();
        }
    }

    @Override
    public void setBaseEditShowOrHide(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"taxcarea"});
        view.setVisible(Boolean.FALSE, new String[]{"taxcbiz", "hangye"});
    }
}

