/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.IFormView;
import kd.bos.form.chart.HistogramChart;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.OrgUtils;
import kd.taxc.tctsa.formplugin.board.helper.AbstractRankService;
import kd.taxc.tctsa.formplugin.board.helper.HistogramChartHelper;
import org.apache.commons.collections4.CollectionUtils;

public class HangYeServiceHelper
extends AbstractRankService {
    @Override
    public List<ListboxItem> initListBox(IFormView view) {
        Listbox listboxap = (Listbox)view.getControl("listboxap");
        ArrayList<ListboxItem> items = new ArrayList<ListboxItem>();
        items.add(new ListboxItem("3", ResManager.loadKDString((String)"\u884c\u4e1a\u6392\u540d", (String)"HangYeServiceHelper_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        listboxap.addItems(items);
        this.cacheListBox(items, view);
        return items;
    }

    @Override
    public void setBaseEditShowOrHide(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"hangye"});
        view.setVisible(Boolean.FALSE, new String[]{"taxcarea", "taxcbiz"});
    }

    @Override
    public void initChat(IFormView view, String type) {
        DynamicObjectCollection orgs;
        view.getPageCache().put("selectedlistboxid", "3");
        QFilter qFilter = this.getQFilter(view);
        List<Object> areaIds = new ArrayList(8);
        try {
            DynamicObjectCollection areas = (DynamicObjectCollection)view.getParentView().getModel().getValue("hangye");
            areaIds = areas.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).distinct().collect(Collectors.toList());
        }
        catch (Exception areas) {
            // empty catch block
        }
        if (CollectionUtils.isEmpty(areaIds)) {
            DynamicObject[] industrycodes = BusinessDataServiceHelper.load((String)"tpo_tcvat_industrycode", (String)"id,number,name,longnumber,level,isleaf", null);
            areaIds = Arrays.stream(industrycodes).map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
        }
        if (EmptyCheckUtils.isEmpty((Object)(orgs = OrgUtils.getTaxOrgList()))) {
            view.setVisible(Boolean.FALSE, new String[]{"piechartap", "histogramchartap", "flexpanelap11", "flexpanelap111", "querymore"});
            return;
        }
        qFilter.and(new QFilter("org", "in", orgs.stream().map(v -> v.getLong("orgid")).distinct().collect(Collectors.toList())));
        DynamicObjectCollection tjsjbInfos = this.getTjsjbRecords(qFilter);
        if (EmptyCheckUtils.isEmpty((Object)tjsjbInfos)) {
            view.setVisible(Boolean.FALSE, new String[]{"piechartap", "histogramchartap", "flexpanelap11", "flexpanelap111"});
            return;
        }
        HashMap<String, List<Long>> key2OrgIDsMap = new HashMap<String, List<Long>>(256);
        HashMap<String, String> key2NameMap = new HashMap<String, String>(256);
        view.setVisible(Boolean.FALSE, new String[]{"piechartap"});
        DynamicObject[] industryInfos = BusinessDataServiceHelper.load((String)"tpo_tcvat_industrycode", (String)"id,number,name,longnumber,level,isleaf", null);
        Map<String, DynamicObject> key2InfoMap = Arrays.stream(industryInfos).collect(Collectors.toMap(k -> k.getString("id"), v -> v));
        for (DynamicObject taxmain : orgs) {
            DynamicObject industry = this.findIndustry(taxmain, key2InfoMap);
            if (null == industry || !areaIds.contains(industry.getLong("id"))) continue;
            Long industryid = industry.getLong("id");
            List orgids = key2OrgIDsMap.getOrDefault(String.valueOf(industryid), new ArrayList(8));
            orgids.add(taxmain.getLong("orgid"));
            key2NameMap.put(String.valueOf(industryid), industry.getString("name"));
            key2OrgIDsMap.put(String.valueOf(industryid), orgids);
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>();
        this.createXYVals(tjsjbInfos, key2OrgIDsMap, key2NameMap, keys, vals, view);
        this.setCharShowOrHide(view, keys);
        HistogramChart barChart = (HistogramChart)view.getControl("histogramchartap");
        HistogramChartHelper.showCustomChart(barChart, keys, vals, "#40A9FF", false);
    }

    private DynamicObject findIndustry(DynamicObject taxmain, Map<String, DynamicObject> key2InfoMap) {
        String codeandnameid = taxmain.getString("codeandname");
        if (EmptyCheckUtils.isEmpty((Object)codeandnameid)) {
            return null;
        }
        return key2InfoMap.get(codeandnameid);
    }
}

