/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board.helper;

import com.google.common.collect.Maps;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;

public class HistogramChartHelper {
    public static Axis createValueAxis(HistogramChart histogramChart, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.value) : histogramChart.createYAxis(name, AxisType.value);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HistogramChartHelper.setLineColor(axis, "#999999");
        return axis;
    }

    public static void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    public static Axis createCategoryAxis(HistogramChart histogramChart, String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.category) : histogramChart.createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        HistogramChartHelper.setLineColor(axis, "#999999");
        histogramChart.setShowTooltip(true);
        return axis;
    }

    public static void createHistogramSeries(HistogramChart histogramChart, String name, Number[] values, String color, Boolean flag) {
        BarSeries histogramSeries = histogramChart.createSeries(name);
        ArrayList<String> funPath = new ArrayList<String>();
        funPath.add("itemStyle");
        funPath.add("normal");
        funPath.add("color");
        histogramSeries.addFuncPath(funPath);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> normap = new HashMap<String, HashMap<String, String>>();
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 1, 0, [{\"offset\": 0,\"color\": '#5F8AFF'}, {\"offset\": 1, \"color\": '#9EB8FF'}])");
        normap.put("normal", map);
        histogramSeries.setPropValue("itemStyle", normap);
        histogramSeries.setStack("stack");
        if (!flag.booleanValue()) {
            histogramSeries.setBarWidth("15px");
        } else {
            int index = values.length;
            HashMap<String, Object> dataZoom = new HashMap<String, Object>();
            dataZoom.put("show", true);
            dataZoom.put("moveOnMouseWheel", true);
            dataZoom.put("moveOnMouseMove", true);
            dataZoom.put("startValue", index - 25);
            dataZoom.put("endValue", index);
            dataZoom.put("orient", "vertical");
            histogramChart.addProperty("dataZoom", dataZoom);
        }
        HashMap dataLabels = Maps.newHashMap();
        dataLabels.put("format", "{point.y:.1f}");
        histogramSeries.setPropValue("dataLabels", (Object)dataLabels);
        histogramSeries.setAnimationDuration(2000);
        Label label = new Label();
        label.setPosition(Position.right);
        label.setShow(true);
        histogramSeries.setLabel(label);
        for (int i = 0; i < values.length; ++i) {
            if (!((double)values[i].floatValue() < 0.001) || !((double)values[i].floatValue() > -0.001)) continue;
            values[i] = BigDecimal.ZERO;
        }
        histogramSeries.setData(values);
    }

    public static void showCustomChart(HistogramChart customchart, List<String> keys, List<BigDecimal> values, String color, Boolean flag) {
        Axis xAxis = HistogramChartHelper.createValueAxis(customchart, "", true);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        HistogramChartHelper.createCategoryAxis(customchart, "", keys, false);
        HistogramChartHelper.createHistogramSeries(customchart, ResManager.loadKDString((String)"\u4e07\u5143", (String)"HistogramChartHelper_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), values.toArray(new BigDecimal[0]), color.isEmpty() ? "#FEC035" : color, flag);
        customchart.setMargin(Position.right, "30px");
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.setLegendVertical(false);
        customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 23});
        customchart.setMargin(Position.top, "30px");
        customchart.setName(new LocaleString(ResManager.loadKDString((String)"", (String)"HistogramChartHelper_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        HashMap textStyle = Maps.newHashMap();
        textStyle.put("fontSize", 12);
        textStyle.put("fontWeight", 450);
        customchart.setTitlePropValue("textStyle", (Object)textStyle);
        customchart.refresh();
    }
}

