/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.board.helper;

import kd.bos.exception.KDBizException;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.formplugin.board.helper.AreaServiceHelper;
import kd.taxc.tctsa.formplugin.board.helper.AreaSmallCardServiceHelper;
import kd.taxc.tctsa.formplugin.board.helper.BanKuaiServiceHelper;
import kd.taxc.tctsa.formplugin.board.helper.BanKuaiSmallCardServiceHelper;
import kd.taxc.tctsa.formplugin.board.helper.CockpitServiceHelper;
import kd.taxc.tctsa.formplugin.board.helper.HangYeServiceHelper;
import kd.taxc.tctsa.formplugin.board.helper.HangYeSmallCardServiceHelper;
import kd.taxc.tctsa.formplugin.board.helper.RankService;

public class ServiceFactory {
    private static RankService areaServiceHelper = new AreaServiceHelper();
    private static RankService hangYeServiceHelper = new HangYeServiceHelper();
    private static RankService banKuaiServiceHelper = new BanKuaiServiceHelper();
    private static RankService cockpitServiceHelper = new CockpitServiceHelper();
    private static RankService areaSmallCardServiceHelper = new AreaSmallCardServiceHelper();
    private static RankService hangYeSmallCardServiceHelper = new HangYeSmallCardServiceHelper();
    private static RankService banKuaiSmallCardServiceHelper = new BanKuaiSmallCardServiceHelper();

    public static final RankService getServiceFactory(String type) {
        if (EmptyCheckUtils.isEmpty((Object)type)) {
            throw new KDBizException("type can not be null");
        }
        if ("1".equalsIgnoreCase(type)) {
            return areaServiceHelper;
        }
        if ("2".equalsIgnoreCase(type)) {
            return hangYeServiceHelper;
        }
        if ("3".equalsIgnoreCase(type)) {
            return banKuaiServiceHelper;
        }
        if ("4".equalsIgnoreCase(type)) {
            return areaSmallCardServiceHelper;
        }
        if ("6".equalsIgnoreCase(type)) {
            return banKuaiSmallCardServiceHelper;
        }
        if ("5".equalsIgnoreCase(type)) {
            return hangYeSmallCardServiceHelper;
        }
        if ("7".equalsIgnoreCase(type)) {
            return cockpitServiceHelper;
        }
        throw new KDBizException("type can not be found impl class");
    }

    public static final String bigCard2SmallCard(String type) {
        if ("1".equalsIgnoreCase(type)) {
            return "4";
        }
        if ("2".equalsIgnoreCase(type)) {
            return "5";
        }
        if ("3".equalsIgnoreCase(type)) {
            return "6";
        }
        return "7";
    }
}

