/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.cockpit;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.entity.CockpitTaxData;
import kd.taxc.tctsa.common.enums.TctsaSysTaxTypeEnum;
import kd.taxc.tctsa.common.helper.LevytypeHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.OrgUtils;
import kd.taxc.tctsa.formplugin.board.helper.ServiceFactory;

public class CockpitTaxStatisticsPiePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(CockpitTaxStatisticsPiePlugin.class);
    private static final String PIECHARTAP = "piechartap";

    public void initialize() {
    }

    public void registerListener(EventObject e) {
        PieChart chart = (PieChart)this.getControl(PIECHARTAP);
        chart.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        List<Long> finalTypeList = this.getFinalTypeList();
        this.handlerDrawChart(startDate, endDate, finalTypeList);
    }

    private void handlerDrawChart(Date startdate, Date enddate, List<Long> taxtypeList) {
        this.drawChartQueryResult(startdate, enddate, taxtypeList);
    }

    private void drawChartQueryResult(Date startdate, Date enddate, List<Long> taxtypeList) {
        QFilter startFilter = new QFilter("skssqq", ">=", (Object)startdate);
        QFilter endFilter = new QFilter("skssqz", "<=", (Object)enddate);
        QFilter typeFilter = new QFilter("taxtype", "in", taxtypeList);
        boolean hasRight = this.addRightFilter(endFilter);
        if (!hasRight) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PIECHARTAP});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{PIECHARTAP});
        DynamicObjectCollection dynamicObjects = TjsjbBusiness.queryTjsjbData(Arrays.asList(startFilter, endFilter, typeFilter, LevytypeHelper.getLevytype()), (String)"id,taxtype,declarestatus,bqybtse,org,jmse");
        Map<Long, List<DynamicObject>> typeGroups = dynamicObjects.stream().collect(Collectors.groupingBy(s -> s.getLong("taxtype")));
        BigDecimal tempTaxTypeNsTotal = BigDecimal.ZERO;
        ArrayList<CockpitTaxData> allTaxDataList = new ArrayList<CockpitTaxData>(32);
        HashMap pkids = new HashMap(32);
        for (long type : taxtypeList) {
            tempTaxTypeNsTotal = ((List)typeGroups.getOrDefault(type, new ArrayList())).stream().map(s -> s.getBigDecimal("bqybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List ids = ((List)typeGroups.getOrDefault(type, new ArrayList())).stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            allTaxDataList.add(new CockpitTaxData(type, TctsaSysTaxTypeEnum.getTaxNameByType((long)type), tempTaxTypeNsTotal, BigDecimal.ZERO));
            pkids.put(TctsaSysTaxTypeEnum.getTaxNameByType((long)type), ids);
            tempTaxTypeNsTotal = BigDecimal.ZERO;
        }
        this.getPageCache().put("pagecache", EmptyCheckUtils.isEmpty(pkids) ? null : SerializationUtils.toJsonString(pkids));
        Map<Long, BigDecimal> collectMap = allTaxDataList.stream().collect(Collectors.groupingBy(v -> v.getTypeId(), Collectors.reducing(BigDecimal.ZERO, CockpitTaxData::getAmount, BigDecimal::add)));
        PieChart pieChart = (PieChart)this.getControl(PIECHARTAP);
        pieChart.clearData();
        PieSeries series = pieChart.createSeries(ResManager.loadKDString((String)"", (String)"CockpitTaxStatisticsPiePlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        for (Map.Entry<Long, BigDecimal> entry : collectMap.entrySet()) {
            if (entry.getValue().divide(new BigDecimal(10000)).setScale(2, 4).compareTo(BigDecimal.ZERO) == 0) continue;
            series.addData(new ItemValue(ResManager.loadKDString((String)TctsaSysTaxTypeEnum.getTaxNameByType((long)entry.getKey()), (String)"TaxStatisticsCardPlugin_1", (String)"CockpitTaxStatisticsPiePlugin_1", (Object[])new Object[0]), (Number)entry.getValue().divide(new BigDecimal(10000)).setScale(2, 4), TctsaSysTaxTypeEnum.getColorByType((long)entry.getKey())));
        }
        Map itemNormalStyle = series.getItemNormalStyle();
        HashMap<String, Object> lableMap = new HashMap<String, Object>();
        lableMap.put("show", Boolean.TRUE);
        lableMap.put("position", "left");
        itemNormalStyle.put("label", lableMap);
        HashMap<String, Boolean> lableLineMap = new HashMap<String, Boolean>();
        lableLineMap.put("show", Boolean.TRUE);
        itemNormalStyle.put("labelLine", lableLineMap);
        series.setRadius("50%", "70%");
        Map<String, Object> values = this.getValues(series);
        this.setEmphasisLabel(values);
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(false);
        pieChart.addTooltip("trigger", (Object)"item");
        pieChart.addTooltip("formatter", (Object)ResManager.loadKDString((String)"{b}    {d}% <br/> \u7eb3\u7a0e\u603b\u989d: {c}\u4e07\u5143", (String)"CockpitTaxStatisticsPiePlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        pieChart.setLegendAlign(XAlign.right, YAlign.top);
        pieChart.setLegendVertical(false);
        pieChart.setLegendPropValue("selectedMode", (Object)"onlyHover");
        pieChart.setLegendPropValue("padding", (Object)new Integer[]{80, 50, 20, 20});
        pieChart.refresh();
    }

    private boolean addRightFilter(QFilter endFilter) {
        boolean isHasRight = true;
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        if (EmptyCheckUtils.isNotEmpty((Object)pageCache.get("type"))) {
            String type = pageCache.get("type");
            QFilter qFilter = ServiceFactory.getServiceFactory(ServiceFactory.bigCard2SmallCard(type)).getBaseDataQFilter(this.getView());
            DynamicObjectCollection taxOrgListHasPermission = OrgUtils.getTaxOrgListHasPermission((QFilter)qFilter);
            if (EmptyCheckUtils.isEmpty((Object)taxOrgListHasPermission)) {
                return false;
            }
            List orgs = taxOrgListHasPermission.stream().map(v -> v.getLong("orgid")).distinct().collect(Collectors.toList());
            endFilter.and(new QFilter("org", "in", orgs));
        }
        return isHasRight;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (PIECHARTAP.equals(key)) {
            Map pkidsMap;
            String name = ((ChartClickEvent)evt).getName();
            String pagecache = this.getPageCache().get("pagecache");
            if (EmptyCheckUtils.isNotEmpty((Object)pagecache) && EmptyCheckUtils.isNotEmpty((Object)(pkidsMap = (Map)SerializationUtils.fromJsonString((String)pagecache, Map.class)))) {
                this.openTjsjReport((List)pkidsMap.get(name));
            }
        }
    }

    private void openTjsjReport(List<Long> pkids) {
        if (EmptyCheckUtils.isEmpty(pkids)) {
            return;
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setPageId(this.getView().getPageId() + "abcd");
        reportShowParameter.setFormId("tctsa_statistics_detail");
        reportShowParameter.setCustomParam("ids", pkids);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }

    private Map<String, Object> getValues(PieSeries series) {
        try {
            Class<?> clazz = Class.forName("kd.bos.form.chart.Series");
            Method getValues = clazz.getDeclaredMethod("getValues", new Class[0]);
            AccessibleObject.setAccessible(new AccessibleObject[]{getValues}, true);
            Object invoke = getValues.invoke((Object)series, (Object[])null);
            return null == invoke ? new HashMap(16) : (Map)invoke;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private List<Long> getFinalTypeList() {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getView().getParentView().getModel().getValue("taxtype");
        List finalTypeList = dynamicObjects.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).distinct().collect(Collectors.toList());
        if (finalTypeList.size() == 0) {
            finalTypeList = TctsaSysTaxTypeEnum.getTypeIdList();
        }
        return finalTypeList;
    }

    private Date getStartDate() {
        return DateUtils.getFirstDateOfMonth((Date)((Date)this.getView().getParentView().getModel().getValue("startdate")));
    }

    private Date getEndDate() {
        return DateUtils.getLastDateOfMonth2((Date)((Date)this.getView().getParentView().getModel().getValue("enddate")));
    }

    private void setEmphasisLabel(Map<String, Object> values) {
        if (null != values && values.size() > 0) {
            Map itemStyle = (Map)values.get("itemStyle");
            HashMap emphasisMap = new HashMap();
            HashMap<String, Serializable> labelMap = new HashMap<String, Serializable>();
            HashMap<String, String> textStyleMap = new HashMap<String, String>();
            textStyleMap.put("fontSize", "24");
            textStyleMap.put("fontWeight", "bold");
            labelMap.put("show", Boolean.TRUE);
            labelMap.put("textStyle", textStyleMap);
            emphasisMap.put("label", labelMap);
            HashMap<String, Boolean> labelLineMap = new HashMap<String, Boolean>();
            labelLineMap.put("show", Boolean.FALSE);
            emphasisMap.put("labelLine", labelLineMap);
            itemStyle.put("emphasis", emphasisMap);
        }
    }
}

