/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.cockpit;

import com.google.common.collect.Maps;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.enums.TctsaSysTaxTypeEnum;
import kd.taxc.tctsa.common.helper.LevytypeHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.OrgUtils;
import kd.taxc.tctsa.common.util.StringUtil;
import kd.taxc.tctsa.formplugin.board.helper.ServiceFactory;

public class CockpitTaxanalysisPlugin
extends AbstractFormPlugin
implements ListboxClickListener {
    private static final String LISTBOXAP = "listboxap";
    private static final String POSITION_VALUE = "30px";
    private static final String TREND = "1";
    private static final String TONGBI = "2";
    private static final String TREND__METADATA = "tctsa_single_trend";
    private static final String TONGBI_METADATA = "tctsa_single_tongbi";
    private static final String QUERYDETAILS = "querydetails";
    private static final String POINTLINECHARTAP = "pointlinechartap";
    private static final String HISTOGRAMCHARTAP = "histogramchartap";
    private static final Map<String, String> RMB_UNIT = new HashMap<String, String>();

    public void afterCreateNewData(EventObject e) {
        Listbox listboxap = (Listbox)this.getControl(LISTBOXAP);
        ArrayList<ListboxItem> items = new ArrayList<ListboxItem>();
        items.add(new ListboxItem(TREND, ResManager.loadKDString((String)"\u8d8b\u52bf\u56fe", (String)"CockpitTaxanalysisPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        items.add(new ListboxItem(TONGBI, ResManager.loadKDString((String)"\u540c\u6bd4\u56fe", (String)"CockpitTaxanalysisPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        listboxap.addItems(items);
        this.initChart(TREND);
    }

    public void listboxClick(ListboxEvent evt) {
        String itemId = evt.getItemId();
        this.initChart(itemId);
    }

    public void registerListener(EventObject e) {
        Listbox listbox = (Listbox)this.getControl(LISTBOXAP);
        listbox.addListboxClickListener((ListboxClickListener)this);
        PointLineChart chart = (PointLineChart)this.getControl(POINTLINECHARTAP);
        chart.addClickListener((ClickListener)this);
        HistogramChart histogramChart = (HistogramChart)this.getView().getControl(HISTOGRAMCHARTAP);
        histogramChart.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{QUERYDETAILS});
    }

    private void initChart(String type) {
        this.getPageCache().put("tabType", type);
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        if (TREND.equalsIgnoreCase(type)) {
            this.initTrendChart(startDate, endDate);
        } else {
            this.initYoYChart(startDate, endDate);
        }
    }

    private void initTrendChart(Date startDate, Date endDate) {
        DynamicObjectCollection dataCollection = this.getStatisticTaxData(startDate, endDate);
        Map<String, BigDecimal> monthAmountMap = this.initAmountMap(this.isLessSixMonth(startDate, endDate) != false ? startDate : DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)endDate, (int)-5)), endDate);
        HashMap<String, List<Long>> monthAndDataIdsMap = new HashMap<String, List<Long>>(6);
        this.setAmount(monthAmountMap, (List<DynamicObject>)dataCollection, monthAndDataIdsMap, "skssqz", "bqybtse", "id");
        this.getPageCache().put("currentpagecache", EmptyCheckUtils.isEmpty(monthAndDataIdsMap) ? null : SerializationUtils.toJsonString(monthAndDataIdsMap));
        PointLineChart chart = (PointLineChart)this.getControl(POINTLINECHARTAP);
        chart.clearData();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{HISTOGRAMCHARTAP});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{POINTLINECHARTAP});
        this.drawTrendChart(monthAmountMap, chart);
    }

    private void initYoYChart(Date startDate, Date endDate) {
        startDate = this.getTongbiStart(startDate, endDate);
        Date preStartDate = DateUtils.addYear((Date)startDate, (int)-1);
        DynamicObjectCollection dataCollection = this.getStatisticTaxData(preStartDate, endDate);
        Date finalStartDate = startDate;
        List<DynamicObject> curPeriodData = dataCollection.stream().filter(p -> p.getDate("skssqq").compareTo(finalStartDate) >= 0 && p.getDate("skssqz").compareTo(endDate) <= 0).collect(Collectors.toList());
        Date preEndDate = DateUtils.addYear((Date)endDate, (int)-1);
        List<DynamicObject> prePeriodData = dataCollection.stream().filter(p -> p.getDate("skssqq").compareTo(preStartDate) >= 0 && p.getDate("skssqz").compareTo(preEndDate) <= 0).collect(Collectors.toList());
        Map<String, BigDecimal> curPeriodMonthAmountMap = this.initAmountMap(startDate, endDate);
        Map<String, BigDecimal> prePeriodMonthAmountMap = this.initAmountMap(preStartDate, preEndDate);
        HashMap<String, List<Long>> curPeriodMonthDataIdsMap = new HashMap<String, List<Long>>(32);
        HashMap<String, List<Long>> prePeriodMonthDataIdsMap = new HashMap<String, List<Long>>(32);
        this.setAmount(curPeriodMonthAmountMap, curPeriodData, curPeriodMonthDataIdsMap, "skssqz", "bqybtse", "id");
        this.setAmount(prePeriodMonthAmountMap, prePeriodData, prePeriodMonthDataIdsMap, "skssqz", "bqybtse", "id");
        this.getPageCache().put("tongbicurrentpagecache", EmptyCheckUtils.isEmpty(curPeriodMonthDataIdsMap) ? null : SerializationUtils.toJsonString(curPeriodMonthDataIdsMap));
        this.getPageCache().put("previouspagecache", EmptyCheckUtils.isEmpty(prePeriodMonthDataIdsMap) ? null : SerializationUtils.toJsonString(prePeriodMonthDataIdsMap));
        HistogramChart customChart = (HistogramChart)this.getControl(HISTOGRAMCHARTAP);
        customChart.clearData();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{POINTLINECHARTAP});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{HISTOGRAMCHARTAP});
        this.drawTongbiChart(curPeriodMonthAmountMap, prePeriodMonthAmountMap, customChart, endDate);
    }

    private DynamicObjectCollection getStatisticTaxData(Date startDate, Date endDate) {
        QFilter filter = this.getQFilter(startDate, endDate);
        List<Long> taxTypeIds = this.getFinalTypeList();
        filter = filter.and(new QFilter("taxtype", "in", taxTypeIds)).and(LevytypeHelper.getLevytype());
        return TjsjbBusiness.getTaxAnalysisData((QFilter)filter);
    }

    private void initChat(String type) {
        this.getPageCache().put("tabType", type);
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        Boolean isLess6 = this.isLessSixMonth(startDate, endDate);
        Date tongbiStart = this.getTongbiStart(startDate, endDate);
        QFilter currentqFilter = this.getQFilter(startDate, endDate);
        QFilter previousqFilter = this.getQFilter(DateUtils.addYear((Date)startDate, (int)-1), DateUtils.addYear((Date)endDate, (int)-1));
        Map<String, BigDecimal> currentAmountMap = this.initAmountMap(isLess6 != false ? startDate : DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)endDate, (int)-5)), endDate);
        Map<String, BigDecimal> tongbiCurrentAmountMap = this.initAmountMap(tongbiStart, endDate);
        Map<String, BigDecimal> previousAmountMap = this.initAmountMap(DateUtils.addYear((Date)tongbiStart, (int)-1), DateUtils.addYear((Date)endDate, (int)-1));
        List<Long> finalTypeList = this.getFinalTypeList();
        QFilter typeFilter = new QFilter("taxtype", "in", finalTypeList);
        currentqFilter = currentqFilter.and(typeFilter);
        previousqFilter = previousqFilter.and(typeFilter);
        DynamicObjectCollection currenttjsjbInfos = QueryServiceHelper.query((String)"tctb_tjsjb", (String)"id,org,skssqq,skssqz,taxtype,bqybtse", (QFilter[])new QFilter[]{currentqFilter});
        DynamicObjectCollection previoustjsjbInfos = QueryServiceHelper.query((String)"tctb_tjsjb", (String)"id,org,skssqq,skssqz,taxtype,bqybtse", (QFilter[])new QFilter[]{previousqFilter});
        HashMap<String, List<Long>> currentpkids = new HashMap<String, List<Long>>(32);
        HashMap<String, List<Long>> tongbiCurrentpkids = new HashMap<String, List<Long>>(32);
        HashMap<String, List<Long>> previouspkids = new HashMap<String, List<Long>>(32);
        this.setAmount(currentAmountMap, (List<DynamicObject>)currenttjsjbInfos, currentpkids, "skssqz", "bqybtse", "id");
        this.setAmount(tongbiCurrentAmountMap, (List<DynamicObject>)currenttjsjbInfos, tongbiCurrentpkids, "skssqz", "bqybtse", "id");
        this.setAmount(previousAmountMap, (List<DynamicObject>)previoustjsjbInfos, previouspkids, "skssqz", "bqybtse", "id");
        this.getPageCache().put("currentpagecache", EmptyCheckUtils.isEmpty(currentpkids) ? null : SerializationUtils.toJsonString(currentpkids));
        this.getPageCache().put("tongbicurrentpagecache", EmptyCheckUtils.isEmpty(tongbiCurrentpkids) ? null : SerializationUtils.toJsonString(tongbiCurrentpkids));
        this.getPageCache().put("previouspagecache", EmptyCheckUtils.isEmpty(previouspkids) ? null : SerializationUtils.toJsonString(previouspkids));
        PointLineChart chart = (PointLineChart)this.getControl(POINTLINECHARTAP);
        HistogramChart customchart = (HistogramChart)this.getControl(HISTOGRAMCHARTAP);
        if (TREND.equalsIgnoreCase(type)) {
            chart.clearData();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{HISTOGRAMCHARTAP});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{POINTLINECHARTAP});
            this.drawTrendChart(currentAmountMap, chart);
        } else {
            customchart.clearData();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{POINTLINECHARTAP});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{HISTOGRAMCHARTAP});
            this.drawTongbiChart(tongbiCurrentAmountMap, previousAmountMap, customchart, endDate);
        }
    }

    private Boolean isLessSixMonth(Date startDate, Date endDate) {
        int month = DateUtils.getMonthDiff((Date)startDate, (Date)endDate);
        Boolean isLess6 = false;
        isLess6 = month <= 5 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return isLess6;
    }

    private Date getTongbiStart(Date startDate, Date endDate) {
        if (DateUtils.getYearOfDate((Date)startDate) == DateUtils.getYearOfDate((Date)endDate)) {
            Boolean isLess6 = this.isLessSixMonth(startDate, endDate);
            if (isLess6.booleanValue()) {
                return startDate;
            }
            return DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)endDate, (int)-5));
        }
        Boolean isLess6 = this.isLessSixMonth(DateUtils.getFirstDateOfYear((Date)endDate), endDate);
        if (isLess6.booleanValue()) {
            return DateUtils.getFirstDateOfYear((Date)endDate);
        }
        return DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)endDate, (int)-5));
    }

    private void drawTongbiChart(Map<String, BigDecimal> currentAmountMap, Map<String, BigDecimal> previousAmountMap, HistogramChart customchart, Date endDate) {
        List categorys = currentAmountMap.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        List<Number> currentValues = currentAmountMap.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)).collect(Collectors.toList());
        List<Number> previousValues = previousAmountMap.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)).collect(Collectors.toList());
        Axis xAxis = this.createValueAxis(customchart, String.format("\uff08%1$s\uff09", ResManager.loadKDString((String)"\u4e07\u5143", (String)"CockpitTaxanalysisPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])), false);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        List<String> newCategorys = categorys.stream().map(s -> String.format(ResManager.loadKDString((String)"%s\u6708\u4efd", (String)"CockpitTaxanalysisPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), Integer.valueOf(s.substring(5, 7)))).collect(Collectors.toList());
        this.createCategoryAxis(customchart, "", newCategorys, true);
        int year = DateUtils.getYearOfDate((Date)endDate);
        String yearName = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"CockpitTaxanalysisPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), year);
        String previousYearName = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"CockpitTaxanalysisPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), year - 1);
        this.createHistogramSeries(customchart, previousYearName, previousValues.toArray(new Number[0]), TREND);
        this.createHistogramSeries(customchart, yearName, currentValues.toArray(new Number[0]), TONGBI);
        ArrayList<BigDecimal> tbchangList = new ArrayList<BigDecimal>(256);
        int i = 0;
        for (BigDecimal bigDecimal : currentValues) {
            BigDecimal growthBigDecimal = BigDecimalUtil.divideObject((Object)BigDecimalUtil.subtractObject((Object)bigDecimal, previousValues.get(i)), previousValues.get(i), (int)4, (int)4);
            if (growthBigDecimal == null) {
                growthBigDecimal = BigDecimal.ZERO;
            }
            tbchangList.add(growthBigDecimal.multiply(new BigDecimal(100)));
            ++i;
        }
        this.createLineSeries(customchart, ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f(%)", (String)"CockpitTaxanalysisPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), tbchangList, "#F57582");
        customchart.setName(new LocaleString(""));
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 35});
        customchart.setMargin(Position.top, "20px");
        customchart.setMargin(Position.right, POSITION_VALUE);
        customchart.setMargin(Position.left, POSITION_VALUE);
        customchart.setShowLegend(true);
        customchart.setShowTooltip(true);
        customchart.setLegendVertical(false);
        customchart.refresh();
    }

    private void setAmount(Map<String, BigDecimal> amountMap, List<DynamicObject> resultCol, Map<String, List<Long>> pkids, String periodField, String amountField, String idField) {
        for (DynamicObject object : resultCol) {
            BigDecimal amount = object.getBigDecimal(amountField);
            Date invoiceDate = object.getDate(periodField);
            String dateStr = DateUtils.format((Date)invoiceDate, (String)"yyyy-MM");
            Long id = object.getLong(idField);
            if (!amountMap.containsKey(dateStr)) continue;
            List ids = pkids.getOrDefault(dateStr, new ArrayList());
            BigDecimal newAmount = amountMap.get(dateStr).add(amount);
            amountMap.put(dateStr, newAmount.setScale(2, 4));
            ids.add(id);
            pkids.put(dateStr, ids);
        }
    }

    private Map<String, BigDecimal> initAmountMap(Date startDate, Date endDate) {
        List monthList = DateUtils.getMonthBetween((Date)startDate, (Date)endDate);
        LinkedHashMap<String, BigDecimal> amountMap = new LinkedHashMap<String, BigDecimal>(monthList.size());
        for (String month : monthList) {
            amountMap.put(month, BigDecimal.ZERO);
        }
        return amountMap;
    }

    private void drawTrendChart(Map<String, BigDecimal> valueMap1, PointLineChart chart) {
        chart.clearData();
        List categorys = valueMap1.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        Axis xAxis = this.createCategoryAxis(chart, ResManager.loadKDString((String)"\u6708\u4efd", (String)"CockpitTaxanalysisPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        xAxis.setCategorys(categorys);
        List<BigDecimal> outputValues = valueMap1.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).divide(new BigDecimal(10000)).setScale(2, 4)).collect(Collectors.toList());
        this.createLine(chart, outputValues);
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setLegendVertical(false);
        chart.setShowLegend(false);
        chart.setMargin(Position.top, POSITION_VALUE);
        chart.setMargin(Position.right, POSITION_VALUE);
        chart.setMargin(Position.left, POSITION_VALUE);
        chart.setMargin(Position.bottom, "0px");
        chart.setName(new LocaleString(ResManager.loadKDString((String)"", (String)"CockpitTaxanalysisPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        chart.setTitleAlign(XAlign.left, YAlign.top);
        chart.refresh();
    }

    private void createLine(PointLineChart chart, List<BigDecimal> outputValues) {
        ArrayList<BigDecimal> lineData1 = new ArrayList<BigDecimal>(100);
        this.createValueAxis(chart, RMB_UNIT.get("3"));
        outputValues.forEach(output -> lineData1.add((BigDecimal)output));
        this.createLineSeries(chart, ResManager.loadKDString((String)"\u7eb3\u7a0e\u603b\u989d", (String)"CockpitTaxanalysisPlugin_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), lineData1, "#9EB8FF");
    }

    private void createLineSeries(PointLineChart pointLineChart, String name, List<BigDecimal> values, String color) {
        LineSeries expireSeries = pointLineChart.createLineSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setData(values.toArray(new Number[0]));
    }

    private void createLineSeries(HistogramChart customchart, String name, List<BigDecimal> values, String color) {
        LineSeries expireSeries = customchart.createLineSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setData(values.toArray(new Number[0]));
    }

    private Axis createCategoryAxis(PointLineChart pointLineChart, String name) {
        Axis axis = pointLineChart.createXAxis(name, AxisType.category);
        axis.setPropValue("nameLocation", (Object)"end");
        axis.setPropValue("position", (Object)"bottom");
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        axis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, 0, 0};
        map.put("padding", aa);
        axis.setPropValue("nameTextStyle", map);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(PointLineChart pointLineChart, String name) {
        Axis axis = pointLineChart.createYAxis(name, AxisType.value);
        HashMap splitLine = Maps.newHashMap();
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, 0, -20};
        map.put("padding", aa);
        axis.setPropValue("nameTextStyle", map);
        this.setLineColor(axis, "#999999");
        pointLineChart.setShowTooltip(true);
        return axis;
    }

    private Axis createValueAxis(HistogramChart histogramChart, String name, boolean isX) {
        Axis xaxis = null;
        xaxis = isX ? histogramChart.createXAxis(name, AxisType.value) : histogramChart.createYAxis(name, AxisType.value);
        xaxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, 2, -20};
        map.put("padding", aa);
        xaxis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        xaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xaxis, "#999999");
        return xaxis;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private Axis createCategoryAxis(HistogramChart histogramChart, String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.category) : histogramChart.createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        histogramChart.setShowTooltip(true);
        return axis;
    }

    private void createHistogramSeries(HistogramChart histogramChart, String name, Number[] values, String isyear) {
        BarSeries histogramSeries = histogramChart.createSeries(name);
        histogramSeries.setBarWidth("25px");
        HashMap dataLabels = Maps.newHashMap();
        dataLabels.put("format", "{point.y:.1f}");
        histogramSeries.setPropValue("dataLabels", (Object)dataLabels);
        histogramSeries.setAnimationDuration(2000);
        Label label = new Label();
        label.setPosition(Position.insideBottom);
        label.setShow(false);
        histogramSeries.setLabel(label);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> normap = new HashMap<String, HashMap<String, String>>();
        map.put("color", TREND.equals(isyear) ? "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#6DDBDC'}, {\"offset\": 1, \"color\": '#5CC0DA'}])" : "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#7DBFFF'}, {\"offset\": 1, \"color\": '#568DFF'}])");
        normap.put("normal", map);
        histogramSeries.setPropValue("itemStyle", normap);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        histogramSeries.addFuncPath(list);
        histogramSeries.setLabel((Label)null);
        for (int i = 0; i < values.length; ++i) {
            if (!((double)values[i].floatValue() < 0.001) || !((double)values[i].floatValue() > -0.001)) continue;
            values[i] = BigDecimal.ZERO;
        }
        histogramSeries.setData(values);
    }

    private QFilter getQFilter(Date startdate, Date enddate) {
        QFilter qFilter = new QFilter("skssqq", ">=", (Object)startdate);
        if (EmptyCheckUtils.isEmpty((Object)startdate) || EmptyCheckUtils.isEmpty((Object)enddate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u4e0d\u6b63\u786e\u3002", (String)"CockpitTaxanalysisPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
        QFilter endFilter = new QFilter("skssqz", "<=", (Object)enddate);
        qFilter.and(endFilter);
        boolean hasRight = this.addRightFilter(endFilter);
        if (!hasRight) {
            this.getView().setVisible(Boolean.FALSE, new String[]{POINTLINECHARTAP, HISTOGRAMCHARTAP, QUERYDETAILS});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{POINTLINECHARTAP, HISTOGRAMCHARTAP, QUERYDETAILS});
        }
        return qFilter;
    }

    private boolean addRightFilter(QFilter endFilter) {
        boolean isHasRight = true;
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        if (EmptyCheckUtils.isNotEmpty((Object)pageCache.get("type"))) {
            String type = pageCache.get("type");
            QFilter qFilter = ServiceFactory.getServiceFactory(ServiceFactory.bigCard2SmallCard(type)).getBaseDataQFilter(this.getView());
            DynamicObjectCollection taxOrgListHasPermission = OrgUtils.getTaxOrgListHasPermission((QFilter)qFilter);
            if (EmptyCheckUtils.isEmpty((Object)taxOrgListHasPermission)) {
                return false;
            }
            List orgs = taxOrgListHasPermission.stream().map(v -> v.getLong("orgid")).distinct().collect(Collectors.toList());
            endFilter.and(new QFilter("org", "in", orgs));
            this.getPageCache().put("orgs", SerializationUtils.toJsonString(orgs));
        }
        return isHasRight;
    }

    private List<Long> getFinalTypeList() {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getView().getParentView().getModel().getValue("taxtype");
        List finalTypeList = dynamicObjects.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).distinct().collect(Collectors.toList());
        if (finalTypeList.size() == 0) {
            finalTypeList = TctsaSysTaxTypeEnum.getTypeIdList();
        }
        return finalTypeList;
    }

    private Date getStartDate() {
        Date startdate = (Date)this.getView().getParentView().getModel().getValue("startdate");
        if (EmptyCheckUtils.isEmpty((Object)startdate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u4e0d\u6b63\u786e\u3002", (String)"CockpitTaxanalysisPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
        return DateUtils.getFirstDateOfMonth((Date)startdate);
    }

    private Date getEndDate() {
        Date enddate = (Date)this.getView().getParentView().getModel().getValue("enddate");
        if (EmptyCheckUtils.isEmpty((Object)enddate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u4e0d\u6b63\u786e\u3002", (String)"CockpitTaxanalysisPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
        return DateUtils.getLastDateOfMonth2((Date)enddate);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (QUERYDETAILS.equals(key)) {
            this.showForm(this.getPageCache().get("tabType"));
        } else if (HISTOGRAMCHARTAP.equals(key) || POINTLINECHARTAP.equals(key)) {
            String name = ((ChartClickEvent)evt).getName();
            String seriesName = ((ChartClickEvent)evt).getSeriesName();
            if (POINTLINECHARTAP.equals(key)) {
                Map pkidsMap;
                String currentpagecache = this.getPageCache().get("currentpagecache");
                if (EmptyCheckUtils.isNotEmpty((Object)currentpagecache) && EmptyCheckUtils.isNotEmpty((Object)(pkidsMap = (Map)SerializationUtils.fromJsonString((String)currentpagecache, Map.class)))) {
                    this.openTjsjReport((List)pkidsMap.get(name));
                }
            } else {
                Map pkidsMap;
                String pagecache;
                Date enddate;
                String datastr = "";
                Boolean isCurrentYear = false;
                if (EmptyCheckUtils.isNotEmpty((Object)seriesName)) {
                    datastr = seriesName.substring(0, 4);
                }
                if (String.valueOf(DateUtils.getYearOfDate((Date)(enddate = this.getEndDate()))).equals(datastr)) {
                    isCurrentYear = true;
                }
                if (EmptyCheckUtils.isNotEmpty((Object)name)) {
                    String month = name.substring(0, name.length() - 2);
                    String month1 = StringUtil.fillCharAtLeft((Object)month, (int)2, (char)'0');
                    datastr = datastr + "-" + month1;
                }
                String string = pagecache = isCurrentYear != false ? this.getPageCache().get("tongbicurrentpagecache") : this.getPageCache().get("previouspagecache");
                if (EmptyCheckUtils.isNotEmpty((Object)pagecache) && EmptyCheckUtils.isNotEmpty((Object)(pkidsMap = (Map)SerializationUtils.fromJsonString((String)pagecache, Map.class)))) {
                    this.openTjsjReport((List)pkidsMap.get(datastr));
                }
            }
        }
    }

    private void openTjsjReport(List<Long> pkids) {
        if (EmptyCheckUtils.isEmpty(pkids)) {
            return;
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setPageId(this.getView().getPageId() + "abcd");
        reportShowParameter.setFormId("tctsa_statistics_detail");
        reportShowParameter.setCustomParam("ids", pkids);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }

    private void showForm(String tabType) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(TREND.equals(tabType) ? TREND__METADATA : TONGBI_METADATA);
        StyleCss sc = new StyleCss();
        sc.setHeight("500px");
        sc.setWidth("960px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("jump", TREND);
        String parentid = this.getView().getParentView().getEntityId();
        customParams.put("mainjump", parentid);
        customParams.put("tabType", this.getPageCache().get("tabType"));
        customParams.put("startdate", this.getStartDate());
        customParams.put("enddate", this.getEndDate());
        if ("tctsa_board_home".equals(parentid)) {
            List orgList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("orgs"), List.class);
            customParams.put("orgList", orgList);
        }
        customParams.put("typeList", this.getFinalTypeList());
        parameter.setCustomParams(customParams);
        parameter.setCaption(TONGBI.equals(tabType) ? ResManager.loadKDString((String)"\u7a0e\u91d1\u540c\u6bd4\u5206\u6790", (String)"CockpitTaxanalysisPlugin_11", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7a0e\u91d1\u8d8b\u52bf\u5206\u6790", (String)"CockpitTaxanalysisPlugin_12", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    static {
        RMB_UNIT.put("3", String.format("\uff08%1$s\uff09", ResManager.loadKDString((String)"\u4e07\u5143", (String)"CockpitTaxanalysisPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
    }
}

