/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.cockpit;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;

public class GroupCockpitHomePlugin
extends AbstractFormPlugin {
    private static final String TCTSA_SINGLE_ANALYSIS = "tctsa_single_analysis";

    public void afterCreateNewData(EventObject e) {
        Object enterType;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (EmptyCheckUtils.isNotEmpty((Object)customParams) && EmptyCheckUtils.isNotEmpty(enterType = customParams.get("enterType"))) {
            this.getPageCache().put("enterType", String.valueOf(enterType));
        }
        this.initData();
        this.setVisbleOrHide();
        this.putYearToCache();
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void itemClick(ItemClickEvent evt) {
        boolean result;
        String itemKey = evt.getItemKey();
        if ("refresh1".equals(itemKey) && (result = this.putYearToCache())) {
            this.refreshView();
        }
    }

    private void setVisbleOrHide() {
        if ("1".equals(this.getPageCache().get("enterType"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"org"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"org"});
            OrgServiceHelper.initMainOrg((IFormView)this.getView(), (Boolean)true);
        }
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent beforeF7SelectEvent) {
        OrgServiceHelper.fseven((BeforeF7SelectEvent)beforeF7SelectEvent, null, (String)"1");
    }

    private boolean validateDate(Date start, Date end) {
        Date enddate = DateUtils.getLastDateOfMonth((Date)end);
        if (null != enddate) {
            Date startdate = DateUtils.getFirstDateOfMonth((Date)start);
            return !startdate.after(enddate);
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ((name.equals("org") || name.equals("startdate") || name.equals("enddate")) && newValue == null && null != changeData[0].getOldValue()) {
            this.getModel().setValue(name, changeData[0].getOldValue());
            return;
        }
        if (e.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        boolean result = this.putYearToCache();
        if (result) {
            this.refreshView();
        }
    }

    private boolean putYearToCache() {
        Date date = (Date)this.getModel().getValue("startdate");
        Date dateend = (Date)this.getModel().getValue("enddate");
        if (EmptyCheckUtils.isEmpty((Object)date) || EmptyCheckUtils.isEmpty((Object)dateend)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u8d77\u6b62\u90fd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GroupCockpitHomePlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean result = this.validateDate(date, dateend);
        if (!result) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u4efd\u9009\u62e9\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f00\u59cb\u6708\u4efd\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6708\u4efd\u3002", (String)"GroupCockpitHomePlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getPageCache().put("startdate", DateUtils.format((Date)date));
        this.getPageCache().put("enddate", DateUtils.format((Date)dateend));
        return true;
    }

    private void refreshView() {
        DynamicObject dynamicObject;
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        String entityId = this.getView().getEntityId();
        if (TCTSA_SINGLE_ANALYSIS.equals(entityId) && (dynamicObject = (DynamicObject)this.getView().getModel().getValue("org")) == null) {
            return;
        }
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.refreshView();
        }
    }

    private void initData() {
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth2((Date)new Date()));
    }
}

