/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.creditquery;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.taxc.tctsa.business.creditquery.CreditQueryRptHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.PermissionUtils;
import kd.taxc.tctsa.formplugin.helper.PieChartHelper;
import kd.taxc.tctsa.formplugin.helper.PointLineChartHelper;

public class CreditQueryRptPlugin
extends AbstractReportFormPlugin
implements SelectRowsEventListener {
    private static final String ORGS = "orgs";

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl(ORGS);
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void afterSetModelValue(DynamicObject scheme) {
        DynamicObjectCollection schemeCollection = scheme.getDynamicObjectCollection(ORGS);
        CreditQueryRptHelper.handlerOrgCollectionVisible((Object)schemeCollection, (IReportView)this.getView(), (IDataModel)this.getModel());
        this.showVisualizationTable();
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"yearfield1", "splitcontainerap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"yearfield", "demotequery", "creditlevel1"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ORGS.equals(name)) {
            Object org = this.getModel().getValue(ORGS);
            CreditQueryRptHelper.handlerOrgCollectionVisible((Object)org, (IReportView)this.getView(), (IDataModel)this.getModel());
        }
        if ("demotequery".equals(name) || "yearfield".equals(name)) {
            if (((Boolean)this.getModel().getValue("demotequery")).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"creditlevel1"});
                this.getModel().setValue("creditlevel1", null);
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"creditlevel1"});
            }
            if (this.getView().getModel().getValue("yearfield") != null) {
                this.getModel().setValue("compareyear", (Object)DateUtils.addYear((Date)((Date)this.getView().getModel().getValue("yearfield")), (int)-1));
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"splitcontainerap"});
        List itemInfos = queryParam.getFilter().getFilterItems();
        List orgIds = CreditQueryRptHelper.getOrgListHasPermission((IReportView)this.getView());
        for (FilterItemInfo items : itemInfos) {
            if (!ORGS.equals(items.getPropName()) || items.getValue() != null) continue;
            items.setValue((Object)orgIds);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Date yearfield = filterInfo.getDate("yearfield");
        String org = filterInfo.getString(ORGS);
        if (null == org && null == yearfield) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreditQueryRptPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        Map map = queryParam.getCustomParam();
        String isVisble = map != null ? (String)map.get("isVisble") : "1";
        this.getView().setVisible(Boolean.valueOf(!"0".equals(isVisble)), new String[]{"splitpanelap"});
        this.showVisualizationTable();
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        Boolean dimension = (Boolean)this.getModel().getValue("demotequery");
        Set unVisbleField = CreditQueryRptHelper.getUnVisibleFields((Boolean)dimension);
        List list = event.getColumns();
        for (AbstractReportColumn abstractReportColumn : list) {
            ReportColumn reportColumn;
            String field;
            if (!(abstractReportColumn instanceof ReportColumn) || !unVisbleField.remove(field = (reportColumn = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            reportColumn.setHide(true);
        }
    }

    private void showVisualizationTable() {
        ArrayList<Long> groupsLongList = new ArrayList<Long>();
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        List list = filterInfo.getFilterItems();
        String yearfieldDate1 = (String)this.getView().getModel().getValue("yearfield1");
        Date yearfieldDate = (Date)this.getView().getModel().getValue("yearfield");
        String creditlevel1 = (String)this.getView().getModel().getValue("creditlevel1");
        Boolean demoteQuery = (Boolean)this.getView().getModel().getValue("demotequery");
        Date compareYear = (Date)this.getView().getModel().getValue("compareyear");
        String demoteRange = (String)this.getView().getModel().getValue("demoterange");
        for (FilterItemInfo filter : list) {
            String name;
            if (null == filter || null == filter.getValue()) continue;
            switch (name = filter.getPropName()) {
                case "orgs": {
                    Object value = filter.getValue();
                    if (value instanceof DynamicObjectCollection) {
                        Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                        groupsLongList.addAll(groups.keySet());
                        break;
                    }
                    if (!(value instanceof List) || ((List)value).size() == 0) break;
                    groupsLongList.addAll((List)value);
                    break;
                }
                case "yearfield": {
                    yearfieldDate = (Date)filter.getValue();
                    break;
                }
                case "compareyear": {
                    compareYear = (Date)filter.getValue();
                    break;
                }
                case "creditlevel1": {
                    creditlevel1 = filter.getValue().toString();
                    break;
                }
                case "yearfield1": {
                    yearfieldDate1 = filter.getValue().toString();
                    break;
                }
                case "demotequery": {
                    demoteQuery = (Boolean)filter.getValue();
                    break;
                }
                case "demoterange": {
                    demoteRange = filter.getValue().toString();
                    break;
                }
            }
        }
        String type = groupsLongList.size() == 1 ? "1" : "2";
        if ("1".equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"singeorgflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"moreorgflex", "degradeflex"});
            PointLineChart pointLineChart = (PointLineChart)this.getControl("pointlinechartap");
            PointLineChartHelper pointLineChartHelper = new PointLineChartHelper();
            pointLineChartHelper.drawChart(pointLineChart, groupsLongList, ResManager.loadKDString((String)"\u5168\u90e8\u5e74\u5ea6", (String)"CreditQueryRptPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]).equals(yearfieldDate1) ? null : yearfieldDate, creditlevel1);
            pointLineChart.setName(new LocaleString(ResManager.loadKDString((String)"\u4fe1\u7528\u7ea7\u522b\u8d8b\u52bf\u56fe", (String)"CreditQueryRptPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
            HashMap textStyle = Maps.newHashMap();
            textStyle.put("fontSize", 18);
            textStyle.put("fontWeight", 500);
            pointLineChart.setTitlePropValue("textStyle", (Object)textStyle);
            pointLineChart.setTitleAlign(XAlign.left, YAlign.top);
            pointLineChart.setShowTooltip(false);
            pointLineChart.refresh();
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"moreorgflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"singeorgflex", "degradeflex"});
            PieChart chart = (PieChart)this.getControl("piechartap");
            PieChartHelper pieChartHelper = new PieChartHelper();
            HistogramChart histogramChart = (HistogramChart)this.getView().getControl("histogramchartap");
            pieChartHelper.drawChart(chart, histogramChart, groupsLongList, yearfieldDate, creditlevel1, demoteQuery, compareYear, demoteRange, "labelap");
            chart.setName(new LocaleString(demoteQuery == false ? ResManager.loadKDString((String)"\u4fe1\u7528\u7ea7\u522b\u5360\u6bd4\u56fe", (String)"CreditQueryRptPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u964d\u7ea7\u7ec4\u7ec7\u5360\u6bd4\u56fe", (String)"CreditQueryRptPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
            histogramChart.setName(new LocaleString(demoteQuery == false ? ResManager.loadKDString((String)"\u4fe1\u7528\u7ea7\u522b\u7ad6\u72b6\u56fe", (String)"CreditQueryRptPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u964d\u7ea7\u7ec4\u7ec7\u7ad6\u72b6\u56fe", (String)"CreditQueryRptPlugin_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
            HashMap textStyle = Maps.newHashMap();
            textStyle.put("fontSize", 16);
            textStyle.put("fontWeight", 500);
            chart.setTitlePropValue("textStyle", (Object)textStyle);
            chart.setTitleAlign(XAlign.left, YAlign.top);
            chart.setShowTooltip(true);
            chart.refresh();
            histogramChart.setTitlePropValue("textStyle", (Object)textStyle);
            histogramChart.setTitleAlign(XAlign.left, YAlign.top);
            histogramChart.setShowTooltip(true);
            histogramChart.refresh();
        }
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
        formShowParameter.getCustomParams().put("orgFuncId", "40");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"CreditQueryRptPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        List<Long> orgIds = this.getDefaultOrgIds();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        QFilter orgIdsFilter = new QFilter("id", "in", orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    public List<Long> getDefaultOrgIds() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            return hasPermOrgResult.getHasPermOrgs();
        }
        return null;
    }
}

