/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.eventcenter.handle;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.constant.TjsjbFieldConstant;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.formplugin.eventcenter.handle.WriteBackContext;
import kd.taxc.tctsa.formplugin.eventcenter.handle.join.DetailMap;
import kd.taxc.tctsa.formplugin.eventcenter.handle.join.JoinConfig;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutableTriple;

public abstract class WriteBackService
extends TjsjbFieldConstant {
    private static final Log logger = LogFactory.getLog(WriteBackService.class);
    private WriteBackContext writeBackContext;

    public void etl() {
        if (this.getContext() == null) {
            return;
        }
        if (!this.getContext().getAllUpdate().booleanValue() && CollectionUtils.isEmpty(this.getContext().getSbbIds())) {
            return;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.decideAllUpdate();
        this.extract();
        this.transfer();
        this.load();
    }

    public void decideAllUpdate() {
        if (!this.getContext().getAllUpdate().booleanValue()) {
            String type = this.getContext().getType();
            List ids = this.getContext().getSbbIds().stream().map(String::valueOf).collect(Collectors.toList());
            QFilter qFilter = new QFilter("type", "=", (Object)type).and("sbbid", "not in", ids);
            DynamicObjectCollection formno = TjsjbBusiness.queryTjsjbData(Collections.singletonList(qFilter), (String)"formno");
            List formno1 = formno.stream().map(m -> m.getString("formno")).distinct().collect(Collectors.toList());
            QFilter mainTableFilter = (QFilter)this.getMainTableSelectConfig().right;
            mainTableFilter.and("id", "not in", this.getContext().getSbbIds());
            DynamicObjectCollection mainDyoList = QueryServiceHelper.query((String)((String)this.getMainTableSelectConfig().left), (String)((String)this.getMainTableSelectConfig().middle), (QFilter[])mainTableFilter.toArray());
            List billnoListOfMainDyo = mainDyoList.stream().map(m -> m.getString("billno")).distinct().collect(Collectors.toList());
            Collection disjunction = CollectionUtils.disjunction(formno1, billnoListOfMainDyo);
            if (CollectionUtils.isNotEmpty((Collection)disjunction)) {
                this.getContext().setAllUpdate(true);
            }
        }
    }

    public abstract MutableTriple<String, String, QFilter> getMainTableSelectConfig();

    public abstract List<JoinConfig> getJoinConfigList();

    public Map<String, Map<String, String>> getExtendOutputMap() {
        List<DynamicObject> mainDyoList = this.getContext().getMainDyoList();
        Map<Long, DynamicObject> mainDyosMap = mainDyoList.stream().collect(Collectors.toMap(k -> k.getLong("ID"), v -> v));
        Map<Long, Long> orgTaxOfficeMap = this.queryTaxOfficeMap(mainDyoList.stream().map(m -> m.getLong("org")).distinct().collect(Collectors.toList()));
        HashMap<String, String> map = new HashMap<String, String>(8);
        for (Map.Entry<Long, Long> entry : orgTaxOfficeMap.entrySet()) {
            map.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>(8);
        hashMap.put("OrgTaxOfficeMap", map);
        return hashMap;
    }

    public abstract DynamicObject handleSingleExtractAndTransfer(DynamicObject var1, Map<String, Map<String, String>> var2, Map<String, Map<String, String>> var3);

    public void extract() {
        long start = System.currentTimeMillis();
        WriteBackContext context = this.getContext();
        List<DynamicObject> mainDyoList = this.queryMainDyoList();
        if (context.getAllUpdate().booleanValue()) {
            List<Long> sbbids = mainDyoList.stream().map(m -> m.getLong("ID")).distinct().collect(Collectors.toList());
            context.setSbbIds(sbbids);
        }
        Map<Long, DynamicObject> mainDyosMap = mainDyoList.stream().collect(Collectors.toMap(k -> k.getLong("ID"), v -> v));
        List<DetailMap> detailMaps = this.queryDetailMap();
        context.setMainDyoList(mainDyoList);
        context.setMainDyosMap(mainDyosMap);
        context.setDetailMaps(detailMaps);
        Map<String, Map<String, String>> extendOutputMap = this.getExtendOutputMap();
        context.setExtendOutputMap(extendOutputMap);
        logger.info("\u83b7\u53d6\u6570\u636e\u5b8c\u6bd5\uff0c\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
    }

    public List<DynamicObject> queryMainDyoList() {
        WriteBackContext context = this.getContext();
        QFilter mainTableFilter = (QFilter)this.getMainTableSelectConfig().right;
        if (!context.getAllUpdate().booleanValue()) {
            mainTableFilter.and("id", "in", context.getSbbIds());
        }
        return QueryServiceHelper.query((String)((String)this.getMainTableSelectConfig().left), (String)((String)this.getMainTableSelectConfig().middle), (QFilter[])mainTableFilter.toArray());
    }

    public void transfer() {
        long start = System.currentTimeMillis();
        WriteBackContext context = this.getContext();
        Map<Long, DynamicObject> mainDyosMap = context.getMainDyosMap();
        List<DetailMap> detailMapList = context.getDetailMaps();
        for (Long sbbId : this.getContext().getSbbIds()) {
            DynamicObject mainDyo = mainDyosMap.get(sbbId);
            if (mainDyo == null) continue;
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(8);
            for (DetailMap detailMap : detailMapList) {
                String name = detailMap.getName();
                Map<String, String> dataMap = detailMap.getDataMap().get(String.valueOf(sbbId));
                map.put(name, dataMap);
            }
            DynamicObject saveDyo = null;
            try {
                saveDyo = this.handleSingleExtractAndTransfer(mainDyo, map, this.getContext().getExtendOutputMap());
            }
            catch (Exception e) {
                String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38:{}", (Object)exceptionStackTraceMessage);
            }
            if (saveDyo == null) continue;
            this.getContext().getTransferResult().add(saveDyo);
        }
        logger.info("\u8f6c\u6362\u6570\u636e\u5b8c\u6bd5\uff0c\u5f97\u5230{}\u6761\u8f6c\u6362\u6570\u636e\uff0c\u8017\u65f6{}", (Object)this.getContext().getTransferResult().size(), (Object)(System.currentTimeMillis() - start));
    }

    public void load() {
        long start = System.currentTimeMillis();
        WriteBackContext context = this.getContext();
        Boolean allUpdate = context.getAllUpdate();
        List<DynamicObject> transferResult = context.getTransferResult();
        String type = context.getType();
        QFilter deleteFilter = new QFilter("type", "=", (Object)type);
        if (!allUpdate.booleanValue()) {
            List<Long> sbbIds = context.getSbbIds();
            List idStrs = sbbIds.stream().map(String::valueOf).distinct().collect(Collectors.toList());
            deleteFilter.and("sbbid", "in", idStrs);
        }
        int deleteSize = DeleteServiceHelper.delete((String)"tctb_tjsjb", (QFilter[])deleteFilter.toArray());
        int addSize = 0;
        if (CollectionUtils.isNotEmpty(transferResult)) {
            List partition = Lists.partition(transferResult, (int)200);
            for (List list : partition) {
                Object[] save = SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                addSize += save.length;
            }
        }
        logger.info("\u52a0\u8f7d\u5230\u6570\u636e\u5e93\u5b8c\u6bd5\uff0c\u5220\u9664\u65e7\u6570\u636e\u6761\u6570{}\uff0c\u4fdd\u5b58\u65b0\u6570\u636e\u6761\u6570{}\uff0c\u8017\u65f6{}", new Object[]{deleteSize, addSize, System.currentTimeMillis() - start});
    }

    public void setPayRecordInfo(Long sbbid, String sbbno, DynamicObject tjsjbRecord) {
        QFilter recordFilter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbid)).and("paystatus", "=", (Object)"1").and("sbbno", "=", (Object)sbbno);
        DynamicObjectCollection payDynamic = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"billno,sbbid ,sjje ,paydate ,id", (QFilter[])recordFilter.toArray());
        BigDecimal allTotal = BigDecimal.ZERO;
        DynamicObjectCollection entityCollection = tjsjbRecord.getDynamicObjectCollection("entryentity");
        if (payDynamic != null) {
            for (DynamicObject payDyo : payDynamic) {
                DynamicObject entity = entityCollection.addNew();
                entity.set("djtsjsj", (Object)payDyo.getBigDecimal("sjje"));
                entity.set("djtjkdate", (Object)payDyo.getDate("paydate"));
                allTotal = BigDecimalUtil.addObject((Object)allTotal, (Object)payDyo.getBigDecimal("sjje")).setScale(2, RoundingMode.HALF_UP);
            }
        }
        tjsjbRecord.set("sjsj", (Object)allTotal);
        tjsjbRecord.set("jkdate", null);
    }

    public BigDecimal getBigDecimalValue(Map<String, String> map, String key) {
        if (map == null) {
            return BigDecimal.ZERO;
        }
        String value = map.get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(value).setScale(2, RoundingMode.HALF_UP);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public Long getLongValue(Map<String, String> map, String key) {
        if (map == null) {
            return 0L;
        }
        String value = map.get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public Map<Long, Long> queryTaxOfficeMap(List<Long> orgIds) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsWithNoStatus(orgIds, (Long)TaxationsysMappingEnum.CHN.getId());
        List taxResultList = (List)taxResult.getData();
        return taxResultList.stream().collect(Collectors.toMap(k -> k.getLong("orgid.id"), v -> v.getLong("taxoffice.id")));
    }

    public List<DetailMap> queryDetailMap() {
        List<Long> sbbIds = this.getContext().getSbbIds();
        List<JoinConfig> joinConfigList = this.getJoinConfigList();
        if (CollectionUtils.isEmpty(joinConfigList)) {
            return new ArrayList<DetailMap>();
        }
        ArrayList<DetailMap> detailMaps = new ArrayList<DetailMap>(8);
        for (JoinConfig joinConfig : joinConfigList) {
            DynamicObjectCollection details;
            List<String> collect = sbbIds.stream().map(String::valueOf).collect(Collectors.toList());
            QFilter detailFilter = new QFilter(joinConfig.getPkField(), "in", joinConfig.getPkMapper().idMapper(collect));
            if (joinConfig.getRightTableFilter() != null) {
                detailFilter.and(joinConfig.getRightTableFilter());
            }
            if (CollectionUtils.isEmpty((Collection)(details = QueryServiceHelper.query((String)joinConfig.getRightTable(), (String)joinConfig.getRightTableField(), (QFilter[])detailFilter.toArray())))) continue;
            DetailMap detailMap = new DetailMap();
            detailMap.setName(joinConfig.getRightTable());
            Map<String, Map<String, String>> detailMapBySbbId = joinConfig.getDetailMap().detailMapper((List<DynamicObject>)details);
            detailMap.setDataMap(detailMapBySbbId);
            detailMaps.add(detailMap);
        }
        return detailMaps;
    }

    public void setContext(WriteBackContext writeBackContext) {
        this.writeBackContext = writeBackContext;
    }

    public WriteBackContext getContext() {
        return this.writeBackContext;
    }

    public void clear() {
    }

    public void setSflRatio(DynamicObject tjsjbDyo) {
        tjsjbDyo.set("fsl", (Object)(BigDecimal.ZERO.compareTo(tjsjbDyo.getBigDecimal("yssr")) != 0 ? BigDecimalUtil.divideObject((Object)tjsjbDyo.getBigDecimal("ynse"), (Object)tjsjbDyo.getBigDecimal("yssr"), (int)4) : BigDecimal.ZERO));
    }
}

