/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.eventcenter.handle.join;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.taxc.tctsa.formplugin.eventcenter.handle.join.JoinConfig;

public class JoinConfigBuilder {
    public JoinConfig buildForVersionModelThree(List<String> keys) {
        JoinConfig joinConfig = new JoinConfig();
        joinConfig.setLeftTable("tpo_declare_main_tsc");
        joinConfig.setLeftTableField("id");
        joinConfig.setRightTable("tpo_declare_detail_tsc");
        joinConfig.setPkField("entryid");
        joinConfig.setRightTableField("entryid,cellnumber,value");
        joinConfig.setPkMapper(ids -> ids.stream().map(m -> Long.parseLong(String.valueOf(m))).collect(Collectors.toList()));
        QFilter qFilter = new QFilter("cellnumber", "in", keys);
        joinConfig.setRightTableFilter(qFilter);
        joinConfig.setDetailMap(details -> {
            HashMap detailMapBySbbId = new HashMap(8);
            Map<String, List<DynamicObject>> listMapGroupByPk = details.stream().collect(Collectors.groupingBy(m -> m.getString(joinConfig.getPkField())));
            for (Map.Entry<String, List<DynamicObject>> entry : listMapGroupByPk.entrySet()) {
                String sbbid = entry.getKey();
                List<DynamicObject> values = entry.getValue();
                HashMap<String, String> map = new HashMap<String, String>(8);
                for (DynamicObject value : values) {
                    map.put(value.getString("cellnumber"), value.getString("value"));
                }
                detailMapBySbbId.put(sbbid, map);
            }
            return detailMapBySbbId;
        });
        return joinConfig;
    }
}

