/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.eventcenter.handle.tcnfep;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tctsa.formplugin.eventcenter.handle.WriteBackService;
import kd.taxc.tctsa.formplugin.eventcenter.handle.join.JoinConfig;
import org.apache.commons.lang3.tuple.MutableTriple;

public class KjqysdsV2WriteBackServiceImpl
extends WriteBackService {
    @Override
    public MutableTriple<String, String, QFilter> getMainTableSelectConfig() {
        return MutableTriple.of((Object)"tcnfep_kj_declare_main", (Object)"id,billno,billstatus,org,skssqq,skssqz,datatype,declarestatus", (Object)new QFilter("type", "=", (Object)this.getContext().getType()).and("billstatus", "=", (Object)"C"));
    }

    @Override
    public List<JoinConfig> getJoinConfigList() {
        JoinConfig joinConfig = new JoinConfig();
        joinConfig.setLeftTable("tcnfep_kj_declare_main");
        joinConfig.setLeftTableField("id");
        joinConfig.setRightTable("tcnfep_fdyqkjhzxsbqk");
        joinConfig.setPkField("sbbid");
        joinConfig.setRightTableField(MetadataUtil.getAllFieldToQuery((String)"tcnfep_fdyqkjhzxsbqk"));
        joinConfig.setPkMapper(ids -> ids.stream().map(String::valueOf).collect(Collectors.toList()));
        joinConfig.setDetailMap(details -> {
            HashMap detailMapBySbbId = new HashMap(8);
            Map<String, List<DynamicObject>> listMapGroupByPk = details.stream().collect(Collectors.groupingBy(m -> m.getString(joinConfig.getPkField())));
            for (Map.Entry<String, List<DynamicObject>> entry : listMapGroupByPk.entrySet()) {
                String sbbid = entry.getKey();
                List<DynamicObject> values = entry.getValue();
                HashMap<String, String> map = new HashMap<String, String>(8);
                for (DynamicObject value : values) {
                    map.put("tcnfep_fdyqkjhzxsbqk#1#sjynsqysdse", value.getString("sjynsqysdse"));
                    map.put("tcnfep_fdyqkjhzxsbqk#1#ynssde", value.getString("ynssde"));
                    map.put("tcnfep_fdyqkjhzxsbqk#1#jmqysdse", value.getString("jmqysdse"));
                    map.put("tcnfep_fdyqkjhzxsbqk#1#ynsqysdse", value.getString("ynsqysdse"));
                }
                detailMapBySbbId.put(sbbid, map);
            }
            return detailMapBySbbId;
        });
        return Collections.singletonList(joinConfig);
    }

    @Override
    public DynamicObject handleSingleExtractAndTransfer(DynamicObject mainDyo, Map<String, Map<String, String>> detailMap, Map<String, Map<String, String>> extendOutputMap) {
        DynamicObject saveDyo = BusinessDataServiceHelper.newDynamicObject((String)"tctb_tjsjb");
        saveDyo.set("org", (Object)mainDyo.getLong("org"));
        saveDyo.set("hsorg", (Object)mainDyo.getLong("org"));
        saveDyo.set("skssqq", mainDyo.get("skssqq"));
        saveDyo.set("skssqz", mainDyo.get("skssqz"));
        saveDyo.set("taxationsys", (Object)1L);
        saveDyo.set("taxareagroup", (Object)AccrualConstant.TAXAREAGROUP_CHINA);
        saveDyo.set("taxtype", (Object)3L);
        saveDyo.set("sbbid", (Object)mainDyo.getLong("ID"));
        saveDyo.set("formno", (Object)mainDyo.getString("billno"));
        saveDyo.set("businesssource", (Object)"0");
        saveDyo.set("metadataid", (Object)"tcnfep_kj_declare_main");
        saveDyo.set("levytype", (Object)"dkdj");
        saveDyo.set("datatype", (Object)mainDyo.getString("datatype"));
        saveDyo.set("declarestatus", (Object)mainDyo.getString("declarestatus"));
        saveDyo.set("type", (Object)"kjqysds");
        Map map = detailMap.getOrDefault("tcnfep_fdyqkjhzxsbqk", new HashMap(8));
        saveDyo.set("bqybtse", (Object)this.getBigDecimalValue(map, "tcnfep_fdyqkjhzxsbqk#1#sjynsqysdse"));
        saveDyo.set("yssr", (Object)this.getBigDecimalValue(map, "tcnfep_fdyqkjhzxsbqk#1#ynssde"));
        saveDyo.set("jmse", (Object)this.getBigDecimalValue(map, "tcnfep_fdyqkjhzxsbqk#1#jmqysdse"));
        saveDyo.set("ynse", (Object)this.getBigDecimalValue(map, "tcnfep_fdyqkjhzxsbqk#1#ynsqysdse"));
        this.setPayRecordInfo(mainDyo.getLong("ID"), mainDyo.getString("billno"), saveDyo);
        this.setSflRatio(saveDyo);
        Map orgTaxOfficeMap = extendOutputMap.getOrDefault("OrgTaxOfficeMap", new HashMap());
        long taxOffice = orgTaxOfficeMap.get(mainDyo.getString("org")) == null ? 0L : Long.parseLong((String)orgTaxOfficeMap.get(mainDyo.getString("org")));
        saveDyo.set("taxoffice", (Object)taxOffice);
        return saveDyo;
    }
}

