/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.eventcenter.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.tctsa.common.entity.LdtsWriteBackBean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LdtsWriteBackServiceImpl {
    private static final String TITLE = "Item-01-0222";
    private static final String STATISTICPROTID = "statisticprotid.number";
    private static final String PREFERENTTAX = "preferenttax";

    public static void startWriteBack(List<LdtsWriteBackBean> ldtsWriteBackBean) {
        Map<String, List<DynamicObject>> detailInfo = LdtsWriteBackServiceImpl.selectDetail(ldtsWriteBackBean);
        DynamicObject dataInfos = LdtsWriteBackServiceImpl.selectData();
        for (LdtsWriteBackBean ldtsBean : ldtsWriteBackBean) {
            String event;
            List<DynamicObject> detailList = detailInfo.get(ldtsBean.getOrg() + "_" + ldtsBean.getType() + "_" + ldtsBean.getSkssqq() + "_" + ldtsBean.getSkssqz());
            if (CollectionUtils.isEmpty(detailList)) continue;
            DynamicObject detail = detailList.get(0);
            switch (event = ldtsBean.getEvent().toLowerCase(Locale.getDefault())) {
                case "new": 
                case "update": {
                    LdtsWriteBackServiceImpl.addAndUpdateLdts(ldtsBean, dataInfos, detail);
                    break;
                }
                case "delete": {
                    LdtsWriteBackServiceImpl.deleteLdts(detail);
                    break;
                }
            }
        }
    }

    private static Map<String, List<DynamicObject>> selectDetail(List<LdtsWriteBackBean> ldtsWriteBackBean) {
        QFilter orgQFilter = new QFilter("org", "in", ldtsWriteBackBean.stream().map(LdtsWriteBackBean::getOrg).collect(Collectors.toList()));
        QFilter taxcategoryidQFilter = new QFilter("taxcategoryid", "in", (Object)1);
        QFilter typeQFilter = new QFilter("type", "in", ldtsWriteBackBean.stream().map(LdtsWriteBackBean::getType).collect(Collectors.toList()));
        DynamicObject[] detailInfos = BusinessDataServiceHelper.load((String)"tctsa_preferentdetail", (String)MetadataUtil.getAllSubFieldString((String)"tctsa_preferentdetail"), (QFilter[])new QFilter[]{orgQFilter, taxcategoryidQFilter, typeQFilter});
        return Arrays.stream(detailInfos).collect(Collectors.groupingBy(a -> a.getString("org.id") + "_" + a.getString("type") + "_" + DateUtils.format((Date)a.getDate("skssqq"), (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)a.getDate("skssqz"), (String)"yyyy-MM-dd")));
    }

    private static DynamicObject selectData() {
        QFilter typeQFilter2 = new QFilter("number", "=", (Object)TITLE);
        return BusinessDataServiceHelper.loadSingle((String)"tctsa_statistic_project", (String)"id,projtype", (QFilter[])new QFilter[]{typeQFilter2});
    }

    private static void addAndUpdateLdts(LdtsWriteBackBean ldtsBean, DynamicObject dataInfos, DynamicObject detailInfos) {
        DynamicObjectCollection entryentity = detailInfos.getDynamicObjectCollection("entryentity");
        Optional<DynamicObject> any = entryentity.stream().filter(m -> StringUtils.equals((CharSequence)m.getString("statisticprotid.id"), (CharSequence)dataInfos.getString("id"))).findAny();
        DynamicObject newObj = any.isPresent() ? any.get() : entryentity.addNew();
        newObj.set("statisticprotid", dataInfos.get("id"));
        newObj.set("preferenttype", dataInfos.get("projtype"));
        newObj.set(PREFERENTTAX, (Object)ldtsBean.getBqsqthzlldtse().add(ldtsBean.getBqsqthclldtse()).setScale(2, 4));
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : entryentity) {
            total = total.add(dynamicObject.getBigDecimal("amountincome").multiply(new BigDecimal("0.25")).add(dynamicObject.getBigDecimal(PREFERENTTAX)));
        }
        detailInfos.set("discountamount", (Object)total);
        detailInfos.set("actualdiscount", (Object)total);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{detailInfos});
    }

    private static void deleteLdts(DynamicObject detailInfos) {
        DynamicObjectCollection entryentity = detailInfos.getDynamicObjectCollection("entryentity");
        Optional<DynamicObject> any = entryentity.stream().filter(m -> m.get(STATISTICPROTID).equals(TITLE)).findAny();
        if (any.isPresent()) {
            entryentity.remove((Object)any.get());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{detailInfos});
        }
    }
}

