/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.eventcenter.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.tctsa.common.entity.TjsjhwsWriteBackBean;
import kd.taxc.tctsa.common.entity.TjsjjtzjbWriteBackBean;
import kd.taxc.tctsa.common.entity.TsjsbTaxReportWriteBackBean;
import kd.taxc.tctsa.common.entity.TsjsbWriteBackBean;
import kd.taxc.tctsa.common.enums.PayRecordTaxTypeEnum;
import kd.taxc.tctsa.common.enums.TctsaSysTaxTypeEnum;
import kd.taxc.tctsa.common.enums.TjsjbMetadataidEnum;
import kd.taxc.tctsa.common.enums.TjsjjtMetadataidEnum;
import kd.taxc.tctsa.common.enums.TysbDeclareEnum;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.TctsaUtils;
import kd.taxc.tctsa.formplugin.eventcenter.handle.WriteBackContext;
import kd.taxc.tctsa.formplugin.eventcenter.handle.WriteBackService;
import kd.taxc.tctsa.formplugin.eventcenter.service.TjsjbFetchSqlService;
import kd.taxc.tctsa.formplugin.eventcenter.service.TjsjbFetchSqlServiceFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TsjsbWriteBackServiceImpl {
    private static final Log logger = LogFactory.getLog(TsjsbWriteBackServiceImpl.class);
    private static final List<String> TYPE_LIST = Arrays.asList("zzsybnsr_fzjg", "zzsybnsr_zjg");
    private static final List<String> ZZSTYPE_LIST = Arrays.asList("1", "6", "19", "20");
    private static final List<Long> DEG_LIST = Arrays.asList(1641488069766976512L, 1641486689354421248L);
    private static final List<Long> RIBEN_LIST = Arrays.asList(1641493001807107072L, 1641493399963997184L);
    private static final String SBBID = "sbbid";
    private static final String TCTSA_TJSJB_RULE_CONFIG = "tctsa_tjsjb_rule_config";
    private static final String TCTSA_TJSJB_RULE_CONFIG_FIELD = "number,type,businesssource ,entryentity.accessfield as accessfield,entryentity.datasourcetext as datasourcetext,entryentity.datasourcejson_tag as datasourcejson_tag,entryentity.recheck as recheck";
    public static final String SUBMIT = "A";
    public static final long USA_CIT_TAX_ID = 1641488655174373376L;
    public static final String NOT_BACKEND_UPDATE = "1";

    public static void startWriteBack(List<Long> sbbIds, Boolean allUpdate, String type, String metadataId) {
        WriteBackContext context = new WriteBackContext();
        context.setSbbIds(sbbIds);
        context.setAllUpdate(allUpdate);
        context.extendInputMap.put("metadataId", metadataId);
        context.setType(type);
        WriteBackService writeBackService = context.getWriteBackService();
        if (writeBackService == null) {
            return;
        }
        writeBackService.etl();
    }

    public static void startWriteBack(List beanList, String updateType, List<Long> taxTypes, String dataHandleType, String msgBody) {
        if (CollectionUtils.isEmpty((Collection)beanList)) {
            return;
        }
        TsjsbWriteBackServiceImpl.filterAndHandleByNewWriteBack(beanList, updateType);
        if (CollectionUtils.isNotEmpty((Collection)beanList)) {
            TsjsbWriteBackServiceImpl.deleteHisWhenBatchUpdate(updateType, taxTypes, dataHandleType);
            for (Object bean : beanList) {
                TsjsbWriteBackServiceImpl.handleMsgBean(updateType, bean, msgBody);
            }
        }
    }

    private static void filterAndHandleByNewWriteBack(List beanList, String updateType) {
        ArrayList<TsjsbWriteBackBean> tsjsbWriteBackBeans = new ArrayList<TsjsbWriteBackBean>(8);
        String type = null;
        Iterator it = beanList.iterator();
        while (it.hasNext()) {
            TsjsbWriteBackBean writeBackBean;
            String writeBackBeanType;
            Object data = it.next();
            if (!(data instanceof TsjsbWriteBackBean) || !"dkdj".equalsIgnoreCase(writeBackBeanType = (writeBackBean = (TsjsbWriteBackBean)data).getType()) && !"kjqysds".equalsIgnoreCase(writeBackBeanType)) continue;
            type = writeBackBeanType;
            tsjsbWriteBackBeans.add((TsjsbWriteBackBean)data);
            it.remove();
        }
        Map<String, List<TsjsbWriteBackBean>> listMap = tsjsbWriteBackBeans.stream().collect(Collectors.groupingBy(tsjsbWriteBackBean -> {
            if (tsjsbWriteBackBean.getMetaDataid() != null) {
                return tsjsbWriteBackBean.getMetaDataid();
            }
            return "";
        }));
        for (List<TsjsbWriteBackBean> values : listMap.values()) {
            List<Long> sbbids = values.stream().map(TsjsbWriteBackBean::getId).distinct().collect(Collectors.toList());
            TsjsbWriteBackServiceImpl.startWriteBack(sbbids, "2".equalsIgnoreCase(updateType), type, values.get(0).getMetaDataid());
        }
    }

    private static void handleMsgBean(String updateType, Object bean, String msgBody) {
        if (bean == null) {
            return;
        }
        try {
            if (bean instanceof TsjsbWriteBackBean) {
                TsjsbWriteBackServiceImpl.handleWriteBackBean(updateType, (TsjsbWriteBackBean)bean, msgBody);
            } else if (bean instanceof TsjsbTaxReportWriteBackBean) {
                TsjsbWriteBackServiceImpl.handleTaxReportWriteBackBean(updateType, (TsjsbTaxReportWriteBackBean)bean);
            } else if (bean instanceof TjsjjtzjbWriteBackBean) {
                TsjsbWriteBackServiceImpl.handleJtWriteBackBean(updateType, (TjsjjtzjbWriteBackBean)bean);
            } else if (bean instanceof TjsjhwsWriteBackBean) {
                TsjsbWriteBackServiceImpl.handleHwsWriteBackBean(updateType, (TjsjhwsWriteBackBean)bean);
            }
        }
        catch (Exception ex) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error("\u6570\u636e:{},\u6570\u636e\u53cd\u5199\u51fa\u73b0\u5f02\u5e38:{}", (Object)JsonUtil.toJson((Object)bean), (Object)exceptionStackTraceMessage);
            throw ex;
        }
    }

    private static void handleWriteBackBean(String updateType, TsjsbWriteBackBean bean, String msgBody) {
        block23: {
            QFilter qfilter;
            if (!"2".equals(updateType) && StringUtils.isNotEmpty((CharSequence)msgBody)) {
                try {
                    DeclareMQMessage declareMQMessage = (DeclareMQMessage)SerializationUtils.fromJsonString((String)msgBody, DeclareMQMessage.class);
                    String topic = declareMQMessage.getTopic();
                    String event = declareMQMessage.getEvent();
                    if ("AUDIT".equalsIgnoreCase(topic) || "AUDIT".equalsIgnoreCase(event)) {
                        bean.setBillStatus("C");
                    } else if ("UNAUDIT".equalsIgnoreCase(topic) || "UNAUDIT".equalsIgnoreCase(event)) {
                        bean.setBillStatus(SUBMIT);
                    }
                }
                catch (Exception declareMQMessage) {
                    // empty catch block
                }
            }
            if (SUBMIT.equals(bean.getBillStatus())) {
                if ("ccxws".equals(bean.getType()) || "qtsf_tysbb".equals(bean.getType()) || "qtsf_fsstysbb".equals(bean.getType())) {
                    QFilter deleteQFilter = new QFilter("formno", "=", (Object)String.valueOf(bean.getBillno()));
                    TsjsbWriteBackServiceImpl.deleteTjsjbData(deleteQFilter.toArray());
                } else {
                    TsjsbWriteBackServiceImpl.deleteOldTjsjbData(bean.getId(), bean.getType(), Long.parseLong(bean.getTaxtype()), bean.getBusinesssource());
                }
                return;
            }
            if (!"C".equals(bean.getBillStatus())) break block23;
            if ("ccxws".equals(bean.getType())) {
                qfilter = new QFilter(SBBID, "=", (Object)String.valueOf(bean.getId()));
                DynamicObjectCollection dyos = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"id,startdate,enddate,ybse,taxtype,sm", (QFilter[])qfilter.toArray());
                for (DynamicObject dyo : dyos) {
                    Long id = dyo.getLong("id");
                    Date skssqq = dyo.getDate("startdate");
                    Date skssqz = dyo.getDate("enddate");
                    BigDecimal ybse = dyo.getBigDecimal("ybse");
                    Long taxTypeId = TctsaSysTaxTypeEnum.getTaxTypeId((String)dyo.getString("taxtype"));
                    if (taxTypeId == null) continue;
                    TsjsbWriteBackServiceImpl.handlerSpecialWriteBack(id, skssqq, skssqz, bean.getType(), taxTypeId, bean, ybse, updateType, "");
                }
            } else if ("qtsf_tysbb".equals(bean.getType()) || "qtsf_fsstysbb".equals(bean.getType())) {
                qfilter = new QFilter(SBBID, "=", (Object)bean.getId());
                DynamicObjectCollection dCollection = QueryServiceHelper.query((String)"totf_sjfzsf_dtb", (String)"id,startdate,enddate,ybse,zspm", (QFilter[])new QFilter[]{qfilter});
                for (DynamicObject dyObject : dCollection) {
                    Long id = dyObject.getLong("id");
                    Date skssqq = dyObject.getDate("startdate");
                    Date skssqz = dyObject.getDate("enddate");
                    BigDecimal ybse = dyObject.getBigDecimal("ybse");
                    Long taxtypeId = TysbDeclareEnum.getTaxType((String)dyObject.getString("zspm"));
                    TsjsbWriteBackServiceImpl.handlerSpecialWriteBack(id, skssqq, skssqz, bean.getType(), taxtypeId, bean, ybse, updateType, dyObject.getString("zspm"));
                }
            } else {
                if (!TsjsbWriteBackServiceImpl.checkBean(bean)) {
                    return;
                }
                TsjsbWriteBackServiceImpl.deleteOldTjsjbData(bean.getId(), bean.getType(), Long.parseLong(bean.getTaxtype()), bean.getBusinesssource());
                Map<String, List<DynamicObject>> tjsjbConfigMap = TsjsbWriteBackServiceImpl.queryTjsjbConfigMapByNotNullFeild(bean.getSkssqq(), bean.getSkssqz(), bean.getType(), Long.parseLong(bean.getTaxtype()), "0", null);
                if (MapUtils.isEmpty(tjsjbConfigMap)) {
                    return;
                }
                for (Map.Entry<String, List<DynamicObject>> entry : tjsjbConfigMap.entrySet()) {
                    DynamicObject saveDyo = TsjsbWriteBackServiceImpl.genAndSetTjsjbCommonField(bean.getOrg(), bean.getSkssqq(), bean.getSkssqz(), bean.getDatatype(), bean.getBusinesssource(), bean.getType(), Long.parseLong(bean.getTaxtype()), String.valueOf(bean.getId()), bean.getMetaDataid(), false);
                    TsjsbWriteBackServiceImpl.setTaxOffice(bean.getSerialno(), bean.getOrg(), bean.getType(), bean.getId(), false, saveDyo);
                    String sm = "";
                    if ("zzsyjskb".equals(bean.getType())) {
                        saveDyo.set("formno", (Object)String.valueOf(bean.getSerialno()));
                    } else {
                        saveDyo.set("formno", (Object)String.valueOf(bean.getBillno()));
                    }
                    for (DynamicObject config : entry.getValue()) {
                        ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>(256);
                        String accessfield = config.getString("accessfield");
                        DynamicObjectCollection collection = TsjsbWriteBackServiceImpl.executeConfig(config, bean.getId(), bean.getSkssqq(), bean.getSkssqz(), bean.getType(), bean.getTaxtype(), bean.getId());
                        for (DynamicObject dynamic : collection) {
                            vals.add(dynamic.getBigDecimal(0));
                            if ("ccxws".equals(bean.getType())) {
                                sm = dynamic.getString("sm");
                                continue;
                            }
                            if (!"yhs".equals(bean.getType())) continue;
                            sm = dynamic.getString("ewblname");
                        }
                        saveDyo.set(accessfield, (Object)vals.stream().reduce(BigDecimal.ZERO, BigDecimal::add));
                        saveDyo.set("taxitemname", (Object)sm);
                    }
                    TsjsbWriteBackServiceImpl.setPayRecordInfo(bean, saveDyo);
                    TsjsbWriteBackServiceImpl.calSflRatio(saveDyo);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
                }
            }
        }
    }

    private static boolean checkBean(TsjsbWriteBackBean bean) {
        if (StringUtil.isEmpty((CharSequence)bean.getTaxtype())) {
            return false;
        }
        if (StringUtil.isNotEmpty((CharSequence)bean.getType()) && TYPE_LIST.contains(bean.getType()) && DateUtils.stringToDate2((String)"2019-04-01").compareTo(bean.getSkssqq()) > 0) {
            return false;
        }
        if (StringUtil.isNotEmpty((CharSequence)bean.getType()) && "zzsyjskb".equals(bean.getType())) {
            return DateUtils.stringToDate2((String)"2019-04-01").compareTo(bean.getSkssqq()) <= 0;
        }
        return true;
    }

    private static void handleJtWriteBackBean(String updateType, TjsjjtzjbWriteBackBean bean) {
        if (NOT_BACKEND_UPDATE.equals(updateType) || SUBMIT.equals(bean.getBillStatus())) {
            QFilter deleteFilter = new QFilter(SBBID, "=", (Object)String.valueOf(bean.getId())).and("taxtype", "=", (Object)bean.getTaxtype()).and("taxareagroup", "=", (Object)(bean.getTaxationsys() == 1L ? Long.valueOf(1708040530098667520L) : bean.getTaxareagroup()));
            DeleteServiceHelper.delete((String)"tctsa_provision_tjsjb", (QFilter[])deleteFilter.toArray());
        }
        if ("C".equals(bean.getBillStatus())) {
            if (EmptyCheckUtils.isEmpty((Object)bean.getTaxtype())) {
                return;
            }
            Map<String, List<DynamicObject>> tjsjbConfigMap = TsjsbWriteBackServiceImpl.queryTjsjbConfigMapByNotNullFeild(bean.getSkssqq(), bean.getSkssqz(), null, bean.getTaxtype(), bean.getBusinesssource(), null);
            if (MapUtils.isEmpty(tjsjbConfigMap)) {
                return;
            }
            for (Map.Entry<String, List<DynamicObject>> entry : tjsjbConfigMap.entrySet()) {
                DynamicObject saveDyo = BusinessDataServiceHelper.newDynamicObject((String)"tctsa_provision_tjsjb");
                saveDyo.set("org", (Object)bean.getOrg());
                saveDyo.set("hsorg", (Object)bean.getHsorg());
                saveDyo.set("skssqq", (Object)bean.getSkssqq());
                saveDyo.set("skssqz", (Object)bean.getSkssqz());
                if ("tpo_declare_main_tsd".equalsIgnoreCase(bean.getMetadataid())) {
                    if ("3".equals(bean.getBusinesssource())) {
                        bean.setMetadataid("itp_proviston_taxes");
                    } else {
                        String metaDataId = 1L != bean.getTaxationsys() ? "gtcp_normal_jt_list" : TjsjjtMetadataidEnum.getMetaDataidByType((String)String.valueOf(bean.getTaxtype()));
                        bean.setMetadataid(metaDataId);
                    }
                }
                saveDyo.set("metadataid", (Object)bean.getMetadataid());
                saveDyo.set("taxationsys", (Object)bean.getTaxationsys());
                saveDyo.set("taxtype", (Object)bean.getTaxtype());
                saveDyo.set("taxareagroup", (Object)(bean.getTaxationsys() == 1L ? Long.valueOf(1708040530098667520L) : bean.getTaxareagroup()));
                saveDyo.set("provisionmatter", (Object)bean.getProvisionmatter());
                saveDyo.set("currency", (Object)bean.getCurrency());
                saveDyo.set("sjtotal", (Object)bean.getSjtotal());
                saveDyo.set("booktype", (Object)bean.getBooktype());
                saveDyo.set(SBBID, (Object)String.valueOf(bean.getId()));
                QFilter idQ = new QFilter("id", "=", (Object)bean.getId());
                DynamicObjectCollection reloads = QueryServiceHelper.query((String)"itp_proviston_taxes", (String)"id,taxesentryentity.taxitem as taxitem,taxesentryentity.bizdimensiontype as bizdimensiontype,taxesentryentity.bizdimensionname as bizdimensionname,taxesentryentity.jtsj as jtsj", (QFilter[])idQ.toArray());
                DynamicObjectCollection entity0Collection = saveDyo.getDynamicObjectCollection("entryentity");
                if (reloads != null && reloads.size() > 0) {
                    for (DynamicObject object : reloads) {
                        DynamicObject dynamic = entity0Collection.addNew();
                        dynamic.set("sm", (Object)object.getString("taxitem"));
                        dynamic.set("bizdimensiontype", (Object)object.getString("bizdimensiontype"));
                        dynamic.set("bizdimensionname", (Object)object.getString("bizdimensionname"));
                        dynamic.set("jtsj", (Object)object.getBigDecimal("jtsj"));
                    }
                }
                for (DynamicObject config : entry.getValue()) {
                    Map<Object, Object> sjhjMap = new HashMap(16);
                    String accessField = config.getString("accessfield");
                    String datasourcejsonTag = config.getString("datasourcejson_tag");
                    List list = TctsaUtils.parseJson((String)datasourcejsonTag);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        String datasourcejson = (String)((Map)list.get(0)).get("datasoucejson");
                        List mapList = TctsaUtils.parseJson((String)datasourcejson);
                        for (Map map : mapList) {
                            if (null == map || EmptyCheckUtils.isEmpty(map.get("tableid"))) continue;
                            TjsjbFetchSqlService factory = TjsjbFetchSqlServiceFactory.factory(true, (String)map.get("entityname"));
                            HashMap<String, Object> customFilterMap = new HashMap<String, Object>(16);
                            customFilterMap.put("id", bean.getId());
                            sjhjMap = factory.queryElementReturnMap(bean.getOrg(), bean.getSkssqq(), bean.getSkssqz(), null, bean.getTaxtype(), bean.getBusinesssource(), customFilterMap);
                        }
                    }
                    saveDyo.set(accessField, sjhjMap.get(accessField));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
            }
        }
    }

    private static void handleHwsWriteBackBean(String updateType, TjsjhwsWriteBackBean bean) {
        if (NOT_BACKEND_UPDATE.equals(updateType) || SUBMIT.equals(bean.getBillStatus())) {
            TsjsbWriteBackServiceImpl.deleteOldTjsjbData(bean.getId(), bean.getType(), bean.getTaxtype(), bean.getBusinesssource());
        }
        if ("C".equals(bean.getBillStatus())) {
            ArrayList<TjsjhwsWriteBackBean> list = new ArrayList<TjsjhwsWriteBackBean>(16);
            boolean isUsaUat = false;
            if (NOT_BACKEND_UPDATE.equals(updateType) && 1641488655174373376L == bean.getTaxtype() && !"1000".equals(bean.getDatatype())) {
                isUsaUat = true;
                QFilter draftIdFilter = new QFilter("draftid", "=", (Object)bean.getId());
                DynamicObjectCollection taxareaDynamicObjects = QueryServiceHelper.query((String)"gtcp_draft_tab", (String)"id,draftid,tab,taxareagroup", (QFilter[])new QFilter[]{draftIdFilter});
                List<Long> taxAreaGroupList = taxareaDynamicObjects.stream().map(s -> s.getLong("taxareagroup")).collect(Collectors.toList());
                taxAreaGroupList.forEach(s -> list.add(new TjsjhwsWriteBackBean(bean.getBillno(), bean.getOrg(), bean.getTaxationsys(), bean.getTaxtype(), s, bean.getSkssqq(), bean.getSkssqz(), bean.getBusinesssource(), bean.getType(), bean.getId(), bean.getBillStatus(), bean.getDatatype())));
            }
            if (!isUsaUat) {
                list.add(bean);
            }
            list.forEach(hwsBean -> TsjsbWriteBackServiceImpl.saveDataByHws(hwsBean, updateType));
        }
    }

    private static void handleTaxReportWriteBackBean(String updateType, TsjsbTaxReportWriteBackBean bean) {
        if (NOT_BACKEND_UPDATE.equals(updateType) || SUBMIT.equals(bean.getBillStatus())) {
            QFilter deleteFilter = new QFilter(SBBID, "=", (Object)String.valueOf(bean.getId())).and("businesssource", "=", (Object)bean.getBusinesssource());
            TsjsbWriteBackServiceImpl.deleteTjsjbData(deleteFilter.toArray());
        }
        if ("C".equals(bean.getBillStatus())) {
            if (StringUtil.isEmpty((CharSequence)bean.getTaxtype())) {
                return;
            }
            Map<String, List<DynamicObject>> tjsjbConfigMap = TsjsbWriteBackServiceImpl.queryTjsjbConfigMapByNotNullFeild(bean.getSkssqq(), bean.getSkssqz(), null, Long.parseLong(bean.getTaxtype()), bean.getBusinesssource(), null);
            if (MapUtils.isEmpty(tjsjbConfigMap)) {
                return;
            }
            for (Map.Entry<String, List<DynamicObject>> entry : tjsjbConfigMap.entrySet()) {
                boolean ishasData = false;
                DynamicObject saveDyo = TsjsbWriteBackServiceImpl.genAndSetTjsjbCommonField(bean.getOrg(), bean.getSkssqq(), bean.getSkssqz(), bean.getDatatype(), bean.getBusinesssource(), null, Long.parseLong(bean.getTaxtype()), String.valueOf(bean.getId()), null, false);
                TsjsbWriteBackServiceImpl.setTaxOffice(null, bean.getOrg(), null, bean.getId(), false, saveDyo);
                for (DynamicObject dynamicObject : entry.getValue()) {
                    ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>(256);
                    String accessField = dynamicObject.getString("accessfield");
                    DynamicObjectCollection resultDyos = TsjsbWriteBackServiceImpl.executeConfig(dynamicObject, bean.getOrg(), bean.getSkssqq(), bean.getSkssqz(), null, bean.getTaxtype(), bean.getId());
                    if (resultDyos != null && resultDyos.size() > 0) {
                        for (DynamicObject dynamic : resultDyos) {
                            vals.add(dynamic.getBigDecimal(0));
                        }
                        ishasData = true;
                    }
                    saveDyo.set(accessField, (Object)vals.stream().reduce(BigDecimal.ZERO, BigDecimal::add));
                }
                if (!ishasData) continue;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
            }
        }
    }

    private static void deleteHisWhenBatchUpdate(String updateType, List<Long> taxTypes, String dataHandleType) {
        if (!"2".equals(updateType)) {
            return;
        }
        if ("3".equals(dataHandleType)) {
            DeleteServiceHelper.delete((String)"tctsa_provision_tjsjb", (QFilter[])new QFilter[0]);
            return;
        }
        QFilter qFilter = "2".equals(dataHandleType) ? new QFilter("businesssource", "=", (Object)NOT_BACKEND_UPDATE) : new QFilter("taxtype", "in", taxTypes).and("levytype", "!=", (Object)"dkdj");
        TsjsbWriteBackServiceImpl.deleteTjsjbData(new QFilter[]{qFilter});
    }

    private static void saveDataByHws(TjsjhwsWriteBackBean bean, String updateType) {
        if (EmptyCheckUtils.isEmpty((Object)bean.getTaxtype())) {
            return;
        }
        Long taxareagroup = 1641488655174373376L == bean.getTaxtype() ? bean.getTaxareagroup() : null;
        Map<String, List<DynamicObject>> tjsjbConfigMap = TsjsbWriteBackServiceImpl.queryTjsjbConfigMapByNotNullFeild(bean.getSkssqq(), bean.getSkssqz(), null, bean.getTaxtype(), bean.getBusinesssource(), taxareagroup);
        if (MapUtils.isEmpty(tjsjbConfigMap)) {
            return;
        }
        if (NOT_BACKEND_UPDATE.equals(updateType)) {
            QFilter[] qFilterArray;
            QFilter sbbidFilter = new QFilter(SBBID, "=", (Object)String.valueOf(bean.getId()));
            QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)(bean.getTaxareagroup() == 1681071243350195200L ? Long.valueOf(1682650334692126720L) : bean.getTaxtype()));
            QFilter taxAreaFilter = new QFilter("taxareagroup", "=", (Object)bean.getTaxareagroup());
            if (1641488655174373376L == bean.getTaxtype()) {
                QFilter[] qFilterArray2 = new QFilter[3];
                qFilterArray2[0] = sbbidFilter;
                qFilterArray2[1] = taxTypeFilter;
                qFilterArray = qFilterArray2;
                qFilterArray2[2] = taxAreaFilter;
            } else {
                QFilter[] qFilterArray3 = new QFilter[2];
                qFilterArray3[0] = sbbidFilter;
                qFilterArray = qFilterArray3;
                qFilterArray3[1] = taxTypeFilter;
            }
            TsjsbWriteBackServiceImpl.deleteTjsjbData(qFilterArray);
        }
        for (Map.Entry<String, List<DynamicObject>> entry : tjsjbConfigMap.entrySet()) {
            QFilter[] qFilterArray;
            String type = bean.getType() != null ? bean.getType() : String.valueOf(entry.getValue().get(0).get("type"));
            Long taxType = bean.getTaxareagroup() == 1681071243350195200L ? Long.valueOf(1682650334692126720L) : bean.getTaxtype();
            String metadataid = "1000".equals(bean.getDatatype()) ? "gtcp_taxpay_refund_bill" : "gtcp_normal_draft_list";
            DynamicObject saveDyo = TsjsbWriteBackServiceImpl.genAndSetTjsjbCommonField(bean.getOrg(), bean.getSkssqq(), bean.getSkssqz(), bean.getDatatype(), bean.getBusinesssource(), type, taxType, String.valueOf(bean.getId()), metadataid, true);
            QFilter draftidFilter = new QFilter("draftid", "=", (Object)bean.getId());
            QFilter statusFilter = new QFilter("payrefstatus", "in", Arrays.asList("pay", "refund"));
            QFilter taxAreaGroupFilter = new QFilter("taxareagroup", "=", (Object)bean.getTaxareagroup());
            QFilter taxtypeFilter = new QFilter("taxcategory", "in", bean.getTaxationsys() == 1641474108371800064L ? DEG_LIST : RIBEN_LIST);
            QFilter sgIdFilter = new QFilter("id", "=", (Object)bean.getId());
            if ("1000".equals(bean.getDatatype())) {
                QFilter[] qFilterArray4 = new QFilter[2];
                qFilterArray4[0] = sgIdFilter;
                qFilterArray = qFilterArray4;
                qFilterArray4[1] = statusFilter;
            } else if (bean.getTaxationsys() == 1641474108371800064L || bean.getTaxationsys() == 1639891185130547200L) {
                QFilter[] qFilterArray5 = new QFilter[4];
                qFilterArray5[0] = draftidFilter;
                qFilterArray5[1] = taxAreaGroupFilter;
                qFilterArray5[2] = statusFilter;
                qFilterArray = qFilterArray5;
                qFilterArray5[3] = taxtypeFilter;
            } else {
                QFilter[] qFilterArray6 = new QFilter[3];
                qFilterArray6[0] = draftidFilter;
                qFilterArray6[1] = taxAreaGroupFilter;
                qFilterArray = qFilterArray6;
                qFilterArray6[2] = statusFilter;
            }
            DynamicObject payDynamic = QueryServiceHelper.queryOne((String)"gtcp_taxpay_refund_bill", (String)"id,amount,payrefunddate,taxestype", (QFilter[])qFilterArray);
            BigDecimal sjsj = BigDecimal.ZERO;
            Date jkdate = null;
            if (payDynamic != null) {
                sjsj = "pay".equals(payDynamic.getString("taxestype")) ? payDynamic.getBigDecimal("amount") : (EmptyCheckUtils.isNotEmpty((Object)payDynamic.getBigDecimal("amount")) ? payDynamic.getBigDecimal("amount").negate() : null);
                jkdate = payDynamic.getDate("payrefunddate");
            }
            DynamicObjectCollection entityCollection = saveDyo.getDynamicObjectCollection("entryentity");
            DynamicObject entity = entityCollection.addNew();
            entity.set("djtsjsj", (Object)sjsj);
            entity.set("djtjkdate", (Object)jkdate);
            saveDyo.set("sjsj", (Object)sjsj);
            saveDyo.set("jkdate", (Object)jkdate);
            saveDyo.set("taxareagroup", (Object)bean.getTaxareagroup());
            saveDyo.set("taxationsys", (Object)bean.getTaxationsys());
            TsjsbWriteBackServiceImpl.setTaxOffice(null, bean.getOrg(), bean.getType(), bean.getId(), true, saveDyo);
            saveDyo.set("formno", (Object)String.valueOf(bean.getBillno()));
            for (DynamicObject dynamicObject : entry.getValue()) {
                String accessfield = dynamicObject.getString("accessfield");
                TjsjbFetchSqlService factory = TjsjbFetchSqlServiceFactory.factory(true, "tpo_declare_main_tsd");
                HashMap<String, Object> customFilterMap = new HashMap<String, Object>(16);
                customFilterMap.put("taxareagroup", bean.getTaxareagroup());
                Map<String, BigDecimal> sjjeMap = factory.queryElementReturnMap(bean.getOrg(), bean.getSkssqq(), bean.getSkssqz(), null, bean.getTaxtype(), bean.getBusinesssource(), customFilterMap);
                saveDyo.set(accessfield, (Object)sjjeMap.get(accessfield));
            }
            TsjsbWriteBackServiceImpl.calSflRatio(saveDyo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
        }
    }

    private static Map<String, List<DynamicObject>> queryTjsjbConfigMapByNotNullFeild(Date skssqq, Date skssqz, String type, Long taxtypeId, String businessSource, Long taxAreaGroup) {
        DynamicObjectCollection configs;
        Map<String, List<DynamicObject>> numberGroups;
        QFilter qFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        if (skssqq != null) {
            qFilter = new QFilter("effectdate", "<=", (Object)skssqq);
            filters.add(qFilter);
        }
        if (skssqz != null) {
            qFilter = new QFilter("invaliddate", ">=", (Object)skssqz);
            filters.add(qFilter);
        }
        if (type != null) {
            qFilter = new QFilter("type", "=", (Object)type);
            filters.add(qFilter);
        }
        if (taxtypeId != null) {
            qFilter = new QFilter("group", "=", (Object)taxtypeId);
            filters.add(qFilter);
        }
        if (businessSource != null) {
            QFilter filter = new QFilter("businesssource", "=", (Object)businessSource);
            filters.add(filter);
        }
        if (taxAreaGroup != null && taxAreaGroup != 0L) {
            qFilter = new QFilter("taxareagroup", "=", (Object)taxAreaGroup);
            filters.add(qFilter);
        }
        if (MapUtils.isEmpty(numberGroups = (configs = QueryServiceHelper.query((String)TCTSA_TJSJB_RULE_CONFIG, (String)TCTSA_TJSJB_RULE_CONFIG_FIELD, (QFilter[])filters.toArray(new QFilter[0]))).stream().collect(Collectors.groupingBy(s -> s.getString("number"))))) {
            logger.info("\u672a\u67e5\u8be2\u5230\u7edf\u8ba1\u7a0e\u91d1\u8868\u53d6\u6570\u914d\u7f6e\uff0cskssqq:{},skssqz:{},type:{},taxtypeId:{},businessSource:{},taxAreaGroup:{}", new Object[]{skssqq, skssqz, type, taxtypeId, businessSource, taxAreaGroup});
        } else if (numberGroups.size() > 1) {
            logger.info("\u67e5\u8be2\u5230\u7edf\u8ba1\u7a0e\u91d1\u8868\u53d6\u6570\u914d\u7f6e\u4e0d\u552f\u4e00\uff0cskssqq:{},skssqz:{},type:{},taxtypeId:{},businessSource:{},taxAreaGroup:{}", new Object[]{skssqq, skssqz, type, taxtypeId, businessSource, taxAreaGroup});
        }
        return numberGroups;
    }

    private static void handlerSpecialWriteBack(Long id, Date skssqq, Date skssqz, String type, Long taxtypeId, TsjsbWriteBackBean bean, BigDecimal ybse, String updateType, String zspm) {
        Map<String, List<DynamicObject>> configMap = TsjsbWriteBackServiceImpl.queryTjsjbConfigMapByNotNullFeild(skssqq, skssqz, type, taxtypeId, "0", null);
        if (MapUtils.isEmpty(configMap)) {
            return;
        }
        if (NOT_BACKEND_UPDATE.equals(updateType)) {
            QFilter deleteFilter = new QFilter(SBBID, "=", (Object)String.valueOf(id)).and("taxtype", "=", (Object)taxtypeId).and("type", "=", (Object)bean.getType());
            TsjsbWriteBackServiceImpl.deleteTjsjbData(deleteFilter.toArray());
        }
        for (Map.Entry<String, List<DynamicObject>> entry : configMap.entrySet()) {
            String sbbid = String.valueOf(id);
            String metadataid = "ccxws".equals(type) ? TjsjbMetadataidEnum.getMetaDataidByType((String)String.valueOf(taxtypeId), (String)"ccxws") : TjsjbMetadataidEnum.getMetaDataidByType((String)String.valueOf(taxtypeId), (String)"");
            DynamicObject saveDyo = TsjsbWriteBackServiceImpl.genAndSetTjsjbCommonField(bean.getOrg(), skssqq, skssqz, bean.getDatatype(), bean.getBusinesssource(), bean.getType(), taxtypeId, sbbid, metadataid, false);
            TsjsbWriteBackServiceImpl.setTaxOffice(bean.getSerialno(), bean.getOrg(), bean.getType(), bean.getId(), false, saveDyo);
            String sm = "";
            saveDyo.set("formno", (Object)bean.getBillno());
            for (DynamicObject config : entry.getValue()) {
                ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>(256);
                String accessfield = config.getString("accessfield");
                DynamicObjectCollection result = TsjsbWriteBackServiceImpl.executeConfig(config, bean.getOrg(), skssqq, skssqz, bean.getType(), String.valueOf(taxtypeId), id);
                for (DynamicObject dynamic : result) {
                    vals.add(dynamic.getBigDecimal(0));
                    if ("ccxws".equals(bean.getType())) {
                        sm = dynamic.getString("sm");
                        continue;
                    }
                    if ("yhs".equals(bean.getType())) {
                        sm = dynamic.getString("ewblname");
                        continue;
                    }
                    if (!"qtsf_tysbb".equals(bean.getType()) && !"qtsf_fsstysbb".equals(bean.getType())) continue;
                    sm = zspm;
                }
                saveDyo.set(accessfield, (Object)vals.stream().reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            saveDyo.set("taxitemname", (Object)sm);
            QFilter sbbidFilter = new QFilter(SBBID, "=", (Object)String.valueOf(bean.getId()));
            QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
            QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
            String smFilterValue = StringUtils.isNotEmpty((CharSequence)zspm) ? TysbDeclareEnum.gettaxitemIdByzspm((String)zspm) : sm;
            QFilter smFilter = new QFilter("entryentity.taxitem", "=", (Object)smFilterValue);
            DynamicObjectCollection payCollection = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"sbbid ,entryentity.sjjemx as sjjemx ,entryentity.yjjemx as yjjemx ,paydate ,id", (QFilter[])new QFilter[]{sbbidFilter, skssqqFilter, skssqzFilter, smFilter});
            DynamicObjectCollection entityCollection = saveDyo.getDynamicObjectCollection("entryentity");
            BigDecimal sjjsTotal = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)payCollection)) {
                Date paydate;
                BigDecimal sjjemx;
                if ("ccxws".equals(bean.getType())) {
                    for (DynamicObject payDyo : payCollection) {
                        BigDecimal yjjemx = payDyo.getBigDecimal("yjjemx");
                        if (!EmptyCheckUtils.isNotEmpty((Object)yjjemx) || yjjemx.compareTo(ybse) != 0) continue;
                        DynamicObject dynamic = entityCollection.addNew();
                        sjjemx = payDyo.getBigDecimal("sjjemx");
                        paydate = payDyo.getDate("paydate");
                        dynamic.set("djtsjsj", (Object)sjjemx);
                        dynamic.set("djtjkdate", (Object)paydate);
                        sjjsTotal = BigDecimalUtil.addObject((Object)sjjsTotal, (Object)sjjemx).setScale(2, RoundingMode.HALF_UP);
                        break;
                    }
                } else {
                    sjjemx = payCollection.size() == 1 ? ((DynamicObject)payCollection.get(0)).getBigDecimal("sjjemx") : BigDecimal.ZERO;
                    paydate = payCollection.size() == 1 ? ((DynamicObject)payCollection.get(0)).getDate("paydate") : null;
                    sjjsTotal = BigDecimalUtil.addObject((Object)sjjsTotal, (Object)sjjemx).setScale(2, RoundingMode.HALF_UP);
                    DynamicObject dynamic = entityCollection.addNew();
                    dynamic.set("djtsjsj", (Object)sjjemx);
                    dynamic.set("djtjkdate", (Object)paydate);
                }
            }
            saveDyo.set("sjsj", (Object)sjjsTotal);
            saveDyo.set("jkdate", null);
            TsjsbWriteBackServiceImpl.calSflRatio(saveDyo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
        }
    }

    private static DynamicObject genAndSetTjsjbCommonField(Long orgId, Date skssqq, Date skssqz, String datatype, String businesssource, String type, Long taxtype, String sbbid, String metadataid, boolean isOverseas) {
        DynamicObject tjsjbRecord = BusinessDataServiceHelper.newDynamicObject((String)"tctb_tjsjb");
        tjsjbRecord.set("org", (Object)orgId);
        tjsjbRecord.set("hsorg", (Object)orgId);
        tjsjbRecord.set("skssqq", (Object)skssqq);
        tjsjbRecord.set("skssqz", (Object)skssqz);
        tjsjbRecord.set("datatype", (Object)datatype);
        tjsjbRecord.set("businesssource", (Object)businesssource);
        tjsjbRecord.set("type", (Object)type);
        tjsjbRecord.set("taxtype", (Object)taxtype);
        tjsjbRecord.set(SBBID, (Object)sbbid);
        tjsjbRecord.set("metadataid", (Object)metadataid);
        tjsjbRecord.set("levytype", (Object)"zxsb");
        tjsjbRecord.set("levytype", (Object)"zxsb");
        if (!isOverseas) {
            tjsjbRecord.set("taxareagroup", (Object)1708040530098667520L);
            tjsjbRecord.set("taxationsys", (Object)1L);
        }
        return tjsjbRecord;
    }

    private static void calSflRatio(DynamicObject tjsjbDyo) {
        tjsjbDyo.set("fsl", (Object)(BigDecimal.ZERO.compareTo(tjsjbDyo.getBigDecimal("yssr")) != 0 ? BigDecimalUtil.divideObject((Object)tjsjbDyo.getBigDecimal("ynse"), (Object)tjsjbDyo.getBigDecimal("yssr"), (int)4) : BigDecimal.ZERO));
    }

    private static DynamicObjectCollection executeConfig(DynamicObject config, Long orgId, Date skssqq, Date skssqz, String type, String taxtype, Long id) {
        DynamicObjectCollection resultList = new DynamicObjectCollection();
        String datasourceJsonTag = config.getString("datasourcejson_tag");
        List list = TctsaUtils.parseJson((String)datasourceJsonTag);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resultList;
        }
        String datasourcejson = (String)((Map)list.get(0)).get("datasoucejson");
        List mapList = TctsaUtils.parseJson((String)datasourcejson);
        for (Map map : mapList) {
            if (null == map || EmptyCheckUtils.isEmpty(map.get("tableid"))) continue;
            String tableId = (String)map.get("tableid");
            QFilter tableFilter = new QFilter("id", "=", (Object)Long.parseLong(tableId));
            DynamicObjectCollection datasourceCollection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,type,subname as zbsubname,ischild,entryentity.id,entryentity.fieldsubname,entryentity.fieldname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate", (QFilter[])tableFilter.toArray());
            ArrayList<DynamicObject> fields = new ArrayList<DynamicObject>(8);
            DynamicObject orgstate = null;
            DynamicObject datestate = null;
            DynamicObject yearstate = null;
            DynamicObject monthstate = null;
            for (DynamicObject d : datasourceCollection) {
                String[] fieldIdArr;
                for (String field : fieldIdArr = ((String)map.get("fieldid")).split(",")) {
                    if (!d.getString("entryentity.id").equals(field)) continue;
                    fields.add(d);
                }
                if ("true".equals(d.getString("entryentity.orgstate"))) {
                    orgstate = d;
                }
                if ("true".equals(d.getString("entryentity.datastate"))) {
                    datestate = d;
                }
                if ("true".equals(d.getString("entryentity.yearstate"))) {
                    yearstate = d;
                }
                if (!"true".equals(d.getString("entryentity.monthstate"))) continue;
                monthstate = d;
            }
            if (fields.size() <= 0) continue;
            boolean ischild = ((DynamicObject)fields.get(0)).getBoolean("ischild");
            String name = ((DynamicObject)fields.get(0)).getString("name");
            String subname = ((DynamicObject)fields.get(0)).getString("zbsubname");
            String tabletype = ((DynamicObject)fields.get(0)).getString("type");
            if (EmptyCheckUtils.isEmpty((Object)orgstate)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u653f\u7b56\u8fd0\u7ef4 \u53d6\u6570\u8868\u914d\u7f6e\u51fa\u9519\u3002 \u5b9e\u4f53\u540d\u79f0\u4e3a%1$s,\u5b57\u8868\u540d\u79f0\u4e3a %2$s \u7ec4\u7ec7\u5b57\u6bb5\u4e3a\u7a7a", (String)"TsjsbWriteBackServiceImpl_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), name, subname));
            }
            TjsjbFetchSqlService factory = TjsjbFetchSqlServiceFactory.factory(ischild, name);
            List<String> selectFieldList = factory.findSelectFieldList(ischild, fields, name, subname, map);
            if ("ccxws".equals(type)) {
                selectFieldList.add("sm");
            } else if ("yhs".equals(type)) {
                selectFieldList.add("ewblname");
            }
            selectFieldList = selectFieldList.stream().distinct().collect(Collectors.toList());
            String selectFields = String.join((CharSequence)",", selectFieldList);
            DynamicObjectCollection collection = factory.queryElement(orgId, map, orgstate, datestate, name, subname, selectFields, tabletype, yearstate, monthstate, skssqq, skssqz, taxtype, id);
            resultList.addAll((Collection)collection);
        }
        return resultList;
    }

    private static void setTaxOffice(String serialno, Long orgId, String type, Long sbbid, boolean isOverseas, DynamicObject tjsjbRecord) {
        TaxResult taxResult;
        List taxResultList;
        long taxofficeid = 0L;
        if (ZZSTYPE_LIST.contains(type) && "zzsyjskb".equals(type)) {
            DynamicObject infoDynamic1;
            DynamicObject accountDynamic1 = QueryServiceHelper.queryOne((String)"tcvat_project_account", (String)"declareserialno,projectid", (QFilter[])new QFilter[]{new QFilter("declareserialno", "=", (Object)String.valueOf(serialno))});
            if (EmptyCheckUtils.isNotEmpty((Object)accountDynamic1) && !ObjectUtils.isEmpty((Object)(infoDynamic1 = QueryServiceHelper.queryOne((String)"tcvat_prepay_project_info", (String)"taxoffice.id as taxofficeid,id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountDynamic1.getLong("projectid"))})))) {
                taxofficeid = infoDynamic1.get("taxofficeid") == null ? 0L : infoDynamic1.getLong("taxofficeid");
            }
        } else if ("ccxws".equals(type) || "qtsf_tysbb".equals(type) || "qtsf_fsstysbb".equals(type)) {
            QFilter idFilter = new QFilter("id", "=", (Object)sbbid);
            DynamicObject nxxDynamic = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"taxauthority.id as taxofficeid", (QFilter[])new QFilter[]{idFilter});
            taxofficeid = EmptyCheckUtils.isNotEmpty((Object)nxxDynamic) ? nxxDynamic.getLong("taxofficeid") : 0L;
        } else if (!isOverseas && EmptyCheckUtils.isNotEmpty((Object)(taxResultList = (List)(taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsWithNoStatus(Collections.singletonList(orgId), (Long)TaxationsysMappingEnum.CHN.getId())).getData())) && taxResultList.size() > 0) {
            taxofficeid = ((DynamicObject)taxResultList.get(0)).getLong("taxoffice.id");
        }
        tjsjbRecord.set("taxoffice", (Object)taxofficeid);
    }

    private static void setPayRecordInfo(TsjsbWriteBackBean bean, DynamicObject tjsjbRecord) {
        QFilter[] qFilterArray;
        QFilter sbbidFilter = new QFilter(SBBID, "=", (Object)String.valueOf(bean.getId()));
        QFilter paystatusFilter = new QFilter("paystatus", "=", (Object)NOT_BACKEND_UPDATE);
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)PayRecordTaxTypeEnum.getTaxNameByType((String)bean.getTaxtype()));
        if (ZZSTYPE_LIST.contains(bean.getTaxtype())) {
            QFilter[] qFilterArray2 = new QFilter[3];
            qFilterArray2[0] = sbbidFilter;
            qFilterArray2[1] = taxTypeFilter;
            qFilterArray = qFilterArray2;
            qFilterArray2[2] = paystatusFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[2];
            qFilterArray3[0] = sbbidFilter;
            qFilterArray = qFilterArray3;
            qFilterArray3[1] = paystatusFilter;
        }
        QFilter[] qFilters = qFilterArray;
        DynamicObjectCollection payDynamic = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"billno,sbbid ,sjje ,paydate ,id", (QFilter[])qFilters);
        BigDecimal allTotal = BigDecimal.ZERO;
        DynamicObjectCollection entityCollection = tjsjbRecord.getDynamicObjectCollection("entryentity");
        if (payDynamic != null) {
            for (DynamicObject payDyo : payDynamic) {
                DynamicObject entity = entityCollection.addNew();
                entity.set("djtsjsj", (Object)payDyo.getBigDecimal("sjje"));
                entity.set("djtjkdate", (Object)payDyo.getDate("paydate"));
                allTotal = BigDecimalUtil.addObject((Object)allTotal, (Object)payDyo.getBigDecimal("sjje")).setScale(2, RoundingMode.HALF_UP);
            }
        }
        tjsjbRecord.set("sjsj", (Object)allTotal);
        tjsjbRecord.set("jkdate", null);
    }

    private static void deleteOldTjsjbData(Long sbbid, String type, Long taxtypeId, String businesssource) {
        QFilter sbbidQFilter = new QFilter(SBBID, "=", (Object)String.valueOf(sbbid));
        QFilter typeQFilter = new QFilter("type", "=", (Object)type);
        QFilter taxtypeQFilter = new QFilter("taxtype", "=", (Object)taxtypeId);
        QFilter businesssourceFilter = new QFilter("businesssource", "=", (Object)businesssource);
        TsjsbWriteBackServiceImpl.deleteTjsjbData(new QFilter[]{sbbidQFilter, taxtypeQFilter, typeQFilter, businesssourceFilter});
    }

    private static void deleteTjsjbData(QFilter[] qFilters) {
        DeleteServiceHelper.delete((String)"tctb_tjsjb", (QFilter[])qFilters);
    }
}

