/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.eventcenter.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.tctsa.common.entity.TjsjhwsWriteBackBean;
import kd.taxc.tctsa.common.entity.TjsjjtzjbWriteBackBean;
import kd.taxc.tctsa.common.entity.TsjsbTaxReportWriteBackBean;
import kd.taxc.tctsa.common.entity.TsjsbWriteBackBean;
import kd.taxc.tctsa.common.enums.TctsaTypeEnum;
import kd.taxc.tctsa.common.enums.TjsjbFetchEnum;
import kd.taxc.tctsa.common.enums.TjsjbMetadataidEnum;
import kd.taxc.tctsa.common.enums.TjsjjtMetadataidEnum;
import kd.taxc.tctsa.common.enums.ZzsUpdateEnum;
import kd.taxc.tctsa.formplugin.eventcenter.impl.TsjsbWriteBackServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TjsjbDataMigrationUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TjsjbDataMigrationUpgradeService.class);
    private static List<String> typeList = Arrays.asList("fjsf", "zzsxgmnsr", "zzsybnsr", "zzsybnsr_ybhz");

    public UpgradeResult beforeExecuteSqlWithResult(String taxTypeSelect, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle h = TX.requiresNew();){
            try {
                logger.info((Object)"\u5347\u7ea7\u5f00\u59cb\u6267\u884c");
                long start = System.currentTimeMillis();
                if ("6".equals(taxTypeSelect)) {
                    TjsjbDataMigrationUpgradeService.handleTaxReportWriteBack();
                } else if ("14".equals(taxTypeSelect)) {
                    TjsjbDataMigrationUpgradeService.handleJtWriteBack();
                } else if ("15".equals(taxTypeSelect)) {
                    TjsjbDataMigrationUpgradeService.handleHwsWriteBack();
                } else if ("tcnfep_2".equals(taxTypeSelect) || "tcnfep_3".equals(taxTypeSelect)) {
                    this.handleTcnfepWriteBack(taxTypeSelect);
                } else {
                    TjsjbDataMigrationUpgradeService.handleWriteBack(taxTypeSelect);
                }
                logger.info((Object)("\u5347\u7ea7\u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start)));
                result.setLog(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"TjsjbDataMigrationUpgradeService_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                result.setSuccess(true);
            }
            catch (Exception t) {
                String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)t);
                logger.error((Object)("\u6570\u636e\u53cd\u5199\u51fa\u73b0\u5f02\u5e38:" + exceptionStackTraceMessage));
                result.setLog(exceptionStackTraceMessage);
                result.setSuccess(false);
                h.markRollback();
                throw t;
            }
        }
        return result;
    }

    private void handleTcnfepWriteBack(String taxTypeSelect) {
        DynamicObjectCollection tcvatNsrxxList;
        QFilter mainFilter;
        List<Object> writeBackBeans = new ArrayList(8);
        if ("tcnfep_2".equals(taxTypeSelect)) {
            mainFilter = new QFilter("type", "in", Arrays.asList("dkdj", "kjqysds")).and("billstatus", "=", (Object)"C");
            tcvatNsrxxList = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,billstatus,skssqq,skssqz,org,datatype,billno,type", (QFilter[])mainFilter.toArray());
            writeBackBeans = tcvatNsrxxList.stream().map(dyo -> new TsjsbWriteBackBean(null, null, "0", dyo.getString("type"), Long.valueOf(dyo.getLong("org")), null, Long.valueOf(dyo.getLong("id")), null, null, null, null, "", null, "dkdj".equals(dyo.getString("type")) ? "tcnfep_dkdj_declare_main" : "tcnfep_kj_declare_main")).collect(Collectors.toList());
        } else {
            mainFilter = new QFilter("templatetype", "in", Arrays.asList("dkdj", "kjqysds")).and("billstatus", "=", (Object)"C");
            tcvatNsrxxList = QueryServiceHelper.query((String)"tpo_declare_main_tsc", (String)"id,billstatus,skssqq,skssqz,org,datatype,billno,templatetype", (QFilter[])mainFilter.toArray());
            writeBackBeans = tcvatNsrxxList.stream().map(dyo -> new TsjsbWriteBackBean(null, null, "0", dyo.getString("templatetype"), Long.valueOf(dyo.getLong("org")), null, Long.valueOf(dyo.getLong("id")), null, null, null, null, "", null, "dkdj".equals(dyo.getString("templatetype")) ? "tcnfep_dkdj_decl_main_new" : "tcnfep_kj_decl_main_new")).collect(Collectors.toList());
        }
        Map<String, List<TsjsbWriteBackBean>> groupBeans = writeBackBeans.stream().collect(Collectors.groupingBy(TsjsbWriteBackBean::getType));
        for (Map.Entry<String, List<TsjsbWriteBackBean>> entry : groupBeans.entrySet()) {
            TsjsbWriteBackServiceImpl.startWriteBack(entry.getValue(), "2", null, "1", null);
        }
    }

    private static void handleWriteBack(String taxTypeSelect) {
        QFilter statusFilter;
        QFilter typeFilter = new QFilter("type", "in", Arrays.asList(TjsjbFetchEnum.getDeclarationType((String)taxTypeSelect)));
        QFilter[] qfilters = new QFilter[]{typeFilter, statusFilter = new QFilter("billstatus", "=", (Object)"C")};
        DynamicObjectCollection tcvatNsrxxList = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,type,billstatus,skssqq,skssqz,org,datatype,billno,entryentity.taxtypes as taxtypes,serialno", (QFilter[])qfilters);
        if (CollectionUtils.isEmpty((Collection)tcvatNsrxxList)) {
            return;
        }
        ArrayList<TsjsbWriteBackBean> writeBackBeans = new ArrayList<TsjsbWriteBackBean>(16);
        for (DynamicObject dyo : tcvatNsrxxList) {
            if ("1".equals(taxTypeSelect)) {
                if (typeList.contains(dyo.getString("type")) && "2".equals(dyo.getString("taxtypes"))) {
                    TjsjbDataMigrationUpgradeService.setWriteBackBeans(dyo, writeBackBeans, taxTypeSelect, true, false);
                    continue;
                }
                writeBackBeans.add(new TsjsbWriteBackBean(dyo.getDate("skssqq"), dyo.getDate("skssqz"), "0", dyo.getString("type"), Long.valueOf(dyo.getLong("org")), ZzsUpdateEnum.getTaxTypeByCode((String)dyo.getString("taxtypes")), Long.valueOf(dyo.getLong("id")), dyo.getString("billstatus"), dyo.getString("datatype"), dyo.getString("billno"), BigDecimal.ZERO, "", dyo.getString("serialno"), TjsjbMetadataidEnum.getMetaDataidByType((String)ZzsUpdateEnum.getTaxTypeByCode((String)dyo.getString("taxtypes")), (String)dyo.getString("type"))));
                continue;
            }
            if ("2".equals(taxTypeSelect)) {
                TjsjbDataMigrationUpgradeService.setWriteBackBeans(dyo, writeBackBeans, "3", false, false);
                continue;
            }
            if ("3".equals(taxTypeSelect)) {
                if ("ccxws".equals(dyo.getString("type"))) {
                    TjsjbDataMigrationUpgradeService.setWriteBackBeans(dyo, writeBackBeans, taxTypeSelect, false, true);
                    continue;
                }
                TjsjbDataMigrationUpgradeService.setWriteBackBeans(dyo, writeBackBeans, TctsaTypeEnum.getTaxTypeByTaxPre((String)dyo.getString("type")), false, false);
                continue;
            }
            TjsjbDataMigrationUpgradeService.setWriteBackBeans(dyo, writeBackBeans, TctsaTypeEnum.getTaxTypeByTaxPre((String)dyo.getString("type")), false, false);
        }
        TsjsbWriteBackServiceImpl.startWriteBack(writeBackBeans, "2", TjsjbFetchEnum.getTaxtypeidListByType((String)taxTypeSelect), "1", null);
    }

    private static void handleHwsWriteBack() {
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter taxsysFilter = new QFilter("taxsystem", "!=", (Object)1L);
        QFilter purposeFilter = new QFilter("draftpurpose", "=", (Object)"nssb");
        QFilter[] filters = new QFilter[]{statusFilter, taxsysFilter, purposeFilter};
        DynamicObjectCollection draftDyos = QueryServiceHelper.query((String)"gtcp_normal_draft_list", (String)"id,billno,billstatus,org,taxsystem,taxtype,taxareagroup,datatype,skssqq,skssqz", (QFilter[])filters);
        ArrayList<Object> writeBackBeans = new ArrayList<Object>(16);
        for (DynamicObject dyo : draftDyos) {
            List taxAreaGroupIds = new ArrayList<Long>(8);
            if (1641488655174373376L == dyo.getLong("taxtype")) {
                QFilter idFilter = new QFilter("draftid", "=", (Object)dyo.getLong("id"));
                DynamicObjectCollection taxareaDynamicObjects = QueryServiceHelper.query((String)"gtcp_draft_tab", (String)"id,draftid,tab,taxareagroup", (QFilter[])idFilter.toArray());
                taxAreaGroupIds = taxareaDynamicObjects.stream().map(s -> s.getLong("taxareagroup")).collect(Collectors.toList());
            } else {
                taxAreaGroupIds.add(dyo.getLong("taxareagroup"));
            }
            List beans = taxAreaGroupIds.stream().map(aLong -> new TjsjhwsWriteBackBean(dyo.getString("billno"), Long.valueOf(dyo.getLong("org")), Long.valueOf(dyo.getLong("taxsystem")), Long.valueOf(dyo.getLong("taxtype")), Long.valueOf(dyo.getLong("taxareagroup")), dyo.getDate("skssqq"), dyo.getDate("skssqz"), "4", null, Long.valueOf(dyo.getLong("id")), "C", dyo.getString("datatype"))).collect(Collectors.toList());
            writeBackBeans.addAll(beans);
        }
        QFilter hwsTaxPayFilter = new QFilter("payrefstatus", "in", Arrays.asList("pay", "refund")).and("datasouce", "=", (Object)"2");
        DynamicObjectCollection payDynamicColl = QueryServiceHelper.query((String)"gtcp_taxpay_refund_bill", (String)"id,amount,payrefunddate,taxestype,billno,org,taxationsys,taxcategory,taxareagroup,skssqq,skssqz", (QFilter[])hwsTaxPayFilter.toArray());
        for (DynamicObject taxPay : payDynamicColl) {
            writeBackBeans.add(new TjsjhwsWriteBackBean(taxPay.getString("billno"), Long.valueOf(taxPay.getLong("org")), Long.valueOf(taxPay.getLong("taxationsys")), Long.valueOf(taxPay.getLong("taxcategory")), Long.valueOf(taxPay.getLong("taxareagroup")), taxPay.getDate("skssqq"), taxPay.getDate("skssqz"), "4", null, Long.valueOf(taxPay.getLong("id")), "C", "1000"));
        }
        QFilter qFilter = new QFilter("taxationsysid", "!=", (Object)1L);
        ArrayList<Long> hwsids = new ArrayList<Long>(16);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_taxcategory", (String)"id,taxationsysid", (QFilter[])new QFilter[]{qFilter});
        Map<Long, List<DynamicObject>> idsMap = Arrays.asList(load).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
        hwsids.addAll(idsMap.keySet());
        TsjsbWriteBackServiceImpl.startWriteBack(writeBackBeans, "2", hwsids, "4", null);
    }

    private static void handleJtWriteBack() {
        QFilter jtFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection itpJtDyos = QueryServiceHelper.query((String)"itp_proviston_taxes", (String)"id,billno,billstatus,taxorg,accountorg,taxsystem,taxtype,taxarea,provistonitem,startdate,enddate,coins,total,accountsettype", (QFilter[])jtFilter.toArray());
        ArrayList<TjsjjtzjbWriteBackBean> backBeans = new ArrayList<TjsjjtzjbWriteBackBean>(16);
        for (DynamicObject dyo : itpJtDyos) {
            backBeans.add(new TjsjjtzjbWriteBackBean(dyo.getString("billno"), Long.valueOf(dyo.getLong("taxorg")), Long.valueOf(dyo.getLong("accountorg")), Long.valueOf(dyo.getLong("taxsystem")), Long.valueOf(dyo.getLong("taxtype")), Long.valueOf(dyo.getLong("taxarea")), Long.valueOf(dyo.getLong("provistonitem")), dyo.getDate("startdate"), dyo.getDate("enddate"), Long.valueOf(dyo.getLong("coins")), dyo.getBigDecimal("total"), dyo.getString("accountsettype"), "3", null, Long.valueOf(dyo.getLong("id")), dyo.getString("billstatus"), "1", "itp_proviston_taxes"));
        }
        QFilter purposeFilter = new QFilter("draftpurpose", "=", (Object)"sjjt");
        QFilter[] filters = new QFilter[]{jtFilter, purposeFilter};
        DynamicObjectCollection gtcpJtDyos = QueryServiceHelper.query((String)"gtcp_normal_jt_list", (String)"id,billno,billstatus,org,taxsystem,taxtype,taxareagroup,datatype,skssqq,skssqz,accountsettype,taxsystem.currency", (QFilter[])filters);
        for (DynamicObject dyo : gtcpJtDyos) {
            if (1641488655174373376L == dyo.getLong("taxtype")) continue;
            backBeans.add(new TjsjjtzjbWriteBackBean(dyo.getString("billno"), Long.valueOf(dyo.getLong("org")), Long.valueOf(dyo.getLong("org")), Long.valueOf(dyo.getLong("taxsystem")), Long.valueOf(dyo.getLong("taxtype")), Long.valueOf(dyo.getLong("taxareagroup")), null, dyo.getDate("skssqq"), dyo.getDate("skssqz"), Long.valueOf(dyo.getLong("taxsystem.currency")), null, dyo.getString("accountsettype"), "2", null, Long.valueOf(dyo.getLong("id")), dyo.getString("billstatus"), "1", 1L != dyo.getLong("taxsystem") ? "gtcp_normal_jt_list" : TjsjjtMetadataidEnum.getMetaDataidByType((String)String.valueOf(dyo.getLong("taxtype")))));
        }
        TsjsbWriteBackServiceImpl.startWriteBack(backBeans, "2", TjsjbFetchEnum.getTaxtypeidListByType((String)"14"), "3", null);
    }

    private static void handleTaxReportWriteBack() {
        QFilter statusQ = new QFilter("billstatus", "=", (Object)"C");
        QFilter[] qfilters = new QFilter[]{statusQ};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctsa_fixed_filling_query", (String)"id,taxtype,billstatus,skssqq,skssqz,org,number,billno,fillperiod,tstatus,sbbid", (QFilter[])qfilters);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        List backBeans = dynamicObjects.stream().map(d -> new TsjsbTaxReportWriteBackBean(d.getDate("skssqq"), d.getDate("skssqz"), "1", Long.valueOf(d.getLong("org")), d.getString("taxtype"), Long.valueOf(d.getLong("id")), d.getString("billstatus"), "1", d.getString("tstatus"), Long.valueOf(d.getLong("sbbid")))).collect(Collectors.toList());
        TsjsbWriteBackServiceImpl.startWriteBack(backBeans, "2", null, "2", null);
    }

    private static void setWriteBackBeans(DynamicObject nsrxxDyo, List<TsjsbWriteBackBean> writeBackBeans, String oldTaxTypeIdStr, Boolean iszzsorccxws, boolean isccxws) {
        if (iszzsorccxws.booleanValue() && ("1".equals(oldTaxTypeIdStr) || "3".equals(oldTaxTypeIdStr))) {
            List typeids = TjsjbFetchEnum.getTaxtypeidListByType((String)oldTaxTypeIdStr);
            for (Long taxTypeId : typeids) {
                if (taxTypeId == 1L) continue;
                TjsjbDataMigrationUpgradeService.setWriteBackBeans(writeBackBeans, String.valueOf(taxTypeId), nsrxxDyo, isccxws);
            }
        } else if ("7".equals(oldTaxTypeIdStr)) {
            List<String> typeList = Arrays.asList("7", "9");
            for (String typeid : typeList) {
                TjsjbDataMigrationUpgradeService.setWriteBackBeans(writeBackBeans, typeid, nsrxxDyo, isccxws);
            }
        } else {
            TjsjbDataMigrationUpgradeService.setWriteBackBeans(writeBackBeans, oldTaxTypeIdStr, nsrxxDyo, isccxws);
        }
    }

    private static void setWriteBackBeans(List<TsjsbWriteBackBean> writeBackBeans, String taxTypeIdStr, DynamicObject nsrxxDyo, boolean isccxws) {
        writeBackBeans.add(new TsjsbWriteBackBean(nsrxxDyo.getDate("skssqq"), nsrxxDyo.getDate("skssqz"), "0", nsrxxDyo.getString("type"), Long.valueOf(nsrxxDyo.getLong("org")), taxTypeIdStr, Long.valueOf(nsrxxDyo.getLong("id")), nsrxxDyo.getString("billstatus"), nsrxxDyo.getString("datatype"), nsrxxDyo.getString("billno"), BigDecimal.ZERO, "", nsrxxDyo.getString("serialno"), isccxws ? TjsjbMetadataidEnum.getMetaDataidByType((String)taxTypeIdStr, (String)"ccxws") : TjsjbMetadataidEnum.getMetaDataidByType((String)taxTypeIdStr, (String)nsrxxDyo.getString("type"))));
    }
}

