/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.eventcenter.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.tctsa.common.entity.LdtsWriteBackBean;
import kd.taxc.tctsa.common.entity.TsjsbWriteBackBean;
import kd.taxc.tctsa.common.enums.TctsaTypeEnum;
import kd.taxc.tctsa.common.enums.TjsjbFetchEnum;
import kd.taxc.tctsa.common.enums.ZzsUpdateEnum;
import kd.taxc.tctsa.formplugin.eventcenter.impl.LdtsWriteBackServiceImpl;
import kd.taxc.tctsa.formplugin.eventcenter.impl.TyhmxWriteBackServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TyhmxDataMigrationUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TyhmxDataMigrationUpgradeService.class);
    private static List<String> typeList = Arrays.asList("fjsf", "zzsxgmnsr", "zzsybnsr", "zzsybnsr_ybhz");
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(TyhmxDataMigrationUpgradeService.doUpgrade(ver));
        this.result.setSuccess(this.success);
        return this.result;
    }

    public static String doUpgrade(String taxTypeSelect) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            logger.info((Object)"\u5347\u7ea7\u5f00\u59cb\u6267\u884c");
            long start = System.currentTimeMillis();
            if ("7".equals(taxTypeSelect)) {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tcvat_tax_refund_manage_a", (String)"id,org,skssqq,skssqz,bqsqthzlldtse,bqsqthclldtse", (QFilter[])new QFilter[0]);
                Map<String, String> declareMap = TyhmxDataMigrationUpgradeService.getDeclareDyo(dynamicObjects);
                HashSet<LdtsWriteBackBean> ldtsWriteBackBeanList = new HashSet<LdtsWriteBackBean>();
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String type = declareMap.get(dynamicObject.getString("org.id") + "_" + dynamicObject.getString("skssqq") + "_" + dynamicObject.getString("skssqz"));
                    if (type == null) continue;
                    LdtsWriteBackBean ldtsBean = new LdtsWriteBackBean();
                    ldtsBean.setEvent("NEW");
                    ldtsBean.setTax("1");
                    ldtsBean.setOrg(Long.valueOf(dynamicObject.getLong("org.id")));
                    ldtsBean.setSkssqq(DateUtils.format((Date)dynamicObject.getDate("skssqq"), (String)"yyyy-MM-dd"));
                    ldtsBean.setSkssqz(DateUtils.format((Date)dynamicObject.getDate("skssqz"), (String)"yyyy-MM-dd"));
                    ldtsBean.setType(type);
                    ldtsBean.setBqsqthclldtse(dynamicObject.getBigDecimal("bqsqthclldtse"));
                    ldtsBean.setBqsqthzlldtse(dynamicObject.getBigDecimal("bqsqthzlldtse"));
                    ldtsWriteBackBeanList.add(ldtsBean);
                }
                LdtsWriteBackServiceImpl.startWriteBack(new ArrayList<LdtsWriteBackBean>(ldtsWriteBackBeanList));
            } else {
                QFilter typeQ = new QFilter("type", "in", Arrays.asList(TjsjbFetchEnum.getDeclarationType((String)taxTypeSelect)));
                QFilter billstatusQ = new QFilter("billstatus", "=", (Object)"C");
                QFilter[] qfilters = new QFilter[]{typeQ, billstatusQ};
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,type,billstatus,skssqq,skssqz,org,datatype,billno,entryentity.taxtypes as taxtypes,serialno", (QFilter[])qfilters);
                List<Object> tsjsbWBBList = new ArrayList<TsjsbWriteBackBean>(16);
                if (dynamicObjects != null && dynamicObjects.size() > 0) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        if ("1".equals(taxTypeSelect)) {
                            if (typeList.contains(dynamicObject.getString("type")) && "2".equals(dynamicObject.getString("taxtypes"))) {
                                TyhmxDataMigrationUpgradeService.getAssembleTsjsbWBBList(dynamicObject, tsjsbWBBList, taxTypeSelect, true);
                                continue;
                            }
                            tsjsbWBBList.add(new TsjsbWriteBackBean(dynamicObject.getDate("skssqq"), dynamicObject.getDate("skssqz"), "0", dynamicObject.getString("type"), Long.valueOf(dynamicObject.getLong("org")), ZzsUpdateEnum.getTaxTypeByCode((String)dynamicObject.getString("taxtypes")), Long.valueOf(dynamicObject.getLong("id")), dynamicObject.getString("billstatus"), dynamicObject.getString("datatype"), dynamicObject.getString("billno"), BigDecimal.ZERO, "", dynamicObject.getString("serialno"), null));
                            continue;
                        }
                        if ("2".equals(taxTypeSelect)) {
                            TyhmxDataMigrationUpgradeService.getAssembleTsjsbWBBList(dynamicObject, tsjsbWBBList, "3", false);
                            continue;
                        }
                        if ("3".equals(taxTypeSelect)) {
                            if ("ccxws".equals(dynamicObject.getString("type"))) {
                                TyhmxDataMigrationUpgradeService.getAssembleTsjsbWBBList(dynamicObject, tsjsbWBBList, taxTypeSelect, false);
                                continue;
                            }
                            TyhmxDataMigrationUpgradeService.getAssembleTsjsbWBBList(dynamicObject, tsjsbWBBList, TctsaTypeEnum.getTaxTypeByTaxPre((String)dynamicObject.getString("type")), false);
                            continue;
                        }
                        TyhmxDataMigrationUpgradeService.getAssembleTsjsbWBBList(dynamicObject, tsjsbWBBList, TctsaTypeEnum.getTaxTypeByTaxPre((String)dynamicObject.getString("type")), false);
                    }
                }
                List billnos = tsjsbWBBList.stream().map(row -> row.getBillno()).collect(Collectors.toList());
                QFilter qFilter = new QFilter("billno", "in", billnos);
                DynamicObject[] existObj = BusinessDataServiceHelper.load((String)"tctsa_preferentdetail", (String)"org,skssqq,skssqz,taxcategoryid,billno", (QFilter[])new QFilter[]{qFilter});
                Set existIds = Arrays.stream(existObj).map(row -> row.getString("org.id") + "_" + row.getString("skssqq") + "_" + row.getString("skssqz") + "_" + row.getString("taxcategoryid.number").replaceFirst("^0*", "") + "_" + row.getString("billno")).collect(Collectors.toSet());
                tsjsbWBBList = tsjsbWBBList.stream().filter(v -> !existIds.contains(v.getOrg() + "_" + v.getSkssqq() + "_" + v.getSkssqz() + "_" + v.getTaxtype() + "_" + v.getBillno())).collect(Collectors.toList());
                TyhmxWriteBackServiceImpl.startWriteBack(tsjsbWBBList, "2", TjsjbFetchEnum.getTaxtypeidListByType((String)taxTypeSelect), "1");
            }
            logger.info((Object)("\u5347\u7ea7\u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start)));
            String string = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"TyhmxDataMigrationUpgradeService_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]);
            return string;
        }
        catch (Throwable t) {
            try {
                logger.info((Object)"\u5f02\u5e38\u62a5\u9519", t);
                h.markRollback();
                throw t;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void getAssembleTsjsbWBBList(DynamicObject dynamicObject, List<TsjsbWriteBackBean> tsjsbWBBList, String var, Boolean iszzsorccxws) {
        if (iszzsorccxws.booleanValue() && ("1".equals(var) || "3".equals(var))) {
            List typeids = TjsjbFetchEnum.getTaxtypeidListByType((String)var);
            for (Long typeid : typeids) {
                if (typeid == 1L) continue;
                TyhmxDataMigrationUpgradeService.setTsjsbWBBList(tsjsbWBBList, String.valueOf(typeid), dynamicObject);
            }
        } else if ("7".equals(var)) {
            List<String> typeList = Arrays.asList("7", "9");
            for (String typeid : typeList) {
                TyhmxDataMigrationUpgradeService.setTsjsbWBBList(tsjsbWBBList, typeid, dynamicObject);
            }
        } else {
            TyhmxDataMigrationUpgradeService.setTsjsbWBBList(tsjsbWBBList, var, dynamicObject);
        }
    }

    private static void setTsjsbWBBList(List<TsjsbWriteBackBean> tsjsbWBBList, String var, DynamicObject dynamicObject) {
        tsjsbWBBList.add(new TsjsbWriteBackBean(dynamicObject.getDate("skssqq"), dynamicObject.getDate("skssqz"), "0", dynamicObject.getString("type"), Long.valueOf(dynamicObject.getLong("org")), var, Long.valueOf(dynamicObject.getLong("id")), dynamicObject.getString("billstatus"), dynamicObject.getString("datatype"), dynamicObject.getString("billno"), BigDecimal.ZERO, "", dynamicObject.getString("serialno"), null));
    }

    public static Map<String, String> getDeclareDyo(DynamicObject[] dynamicObjects) {
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return new HashMap<String, String>();
        }
        Set skssqqSet = Arrays.stream(dynamicObjects).map(v -> v.getDate("skssqq")).collect(Collectors.toSet());
        Set skssqzSet = Arrays.stream(dynamicObjects).map(v -> v.getDate("skssqz")).collect(Collectors.toSet());
        Set orgSet = Arrays.stream(dynamicObjects).map(v -> v.getLong("org.id")).collect(Collectors.toSet());
        List typeList = Arrays.stream(TaxTypeEnum.TCVAT.getTemplates()).collect(Collectors.toList());
        QFilter orgidFilter = new QFilter("org", "in", orgSet);
        QFilter stypeFilter = new QFilter("type", "in", typeList);
        QFilter startDataFilter = new QFilter("skssqq", "in", skssqqSet);
        QFilter endDataFilter = new QFilter("skssqz", "in", skssqzSet);
        DynamicObjectCollection zzsList = QueryServiceHelper.query((String)"tcvat_zzs_declare_list", (String)"org,type,skssqq,skssqz", (QFilter[])new QFilter[]{orgidFilter, startDataFilter, endDataFilter, stypeFilter});
        if (CollectionUtils.isEmpty((Collection)zzsList)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        zzsList.stream().forEach(o -> returnMap.put(o.getString("org") + "_" + o.getString("skssqq") + "_" + o.getString("skssqz"), o.getString("type")));
        return returnMap;
    }
}

