/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.helper;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.CreditHandlerUtils;
import kd.taxc.tctsa.common.util.DateUtils;

public class PieChartHelper {
    private static Log logger = LogFactory.getLog(PieChartHelper.class);
    private static final List<String> TYPES = Arrays.asList("A", "B", "C", "D", "M");
    private static final List<String> LEVELS = Arrays.asList("1", "2", "3");
    private static final List<String> LEVELVALUES = PieChartHelper.getLevelvalues();

    public Map<String, List> drawChart(PieChart pieChart, HistogramChart histogramChart, List orgs, Date yearfieldDate, String creditlevel1, Boolean demoteQuery, Date compareYear, String demoteRange, String key) {
        Map<String, Long> result = this.getQueryResult(orgs, yearfieldDate, creditlevel1, demoteQuery, compareYear, demoteRange);
        pieChart.clearData();
        PieSeries series = pieChart.createSeries(ResManager.loadKDString((String)"", (String)"PieChartHelper_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        series.addData(new ItemValue(demoteQuery == false ? "A" : ResManager.loadKDString((String)"\u4e00\u7ea7", (String)"PieChartHelper_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), demoteQuery == false ? (Number)result.get("A") : (Number)(result.get("1") != null ? (Number)result.get("1") : (Number)0), "#40A9FF"));
        series.addData(new ItemValue(demoteQuery == false ? "B" : ResManager.loadKDString((String)"\u4e8c\u7ea7", (String)"PieChartHelper_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), demoteQuery == false ? (Number)result.get("B") : (Number)(result.get("2") != null ? (Number)result.get("2") : (Number)0), "#26C9C3"));
        series.addData(new ItemValue(demoteQuery == false ? "C" : ResManager.loadKDString((String)"\u4e09\u7ea7", (String)"PieChartHelper_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), demoteQuery == false ? (Number)result.get("C") : (Number)(result.get("3") != null ? (Number)result.get("3") : (Number)0), "#73D13D"));
        if (!demoteQuery.booleanValue()) {
            series.addData(new ItemValue("D", (Number)result.get("D"), "#FFC53D"));
        }
        if (!demoteQuery.booleanValue()) {
            series.addData(new ItemValue("M", (Number)result.get("M"), "#FFA940"));
        }
        Map itemNormalStyle = series.getItemNormalStyle();
        HashMap<String, Object> lableMap = new HashMap<String, Object>();
        lableMap.put("show", Boolean.TRUE);
        lableMap.put("position", "left");
        itemNormalStyle.put("label", lableMap);
        HashMap<String, Boolean> lableLineMap = new HashMap<String, Boolean>();
        lableLineMap.put("show", Boolean.TRUE);
        itemNormalStyle.put("labelLine", lableLineMap);
        series.setRadius("70%");
        Map<String, Object> values = this.getValues(series);
        this.setEmphasisLabel(values);
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(true);
        pieChart.addTooltip("trigger", (Object)"item");
        pieChart.addTooltip("formatter", (Object)ResManager.loadKDString((String)"{b}    {d}% <br/> \u7ec4\u7ec7\u6570\u91cf: {c}", (String)"PieChartHelper_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        pieChart.setLegendAlign(XAlign.right, YAlign.top);
        pieChart.setLegendVertical(true);
        pieChart.setLegendPropValue("selectedMode", (Object)"onlyHover");
        pieChart.setLegendPropValue("padding", (Object)new Integer[]{20, 10, 20, 20});
        pieChart.refresh();
        ArrayList<Long> typeCountList = new ArrayList<Long>();
        if (!demoteQuery.booleanValue()) {
            for (String type : TYPES) {
                typeCountList.add(result.get(type));
            }
        } else {
            for (String level : LEVELS) {
                typeCountList.add(result.get(level) != null ? result.get(level) : Long.valueOf(0L));
            }
        }
        this.showCustomChart(histogramChart, demoteQuery == false ? TYPES : LEVELVALUES, typeCountList, "#5582F3");
        return null;
    }

    private void showCustomChart(HistogramChart customchart, List<String> keys, List<Long> values, String color) {
        customchart.clearData();
        Axis xAxis = this.createValueAxis(customchart, "", false);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        this.createCategoryAxis(customchart, ResManager.loadKDString((String)"(\u5e45\u5ea6)", (String)"PieChartHelper_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), keys, true);
        this.createHistogramSeries(customchart, ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u91cf", (String)"PieChartHelper_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), values.toArray(new Number[0]), color.isEmpty() ? "#FEC035" : color);
        customchart.setMargin(Position.right, "50px");
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setLegendVertical(true);
        customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 23});
        customchart.setMargin(Position.top, "30px");
        customchart.setName(new LocaleString(ResManager.loadKDString((String)"(\u6570\u91cf)", (String)"PieChartHelper_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        HashMap textStyle = Maps.newHashMap();
        textStyle.put("fontSize", 12);
        textStyle.put("fontWeight", 450);
        customchart.setTitlePropValue("textStyle", (Object)textStyle);
        customchart.refresh();
    }

    private Map<String, Long> getQueryResult(List orgs, Date yearfieldDate, String creditlevel1, Boolean demoteQuery, Date compareYear, String demoteRange) {
        QFilter qFilter3;
        QFilter qFilter1;
        ArrayList<QFilter> noRangeqFilters = new ArrayList<QFilter>();
        ArrayList<QFilter> rangeqFilters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("orgid", "in", (Object)orgs);
        noRangeqFilters.add(qFilter);
        rangeqFilters.add(qFilter);
        if (demoteQuery.booleanValue()) {
            qFilter1 = new QFilter("taxcreditrating.year", ">=", (Object)DateUtils.getFirstDateOfYear((Date)yearfieldDate));
            qFilter1.and(new QFilter("taxcreditrating.year", "<=", (Object)DateUtils.getLastDateOfYear((Date)yearfieldDate)));
            noRangeqFilters.add(qFilter1);
            QFilter qFilter2 = new QFilter("taxcreditrating.year", ">=", (Object)DateUtils.getFirstDateOfYear((Date)compareYear));
            qFilter2.and(new QFilter("taxcreditrating.year", "<=", (Object)DateUtils.getLastDateOfYear((Date)compareYear)));
            rangeqFilters.add(qFilter2);
        } else {
            qFilter1 = new QFilter("taxcreditrating.year", ">=", (Object)DateUtils.getFirstDateOfYear((Date)yearfieldDate));
            qFilter1.and(new QFilter("taxcreditrating.year", "<=", (Object)DateUtils.getLastDateOfYear((Date)yearfieldDate)));
            noRangeqFilters.add(qFilter1);
        }
        String[] creditleveltypes = creditlevel1 != null ? creditlevel1.split(",") : null;
        QFilter qFilter2 = qFilter3 = creditleveltypes != null ? new QFilter("taxcreditrating.creditlevel", "in", Arrays.asList(creditleveltypes)) : null;
        if (qFilter3 != null) {
            noRangeqFilters.add(qFilter3);
            rangeqFilters.add(qFilter3);
        }
        QFilter[] noRangeqFilter = noRangeqFilters.toArray(new QFilter[noRangeqFilters.size()]);
        QFilter[] rangeqFilter = rangeqFilters.toArray(new QFilter[rangeqFilters.size()]);
        DynamicObjectCollection querycDynamicObjects = TaxcMainServiceHelper.queryDiy((QFilter[])noRangeqFilter, (String)TaxcMainServiceHelper.selectFields1);
        DynamicObjectCollection compareDynamicObjects = TaxcMainServiceHelper.queryDiy((QFilter[])rangeqFilter, (String)TaxcMainServiceHelper.selectFields1);
        Map<String, List<DynamicObject>> groups = querycDynamicObjects.stream().collect(Collectors.groupingBy(s -> s.getString("taxcreditrating.creditlevel")));
        Map<String, Long> count = new HashMap<String, Long>();
        List objects = new ArrayList();
        if (!demoteQuery.booleanValue()) {
            for (String type : TYPES) {
                count.put(type, this.getCount(groups, type));
            }
        } else {
            objects = CreditHandlerUtils.getAllData((DynamicObjectCollection)querycDynamicObjects, (DynamicObjectCollection)compareDynamicObjects, (String)demoteRange, (Boolean)demoteQuery);
            count = objects.stream().collect(Collectors.groupingBy(k -> String.valueOf(k[0]), Collectors.counting()));
        }
        return count;
    }

    private Long getCount(Map<String, List<DynamicObject>> groups, String type) {
        Long count = groups.get(type) != null ? Long.parseLong(String.valueOf(groups.get(type).size())) : 0L;
        return count;
    }

    private Map<String, Object> getValues(PieSeries series) {
        try {
            Class<?> clazz = Class.forName("kd.bos.form.chart.Series");
            Method getValues = clazz.getDeclaredMethod("getValues", new Class[0]);
            AccessibleObject.setAccessible(new AccessibleObject[]{getValues}, true);
            Object invoke = getValues.invoke((Object)series, (Object[])null);
            return null == invoke ? new HashMap(16) : (Map)invoke;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private void setEmphasisLabel(Map<String, Object> values) {
        if (null != values && values.size() > 0 && null != values.get("itemStyle")) {
            Map itemStyle = (Map)values.get("itemStyle");
            HashMap emphasisMap = new HashMap();
            HashMap<String, Serializable> labelMap = new HashMap<String, Serializable>();
            HashMap<String, String> textStyleMap = new HashMap<String, String>();
            textStyleMap.put("fontSize", "24");
            textStyleMap.put("fontWeight", "bold");
            labelMap.put("show", Boolean.TRUE);
            labelMap.put("textStyle", textStyleMap);
            emphasisMap.put("label", labelMap);
            HashMap<String, Boolean> labelLineMap = new HashMap<String, Boolean>();
            labelLineMap.put("show", Boolean.FALSE);
            emphasisMap.put("labelLine", labelLineMap);
            itemStyle.put("emphasis", emphasisMap);
        }
    }

    private Axis createValueAxis(HistogramChart histogramChart, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.value) : histogramChart.createYAxis(name, AxisType.value);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        return axis;
    }

    private Axis createCategoryAxis(HistogramChart histogramChart, String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.category) : histogramChart.createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        histogramChart.setShowTooltip(true);
        return axis;
    }

    private void createHistogramSeries(HistogramChart histogramChart, String name, Number[] values, String color) {
        BarSeries histogramSeries = histogramChart.createSeries(name);
        histogramSeries.setStack("stack");
        histogramSeries.setBarWidth("25px");
        histogramSeries.setColor(color);
        HashMap dataLabels = Maps.newHashMap();
        dataLabels.put("format", "{point.y:.1f}");
        histogramSeries.setPropValue("dataLabels", (Object)dataLabels);
        histogramSeries.setAnimationDuration(2000);
        Label label = new Label();
        label.setPosition(Position.insideRight);
        label.setShow(false);
        histogramSeries.setLabel(label);
        for (int i = 0; i < values.length; ++i) {
            if (!((double)values[i].floatValue() < 0.001) || !((double)values[i].floatValue() > -0.001)) continue;
            values[i] = null;
        }
        histogramSeries.setData(values);
    }

    private static List<String> getLevelvalues() {
        return Arrays.asList(ResManager.loadKDString((String)"\u4e00\u7ea7", (String)"PieChartHelper_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u7ea7", (String)"PieChartHelper_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u7ea7", (String)"PieChartHelper_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
    }
}

