/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.orm.query.QFilter;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.StringUtil;

public class PointLineChartHelper {
    private static final List<String> TYPES = Arrays.asList("0", "1", "2", "3", "4");

    public Map<String, List> drawChart(PointLineChart pointLineChart, List orgs, Date yearfieldDate, String creditlevel1) {
        boolean isX = true;
        Axis categoryAxis = this.createCategoryAxis(pointLineChart, ResManager.loadKDString((String)"(\u5e74\u5ea6)", (String)"PointLineChartHelper_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), isX);
        HashMap nametextstyle = Maps.newHashMap();
        nametextstyle.put("color", "#000000");
        nametextstyle.put("fontSize", 16);
        categoryAxis.setPropValue("nameTextStyle", (Object)nametextstyle);
        categoryAxis.setPropValue("nameLocation", (Object)"end");
        categoryAxis.setPropValue("position", (Object)"bottom");
        HashMap axislabel = Maps.newHashMap();
        HashMap textstyle = Maps.newHashMap();
        textstyle.put("color", "#000000");
        textstyle.put("fontSize", "16");
        axislabel.put("textStyle", textstyle);
        categoryAxis.setPropValue("axisLabel", (Object)axislabel);
        Map<String, List> result = this.getQueryResult(orgs, yearfieldDate, creditlevel1);
        categoryAxis.setCategorys(result.get("yearList"));
        Axis ValueAxis = this.createValueAxis(pointLineChart, ResManager.loadKDString((String)"(\u7ea7\u522b)", (String)"PointLineChartHelper_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), TYPES, !isX);
        HashMap yAxisnametextstyle = Maps.newHashMap();
        yAxisnametextstyle.put("color", "#000000");
        yAxisnametextstyle.put("fontSize", 16);
        ValueAxis.setPropValue("nameTextStyle", (Object)yAxisnametextstyle);
        this.createLineSeries(pointLineChart, ResManager.loadKDString((String)"\u4fe1\u7528\u7ea7\u522b", (String)"PointLineChartHelper_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), result.get("creditlevelList"), "#666666");
        pointLineChart.setMargin(Position.right, "80px");
        pointLineChart.setMargin(Position.top, "80px");
        pointLineChart.setMargin(Position.left, "80px");
        pointLineChart.setLegendPropValue("top", (Object)"8%");
        pointLineChart.refresh();
        return result;
    }

    private Map<String, List> getQueryResult(List orgs, Date yearfieldDate, String creditlevel1) {
        QFilter qFilter3;
        QFilter qFilter2;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter1 = new QFilter("orgid", "in", (Object)orgs);
        QFilter qFilter = qFilter2 = yearfieldDate != null ? new QFilter("taxcreditrating.year", ">=", (Object)DateUtils.getFirstDateOfYear((Date)yearfieldDate)) : null;
        if (qFilter2 != null) {
            qFilter2.and(new QFilter("taxcreditrating.year", "<=", (Object)DateUtils.getLastDateOfYear((Date)yearfieldDate)));
        }
        String[] creditleveltypes = creditlevel1 != null ? creditlevel1.split(",") : null;
        QFilter qFilter4 = qFilter3 = creditleveltypes != null ? new QFilter("taxcreditrating.creditlevel", "in", Arrays.asList(creditleveltypes)) : null;
        if (qFilter1 != null) {
            qFilters.add(qFilter1);
        }
        if (qFilter2 != null) {
            qFilters.add(qFilter2);
        }
        if (qFilter3 != null) {
            qFilters.add(qFilter3);
        }
        QFilter[] qFilter5 = qFilters.toArray(new QFilter[qFilters.size()]);
        DynamicObjectCollection collection = TaxcMainServiceHelper.queryDiyOrderBys((QFilter[])qFilter5, (String)TaxcMainServiceHelper.selectFields1, (String)TaxcMainServiceHelper.orderBys1);
        HashMap<String, List> result = new HashMap<String, List>();
        ArrayList<String> creditlevelList = new ArrayList<String>();
        ArrayList<String> yearList = new ArrayList<String>();
        ArrayList<String> maincompany = new ArrayList<String>();
        for (DynamicObject obj : collection) {
            if (obj.getDate("taxcreditrating.year") == null && StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) && StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.ratingscore")) && StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.remark"))) continue;
            if (StringUtil.isNotEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel"))) {
                creditlevelList.add(obj.getString("taxcreditrating.creditlevel"));
            }
            if (obj.getDate("taxcreditrating.year") != null && StringUtil.isNotEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel"))) {
                yearList.add(String.valueOf(DateUtils.getYearOfDate((Date)obj.getDate("taxcreditrating.year"))));
            }
            if (maincompany.size() != 0) continue;
            maincompany.add(obj.getString("orgid.name"));
        }
        result.put("creditlevelList", creditlevelList);
        result.put("yearList", yearList);
        result.put("maincompany", maincompany);
        return result;
    }

    private Axis createCategoryAxis(PointLineChart pointLineChart, String name, boolean isx) {
        Axis axis = null;
        axis = isx ? pointLineChart.createXAxis(name, AxisType.category) : pointLineChart.createYAxis(name, AxisType.category);
        HashMap axisTick = Maps.newHashMap();
        axisTick.put("interval", 0);
        axisTick.put("show", Boolean.FALSE);
        axisTick.put("grid", Position.left);
        axis.setPropValue("axisTick", (Object)axisTick);
        return axis;
    }

    private Axis createValueAxis(PointLineChart pointLineChart, String name, List<String> demensions, boolean isx) {
        Axis axis = null;
        axis = isx ? pointLineChart.createXAxis(name, AxisType.value) : pointLineChart.createYAxis(name, AxisType.value);
        axis.setMax((Number)4);
        axis.setMin((Number)0);
        axis.setCategorys(demensions);
        HashMap axisTick = Maps.newHashMap();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        HashMap splitLine = Maps.newHashMap();
        HashMap lineStyle = Maps.newHashMap();
        HashMap axisLabel = Maps.newHashMap();
        axisLabel.put("show", Boolean.FALSE);
        axis.setPropValue("axisLabel", (Object)axisLabel);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        return axis;
    }

    private void createLineSeries(PointLineChart pointLineChart, String name, List<String> values, String color) {
        LineSeries expireSeries = pointLineChart.createSeries(name);
        expireSeries.setItemColor(color);
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String value;
            switch (value = iterator.next()) {
                case "A": {
                    expireSeries.addData(new ItemValue(ResManager.loadKDString((String)"A", (String)"PointLineChartHelper_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)4, "#40A9FF"));
                    break;
                }
                case "B": {
                    expireSeries.addData(new ItemValue(ResManager.loadKDString((String)"B", (String)"PointLineChartHelper_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)3, "#40A9FF"));
                    break;
                }
                case "C": {
                    expireSeries.addData(new ItemValue(ResManager.loadKDString((String)"C", (String)"PointLineChartHelper_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)2, "#40A9FF"));
                    break;
                }
                case "D": {
                    expireSeries.addData(new ItemValue(ResManager.loadKDString((String)"D", (String)"PointLineChartHelper_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)1, "#40A9FF"));
                    break;
                }
                case "M": {
                    expireSeries.addData(new ItemValue(ResManager.loadKDString((String)"M", (String)"PointLineChartHelper_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (Number)0, "#40A9FF"));
                }
            }
        }
    }
}

