/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.helper;

import com.google.common.collect.Maps;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.common.util.BigDecimalUtil;

public class TaxDetailChartHelper {
    private static Log logger = LogFactory.getLog(TaxDetailChartHelper.class);

    public Map<String, List> drawChart(HistogramChart histogramChart, String taxName, Date clickStartDate, Date clickEndDate, String flag, List<String> list, String combofield, List<Long> queryOrgList) {
        Map<String, List> result = this.getQueryResult(taxName, clickStartDate, clickEndDate, flag, histogramChart, list, combofield, queryOrgList);
        return result;
    }

    private Map<String, List> getQueryResult(String taxName, Date clickStartDate, Date clickEndDate, String flag, HistogramChart histogramChart, List<String> list, String combofield, List<Long> newQueryOrgList) {
        HashMap<String, List> mapList = new HashMap<String, List>(16);
        QFilter qfilter = new QFilter("fillperiod", "=", (Object)flag);
        if ("1".equals(combofield)) {
            qfilter.and(new QFilter("name", "=", (Object)taxName));
        } else {
            qfilter.and(new QFilter("org", "=", (Object)Long.parseLong(taxName)));
        }
        qfilter.and(new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)clickStartDate)));
        qfilter.and(new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth2((Date)clickEndDate)));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctsa_fixed_filling_query", (String)"fillperiod,number,name,amount,skssqq,skssqz,org", (QFilter[])new QFilter[]{qfilter});
        Map<Long, List<DynamicObject>> orgGroups = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(s -> s.getLong("org.id")));
        Map<String, List<DynamicObject>> nameGroups = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(s -> s.getLocaleString("name").getLocaleValue()));
        ArrayList<String> orgNameList = new ArrayList<String>(16);
        ArrayList<Long> orgLongList = new ArrayList<Long>(16);
        ArrayList<BigDecimal> orgAmountList = new ArrayList<BigDecimal>(16);
        ArrayList<String> sxnameList = new ArrayList<String>(16);
        ArrayList<String> orgsxnameList = new ArrayList<String>(16);
        ArrayList<BigDecimal> sxnameAmountList = new ArrayList<BigDecimal>(16);
        Iterator<Map.Entry<Long, List<DynamicObject>>> it = orgGroups.entrySet().iterator();
        Iterator<Map.Entry<String, List<DynamicObject>>> nameits = nameGroups.entrySet().iterator();
        if ("1".equals(combofield)) {
            while (it.hasNext()) {
                Map.Entry<Long, List<DynamicObject>> entry = it.next();
                Map<String, String> map = this.getInfoByOrgIdFromErp(String.valueOf(entry.getKey()), "number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank");
                orgNameList.add(map.get("name"));
                orgLongList.add(entry.getKey());
                orgAmountList.add(this.getTotalAmount(entry.getValue()));
            }
            this.showCustomChart(histogramChart, orgNameList, orgAmountList, orgLongList, list, null, null, combofield);
        } else {
            while (nameits.hasNext()) {
                Map.Entry<String, List<DynamicObject>> entry = nameits.next();
                sxnameList.add(entry.getKey());
                orgsxnameList.add(entry.getKey());
                sxnameAmountList.add(this.getTotalAmount(entry.getValue()));
            }
            this.showCustomChart(histogramChart, sxnameList, sxnameAmountList, null, null, orgsxnameList, list, combofield);
        }
        mapList.put("org", orgLongList);
        mapList.put("sxname", orgsxnameList);
        return mapList;
    }

    private BigDecimal getTotalAmount(List<DynamicObject> dynamicObjects) {
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : dynamicObjects) {
            total = BigDecimalUtil.addObject((Object)total, (Object)dynamicObject.getBigDecimal("amount"));
        }
        return total.divide(new BigDecimal(10000)).setScale(2, 4);
    }

    private void showCustomChart(HistogramChart customchart, List<String> keys, List<BigDecimal> values, List<Long> orgLongList, List<String> list, List<String> orgsxnameList, List<String> sxList, String combofield) {
        customchart.clearData();
        Axis xAxis = this.createValueAxis(customchart, "", false);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        this.createCategoryAxis(customchart, ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"TaxDetailChartHelper_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), keys, true);
        this.createHistogramSeries(customchart, ResManager.loadKDString((String)"\u586b\u62a5\u91d1\u989d(\u4e07\u5143) ", (String)"TaxDetailChartHelper_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), values.toArray(new Number[0]), orgLongList, list, orgsxnameList, sxList, combofield);
        customchart.setMargin(Position.right, "50px");
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setLegendVertical(true);
        customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 23});
        customchart.setMargin(Position.top, "30px");
        customchart.setName(new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d (\u4e07\u5143)", (String)"TaxDetailChartHelper_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        HashMap textStyle = Maps.newHashMap();
        textStyle.put("fontSize", 12);
        textStyle.put("fontWeight", 450);
        customchart.setTitlePropValue("textStyle", (Object)textStyle);
        customchart.refresh();
    }

    private Axis createValueAxis(HistogramChart histogramChart, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.value) : histogramChart.createYAxis(name, AxisType.value);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        return axis;
    }

    private Axis createCategoryAxis(HistogramChart histogramChart, String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.category) : histogramChart.createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap axisLabel = Maps.newHashMap();
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", 0);
        axisLabel.put("rotate", 40);
        axis.setPropValue("axisLabel", (Object)axisLabel);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        histogramChart.setShowTooltip(true);
        return axis;
    }

    private void createHistogramSeries(HistogramChart histogramChart, String name, Number[] values, List<Long> orgLongList, List<String> list, List<String> orgsxnameList, List<String> sxList, String combofield) {
        block7: {
            int i;
            BarSeries histogramSeries;
            block6: {
                histogramSeries = histogramChart.createSeries(name);
                histogramSeries.setStack("stack");
                histogramSeries.setBarWidth("25px");
                HashMap dataLabels = Maps.newHashMap();
                dataLabels.put("format", "{point.y:.1f}");
                histogramSeries.setPropValue("dataLabels", (Object)dataLabels);
                histogramSeries.setAnimationDuration(2000);
                Label label = new Label();
                label.setPosition(Position.insideRight);
                label.setShow(false);
                histogramSeries.setLabel(label);
                i = 0;
                if (!"1".equals(combofield)) break block6;
                for (Long sxname : orgLongList) {
                    if (list != null && list.contains(String.valueOf(sxname))) {
                        histogramSeries.addData(name, values[i], "#FFA940");
                    } else {
                        histogramSeries.addData(name, values[i], "#40A9FF");
                    }
                    ++i;
                }
                break block7;
            }
            if (!"2".equals(combofield)) break block7;
            for (String sxname : orgsxnameList) {
                if (sxList != null && sxList.contains(sxname)) {
                    histogramSeries.addData(name, values[i], "#FFA940");
                } else {
                    histogramSeries.addData(name, values[i], "#40A9FF");
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getInfoByOrgIdFromErp(String orgId, String ... selectFields) {
        QFilter id = new QFilter("id", "=", (Object)Long.parseLong(orgId));
        StringBuilder selectStrBuilder = new StringBuilder();
        int len = selectFields.length;
        for (int i = 0; i < len; ++i) {
            selectStrBuilder.append(selectFields[i]);
            selectStrBuilder.append(',');
        }
        String temp = selectStrBuilder.toString();
        String selectStr = temp.substring(0, temp.length() - 1);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)OrgViewServiceHelper.class.getName(), (String)"bos_org", (String)selectStr, (QFilter[])new QFilter[]{id}, (String)"id");){
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                for (int key = 0; key < selectFields.length; ++key) {
                    map.put(selectFields[key], row.getString(selectFields[key]));
                }
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            logger.info("TaxDetailChartHelper.getInfoByOrgIdFromErp", (Object)e);
            return new HashMap<String, String>();
        }
    }
}

