/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.preferentstatistic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;

public class PreferentDataPlugin
extends AbstractBillPlugIn
implements CellClickListener,
BeforeF7SelectListener {
    private static final String RECHECK = "recheck";
    private static final String DATASOURCETEXT = "datasourcetext";

    public void registerListener(EventObject e) {
        EntryGrid eg = (EntryGrid)this.getView().getControl("entryentity");
        eg.addCellClickListener((CellClickListener)this);
        BasedataEdit taxcategoryidBe = (BasedataEdit)this.getControl("taxcategoryid");
        taxcategoryidBe.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit statisticprotidBe = (BasedataEdit)this.getControl("statisticprotid");
        statisticprotidBe.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String id = MetadataDao.getIdByNumber((String)"tctsa_preferentdetail", (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List items = formMeta.getItems();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(items.size());
        HashSet idList = new HashSet(1);
        items.stream().filter(v -> Arrays.asList("fs_baseinfo", "entryentity").contains(v.getKey())).collect(Collectors.toList()).forEach(u -> idList.add(u.getId()));
        for (ControlAp item : items) {
            if (!idList.contains(item.getParentId()) || item.isHidden()) continue;
            String name = item.getName().getLocaleValue();
            String key = item.getKey();
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(name));
            comboItem.setValue(key);
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("accessfield");
        comboEdit.setComboItems(comboItems);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        DynamicObject taxationsysid = this.getModel().getDataEntity().getDynamicObject("taxationsysid");
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"taxcategoryid")) {
            QFilter taxationsysidQ = new QFilter("taxationsysid", "=", taxationsysid.get("id"));
            beforeF7SelectEvent.getCustomQFilters().add(taxationsysidQ);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"statisticprotid")) {
            DynamicObject taxcategoryid = this.getModel().getDataEntity().getDynamicObject("taxcategoryid");
            if (taxationsysid == null || taxcategoryid == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u548c\u7a0e\u79cd\u3002", (String)"PreferentDataPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter selectQF = new QFilter("taxationsysid", "=", taxationsysid.get("id")).and(new QFilter("taxcategoryid", "=", taxcategoryid.get("id")));
            beforeF7SelectEvent.getCustomQFilters().add(selectQF);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldkey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        if ("operationcolumnap".equals(fieldkey)) {
            String recheck = null;
            String datasourcetext = null;
            String datasourcejson = null;
            if (this.getView().getModel().getValue(RECHECK, row) != null) {
                recheck = this.getView().getModel().getValue(RECHECK, row).toString();
                datasourcetext = this.getView().getModel().getValue(DATASOURCETEXT, row).toString();
                datasourcejson = this.getView().getModel().getValue("datasourcejson_tag", row).toString();
            }
            this.openPage(fieldkey, row, recheck, datasourcetext, datasourcejson);
        }
    }

    private void openPage(String key, int row, String recheck, String datasourcetext, String datasourcejson) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tctsa_tjsjb_datas_config");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key + "_" + row);
        if (StringUtils.isNotEmpty((CharSequence)recheck)) {
            showParameter.setCustomParam(RECHECK, (Object)recheck);
            showParameter.setCustomParam(DATASOURCETEXT, (Object)datasourcetext);
            showParameter.setCustomParam("datasourcejson", (Object)datasourcejson);
        }
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String id = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        String[] ids = id.split("_");
        if (null != returnData) {
            String textfield = returnData.get(DATASOURCETEXT).toString();
            String datasourcejson = returnData.get("datasourcejson").toString();
            String recheck = returnData.get(RECHECK).toString();
            this.getModel().setValue(DATASOURCETEXT, (Object)textfield, Integer.parseInt(ids[1]));
            this.getModel().setValue("datasourcejson_tag", (Object)datasourcejson, Integer.parseInt(ids[1]));
            this.getModel().setValue(RECHECK, (Object)recheck, Integer.parseInt(ids[1]));
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

