/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.preferentstatistic;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.helper.OpenDeclareHelper;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PreferentDetailList
extends AbstractListPlugin {
    private static final String SBBID = "sbbid";
    private static final String BILLNO = "billno";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        TaxResult orgidList = OrgServiceHelper.getAllOrg();
        if (orgidList != null && orgidList.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)orgidList.getData()))) {
            qFilters.add(new QFilter("org.id", "in", orgidList.getData()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterColumn createTimeFilter = args.getFilterColumn("taxationsysid.name");
        createTimeFilter.setDefaultValue(TaxationsysMappingEnum.CHN.getId().toString());
        List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            List orgIds;
            TaxResult listTaxResult;
            TaxResult orgFlag;
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.equals("org.number") || (orgFlag = OrgServiceHelper.isOrg((Long)RequestContext.get().getOrgId())).isSuccess() && !BooleanUtils.isFalse((Boolean)((Boolean)orgFlag.getData())) || (listTaxResult = OrgServiceHelper.getAllOrg()) == null || !listTaxResult.isSuccess() || !CollectionUtils.isNotEmpty((Collection)(orgIds = (List)listTaxResult.getData()))) continue;
            filterColumn.setDefaultValues(new Object[]{((Long)orgIds.get(0)).toString()});
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (SKSSQQ.equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate(SKSSQQ), (String)TctsaConstant.FORMAT);
            String skssqz = DateUtils.format((Date)data.getDate(SKSSQZ), (String)TctsaConstant.FORMAT);
            e.setFormatValue((Object)(skssqq + "~" + skssqz));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)BILLNO, (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            DynamicObject nsrxx = BusinessDataServiceHelper.loadSingle((String)"tctsa_preferentdetail", (String)SBBID, (QFilter[])new QFilter[]{new QFilter("id", "=", currentSelectedRowInfo.getPrimaryKeyValue())});
            if (ObjectUtils.isEmpty((Object)nsrxx)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f18\u60e0\u660e\u7ec6\u6570\u636e\u5df2\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u3002", (String)"PreferentDetailList_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return;
            }
            String id = nsrxx.getString(SBBID);
            String sbbnocol = currentSelectedRowInfo.getBillNo();
            OpenDeclareHelper.opentPreferentdetail((IFormView)this.getView(), (String)id, (String)sbbnocol);
        }
    }
}

