/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.processquery;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.StepsOption;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.taxc.tctsa.common.constant.DeclareConstant;
import kd.taxc.tctsa.common.constant.SsbProcessQueryConstant;
import kd.taxc.tctsa.common.constant.TemplateTypeConstant;
import kd.taxc.tctsa.common.entity.DeclareRequestModel;
import kd.taxc.tctsa.common.enums.SsbColEnum;
import kd.taxc.tctsa.common.enums.SsbQueryContainerEnum;
import kd.taxc.tctsa.common.enums.SsbTotalGroupEnum;
import kd.taxc.tctsa.common.enums.TctsaTypeEnum;
import kd.taxc.tctsa.common.enums.TemplateEnum;
import kd.taxc.tctsa.common.enums.WizardapEnum;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.json.JsonUtil;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.StringUtil;

public class SsbProcessQueryRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";
    private static final String TCRET_QUERY_REPORT = "tcret_query_report";
    private static final String TCRET_DECLARE_MAIN = "tcret_declare_main";
    private static final String DEFAULT_ORGS = "defaultorgs";

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String id = hyperLinkClickEvent.getRowData().getString("id");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id), (String)"tcvat_nsrxx");
        String type = object.getString("type");
        if ("ccxws".equals(type)) {
            DynamicObject object1 = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(id), (String)TCRET_QUERY_REPORT);
            DynamicObject object2 = QueryServiceHelper.queryOne((String)TCRET_DECLARE_MAIN, (String)"id,declaredate,billno,taxauthority", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)Long.parseLong(id))});
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put(ORGID_KEY, object1.getDynamicObject("org").getString("id"));
            customParams.put(ORGNAME_KEY, object1.getDynamicObject("org").getString("name"));
            customParams.put("declaredate", object2.getDate("declaredate"));
            customParams.put("billno", object2.get("billno"));
            customParams.put("taxauthority", object2.getLong("taxauthority"));
            customParams.put("maindataid", object2.getLong("id"));
            customParams.put("type", "ccxws");
            customParams.put("templatetype", "ccxws");
            String startDate = DateUtils.format((Date)object2.getDate("declaredate"), (String)"yyyy-MM-dd");
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", DateUtils.format((Date)object2.getDate("declaredate"), (String)"yyyy-MM-dd"));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("modifytime", object1.getDate("modifytime"));
            String billstatus = object1.getString("billstatus");
            String declarestatus = object1.getString("declarestatus");
            String dataType = object1.getString("datatype");
            customParams.put("datatype", dataType);
            customParams.put("sbbid", object1.getString("id"));
            this.showDeclarePageCCXWS("ccxws", param, customParams, billstatus, declarestatus, dataType, object1);
        } else {
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
            customParams.put(ORGNAME_KEY, object.getDynamicObject("org").getString("name"));
            Date skssqq = object.getDate("skssqq");
            Date skssqz = object.getDate("skssqz");
            customParams.put("sbbid", object.getString("id"));
            customParams.put("billno", object.getString("billno"));
            customParams.put("type", type);
            customParams.put("templatetype", type);
            customParams.put("taxPayerType", type);
            customParams.put("deadLine", "month".equals(object.getString("taxlimit")) ? "aysb" : "ajsb");
            customParams.put("tcrettype", object.getString("tcrettype"));
            customParams.put("apanage", object.getString("apanage"));
            String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("taxlimit", DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
            customParams.put("taxperiod", startDate.substring(0, 7));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("modifytime", object.getDate("modifytime"));
            String billstatus = object.getString("billstatus");
            String declarestatus = object.getString("declarestatus");
            String dataType = object.getString("datatype");
            this.showDeclarePage(StringUtils.trimToEmpty((String)type), param, customParams, billstatus, declarestatus, dataType);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object taxtype = this.getModel().getValue("taxtype");
        Date datefield = (Date)this.getModel().getValue("datefield");
        if (EmptyCheckUtils.isEmpty((Object)taxtype) || EmptyCheckUtils.isEmpty((Object)datefield)) {
            return false;
        }
        if (TctsaTypeEnum.TAX_YHS.getTaxType().equals(((DynamicObject)taxtype).getString("id")) && DateUtils.stringToDate((String)"2021-05-01").compareTo(DateUtils.addMonth((Date)datefield, (int)-1)) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u53ea\u80fd\u67e52021\u5e745\u671f\u53ca\u4ee5\u540e\u5c5e\u671f\u7684\u7533\u62a5\u8fdb\u5ea6\u3002", (String)"SsbProcessQueryRptPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("group".equals(name)) {
            this.getView().refresh();
        }
    }

    private void showDeclarePage(String type, FormShowParameter param, Map<String, Object> customParams, String billstatus, String declarestatus, String dataType) {
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        OrgServiceHelper.initOrgArr((IFormView)this.getView(), (Boolean)false);
    }

    public void afterCreateNewData(EventObject e) {
        OrgServiceHelper.initOrgArr((IFormView)this.getView(), (Boolean)false);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.setBoard();
    }

    private void setBoard() {
        WizardapEnum[] wizardapEnumVals;
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        ReportListModel reportModel = (ReportListModel)reportList.getReportModel();
        int rowCount = reportModel.getRowCount();
        DynamicObjectCollection rowData = reportModel.getRowData(0, rowCount);
        List dynamicObjectList = rowData.stream().filter(r -> !"0".equalsIgnoreCase(r.getString("id"))).collect(Collectors.toList());
        Wizard wizard = (Wizard)this.getControl("wizardap");
        List stepsOptions = wizard.getStepsOptions();
        stepsOptions.clear();
        for (WizardapEnum wizardapEnumVal : wizardapEnumVals = WizardapEnum.values()) {
            StepsOption stepsOption = new StepsOption();
            stepsOption.setTitle(new LocaleString(wizardapEnumVal.getName()));
            stepsOption.setStatus(wizardapEnumVal.getStep());
            if (EmptyCheckUtils.isEmpty(dynamicObjectList)) {
                stepsOption.setDescription(new LocaleString("0.00%"));
            } else {
                BigDecimal bigDecimal = BigDecimalUtil.divideObject((Object)dynamicObjectList.stream().filter(v -> wizardapEnumVal.getFieldKeys().contains(v.getString(wizardapEnumVal.getFieldId()))).count(), (Object)dynamicObjectList.size(), (int)4);
                stepsOption.setDescription(new LocaleString(BigDecimalUtil.multiplyObject((Object)bigDecimal, (Object)100, (int)2) + "%"));
            }
            stepsOptions.add(stepsOption);
        }
        wizard.setWizardStepsOptions(stepsOptions);
    }

    public void registerListener(EventObject e) {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl(SsbQueryContainerEnum.ORG.getCode());
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent beforeF7SelectEvent) {
        OrgServiceHelper.fseven((BeforeF7SelectEvent)beforeF7SelectEvent, null, (String)"1");
    }

    private void clearUserSetting() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("formId");
        String configKey = formId + "_reportlistap_gridConfig";
        UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)configKey);
    }

    private void createDynamicCol() {
        Object val = this.getView().getModel().getValue("group");
        if (ObjectUtils.isEmpty((Object)val)) {
            return;
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List reportColumnList = listTable.getColumns();
        SsbColEnum firstColEnum = SsbTotalGroupEnum.getEnumByCode((String)String.valueOf(val)).getFirstColEnum();
        ReportColumn firstReportColumn = null;
        int index = 0;
        for (int i = 0; i < reportColumnList.size(); ++i) {
            ReportColumn temp = (ReportColumn)reportColumnList.get(i);
            if (i == 0 && temp.getFieldKey().equalsIgnoreCase(firstColEnum.getRowMetaMsgInfo().getFieldId())) break;
            if (!temp.getFieldKey().equalsIgnoreCase(firstColEnum.getRowMetaMsgInfo().getFieldId())) continue;
            firstReportColumn = temp;
            index = i;
            break;
        }
        if (null != firstReportColumn && 0 != index) {
            reportColumnList.remove(index);
            reportColumnList.add(0, firstReportColumn);
        }
    }

    public void packageData(PackageDataEvent e) {
        String text;
        ReportColumn columnDesc = (ReportColumn)e.getSource();
        DynamicObject d = e.getRowData();
        if (columnDesc.getFieldKey().equals("ssqcol") && ("0".equals(d.getString("id")) || "-1".equals(d.getString("id")) || ResManager.loadKDString((String)"\u672a\u751f\u6210\u7533\u62a5\u8868", (String)"SsbProcessQueryRptPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]).equals(d.getString("sbbnocol")))) {
            text = d.getString("ssqcol");
            e.setFormatValue((Object)("<nolink>" + text));
        }
        if (columnDesc.getFieldKey().equals("sbbnocol") && ResManager.loadKDString((String)"\u672a\u751f\u6210\u7533\u62a5\u8868", (String)"SsbProcessQueryRptPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]).equals(d.getString("sbbnocol"))) {
            text = d.getString("sbbnocol");
            e.setFormatValue((Object)("<nolink>" + text));
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        IDataModel iDataModel = this.getView().getModel();
        ReportFilter reportFilter = (ReportFilter)this.getView().getControl("reportfilterap");
        String showFields = reportFilter.getShowFilterFields();
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)showFields)) {
            List showFieldList = (List)JsonUtil.fromJson((String)showFields, List.class);
            String msg = this.formatShowFilter(showFieldList, iDataModel);
            evt.setFormatedFilterString(msg);
        }
    }

    private String formatShowFilter(List<String> fields, IDataModel model) {
        StringBuilder msg = new StringBuilder();
        BindingContext bindingContext = new BindingContext((Object)model.getDataEntity());
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(field);
            if (fieldEdit == null) {
                return null;
            }
            Object value = fieldEdit.getBindingValue(bindingContext);
            Object valDesc = this.getValueDesc(value, fieldEdit.getProperty());
            if (valDesc == null || !org.apache.commons.lang.StringUtils.isNotEmpty((String)valDesc.toString())) continue;
            if (msg.length() > 0) {
                msg.append(";  ");
            }
            msg.append(fieldEdit.getProperty().getDisplayName()).append(':').append(' ').append(valDesc);
        }
        return msg.toString();
    }

    private Object getValueDesc(Object value, IDataEntityProperty prop) {
        Object valDesc = "";
        if (value == null) {
            return valDesc;
        }
        if (!(prop instanceof BasedataProp) && !(prop instanceof MulBasedataProp)) {
            valDesc = prop instanceof ComboProp ? ((ComboProp)prop).getItemByName(value.toString()) : (prop instanceof DateProp || prop instanceof DateTimeProp ? DateUtils.format((Date)DateUtils.stringToDate((String)((String)value)), (String)"yyyy-MM") : (prop instanceof BooleanProp ? (Boolean.parseBoolean(value.toString()) ? ResManager.loadKDString((String)"\u662f", (String)"SsbProcessQueryRptPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SsbProcessQueryRptPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])) : value));
        } else if (value instanceof ArrayList) {
            ArrayList<String> valueDescList = new ArrayList<String>();
            for (Object valueArray : (List)value) {
                Object[] valArray = (Object[])valueArray;
                String newValueDesc = null;
                if (valArray.length >= 2) {
                    String string = newValueDesc = valArray[1] == null ? "" : valArray[1].toString();
                }
                if (!kd.bos.util.StringUtils.isNotEmpty(newValueDesc)) continue;
                valueDescList.add(newValueDesc);
            }
            valDesc = String.join((CharSequence)";", valueDescList);
        } else {
            Object[] valArray = (Object[])value;
            if (valArray.length >= 2) {
                valDesc = valArray[1] == null ? "" : valArray[1].toString();
            }
        }
        return valDesc;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.clearUserSetting();
        this.createDynamicCol();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        this.createTrueQFilterList(queryParam);
        super.beforeQuery(queryParam);
    }

    private void createTrueQFilterList(ReportQueryParam queryParam) {
        List itemInfos = queryParam.getFilter().getFilterItems();
        itemInfos.removeIf(item -> item.getPropName().equals("group") || item.getPropName().equals(SsbProcessQueryConstant.ORG));
        FilterItemInfo dimensionInfo = new FilterItemInfo();
        dimensionInfo.setPropName("group");
        dimensionInfo.setValue(this.getModel().getValue("group"));
        queryParam.getFilter().getFilterItems().add(dimensionInfo);
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getView().getModel().getValue(SsbProcessQueryConstant.ORG);
        if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(DEFAULT_ORGS))) {
            throw new KDBizException("user no right");
        }
        List orgids = EmptyCheckUtils.isEmpty((Object)dynamicObjects) ? Arrays.stream(this.getPageCache().get(DEFAULT_ORGS).split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList()) : dynamicObjects.stream().map(v -> ((DynamicObject)v.get(1)).getLong("id")).collect(Collectors.toList());
        FilterItemInfo org = new FilterItemInfo();
        org.setPropName(SsbProcessQueryConstant.ORG);
        org.setValue(orgids);
        queryParam.getFilter().getFilterItems().add(org);
    }

    private void showDeclarePageCCXWS(String type, FormShowParameter param, Map<String, Object> customParams, String billstatus, String declarestatus, String dataType, DynamicObject object) {
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("declared".equals(declarestatus) || "2".equals(dataType)) {
            if ("2".equals(dataType) && "A".equals(billstatus)) {
                param.setFormId("tcret_declare_import_edit");
            } else {
                param.setFormId(templateEnum.getDeclareShowPage());
            }
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get(ORGID_KEY))));
            requestModel.setTemplateType("ccxws");
            requestModel.setId(Long.valueOf(object.getLong("id")));
            requestModel.setSkssqq(DateUtils.format((Date)object.getDate("skssqq")));
            requestModel.setSkssqz(DateUtils.format((Date)object.getDate("skssqz")));
            requestModel.setOperation("read");
            requestModel.setRefresh(Boolean.valueOf(false));
            requestModel.addBusinessValue("declaremonth", (String)customParams.get("skssqq"));
            requestModel.addBusinessValue("maindataid", customParams.get("maindataid").toString());
            String templateid = object.getString("templateid");
            if (StringUtil.isNotEmpty((CharSequence)templateid)) {
                requestModel.setTemplateId(Long.valueOf(templateid));
            }
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

