/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.processquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.common.constant.SsbProcessQueryConstant;
import kd.taxc.tctsa.common.entity.RowMetaMsgInfo;
import kd.taxc.tctsa.common.entity.SbbProcessBean;
import kd.taxc.tctsa.common.enums.SsbColEnum;
import kd.taxc.tctsa.common.enums.SsbTotalGroupEnum;
import kd.taxc.tctsa.common.enums.TaxTypeComboEnum;
import kd.taxc.tctsa.common.enums.TaxTypeEndDateEnum;
import kd.taxc.tctsa.common.enums.TctsaTypeEnum;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.BizCommomUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.MetadataUtil;
import kd.taxc.tctsa.common.util.OrgUtils;
import kd.taxc.tctsa.common.util.RegisterAddressUtil;

public class SsbProcessQueryRptQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        return this.getFilter(reportQueryParam);
    }

    private DataSet getFilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List filterItemInfos = filterInfo.getFilterItems();
        if (CollectionUtils.isEmpty((Collection)filterItemInfos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SsbProcessQueryRptQueryPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        }
        FilterItemInfo orgItemInfo = null;
        FilterItemInfo groupItemInfo = null;
        FilterItemInfo dateItemInfo = null;
        for (FilterItemInfo itemInfo : filterItemInfos) {
            if (itemInfo.getPropName().equalsIgnoreCase(SsbProcessQueryConstant.ORG)) {
                orgItemInfo = itemInfo;
                continue;
            }
            if (itemInfo.getPropName().equalsIgnoreCase("group")) {
                groupItemInfo = itemInfo;
                continue;
            }
            if (!itemInfo.getPropName().equalsIgnoreCase(SsbProcessQueryConstant.DATE_FIELD)) continue;
            dateItemInfo = itemInfo;
        }
        if (null == orgItemInfo || null == groupItemInfo || null == dateItemInfo) {
            throw new KDBizException("paramter can not be null");
        }
        Date nowDate = new Date();
        String taxtype = ((DynamicObject)filterInfo.getValue(SsbProcessQueryConstant.TAX_TYPE)).getString("id");
        ArrayList<Long> needRecordOrgIds = new ArrayList<Long>(10);
        ArrayList<Long> anciRecordOrgIds = new ArrayList<Long>(10);
        List<Object> mapList = new ArrayList(10);
        ArrayList<List<Map<String, Object>>> mapListList = new ArrayList<List<Map<String, Object>>>(10);
        for (Long orgid : (List)orgItemInfo.getValue()) {
            try {
                mapList = TctsaTypeEnum.TAX_YHS.getTaxType().equals(taxtype) ? this.decideTaxTypeIsEnable(orgid, TctsaTypeEnum.TAX_YHS.getTaxPre(), dateItemInfo.getDate()) : RegisterAddressUtil.findOrgApplyTypeTaxTypeEndDate((Object)orgid, (String)taxtype, (Date)dateItemInfo.getDate());
            }
            catch (KDBizException e) {
                continue;
            }
            anciRecordOrgIds.add(orgid);
            if (EmptyCheckUtils.isEmpty(mapList)) continue;
            mapListList.add(mapList);
            needRecordOrgIds.add(orgid);
        }
        QFilter orgQFilter = new QFilter("org", "in", needRecordOrgIds);
        QFilter datesQFilter = new QFilter("skssqq", ">=", (Object)DateUtils.getFirstDateOfYear((Date)DateUtils.addMonth((Date)dateItemInfo.getDate(), (int)-1)));
        QFilter dateeQFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getLastDateOfMonth((Date)dateItemInfo.getDate()));
        QFilter typeFilter = new QFilter("type", "in", (Object)TaxTypeEndDateEnum.getEnumByCode((String)taxtype).getTypes());
        DynamicObjectCollection existRecords = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,skssqq,skssqz,paystatus,org,type,declarestatus,taxlimit,billno", (QFilter[])new QFilter[]{orgQFilter, datesQFilter, dateeQFilter, typeFilter});
        ArrayList<SbbProcessBean> aqsbbProcessBeanList = new ArrayList<SbbProcessBean>(16);
        ArrayList<SbbProcessBean> acsbbProcessBeanList = new ArrayList<SbbProcessBean>(16);
        if (TctsaTypeEnum.TAX_YHS.getTaxType().equals(taxtype)) {
            for (DynamicObject d : existRecords) {
                QFilter qfilter = new QFilter("sbbid", "=", (Object)String.valueOf(d.getLong("id")));
                QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"SsbProcessQueryRptQueryPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                DynamicObjectCollection dCollection = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)MetadataUtil.getAllFieldString((String)"tcret_ccxws_zb_hb"), (QFilter[])new QFilter[]{qfilter, taxtypeFilter});
                if (null == dCollection || dCollection.size() <= 0) continue;
                dCollection.stream().forEach(v -> aqsbbProcessBeanList.add(new SbbProcessBean(v.getDate("startdate"), v.getDate("enddate"), d.getString("type"), Long.valueOf(d.getLong("org")), v.getString("taxtype"), Long.valueOf(d.getLong("id")), d.getString("billno"), d.getString("declarestatus"), d.getString("paystatus"), "aqsb")));
            }
            QFilter orgfilter = new QFilter("org", "in", anciRecordOrgIds);
            QFilter declaretypeFilter = new QFilter("declaretype", "=", (Object)"acsb");
            QFilter skssqqFilter = new QFilter("skssqq", "<=", (Object)nowDate);
            QFilter sbbbillnoFilter = new QFilter("sbbbillno", "=", (Object)ResManager.loadKDString((String)"\u672a\u751f\u6210\u7533\u62a5\u8868", (String)"SsbProcessQueryRptQueryPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            DynamicObjectCollection acsbCollection = QueryServiceHelper.query((String)"tcret_yhs_tax_source_info", (String)MetadataUtil.getAllFieldString((String)"tcret_yhs_tax_source_info"), (QFilter[])new QFilter[]{orgfilter, declaretypeFilter, skssqqFilter, sbbbillnoFilter});
            if (null != acsbCollection && acsbCollection.size() > 0) {
                acsbCollection.stream().forEach(v -> acsbbProcessBeanList.add(new SbbProcessBean(v.getDate("skssqq"), v.getDate("skssqz"), "yhs", Long.valueOf(v.getLong("org")), "", Long.valueOf(v.getLong("id")), v.getString("sbbbillno"), "undeclare", "0", "acsb")));
            }
        }
        ArrayList<String> listTemp = new ArrayList<String>();
        Iterator it = acsbbProcessBeanList.iterator();
        while (it.hasNext()) {
            SbbProcessBean a = (SbbProcessBean)it.next();
            String combDate = a.getOrg() + "-" + a.getSkssqq() + "-" + a.getSkssqq();
            if (listTemp.contains(combDate)) {
                it.remove();
                continue;
            }
            listTemp.add(combDate);
        }
        if (null == groupItemInfo) {
            throw new KDBizException("paramter can not be null");
        }
        List cols = SsbColEnum.createDynamicCol((String)SsbTotalGroupEnum.getEnumByCode((String)String.valueOf(groupItemInfo.getValue())).getFirstColEnum().getRowMetaMsgInfo().getFieldId());
        return this.fillRecordAndFilter(existRecords, mapListList, cols, aqsbbProcessBeanList, acsbbProcessBeanList, taxtype);
    }

    private List<Map<String, Object>> decideTaxTypeIsEnable(Long orgid, String taxtype, Date date) {
        DynamicObject taxmain = TaxcMainServiceHelper.getTaxcMainSingleEnable((Long)Long.parseLong(String.valueOf(orgid)), (String)taxtype, (String)"1");
        if (taxmain == null) {
            String orgname = OrgUtils.getOrgNameById((String)String.valueOf(orgid));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7a0e\u52a1\u4fe1\u606f\u7ef4\u62a4\u5df2\u5f00\u542f\u5370\u82b1\u7a0e\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011\u4fe1\u606f\u3002", (String)"SsbProcessQueryRptQueryPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), orgname));
        }
        TaxTypeComboEnum taxTypeComboEnum = TaxTypeComboEnum.getEnumByCode((String)taxtype);
        Date lastMonth = DateUtils.addMonth((Date)date, (int)-1);
        String formid = taxTypeComboEnum.getFormId();
        QFilter orgqFilter = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        QFilter taxtypeqFilter = new QFilter("taxtype", "=", (Object)TaxTypeComboEnum.YHS.getCode());
        QFilter modfiydateqFilter = new QFilter("modifydate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)lastMonth));
        DynamicObjectCollection taxtypeColls = QueryServiceHelper.query((String)formid, (String)"id,modifydate,modifier,entryentity.taxrate,entryentity.period as period,entryentity.isverify,entryentity.hdrate,entryentity.effectivedate as effectivedate,entryentity.expirydate as expirydate", (QFilter[])new QFilter[]{orgqFilter, taxtypeqFilter, modfiydateqFilter});
        List<DynamicObject> lastOneList = SsbProcessQueryRptQueryPlugin.getTaxVer(taxtypeColls, DateUtils.getLastDateOfMonth((Date)lastMonth));
        List<Object> matchList = new ArrayList(16);
        List<Object> taxPeriodList = new ArrayList(16);
        if (null != lastOneList && lastOneList.size() > 0) {
            matchList = lastOneList.stream().filter(v -> v.getDate("effectivedate").compareTo(DateUtils.getLastDateOfMonth((Date)lastMonth)) <= 0 && v.getDate("expirydate").compareTo(DateUtils.getLastDateOfMonth((Date)lastMonth)) >= 0).collect(Collectors.toList());
            taxPeriodList = matchList.stream().map(v -> v.getString("period")).distinct().collect(Collectors.toList());
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(10);
        if (taxPeriodList != null && taxPeriodList.size() > 0) {
            taxPeriodList.forEach(v -> {
                HashMap<String, Object> resMap = new HashMap<String, Object>(16);
                resMap.put("orgid", orgid);
                Date startdate = null;
                Date enddate = null;
                int month = DateUtils.getMonthOfDate((Date)date);
                String taxlimit = "";
                if ("month".equals(v)) {
                    startdate = DateUtils.getFirstDateOfMonth((Date)lastMonth);
                    enddate = DateUtils.getLastDateOfMonth((Date)lastMonth);
                    taxlimit = "month";
                } else if ("season".equals(v)) {
                    if (month == 1 || month == 4 || month == 7 || month == 10) {
                        startdate = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)date, (int)-3));
                        enddate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfSeason((Date)DateUtils.addMonth((Date)date, (int)-3)));
                        taxlimit = "season";
                    }
                } else if ("halfyear".equals(v)) {
                    if (month == 1 || month == 7) {
                        startdate = DateUtils.getFirstDateOfHalfYear((Date)DateUtils.addMonth((Date)date, (int)-6));
                        enddate = DateUtils.getLastDateOfHalfYear((Date)DateUtils.addMonth((Date)date, (int)-6));
                        taxlimit = "halfyear";
                    }
                } else if ("year".equals(v) && month == 1) {
                    startdate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)date, (int)-1));
                    enddate = DateUtils.getLastDateOfYear((Date)DateUtils.addYear((Date)date, (int)-1));
                    taxlimit = "year";
                }
                if (startdate != null && enddate != null) {
                    resMap.put("startdate", startdate);
                    resMap.put("enddate", enddate);
                    resMap.put("taxlimit", taxlimit);
                    mapList.add(resMap);
                }
            });
        }
        return mapList;
    }

    private DataSet fillRecordAndFilter(DynamicObjectCollection existRecords, List<List<Map<String, Object>>> mapListList, List<RowMetaMsgInfo> cols, List<SbbProcessBean> aqsbbProcessBeanList, List<SbbProcessBean> acsbbProcessBeanList, String taxtype) {
        ArrayList colls = new ArrayList(10);
        RowMetaMsgInfo groupCol = cols.get(0);
        HashMap<String, Object> resRow = null;
        HashMap<String, Object> acRow = null;
        for (List<Map<String, Object>> tempMapList : mapListList) {
            for (Map<String, Object> tempMap : tempMapList) {
                Date compareenddate;
                Date comparestartdate;
                Long compareorgid;
                Long orgid = (Long)tempMap.get("orgid");
                Date startdate = (Date)tempMap.get("startdate");
                Date enddate = (Date)tempMap.get("enddate");
                String taxlimit = (String)tempMap.get("taxlimit");
                boolean isExist = false;
                if (TctsaTypeEnum.TAX_YHS.getTaxType().equals(taxtype)) {
                    if (null != aqsbbProcessBeanList && aqsbbProcessBeanList.size() > 0) {
                        for (SbbProcessBean sbbProcessBean : aqsbbProcessBeanList) {
                            compareorgid = sbbProcessBean.getOrg();
                            comparestartdate = sbbProcessBean.getSkssqq();
                            compareenddate = sbbProcessBean.getSkssqz();
                            if (!orgid.equals(compareorgid) || !DateUtils.format((Date)startdate).equalsIgnoreCase(DateUtils.format((Date)comparestartdate)) || !DateUtils.format((Date)enddate).equalsIgnoreCase(DateUtils.format((Date)compareenddate))) continue;
                            isExist = true;
                            resRow = new HashMap(16);
                            resRow.put("orgid", orgid);
                            resRow.put("skssqq", comparestartdate);
                            resRow.put("skssqz", compareenddate);
                            resRow.put("type", sbbProcessBean.getType());
                            resRow.put("declarestatus", sbbProcessBean.getDeclarestatus());
                            resRow.put("paystatus", sbbProcessBean.getPaystatus());
                            resRow.put("id", sbbProcessBean.getId());
                            resRow.put("sbbno", sbbProcessBean.getBillno());
                        }
                    }
                    if (!isExist) {
                        resRow = new HashMap<String, Object>(16);
                        resRow.put("orgid", orgid);
                        resRow.put("skssqq", startdate);
                        resRow.put("skssqz", enddate);
                        resRow.put("type", "0");
                        resRow.put("declarestatus", "undeclare");
                        resRow.put("paystatus", "0");
                        resRow.put("id", "-1");
                        resRow.put("sbbno", "");
                    }
                } else {
                    for (DynamicObject existTemp : existRecords) {
                        compareorgid = existTemp.getLong("org");
                        comparestartdate = existTemp.getDate("skssqq");
                        compareenddate = existTemp.getDate("skssqz");
                        String comparetaxlimit = existTemp.getString("taxlimit");
                        if (!orgid.equals(compareorgid) || !DateUtils.format((Date)startdate).equalsIgnoreCase(DateUtils.format((Date)comparestartdate)) || !DateUtils.format((Date)enddate).equalsIgnoreCase(DateUtils.format((Date)compareenddate)) || !taxlimit.equalsIgnoreCase(comparetaxlimit)) continue;
                        isExist = true;
                        resRow = new HashMap(16);
                        resRow.put("orgid", orgid);
                        resRow.put("skssqq", comparestartdate);
                        resRow.put("skssqz", compareenddate);
                        resRow.put("type", existTemp.get("type"));
                        resRow.put("declarestatus", existTemp.get("declarestatus"));
                        resRow.put("paystatus", existTemp.get("paystatus"));
                        resRow.put("id", existTemp.get("id"));
                        resRow.put("sbbno", existTemp.get("billno"));
                    }
                    if (!isExist) {
                        resRow = new HashMap(16);
                        resRow.put("orgid", orgid);
                        resRow.put("skssqq", startdate);
                        resRow.put("skssqz", enddate);
                        resRow.put("type", "0");
                        resRow.put("declarestatus", "undeclare");
                        resRow.put("paystatus", "0");
                        resRow.put("id", "-1");
                        resRow.put("sbbno", "");
                    }
                }
                colls.add(resRow);
            }
        }
        if (TctsaTypeEnum.TAX_YHS.getTaxType().equals(taxtype) && null != acsbbProcessBeanList && acsbbProcessBeanList.size() > 0) {
            for (SbbProcessBean sbbProcessBean : acsbbProcessBeanList) {
                Long compareorgid = sbbProcessBean.getOrg();
                Date comparestartdate = sbbProcessBean.getSkssqq();
                Date compareenddate = sbbProcessBean.getSkssqz();
                acRow = new HashMap<String, Object>(16);
                acRow.put("orgid", compareorgid);
                acRow.put("skssqq", comparestartdate);
                acRow.put("skssqz", compareenddate);
                acRow.put("type", sbbProcessBean.getType());
                acRow.put("declarestatus", sbbProcessBean.getDeclarestatus());
                acRow.put("paystatus", sbbProcessBean.getPaystatus());
                acRow.put("id", sbbProcessBean.getId());
                acRow.put("sbbno", sbbProcessBean.getBillno());
                colls.add(acRow);
            }
        }
        Map<String, List<Map>> key2GroupListMap = colls.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.get(groupCol.getQueryFiled()))));
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        for (Map.Entry<String, List<Map>> entry : key2GroupListMap.entrySet()) {
            Object[] resRowData;
            for (Map map : entry.getValue()) {
                resRowData = this.createRow(map, cols);
                coll.add(resRowData);
            }
            resRowData = this.createTotalRow(entry.getValue().get(0), cols, entry.getValue().size());
            coll.add(resRowData);
        }
        RowMeta rowMeta = BizCommomUtil.createRowMeta(cols);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "ssbprocessqueryrpt")).createDataSet(new Input[]{inputs});
    }

    private Object[] createTotalRow(Map<String, Object> tempMap, List<RowMetaMsgInfo> cols, int totalSize) {
        Object[] row = new Object[cols.size()];
        RowMetaMsgInfo firstCol = cols.get(0);
        row[0] = tempMap.get(firstCol.getQueryFiled());
        for (int i = 1; i < cols.size(); ++i) {
            row[i] = cols.get(i).getFieldId().equalsIgnoreCase(SsbColEnum.SQSSQ.getRowMetaMsgInfo().getFieldId()) ? Integer.valueOf(totalSize) : (cols.get(i).getFieldId().equalsIgnoreCase(SsbColEnum.ID.getRowMetaMsgInfo().getFieldId()) ? Integer.valueOf(0) : "");
        }
        return row;
    }

    private Object[] createRow(Map<String, Object> tempMap, List<RowMetaMsgInfo> cols) {
        Object[] row = new Object[cols.size()];
        int index = 0;
        for (RowMetaMsgInfo ssbColEnum : cols) {
            if (ssbColEnum.getFieldId().equalsIgnoreCase(SsbColEnum.SQSSQ.getRowMetaMsgInfo().getFieldId())) {
                String dbField = ssbColEnum.getQueryFiled();
                String[] dbFields = dbField.split(",");
                row[index++] = DateUtils.format((Date)((Date)tempMap.get(dbFields[0])), (String)DateUtils.YYYYMMDD_CHINESE) + "~" + DateUtils.format((Date)((Date)tempMap.get(dbFields[1])), (String)DateUtils.YYYYMMDD_CHINESE);
                continue;
            }
            row[index++] = tempMap.get(ssbColEnum.getQueryFiled());
        }
        return row;
    }

    private static List<DynamicObject> getTaxVer(DynamicObjectCollection taxtypeColls, Date lastDateOfMonth) {
        if (null == taxtypeColls || 0 == taxtypeColls.size()) {
            return null;
        }
        Map.Entry<Object, Object> lastone2 = null;
        Map<Object, Object> collSortMap = new LinkedHashMap(16);
        List<Object> lastoneList = new ArrayList<DynamicObject>(16);
        Map<Date, List<DynamicObject>> collMap = taxtypeColls.stream().collect(Collectors.groupingBy(v -> v.getDate("modifydate")));
        collSortMap = SsbProcessQueryRptQueryPlugin.sortMap(collMap);
        if (collMap.size() > 0) {
            for (Map.Entry<Object, Object> lastone2 : collSortMap.entrySet()) {
            }
            if (null != lastone2) {
                Date date = (Date)lastone2.getKey();
                lastoneList = (List)lastone2.getValue();
            }
        }
        return lastoneList;
    }

    public static Map<Date, List<DynamicObject>> sortMap(Map<Date, List<DynamicObject>> map) {
        Set<Map.Entry<Date, List<DynamicObject>>> mapEntries = map.entrySet();
        LinkedList<Map.Entry<Date, List<DynamicObject>>> result = new LinkedList<Map.Entry<Date, List<DynamicObject>>>(mapEntries);
        Collections.sort(result, (d1, d2) -> ((Date)d1.getKey()).compareTo((Date)d2.getKey()));
        LinkedHashMap<Date, List<DynamicObject>> linkMap = new LinkedHashMap<Date, List<DynamicObject>>(16);
        for (Map.Entry entry : result) {
            linkMap.put((Date)entry.getKey(), (List<DynamicObject>)entry.getValue());
        }
        return linkMap;
    }
}

