/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.tctsa.common.entity.EnterpriseCard;
import kd.taxc.tctsa.common.enums.PeriodEnum;
import kd.taxc.tctsa.common.helper.FixedFillHandlerHelper;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class EnterpriseFillItemPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(EnterpriseFillItemPlugin.class);
    private static final String ORG = "org";
    private static final String NUMBER = "number";
    private static final String TCTSA_REPORT_ITEMS = "tctsa_report_items";
    private static final String LABELENTITY = "labelentity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final List<Integer> SKSSQQMONTHS = Arrays.asList(1, 4, 7, 10);
    private static final List<Integer> HALFMONTHS = Arrays.asList(1, 7);

    public void initialize() {
        CardEntry cardList = (CardEntry)this.getView().getControl(ENTRYENTITY1);
        cardList.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.initEnterData(false);
    }

    private void handlerEnterpriseFill(long orgid, String fillPeriod, boolean isYouClick) {
        DynamicObject[] summaries = this.getSummaries();
        String periodList = Arrays.stream(summaries).filter(s -> "1".equals(s.getString("enable"))).map(v -> v.getString("period")).distinct().collect(Collectors.joining(","));
        this.getPageCache().put("periodList", periodList);
        QFilter qfilter = new QFilter("fillperiod", "=", this.getModel().getValue("fillperiod"));
        qfilter.and(new QFilter(ORG, "=", (Object)orgid));
        qfilter.and(new QFilter("skssqq", "=", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue("skssqq")))));
        qfilter.and(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)((Date)this.getModel().getValue("skssqz")))));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tctsa_fixed_filling_query", (String)"fillperiod,number,name,amount,decimal,sxcontent,billstatus,modifier,skssqq,skssqz,org,modifytime", (QFilter[])new QFilter[]{qfilter});
        Map<String, List<DynamicObject>> taxmainGroup = dynamicObjectCollection.stream().collect(Collectors.groupingBy(s -> s.getString(NUMBER)));
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (!isYouClick) {
            this.getModel().deleteEntryData(ENTRYENTITY1);
        }
        Map<String, String> map = this.getInfoByOrgIdFromErp(String.valueOf(orgid), NUMBER, "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank");
        Label totalName = (Label)this.getControl("labelap2");
        totalName.setText(String.format(ResManager.loadKDString((String)"[%s]\u672c\u5e74\u5ea6\u5f85\u586b\u62a5\u6e05\u5355", (String)"EnterpriseFillItemPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), map.get("name")));
        ArrayList<String> numberList = new ArrayList<String>(16);
        int count = 0;
        for (DynamicObject summary : summaries) {
            if (null != fillPeriod && "1".equals(summary.getString("enable")) && fillPeriod.equals(summary.getString("period"))) {
                int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("id", summary.get("id"), row);
                this.getModel().setValue(NUMBER, summary.get(NUMBER), row);
                this.getModel().setValue("name", summary.get("name"), row);
                this.getModel().setValue("amount", taxmainGroup.get(summary.get(NUMBER)) != null ? taxmainGroup.get(summary.get(NUMBER)).get(0).get("amount") : null, row);
                this.getModel().setValue("decimal", taxmainGroup.get(summary.get(NUMBER)) != null ? taxmainGroup.get(summary.get(NUMBER)).get(0).get("decimal") : null, row);
                this.getModel().setValue("sxcontent", taxmainGroup.get(summary.get(NUMBER)) != null ? taxmainGroup.get(summary.get(NUMBER)).get(0).get("sxcontent") : null, row);
                this.getModel().setValue("type", summary.get("group"), row);
                this.getModel().setValue("fillingtype", summary.get("fillingtype"), row);
                this.getModel().setValue("period", summary.get("period"), row);
                this.getModel().setValue("taxtype", summary.get("taxtype"), row);
                DynamicObjectCollection labelsCollection = summary.getDynamicObjectCollection(LABELENTITY);
                this.getModel().setValue("labelid", (Object)labelsCollection.stream().map(v -> v.getDynamicObject("labelid").get("id")).collect(Collectors.toList()).toArray(), row);
                this.getModel().setValue("description", summary.get("description"), row);
                this.getModel().setValue("billstatus", taxmainGroup.get(summary.get(NUMBER)) != null ? taxmainGroup.get(summary.get(NUMBER)).get(0).get("billstatus") : null, row);
                this.getModel().setValue("modifier", taxmainGroup.get(summary.get(NUMBER)) != null ? taxmainGroup.get(summary.get(NUMBER)).get(0).get("modifier") : null, row);
                this.getModel().setValue("modifydate", taxmainGroup.get(summary.get(NUMBER)) != null ? taxmainGroup.get(summary.get(NUMBER)).get(0).get("modifytime") : "", row);
                numberList.add(summary.getString(NUMBER));
            }
            if (!"1".equals(summary.getString("enable"))) continue;
            ++count;
        }
        this.getPageCache().put("numberList", String.join((CharSequence)",", numberList));
        if (count == 0) {
            return;
        }
        if (!isYouClick) {
            this.loadCardData(orgid, periodList, summaries);
        }
    }

    private DynamicObject[] getSummaries() {
        ArrayList<QFilter> Qfilters = new ArrayList<QFilter>();
        QFilter sharingorg = new QFilter("planentity.orgentity.orgid", "=", (Object)Long.parseLong(((DynamicObject)this.getView().getModel().getValue(ORG)).getString("id")));
        QFilter enable = new QFilter("planentity.status", "=", (Object)"1");
        Qfilters.add(sharingorg);
        Qfilters.add(enable);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctsa_report_item_assign", (String)"id,planentity.orgentity.id as orgentityid,planentity.riskentity.riskid as riskid", (QFilter[])Qfilters.toArray(new QFilter[Qfilters.size()]));
        HashSet<Long> riskIdList = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            riskIdList.add(dynamicObject.getLong("riskid"));
        }
        return BusinessDataServiceHelper.load((Object[])riskIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTSA_REPORT_ITEMS));
    }

    private void loadCardData(Long orgid, String periodList, DynamicObject[] summaries) {
        String allNumberList = Arrays.stream(summaries).filter(s -> "1".equals(s.getString("enable"))).map(v -> v.getString(NUMBER)).distinct().collect(Collectors.joining(","));
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)new Date());
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)new Date());
        QFilter qfilter = new QFilter(ORG, "=", (Object)orgid);
        if (EmptyCheckUtils.isNotEmpty((Object)allNumberList)) {
            qfilter.and(new QFilter(NUMBER, "in", Arrays.asList(allNumberList.split(","))));
        }
        qfilter.and(new QFilter("skssqq", ">=", (Object)firstDateOfYear));
        qfilter.and(new QFilter("skssqz", "<=", (Object)lastDateOfYear));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctsa_fixed_filling_query", (String)"fillperiod,number,name,amount,skssqq,skssqz,org,tstatus,billstatus", (QFilter[])new QFilter[]{qfilter});
        this.getModel().deleteEntryData(ENTRYENTITY1);
        Map<String, Long> moreObjMap = Arrays.stream(summaries).collect(Collectors.groupingBy(p -> p.getString("period"), Collectors.counting()));
        if (dynamicObjects.size() == 0) {
            this.loadCard(null, firstDateOfYear, periodList, orgid, moreObjMap);
        } else {
            this.loadCard(dynamicObjects, firstDateOfYear, periodList, orgid, moreObjMap);
        }
    }

    private void loadCard(DynamicObjectCollection dynamicObjects, Date firstDateOfYear, String periodList, Long orgid, Map<String, Long> moreObjMap) {
        ArrayList<EnterpriseCard> priseList = new ArrayList<EnterpriseCard>(16);
        this.packageAllPriseList(priseList, firstDateOfYear, periodList);
        if (null != dynamicObjects && dynamicObjects.size() > 0) {
            Map<String, List<DynamicObject>> fillperiodGroups = dynamicObjects.stream().collect(Collectors.groupingBy(s -> s.getString("fillperiod")));
            ArrayList<EnterpriseCard> oldEnterpriseList = new ArrayList<EnterpriseCard>(16);
            for (Map.Entry<String, List<DynamicObject>> entry : fillperiodGroups.entrySet()) {
                String fillperiod = entry.getKey();
                Map<Date, List<DynamicObject>> skssqqGroups = entry.getValue().stream().collect(Collectors.groupingBy(s -> s.getDate("skssqq")));
                for (Map.Entry<Date, List<DynamicObject>> skssqqEntry : skssqqGroups.entrySet()) {
                    List billstatusList = skssqqEntry.getValue().stream().map(s -> s.getString("billstatus")).collect(Collectors.toList());
                    int icount = 0;
                    for (String billstatus : billstatusList) {
                        if (!"C".equals(billstatus)) continue;
                        ++icount;
                    }
                    Long count = moreObjMap.get(fillperiod) == null ? Long.valueOf(0L) : moreObjMap.get(fillperiod);
                    String tstatus = count == (long)icount ? "2" : "1";
                    oldEnterpriseList.add(new EnterpriseCard(PeriodEnum.getCardNameeByPeriod((String)entry.getKey()), tstatus, skssqqEntry.getKey(), skssqqEntry.getValue().get(0).getDate("skssqz")));
                }
            }
            for (EnterpriseCard enterp : oldEnterpriseList) {
                Iterator its = priseList.iterator();
                while (its.hasNext()) {
                    EnterpriseCard enter = (EnterpriseCard)its.next();
                    if (!enter.getFillperiod().equals(enterp.getFillperiod()) || !enter.getRangeSq().equals(enterp.getRangeSq())) continue;
                    if ("2".equals(enterp.getTstatus())) {
                        its.remove();
                        continue;
                    }
                    if (!"1".equals(enterp.getTstatus())) continue;
                    enter.setTstatus("1");
                }
            }
            this.setCardData(priseList, orgid);
        } else {
            this.setCardData(priseList, orgid);
        }
    }

    private void setCardData(List<EnterpriseCard> priseList, Long orgid) {
        for (EnterpriseCard enc : priseList) {
            int index = this.getModel().createNewEntryRow(ENTRYENTITY1);
            this.getModel().setValue("periodn", (Object)enc.getFillperiod(), index);
            this.getModel().setValue("range_skssqq", (Object)enc.getRangeSq(), index);
            this.getModel().setValue("range_skssqz", (Object)enc.getRangeSz(), index);
            this.getModel().setValue("tstatus", (Object)enc.getTstatus(), index);
            this.getModel().setValue("hideorg", (Object)orgid, index);
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List rows = evt.getNewRows();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rows)) {
            for (Integer row : rows) {
                String periodn = (String)this.getModel().getValue("periodn", row.intValue());
                Date rangeSkssqq = (Date)this.getModel().getValue("range_skssqq", row.intValue());
                Date rangeSkssqz = (Date)this.getModel().getValue("range_skssqz", row.intValue());
                Long orgid = Long.parseLong(((DynamicObject)this.getModel().getValue("hideorg", row.intValue())).getString("id"));
                this.getPageCache().put("isChange", "1");
                this.getView().getModel().setValue(ORG, (Object)orgid);
                this.setFillPeriod(DateUtils.getFirstDateOfMonth((Date)rangeSkssqq), DateUtils.getLastDateOfMonth2((Date)rangeSkssqz));
                this.getPageCache().put("isChange", "0");
                this.getView().getModel().setValue("fillperiod", (Object)PeriodEnum.getPeriodByCardName((String)periodn));
                this.handlerEnterpriseFill(orgid, (String)this.getModel().getValue("fillperiod"), true);
            }
        }
    }

    private void packageAllPriseList(List<EnterpriseCard> priseList, Date firstDateOfYear, String periodList) {
        int y = 0;
        int z = 0;
        for (int i = 0; i <= 18; ++i) {
            if (i >= 0 && i <= 11) {
                if (periodList == null || !periodList.contains("1")) continue;
                priseList.add(new EnterpriseCard(ResManager.loadKDString((String)"\u6708\u5ea6", (String)"EnterpriseFillItemPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "0", DateUtils.addMonth((Date)firstDateOfYear, (int)i), DateUtils.getLastDateOfMonth2((Date)DateUtils.addMonth((Date)firstDateOfYear, (int)i))));
                continue;
            }
            if (i >= 12 && i <= 15) {
                if (periodList == null || !periodList.contains("2")) continue;
                priseList.add(new EnterpriseCard(ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"EnterpriseFillItemPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "0", DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)firstDateOfYear, (int)y)), DateUtils.getLastDateOfSeason((Date)DateUtils.addMonth((Date)firstDateOfYear, (int)y))));
                y += 3;
                continue;
            }
            if (i >= 16 && i <= 17) {
                if (periodList == null || !periodList.contains("3")) continue;
                priseList.add(new EnterpriseCard(ResManager.loadKDString((String)"\u534a\u5e74\u5ea6", (String)"EnterpriseFillItemPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "0", DateUtils.getFirstDateOfHalfYear((Date)DateUtils.addMonth((Date)firstDateOfYear, (int)z)), DateUtils.getLastDateOfHalfYear((Date)DateUtils.addMonth((Date)firstDateOfYear, (int)z))));
                z += 6;
                continue;
            }
            if (periodList == null || !periodList.contains("4")) continue;
            priseList.add(new EnterpriseCard(ResManager.loadKDString((String)"\u5e74\u5ea6", (String)"EnterpriseFillItemPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), "0", DateUtils.getFirstDateOfYear((Date)firstDateOfYear), DateUtils.getLastDateOfYear((Date)firstDateOfYear)));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("donothing".equals(args.getOperateKey())) {
                Boolean ispass = this.checkDataValid();
                if (!ispass.booleanValue()) {
                    OperatorDialogUtils.operateDialogByAppid((String)"tctsa", (String)"tctsa_enterprise_fixed_fi", (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"EnterpriseFillItemPlugin_13", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"EnterpriseFillItemPlugin_14", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
                if (rowCount == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u671f\u6682\u65e0\u53ef\u4fdd\u5b58\u7684\u586b\u62a5\u6570\u636e\u3002", (String)"EnterpriseFillItemPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                    OperatorDialogUtils.operateDialogByAppid((String)"tctsa", (String)"tctsa_enterprise_fixed_fi", (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"EnterpriseFillItemPlugin_13", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"EnterpriseFillItemPlugin_14", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.saveDatatoFillQuery();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"EnterpriseFillItemPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                DynamicObject[] summaries = this.getSummaries();
                this.loadCardData(Long.parseLong(((DynamicObject)this.getView().getModel().getValue(ORG)).getString("id")), this.getPageCache().get("periodList"), summaries);
                OperatorDialogUtils.operateDialogByAppid((String)"tctsa", (String)"tctsa_enterprise_fixed_fi", (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"EnterpriseFillItemPlugin_13", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EnterpriseFillItemPlugin_15", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            } else if ("donothingsubmit".equals(args.getOperateKey())) {
                int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(8);
                for (int row = 0; row < rowCount; ++row) {
                    QFilter qfilter = new QFilter("fillperiod", "=", this.getModel().getValue("fillperiod"));
                    qfilter.and(new QFilter(ORG, "=", (Object)((DynamicObject)this.getView().getModel().getValue(ORG)).getLong("id")));
                    qfilter.and(new QFilter(NUMBER, "=", this.getModel().getValue(NUMBER, row)));
                    qfilter.and(new QFilter("skssqq", "=", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue("skssqq")))));
                    qfilter.and(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)((Date)this.getModel().getValue("skssqz")))));
                    DynamicObject fixedFillingDyo = BusinessDataServiceHelper.loadSingle((String)"tctsa_fixed_filling_query", (String)"id,fillperiod,number,name,amount,decimal,sxcontent,skssqq,skssqz,org,modifytime,billstatus,modifier,tstatus,entryentity.labelid", (QFilter[])new QFilter[]{qfilter});
                    if (fixedFillingDyo == null || !"A".equals(fixedFillingDyo.getString("billstatus"))) continue;
                    updateList.add(fixedFillingDyo);
                }
                if (CollectionUtils.isNotEmpty(updateList)) {
                    Boolean haveSingleFlow = FixedFillHandlerHelper.haveFlow((Boolean)false);
                    Boolean haveBatchFlow = FixedFillHandlerHelper.haveFlow((Boolean)true);
                    if (haveBatchFlow.booleanValue() && haveSingleFlow.booleanValue()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u4e2a\u5ba1\u6279\u6d41\u548c\u6279\u91cf\u5ba1\u6279\u6d41\u914d\u7f6e\u91cd\u590d\u3002", (String)"EnterpriseFillItemPlugin_18", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    List ids = updateList.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
                    if (haveBatchFlow.booleanValue()) {
                        FixedFillHandlerHelper.executeBatchFixedFillOperate(ids, (String)"submit", (IFormView)this.getView());
                    } else {
                        OperationResult localResult = OperationServiceHelper.executeOperate((String)"submit", (String)"tctsa_fixed_filling_query", (DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                        if (!localResult.isSuccess()) {
                            this.getView().showOperationResult(localResult);
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(updateList)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"EnterpriseFillItemPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                    OperatorDialogUtils.operateDialogByAppid((String)"tctsa", (String)"tctsa_enterprise_fixed_fi", (String)ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"EnterpriseFillItemPlugin_16", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"EnterpriseFillItemPlugin_10", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u63d0\u4ea4\u6682\u5b58\u7684\u6570\u636e\uff0c\u5f53\u524d\u6ca1\u6709\u53ef\u63d0\u4ea4\u7684\u6570\u636e\u3002", (String)"EnterpriseFillItemPlugin_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                    OperatorDialogUtils.operateDialogByAppid((String)"tctsa", (String)"tctsa_enterprise_fixed_fi", (String)ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"EnterpriseFillItemPlugin_16", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"EnterpriseFillItemPlugin_17", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                }
            }
        }
        this.initEnterData(true);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("refresh".equals(evt.getItemKey())) {
            this.initEnterData(true);
        }
    }

    private void initEnterData(boolean isRefresh) {
        OrgServiceHelper.initMainOrgEnable((IFormView)this.getView());
        if (!isRefresh) {
            this.setFillPeriod(DateUtils.getFirstDateOfMonth((Date)new Date()), DateUtils.getLastDateOfMonth2((Date)new Date()));
        }
        if (this.getView().getModel().getValue(ORG) == null) {
            Label totalName = (Label)this.getControl("labelap2");
            totalName.setText(ResManager.loadKDString((String)"\u672c\u5e74\u5ea6\u5f85\u586b\u62a5\u6e05\u5355", (String)"EnterpriseFillItemPlugin_11", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            this.getModel().deleteEntryData(ENTRYENTITY1);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7", (String)"EnterpriseFillItemPlugin_12", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.handlerEnterpriseFill(Long.parseLong(((DynamicObject)this.getView().getModel().getValue(ORG)).getString("id")), (String)this.getModel().getValue("fillperiod"), false);
    }

    private Boolean checkDataValid() {
        Boolean ispass;
        if (null == this.getView().getModel().getValue(ORG) || null == this.getModel().getValue("fillperiod") || null == this.getModel().getValue("skssqq") || null == this.getModel().getValue("skssqz")) {
            if (null == this.getView().getModel().getValue(ORG)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EnterpriseFillItemPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u9700\u4e3a\u5b8c\u6574\u7684\u586b\u62a5\u5468\u671f\uff0c\u4f8b\u5982\uff1a\u6574\u6708\u3001\u6574\u5b63\u3001\u6574\u534a\u5e74\u6216\u6574\u5e74\u3002", (String)"EnterpriseFillItemPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (null != this.getModel().getValue("skssqq") && null != this.getModel().getValue("skssqz")) {
            int day2;
            int day = DateUtils.getDayOfDate((Date)((Date)this.getModel().getValue("skssqq")));
            if (day != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u9700\u4e3a\u5b8c\u6574\u7684\u586b\u62a5\u5468\u671f\uff0c\u4f8b\u5982\uff1a\u6574\u6708\u3001\u6574\u5b63\u3001\u6574\u534a\u5e74\u6216\u6574\u5e74\u3002", (String)"EnterpriseFillItemPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return false;
            }
            Date lastDate = DateUtils.getLastDateOfMonth2((Date)((Date)this.getModel().getValue("skssqz")));
            int day1 = DateUtils.getDayOfDate((Date)((Date)this.getModel().getValue("skssqz")));
            if (day1 != (day2 = DateUtils.getDayOfDate((Date)lastDate))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u9700\u4e3a\u5b8c\u6574\u7684\u586b\u62a5\u5468\u671f\uff0c\u4f8b\u5982\uff1a\u6574\u6708\u3001\u6574\u5b63\u3001\u6574\u534a\u5e74\u6216\u6574\u5e74\u3002", (String)"EnterpriseFillItemPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (!(ispass = this.checkSSQ((String)this.getModel().getValue("fillperiod"))).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u9700\u4e3a\u5b8c\u6574\u7684\u586b\u62a5\u5468\u671f\uff0c\u4f8b\u5982\uff1a\u6574\u6708\u3001\u6574\u5b63\u3001\u6574\u534a\u5e74\u6216\u6574\u5e74\u3002", (String)"EnterpriseFillItemPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void saveDatatoFillQuery() {
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tctsa_fixed_filling_query");
        ArrayList<DynamicObject> summaryGroupDataList = new ArrayList<DynamicObject>(16);
        for (int row = 0; row < rowCount; ++row) {
            QFilter qfilter = new QFilter("fillperiod", "=", this.getModel().getValue("fillperiod"));
            qfilter.and(new QFilter(ORG, "=", (Object)((DynamicObject)this.getView().getModel().getValue(ORG)).getLong("id")));
            qfilter.and(new QFilter(NUMBER, "=", this.getModel().getValue(NUMBER, row)));
            qfilter.and(new QFilter("skssqq", "=", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue("skssqq")))));
            qfilter.and(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)((Date)this.getModel().getValue("skssqz")))));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctsa_fixed_filling_query", (String)"id,fillperiod,number,name,amount,decimal,sxcontent,skssqq,skssqz,org,modifytime,modifier,tstatus,entryentity.labelid,labelid,group,description,taxtype", (QFilter[])new QFilter[]{qfilter});
            if (dynamicObject != null) {
                dynamicObject.set("amount", this.getModel().getValue("amount", row));
                dynamicObject.set("decimal", this.getModel().getValue("decimal", row));
                dynamicObject.set("sxcontent", this.getModel().getValue("sxcontent", row));
                dynamicObject.set("group", this.getModel().getValue("type", row));
                dynamicObject.set("description", this.getModel().getValue("description", row));
                dynamicObject.set("taxtype", this.getModel().getValue("taxtype", row));
                dynamicObject.set("modifytime", (Object)new Date());
                dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
                DynamicObject reportObj = BusinessDataServiceHelper.loadSingle((String)TCTSA_REPORT_ITEMS, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("id", row))});
                if (reportObj != null) {
                    dynamicObject.set("name", (Object)reportObj.getLocaleString("name"));
                } else {
                    dynamicObject.set("name", this.getModel().getValue("name", row));
                }
                DynamicObjectCollection labelsCollection = (DynamicObjectCollection)this.getModel().getValue("labelid", row);
                dynamicObject.set("labelid", (Object)labelsCollection);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                continue;
            }
            if (!("1".equals(this.getModel().getValue("fillingtype", row)) && EmptyCheckUtils.isNotEmpty((Object)this.getModel().getValue("amount", row)) || "2".equals(this.getModel().getValue("fillingtype", row)) && EmptyCheckUtils.isNotEmpty((Object)this.getModel().getValue("decimal", row))) && (!"3".equals(this.getModel().getValue("fillingtype", row)) || !EmptyCheckUtils.isNotEmpty((Object)this.getModel().getValue("sxcontent", row)))) continue;
            DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
            summary.set("datasource", (Object)"1");
            summary.set("sbbid", this.getModel().getValue("id", row));
            summary.set(ORG, this.getModel().getValue(ORG));
            summary.set(NUMBER, this.getModel().getValue(NUMBER, row));
            summary.set("amount", this.getModel().getValue("amount", row));
            summary.set("decimal", this.getModel().getValue("decimal", row));
            summary.set("sxcontent", this.getModel().getValue("sxcontent", row));
            summary.set("group", this.getModel().getValue("type", row));
            summary.set("description", this.getModel().getValue("description", row));
            summary.set("taxtype", this.getModel().getValue("taxtype", row));
            summary.set("fillperiod", this.getModel().getValue("period", row));
            summary.set("skssqq", (Object)DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue("skssqq"))));
            summary.set("skssqz", (Object)DateUtils.getLastDateOfMonth2((Date)((Date)this.getModel().getValue("skssqz"))));
            summary.set("modifytime", (Object)new Date());
            summary.set("modifier", (Object)RequestContext.get().getUserId());
            summary.set("billstatus", (Object)"A");
            DynamicObject reportObj = BusinessDataServiceHelper.loadSingle((String)TCTSA_REPORT_ITEMS, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("id", row))});
            if (reportObj != null) {
                summary.set("name", (Object)reportObj.getLocaleString("name"));
            } else {
                summary.set("name", this.getModel().getValue("name", row));
            }
            DynamicObjectCollection labelsCollection = (DynamicObjectCollection)this.getModel().getValue("labelid", row);
            summary.set("labelid", (Object)labelsCollection);
            summaryGroupDataList.add(summary);
        }
        SaveServiceHelper.save((DynamicObject[])summaryGroupDataList.toArray(new DynamicObject[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((String)"refill", (String)messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"refill"});
            this.showAmountfieldColum("amountfield");
        }
    }

    private void showAmountfieldColum(String columKey) {
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        for (int row = 0; row < rowCount; ++row) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{columKey});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        OrgServiceHelper.fsevenEnable((BeforeF7SelectEvent)beforeF7SelectEvent);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Boolean ispass = this.checkData(name);
        if (!ispass.booleanValue()) {
            return;
        }
        if (ORG.equals(name) || "fillperiod".equals(name) || "skssqq".equals(name) || "skssqz".equals(name)) {
            this.handlerEnterpriseFill(Long.parseLong(((DynamicObject)this.getView().getModel().getValue(ORG)).getString("id")), (String)this.getModel().getValue("fillperiod"), false);
        }
    }

    private Boolean checkData(String name) {
        if (null == this.getView().getModel().getValue(ORG) || null == this.getModel().getValue("fillperiod") || null == this.getModel().getValue("skssqq") || null == this.getModel().getValue("skssqz")) {
            return false;
        }
        if (this.getPageCache().get("isChange") != null && "1".equals(this.getPageCache().get("isChange"))) {
            return false;
        }
        if ("fillperiod".equals(name)) {
            this.getPageCache().put("isChange", "1");
            this.handlerFillperiod((String)this.getModel().getValue("fillperiod"));
            this.getPageCache().put("isChange", "0");
        }
        if ("skssqq".equals(name) || "skssqz".equals(name)) {
            Boolean ispass;
            if (null != this.getModel().getValue("skssqq") && null != this.getModel().getValue("skssqz")) {
                int day2;
                int day = DateUtils.getDayOfDate((Date)((Date)this.getModel().getValue("skssqq")));
                if (day != 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u9700\u4e3a\u5b8c\u6574\u7684\u586b\u62a5\u5468\u671f\uff0c\u4f8b\u5982\uff1a\u6574\u6708\u3001\u6574\u5b63\u3001\u6574\u534a\u5e74\u6216\u6574\u5e74\u3002", (String)"EnterpriseFillItemPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                    return false;
                }
                Date lastDate = DateUtils.getLastDateOfMonth2((Date)((Date)this.getModel().getValue("skssqz")));
                int day1 = DateUtils.getDayOfDate((Date)((Date)this.getModel().getValue("skssqz")));
                if (day1 != (day2 = DateUtils.getDayOfDate((Date)lastDate))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u9700\u4e3a\u5b8c\u6574\u7684\u586b\u62a5\u5468\u671f\uff0c\u4f8b\u5982\uff1a\u6574\u6708\u3001\u6574\u5b63\u3001\u6574\u534a\u5e74\u6216\u6574\u5e74\u3002", (String)"EnterpriseFillItemPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            if (!(ispass = this.checkSSQ((String)this.getModel().getValue("fillperiod"))).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u9700\u4e3a\u5b8c\u6574\u7684\u586b\u62a5\u5468\u671f\uff0c\u4f8b\u5982\uff1a\u6574\u6708\u3001\u6574\u5b63\u3001\u6574\u534a\u5e74\u6216\u6574\u5e74\u3002", (String)"EnterpriseFillItemPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private Boolean checkSSQ(String fillperiod) {
        int month = DateUtils.getMonthDiff((Date)((Date)this.getModel().getValue("skssqz")), (Date)((Date)this.getModel().getValue("skssqq")));
        int startMonth = DateUtils.getMonthOfDate((Date)((Date)this.getModel().getValue("skssqq")));
        switch (fillperiod) {
            case "1": {
                if (month == 0) break;
                return false;
            }
            case "2": {
                if (month != 2) {
                    return false;
                }
                if (SKSSQQMONTHS.contains(startMonth)) break;
                return false;
            }
            case "3": {
                if (month != 5) {
                    return false;
                }
                if (HALFMONTHS.contains(startMonth)) break;
                return false;
            }
            case "4": {
                if (month != 11) {
                    return false;
                }
                if (startMonth == 1) break;
                return false;
            }
        }
        return true;
    }

    private void handlerFillperiod(String value) {
        switch (value) {
            case "1": {
                this.setFillPeriod(DateUtils.getFirstDateOfMonth((Date)new Date()), DateUtils.getLastDateOfMonth2((Date)new Date()));
                break;
            }
            case "2": {
                this.setFillPeriod(DateUtils.getFirstDateOfSeason((Date)new Date()), DateUtils.getLastDateOfSeason((Date)new Date()));
                break;
            }
            case "3": {
                this.setFillPeriod(DateUtils.getFirstDateOfHalfYear((Date)new Date()), DateUtils.getLastDateOfHalfYear((Date)new Date()));
                break;
            }
            case "4": {
                this.setFillPeriod(DateUtils.getFirstDateOfYear((Date)new Date()), DateUtils.getLastDateOfYear((Date)new Date()));
            }
        }
    }

    private void setFillPeriod(Date firstDateOfMonth, Date lastDateOfMonth) {
        this.getView().getModel().setValue("skssqq", (Object)firstDateOfMonth);
        this.getView().getModel().setValue("skssqz", (Object)lastDateOfMonth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getInfoByOrgIdFromErp(String orgId, String ... selectFields) {
        QFilter id = new QFilter("id", "=", (Object)Long.parseLong(orgId));
        StringBuilder selectStrBuilder = new StringBuilder();
        int len = selectFields.length;
        for (int i = 0; i < len; ++i) {
            selectStrBuilder.append(selectFields[i]);
            selectStrBuilder.append(',');
        }
        String temp = selectStrBuilder.toString();
        String selectStr = temp.substring(0, temp.length() - 1);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)OrgViewServiceHelper.class.getName(), (String)"bos_org", (String)selectStr, (QFilter[])new QFilter[]{id}, (String)"id");){
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                for (int key = 0; key < selectFields.length; ++key) {
                    map.put(selectFields[key], row.getString(selectFields[key]));
                }
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            logger.info("EnterpriseFillItemPlugin.getInfoByOrgIdFromErp", (Object)e);
            return new HashMap<String, String>();
        }
    }
}

