/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.business.reportitems.EnterpriseFillQueryImportHelper;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;

public class EnterpriseFillQueryImportPlugin
extends BatchImportPlugin {
    private static final String NUMBER = "number";
    private static final String SYSTEMNAME = "taxc-tctsa-formplugin";

    public List<String> getDefaultLockUIs() {
        return Arrays.asList("radiofield1", "radiofield2");
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> it = billdatas.iterator();
        List numberList = billdatas.stream().map(v -> v.getData().getString(NUMBER)).collect(Collectors.toList());
        QFilter numberFilter = new QFilter(NUMBER, "in", numberList);
        DynamicObjectCollection moreObj = QueryServiceHelper.query((String)"tctsa_report_items", (String)"id,number,name,enable,period,taxtype.number,taxtype.name,description,fillingtype", (QFilter[])new QFilter[]{numberFilter});
        Map<String, List<DynamicObject>> moreObjMap = moreObj.stream().collect(Collectors.groupingBy(s -> s.getString(NUMBER)));
        QFilter risknumberFilter = new QFilter("planentity.riskentity.riskid.number", "in", numberList);
        ArrayList orgList = new ArrayList(10);
        billdatas.stream().forEach(v -> {
            JSONObject obj = (JSONObject)v.getData().get((Object)"org");
            orgList.add(obj.getString(NUMBER));
        });
        QFilter orgFilter = new QFilter("planentity.orgentity.orgid.number", "in", orgList);
        DynamicObjectCollection assignList = QueryServiceHelper.query((String)"tctsa_report_item_assign", (String)"id,org.number,planentity.orgentity.orgid.number,planentity.riskentity.riskid.number,planentity.status", (QFilter[])new QFilter[]{risknumberFilter, orgFilter});
        Map<String, List<DynamicObject>> assignMap = assignList.stream().collect(Collectors.groupingBy(s -> s.getString("planentity.riskentity.riskid.number") + "_" + s.get("planentity.orgentity.orgid.number")));
        Set orgSet = OrgServiceHelper.orgNumber();
        while (it.hasNext()) {
            ImportBillData data = it.next();
            JSONObject obj = data.getData();
            String errorStr = EnterpriseFillQueryImportHelper.checkField((JSONObject)obj);
            if (!StringUtils.isEmpty((Object)errorStr)) {
                logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)errorStr, (String)"EnterpriseFillQueryImportPlugin_2", (String)SYSTEMNAME, (Object[])new Object[0])).fail();
                it.remove();
                continue;
            }
            if (!EnterpriseFillQueryImportHelper.checkPeriodAndItem((JSONObject)obj, (ImportBillData)data, (ImportLogger)logger, moreObjMap)) {
                it.remove();
                continue;
            }
            if (EnterpriseFillQueryImportHelper.checkOrgAndExist((JSONObject)obj, (ImportBillData)data, (ImportLogger)logger, assignMap, (Set)orgSet)) continue;
            it.remove();
        }
    }
}

