/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.helper.FixedFillHandlerHelper;
import kd.taxc.tctsa.common.util.BaseDataUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EnterpriseFillQueryListPlugin
extends AbstractListPlugin {
    private static final String BILL_LIST = "billlistap";

    public void filterContainerInit(FilterContainerInitArgs args) {
        List labelIdList;
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fillperiod = (String)customParams.get("period");
        CommonFilterColumn commonFilterColumn = new CommonFilterColumn("labelid.number");
        commonFilterColumn.setMulti(true);
        args.addFilterColumn((FilterColumn)commonFilterColumn);
        commonFilterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"EnterpriseFillQueryListPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0])));
        if (!ObjectUtils.isEmpty((Object)this.getPageCache().get("labelId")) && CollectionUtils.isNotEmpty((Collection)(labelIdList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("labelId"), String.class))) && null != labelIdList.get(0) && ((String)labelIdList.get(0)).trim().length() > 0) {
            commonFilterColumn.setDefaultValues(new Object[]{labelIdList});
        }
        List orgs = new ArrayList();
        if (null != customParams.get("orgid")) {
            orgs = (List)SerializationUtils.fromJsonString((String)customParams.get("orgid").toString(), List.class);
        }
        List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            String fieldName = filterColumn.getFieldName();
            if (fieldName.startsWith("fillperiod") && StringUtils.isNotEmpty((CharSequence)fillperiod)) {
                filterColumn.setDefaultValue(fillperiod);
                continue;
            }
            if (!fieldName.equals("org.name")) continue;
            if (!orgs.isEmpty()) {
                filterColumn.setDefaultValues(orgs.stream().map(Object::toString).collect(Collectors.toList()));
                continue;
            }
            filterColumn.setDefaultValues(new Object[]{BaseDataUtil.getDefaultOrg((IFormView)this.getView())});
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        List list;
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && "labelid.id".equals((list = (List)currentCommonFilter.get("FieldName")).get(0))) {
            List labelId = (List)currentCommonFilter.get("Value");
            this.getPageCache().put("labelId", SerializationUtils.toJsonString((Object)labelId));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals("import")) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            billList.refresh();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(FixedFillHandlerHelper.haveFlow((Boolean)true), new String[]{"workflowno"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        FormOperate source = (FormOperate)evt.getSource();
        String operationKey = source.getOperateKey();
        if (!TctsaConstant.WORKFLOW_KEYS.contains(operationKey) && !"viewflowchart".equalsIgnoreCase(operationKey)) {
            return;
        }
        BillList billList = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Boolean haveSingleFlow = FixedFillHandlerHelper.haveFlow((Boolean)false);
        Boolean haveBatchFlow = FixedFillHandlerHelper.haveFlow((Boolean)true);
        if (haveBatchFlow.booleanValue() && haveSingleFlow.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u4e2a\u5ba1\u6279\u6d41\u548c\u6279\u91cf\u5ba1\u6279\u6d41\u914d\u7f6e\u91cd\u590d\u3002", (String)"EnterpriseFillQueryListPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        List ids = selectedRows.stream().map(m -> Long.parseLong(String.valueOf(m.getPrimaryKeyValue()))).distinct().collect(Collectors.toList());
        if ("viewflowchart".equals(operationKey) && haveBatchFlow.booleanValue()) {
            evt.setCancel(true);
            DynamicObject[] fixedFillings = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tctsa_fixed_filling_query"));
            List workflownoList = Arrays.stream(fixedFillings).map(m -> m.getString("workflowno")).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
            if (workflownoList.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5ba1\u6279\u6570\u636e\u3002", (String)"EnterpriseFillQueryListPlugin_2", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            } else if (workflownoList.size() == 1) {
                QFilter matchFilter = new QFilter("billno", "in", workflownoList);
                DynamicObject matchAggr = BusinessDataServiceHelper.loadSingle((String)"tctsa_fixed_filling_aggr", (QFilter[])matchFilter.toArray());
                WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)matchAggr.getLong("id"));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"EnterpriseFillQueryListPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
        } else if (haveBatchFlow.booleanValue()) {
            evt.setCancel(true);
            FixedFillHandlerHelper.executeBatchFixedFillOperate(ids, (String)operationKey, (IFormView)this.getView());
            billList.refresh();
        }
    }
}

