/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.util.DBUtils;
import kd.taxc.tctsa.common.util.OrgCheckUtil;
import kd.taxc.tctsa.common.util.PermissionUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class SharingReportItemPlugin
extends AbstractBillPlugIn
implements SelectRowsEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String ORG = "org";
    private static final String REPORT_ASSIGN_ENTITY = "tctsa_report_item_assign";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String IS_CHANGE_ROW = "isChangeRow";
    private static final String CHANGE_ROW_TIME = "changeRowTime";
    private static final String CURRENT_PLAN_INDEX = "current_plan_index";

    public void initialize() {
        CardEntry planentity = (CardEntry)this.getControl("planentity");
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
        formShowParameter.getCustomParams().put("orgFuncId", "40");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"SharingReportItemPlugin_8", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        List<Long> orgIds = this.getDefaultOrgIds();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        formShowParameter.getListFilterParameter().getQFilters().removeIf(qFilter -> "id".equals(qFilter.getProperty()));
        QFilter orgIdsFilter = new QFilter("id", "in", orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
        formShowParameter.setMultiSelect(false);
    }

    public List<Long> getDefaultOrgIds() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            return hasPermOrgResult.getHasPermOrgs();
        }
        return null;
    }

    private void initOrg() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("orgid")) {
            this.getModel().setValue(ORG, customParams.get("orgid"));
            this.getPageCache().put("orgid", String.valueOf(customParams.get("orgid")));
        } else {
            String orgid = OrgCheckUtil.findTaxOrg((IFormView)this.getView(), (String)ORG, (IPageCache)this.getPageCache());
            if (null != orgid) {
                this.getModel().setValue(ORG, (Object)orgid);
                this.getPageCache().put("orgid", orgid);
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flex_addorg", "vector_addorg", "label_addorg", "flex_vieworg", "vector_vieworg", "label_vieworg", "labelcreate", "toolbar", "tbmain"});
        EntryGrid riskentity = (EntryGrid)this.getControl("riskentity");
        riskentity.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        BillShowParameter parameter = (BillShowParameter)e.getSource();
        long orgid = null != parameter.getCustomParams() && null != parameter.getCustomParams().get("orgid") ? Long.parseLong((String)parameter.getCustomParams().get("orgid")) : this.getOrgId();
        QFilter orgFilter = new QFilter(ORG, "=", (Object)orgid);
        DynamicObject plan = QueryServiceHelper.queryOne((String)REPORT_ASSIGN_ENTITY, (String)"id", (QFilter[])new QFilter[]{orgFilter});
        if (plan != null) {
            String pkId = plan.getString("id");
            parameter.setPkId((Object)pkId);
        }
    }

    private long getOrgId() {
        DynamicObject org;
        try {
            org = (DynamicObject)this.getModel().getValue(ORG);
        }
        catch (Exception ee) {
            org = null;
        }
        Long orgid = org != null && "1".equals(org.getString("enable")) ? Long.valueOf(org.getLong("id")) : PermissionUtils.getDefaultOrgId();
        return orgid;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initOrg();
        this.resetPlanName(0);
    }

    public void afterBindData(EventObject e) {
        this.setPlanCardRow();
        this.updateAddLableName();
        this.setVisible();
    }

    public void setPlanCardRow() {
        int count = this.getModel().getEntryRowCount("planentity") - 1;
        int currentPlanIndex = Math.min(NumberUtils.toInt((String)this.getPageCache().get(CURRENT_PLAN_INDEX)), count);
        CardEntry cardEntry = (CardEntry)this.getControl("planentity");
        cardEntry.selectCard(Integer.valueOf(currentPlanIndex));
        cardEntry.selectRowsChanged(Collections.singletonList(currentPlanIndex), null);
    }

    private void updateAddLableName() {
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentity");
        if (null == orgEntity || orgEntity.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_vieworg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_addorg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_vieworg", "flex_addorg"});
        }
        String status = (String)this.getModel().getValue("status");
        if ("1".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pick"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"ban"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ban"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"pick"});
        }
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount("planentity");
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", "planentity"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", "planentity"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (ORG.equals(e.getProperty().getName())) {
            if (changeData != null && changeData.length > 0) {
                DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
                if (null == changeData[0].getOldValue() && null != changeData[0].getNewValue()) {
                    return;
                }
                if (null == newOrg) {
                    this.getView().getModel().setValue(ORG, (Object)this.getPageCache().get("orgid"));
                    return;
                }
                String neworgid = newOrg.getString("id");
                if (neworgid.equals(this.getPageCache().get("orgid"))) {
                    return;
                }
                String appid = this.getView().getFormShowParameter().getAppId();
                if (!OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)neworgid, (String)appid, null)) {
                    HashMap<String, Object> custom = new HashMap<String, Object>();
                    custom.put("orgid", neworgid);
                    QFilter filter = new QFilter(ORG, "=", (Object)Long.parseLong(neworgid));
                    DynamicObject plan = QueryServiceHelper.queryOne((String)REPORT_ASSIGN_ENTITY, (String)"id", (QFilter[])new QFilter[]{filter});
                    if (plan != null) {
                        this.showBill(plan.getLong("id"), custom);
                    } else {
                        this.showBill(null, custom);
                    }
                    this.getView().close();
                } else {
                    this.getModel().setValue(ORG, (Object)this.getPageCache().get("orgid"));
                    this.getModel().setDataChanged(false);
                }
            }
        } else if ("planname".equals(e.getProperty().getName())) {
            if (!"true".equals(this.getPageCache().get("refresh")) && ("true".equals(this.getPageCache().get(IS_CHANGE_ROW)) || this.isNormalChange())) {
                this.getPageCache().remove(IS_CHANGE_ROW);
                CardEntry planentity = (CardEntry)this.getControl("planentity");
                int[] selectRows = planentity.getSelectRows();
                if (selectRows != null && selectRows.length > 0) {
                    this.getModel().setValue("name", e.getChangeSet()[0].getNewValue(), selectRows[0]);
                }
            }
            if (null != this.getPageCache().get(CURRENT_PLAN_INDEX)) {
                int index = Integer.parseInt(this.getPageCache().get(CURRENT_PLAN_INDEX));
                DynamicObject[] planentities = this.getModel().getEntryEntity("planentity", index, index + 1);
                if (planentities != null && planentities.length > 0 && !planentities[0].getString("name").equals(this.getModel().getValue("planname"))) {
                    this.getModel().setValue("planname", (Object)planentities[0].getString("name"));
                }
            }
        }
    }

    private boolean isNormalChange() {
        String format = DateUtils.format((Date)new Date(), (String)YYYY_MM_DD_HH_MM_SS);
        return !format.equals(this.getPageCache().get(CHANGE_ROW_TIME));
    }

    private void showBill(Object pkId, Map<String, Object> customParams) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCustomParams(customParams);
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
        } else {
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        }
        billShowParameter.setFormId(REPORT_ASSIGN_ENTITY);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void click(EventObject evt) {
        boolean isViewOrg;
        Object source = evt.getSource();
        boolean isAddOrg = source instanceof Vector && "vector_addorg".equals(((Vector)source).getKey()) || source instanceof Container && "flex_addorg".equals(((Container)source).getKey()) || source instanceof Label && "label_addorg".equals(((Label)source).getKey());
        boolean bl = isViewOrg = source instanceof Vector && "vector_vieworg".equals(((Vector)source).getKey()) || source instanceof Container && "flex_vieworg".equals(((Container)source).getKey()) || source instanceof Label && "label_vieworg".equals(((Label)source).getKey());
        if ((isAddOrg || isViewOrg) && !this.checkPlanNotSelected()) {
            this.showOrgTreeList();
        } else if (source instanceof Label && "labelcreate".equals(((Label)source).getKey())) {
            Button button = (Button)this.getControl("button_addplan");
            button.click();
        }
        this.updateAddLableName();
    }

    private boolean checkPlanNotSelected() {
        EntryGrid planentity = (EntryGrid)this.getControl("planentity");
        int[] selectedRows = planentity.getSelectRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5171\u4eab\u65b9\u6848\u88ab\u9009\u4e2d\uff0c\u8bf7\u5148\u6dfb\u52a0\u5171\u4eab\u65b9\u6848\u3002", (String)"SharingReportItemPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void showOrgTreeList() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)2);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u88ab\u5171\u4eab\u7ec4\u7ec7", (String)"SharingReportItemPlugin_7", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
        StyleCss sc = new StyleCss();
        sc.setHeight("660px");
        sc.setWidth("1200px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentity");
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        for (DynamicObject entity : orgEntity) {
            ListSelectedRow row = new ListSelectedRow();
            DynamicObject org = entity.getDynamicObject("orgid");
            if (null == org) continue;
            row.setPrimaryKeyValue(org.get("id"));
            listSelectedRowCollection.add((Object)row);
        }
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"SharingReportItemPlugin_1", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            return;
        }
        List filters = parameter.getListFilterParameter().getQFilters();
        List<Long> orgList = Collections.singletonList(org.getLong("id"));
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"40", orgList, (boolean)true);
        List queryOrgs = OrgServiceHelper.queryOrgListByCondition();
        subOrgIds.retainAll(queryOrgs);
        filters.add(new QFilter("id", "in", (Object)subOrgIds.toArray()));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectorg"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        if (newRows != null && newRows.size() > 0) {
            Integer startRowIndex = (Integer)newRows.get(0);
            this.getPageCache().put(CURRENT_PLAN_INDEX, String.valueOf(startRowIndex));
            this.getPageCache().put(CHANGE_ROW_TIME, DateUtils.format((Date)new Date(), (String)YYYY_MM_DD_HH_MM_SS));
            this.getPageCache().put(IS_CHANGE_ROW, "true");
            this.resetPlanName(startRowIndex);
        }
        this.updateAddLableName();
    }

    private void resetPlanName(Integer startRowIndex) {
        DynamicObject[] planentities = this.getModel().getEntryEntity("planentity", startRowIndex.intValue(), startRowIndex + 1);
        if (planentities != null && planentities.length > 0) {
            this.getModel().setValue("planname", (Object)planentities[0].getString("name"));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("planentity".equals(e.getEntryProp().getName())) {
            CardEntry planentity = (CardEntry)this.getControl("planentity");
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (rowDataEntities != null && rowDataEntities.length > 0) {
                int rowIndex = rowDataEntities[0].getRowIndex();
                planentity.selectCard(Integer.valueOf(rowIndex));
                planentity.selectRowsChanged(Collections.singletonList(rowIndex), null);
            }
            this.updateAddLableName();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        EntryGrid entryGrid;
        int[] selectRows;
        if ("planentity".equals(e.getEntryProp().getName())) {
            this.updateAddLableName();
            this.resetPlanName(this.getModel().getEntryRowCount("planentity") - 1);
        }
        if ((selectRows = (entryGrid = (EntryGrid)this.getControl("planentity")).getSelectRows()) != null && selectRows.length > 0) {
            Integer startRowIndex = selectRows[0];
            this.getPageCache().put(CURRENT_PLAN_INDEX, String.valueOf(startRowIndex));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        EntryGrid planentity;
        int[] rows;
        ListSelectedRowCollection listSelectedRows;
        Object returnData = evt.getReturnData();
        if ("selectorg".equals(evt.getActionId())) {
            ListSelectedRowCollection orgs = (ListSelectedRowCollection)returnData;
            if (orgs != null) {
                EntryGrid planentity2 = (EntryGrid)this.getControl("planentity");
                int[] selectRows = planentity2.getSelectRows();
                int planIndex = selectRows[0];
                this.getModel().setEntryCurrentRowIndex("planentity", planIndex);
                this.getModel().deleteEntryData("orgentity");
                for (ListSelectedRow selectedRow : orgs) {
                    int index = this.getModel().createNewEntryRow("orgentity");
                    this.getModel().setValue("orgid", selectedRow.getPrimaryKeyValue(), index, planIndex);
                }
            }
            this.updateAddLableName();
        } else if ("selectrisk".equals(evt.getActionId()) && (listSelectedRows = (ListSelectedRowCollection)returnData) != null && (rows = (planentity = (EntryGrid)this.getControl("planentity")).getSelectRows()) != null && rows.length > 0) {
            int row = rows[0];
            this.getModel().deleteEntryData("riskentity");
            for (ListSelectedRow selectedRow : listSelectedRows) {
                int index = this.getModel().createNewEntryRow("riskentity");
                this.getModel().setValue("riskid", selectedRow.getPrimaryKeyValue(), index, row);
            }
            this.getView().updateView("riskentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Integer seqno;
        QFilter seqFilter;
        Long id;
        QFilter idFilter;
        DynamicObject[] objects;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            int planCount = this.getModel().getEntryRowCount("planentity");
            if (planCount == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"SharingReportItemPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection planentity = this.getModel().getEntryEntity("planentity");
            for (int row = 0; row < planentity.size(); ++row) {
                this.getModel().setEntryCurrentRowIndex("planentity", row);
                int orgCount = this.getModel().getEntryRowCount("orgentity");
                String planName = ((DynamicObject)planentity.get(row)).getString("name");
                if (orgCount == 0) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u88ab\u5171\u4eab\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u88ab\u5171\u4eab\u7ec4\u7ec7\u3002", (String)"SharingReportItemPlugin_5", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                int riskCount = this.getModel().getEntryRowCount("riskentity");
                if (riskCount != 0) continue;
                String errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u56fa\u5b9a\u586b\u62a5\u9879\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u56fa\u5b9a\u586b\u62a5\u9879\u3002", (String)"SharingReportItemPlugin_6", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg);
                args.setCancel(true);
                return;
            }
        } else if (args.getSource() instanceof Refresh) {
            this.getPageCache().put("refresh", "true");
        } else if (args.getSource() instanceof DeleteEntry) {
            int index = Integer.parseInt(this.getPageCache().get(CURRENT_PLAN_INDEX));
            DynamicObject[] planentities = this.getModel().getEntryEntity("planentity", index, index + 1);
            if (planentities.length > 0) {
                String updateSql = " DELETE FROM t_tctsa_sharingplan WHERE fentryid='" + planentities[0].getPkValue() + "'";
                DBUtils.execute((String)updateSql);
            }
        } else if (args.getSource() instanceof StatusConvert && (objects = BusinessDataServiceHelper.load((String)REPORT_ASSIGN_ENTITY, (String)"planentity.seq,planentity.status", (QFilter[])new QFilter[]{idFilter = new QFilter("id", "=", (Object)(id = (Long)this.getModel().getValue("id"))), seqFilter = new QFilter("planentity.seq", "=", (Object)((seqno = Integer.valueOf(Integer.parseInt(this.getPageCache().get(CURRENT_PLAN_INDEX)))) + 1))})) != null && objects.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"SharingReportItemPlugin_9", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setStatus(BillOperationStatus status) {
        ((IBillView)this.getView()).setBillStatus(status);
        if (BillOperationStatus.EDIT.equals((Object)status)) {
            this.getPageCache().put("status", "edit");
        } else {
            this.getPageCache().put("status", "view");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("close".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.setStatus(BillOperationStatus.VIEW);
            Button button = (Button)this.getView().getControl("button_addplan");
            button.click();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("selectrisk")) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            this.showRiskSelect();
        } else if (args.getOperateKey().equals("refresh") || args.getOperateKey().equals("save") && args.getOperationResult().isSuccess()) {
            if ("true".equals(this.getPageCache().get("refresh"))) {
                this.getPageCache().put("refresh", "false");
            }
            this.setPlanCardRow();
            this.updateAddLableName();
        } else if (args.getOperateKey().equals("enable") || args.getOperateKey().equals("disable")) {
            String newValue = "enable".equals(args.getOperateKey()) ? "1" : "0";
            Integer seqno = Integer.parseInt(this.getPageCache().get(CURRENT_PLAN_INDEX));
            this.getModel().setValue("status", (Object)newValue, seqno.intValue());
            this.updateAddLableName();
            List ids = args.getOperationResult().getSuccessPkIds();
            if (null == ids || ids.size() == 0) {
                return;
            }
            long id = (Long)ids.get(0);
            QFilter idFilter = new QFilter("id", "=", (Object)id);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)REPORT_ASSIGN_ENTITY, (String)"planentity.seq,planentity.status", (QFilter[])new QFilter[]{idFilter});
            DynamicObjectCollection collection = dynamicObjects[0].getDynamicObjectCollection("planentity");
            String currentSeq = String.valueOf(Integer.parseInt(this.getPageCache().get(CURRENT_PLAN_INDEX)) + 1);
            for (DynamicObject dyo : collection) {
                if (!dyo.getString("seq").equals(currentSeq)) continue;
                dyo.set("status", (Object)newValue);
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                break;
            }
        }
        this.setVisible();
    }

    private void showRiskSelect() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tctsa_report_items", (boolean)true, (int)2);
        DynamicObjectCollection riskentity = this.getModel().getEntryEntity("riskentity");
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        for (DynamicObject entity : riskentity) {
            ListSelectedRow row = new ListSelectedRow();
            DynamicObject risk = entity.getDynamicObject("riskid");
            row.setName(risk.getString("name"));
            row.setNumber(risk.getString("number"));
            row.setPrimaryKeyValue(risk.get("id"));
            listSelectedRowCollection.add((Object)row);
        }
        parameter.setFormId("bos_treelistf7");
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        parameter.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)"1"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectrisk"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getFieldName().equals("number")) {
            int rowIndex = evt.getRowIndex();
            DynamicObject risk = (DynamicObject)this.getModel().getValue("riskid", rowIndex);
            Object pkValue = risk.getPkValue();
            this.openBill(pkValue, "tctsa_report_items");
        }
    }

    private void openBill(Object pkValue, String entity) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(entity);
        if (pkValue == null) {
            parameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setBillStatus(BillOperationStatus.VIEW);
            parameter.setPageId(pkValue + "#" + entity);
            parameter.setPkId(pkValue);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entity);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

