/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.formplugin.reportitems;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;

public class StayReportTaskItemListPlugin
extends AbstractListPlugin {
    private static final String TCTSA_REPORT_DTASK_BILL = "tctsa_report_dtask_bill";
    public static final String TCTSA_STAY_REPORT_DTASK = "tctsa_stay_report_dtask";

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("billstatus", "=", (Object)"1"));
        qFilters.add(new QFilter("submitstatus", "!=", (Object)"1"));
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if ("orgfield.name".equals(args.getFieldName())) {
            List orgList = OrgServiceHelper.getOrgListHasPermissionAll();
            args.addCustomQFilter(new QFilter("id", "in", (Object)orgList));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("orgfield.id".equals(args.getFieldName())) {
            List orgList = OrgServiceHelper.getOrgListHasPermissionAll();
            args.getCustomQFilters().add(new QFilter("id", "in", (Object)orgList));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if ("billno".equals(args.getHyperLinkClickEvent().getFieldName())) {
            this.openBill(currentSelectedRowInfo.getPrimaryKeyValue(), TCTSA_STAY_REPORT_DTASK);
        }
    }

    private void openBill(Object pkValue, String entity) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(entity);
        parameter.setPageId(this.getView().getPageId() + entity + pkValue);
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("numberid", pkValue);
        customParams.put("isstay", "0");
        parameter.setCustomParams(customParams);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        BillList billlist;
        if (args.getOperationResult() != null && "donothingsubmit".equals(args.getOperateKey()) && args.getOperationResult().isSuccess() && (billlist = (BillList)this.getControl("billlistap")) != null) {
            ListSelectedRowCollection selectedRowCollection = billlist.getSelectedRows();
            if (selectedRowCollection != null && selectedRowCollection.size() > 0) {
                List pks = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                ArrayList<DynamicObject> summaryGroupDataList = new ArrayList<DynamicObject>(16);
                Boolean fullSucess = true;
                for (Object pkId : pks) {
                    DynamicObject dyo = BusinessDataServiceHelper.loadSingle(pkId, (String)TCTSA_REPORT_DTASK_BILL);
                    if (dyo != null && !"2".equals(dyo.get("combofield"))) {
                        fullSucess = false;
                        continue;
                    }
                    if (dyo == null) continue;
                    dyo.set("submitstatus", (Object)"1");
                    dyo.set("modifydate", (Object)new Date());
                    summaryGroupDataList.add(dyo);
                }
                SaveServiceHelper.save((DynamicObject[])summaryGroupDataList.toArray(new DynamicObject[0]));
                billlist.refreshData();
                if (fullSucess.booleanValue()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"StayReportTaskItemListPlugin_3", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5b8c\u6210\u7684\u586b\u62a5\u4efb\u52a1\u53ef\u4ee5\u63d0\u4ea4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"StayReportTaskItemListPlugin_0", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"StayReportTaskItemListPlugin_4", (String)"taxc-tctsa-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

